/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/audio_config.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Settings related to speech synthesizing.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings}
 */
public final class TextToSpeechSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings)
    TextToSpeechSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextToSpeechSettings.newBuilder() to construct.
  private TextToSpeechSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextToSpeechSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextToSpeechSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_TextToSpeechSettings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 1:
        return internalGetSynthesizeSpeechConfigs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_TextToSpeechSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.class,
            com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.Builder.class);
  }

  public static final int SYNTHESIZE_SPEECH_CONFIGS_FIELD_NUMBER = 1;

  private static final class SynthesizeSpeechConfigsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
                    newDefaultInstance(
                        com.google.cloud.dialogflow.cx.v3beta1.AudioConfigProto
                            .internal_static_google_cloud_dialogflow_cx_v3beta1_TextToSpeechSettings_SynthesizeSpeechConfigsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
      synthesizeSpeechConfigs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
      internalGetSynthesizeSpeechConfigs() {
    if (synthesizeSpeechConfigs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry);
    }
    return synthesizeSpeechConfigs_;
  }

  public int getSynthesizeSpeechConfigsCount() {
    return internalGetSynthesizeSpeechConfigs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
   * SynthesizeSpeechConfig.
   *
   * These settings affect:
   *
   *  - The [phone
   *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
   *    synthesize configuration set via
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
   *
   *  - How speech is synthesized when invoking
   *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
   *    only applies if
   *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
   *    is not specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
   * </code>
   */
  @java.lang.Override
  public boolean containsSynthesizeSpeechConfigs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSynthesizeSpeechConfigs().getMap().containsKey(key);
  }
  /** Use {@link #getSynthesizeSpeechConfigsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
      getSynthesizeSpeechConfigs() {
    return getSynthesizeSpeechConfigsMap();
  }
  /**
   *
   *
   * <pre>
   * Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
   * SynthesizeSpeechConfig.
   *
   * These settings affect:
   *
   *  - The [phone
   *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
   *    synthesize configuration set via
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
   *
   *  - How speech is synthesized when invoking
   *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
   *    only applies if
   *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
   *    is not specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
      getSynthesizeSpeechConfigsMap() {
    return internalGetSynthesizeSpeechConfigs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
   * SynthesizeSpeechConfig.
   *
   * These settings affect:
   *
   *  - The [phone
   *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
   *    synthesize configuration set via
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
   *
   *  - How speech is synthesized when invoking
   *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
   *    only applies if
   *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
   *    is not specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig
      getSynthesizeSpeechConfigsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        map = internalGetSynthesizeSpeechConfigs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
   * SynthesizeSpeechConfig.
   *
   * These settings affect:
   *
   *  - The [phone
   *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
   *    synthesize configuration set via
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
   *
   *  - How speech is synthesized when invoking
   *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
   *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
   *    only applies if
   *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
   *    is not specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig
      getSynthesizeSpeechConfigsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        map = internalGetSynthesizeSpeechConfigs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetSynthesizeSpeechConfigs(),
        SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry,
        1);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        entry : internalGetSynthesizeSpeechConfigs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
          synthesizeSpeechConfigs__ =
              SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, synthesizeSpeechConfigs__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings other =
        (com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings) obj;

    if (!internalGetSynthesizeSpeechConfigs().equals(other.internalGetSynthesizeSpeechConfigs()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetSynthesizeSpeechConfigs().getMap().isEmpty()) {
      hash = (37 * hash) + SYNTHESIZE_SPEECH_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSynthesizeSpeechConfigs().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings related to speech synthesizing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings)
      com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TextToSpeechSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetSynthesizeSpeechConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 1:
          return internalGetMutableSynthesizeSpeechConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TextToSpeechSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableSynthesizeSpeechConfigs().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TextToSpeechSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings build() {
      com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings result =
          new com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.synthesizeSpeechConfigs_ = internalGetSynthesizeSpeechConfigs();
        result.synthesizeSpeechConfigs_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings.getDefaultInstance())
        return this;
      internalGetMutableSynthesizeSpeechConfigs()
          .mergeFrom(other.internalGetSynthesizeSpeechConfigs());
      bitField0_ |= 0x00000001;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
                    synthesizeSpeechConfigs__ =
                        input.readMessage(
                            SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableSynthesizeSpeechConfigs()
                    .getMutableMap()
                    .put(synthesizeSpeechConfigs__.getKey(), synthesizeSpeechConfigs__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        synthesizeSpeechConfigs_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        internalGetSynthesizeSpeechConfigs() {
      if (synthesizeSpeechConfigs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry);
      }
      return synthesizeSpeechConfigs_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        internalGetMutableSynthesizeSpeechConfigs() {
      if (synthesizeSpeechConfigs_ == null) {
        synthesizeSpeechConfigs_ =
            com.google.protobuf.MapField.newMapField(
                SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry);
      }
      if (!synthesizeSpeechConfigs_.isMutable()) {
        synthesizeSpeechConfigs_ = synthesizeSpeechConfigs_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return synthesizeSpeechConfigs_;
    }

    public int getSynthesizeSpeechConfigsCount() {
      return internalGetSynthesizeSpeechConfigs().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    @java.lang.Override
    public boolean containsSynthesizeSpeechConfigs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSynthesizeSpeechConfigs().getMap().containsKey(key);
    }
    /** Use {@link #getSynthesizeSpeechConfigsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        getSynthesizeSpeechConfigs() {
      return getSynthesizeSpeechConfigsMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        getSynthesizeSpeechConfigsMap() {
      return internalGetSynthesizeSpeechConfigs().getMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig
        getSynthesizeSpeechConfigsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
          map = internalGetSynthesizeSpeechConfigs().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig
        getSynthesizeSpeechConfigsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
          map = internalGetSynthesizeSpeechConfigs().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSynthesizeSpeechConfigs() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    public Builder removeSynthesizeSpeechConfigs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
        getMutableSynthesizeSpeechConfigs() {
      bitField0_ |= 0x00000001;
      return internalGetMutableSynthesizeSpeechConfigs().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    public Builder putSynthesizeSpeechConfigs(
        java.lang.String key, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
     * SynthesizeSpeechConfig.
     *
     * These settings affect:
     *
     *  - The [phone
     *  gateway](https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
     *    synthesize configuration set via
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings].
     *
     *  - How speech is synthesized when invoking
     *  [session][google.cloud.dialogflow.cx.v3beta1.Sessions] APIs.
     *    [Agent.text_to_speech_settings][google.cloud.dialogflow.cx.v3beta1.Agent.text_to_speech_settings]
     *    only applies if
     *    [OutputAudioConfig.synthesize_speech_config][google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig.synthesize_speech_config]
     *    is not specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 1;
     * </code>
     */
    public Builder putAllSynthesizeSpeechConfigs(
        java.util.Map<
                java.lang.String, com.google.cloud.dialogflow.cx.v3beta1.SynthesizeSpeechConfig>
            values) {
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings)
  private static final com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextToSpeechSettings> PARSER =
      new com.google.protobuf.AbstractParser<TextToSpeechSettings>() {
        @java.lang.Override
        public TextToSpeechSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextToSpeechSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextToSpeechSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TextToSpeechSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
