/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/test_case.proto

package com.google.cloud.dialogflow.cx.v3beta1;

public interface TestCaseOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.TestCase)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The unique identifier of the test case.
   * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
   * will populate the name automatically. Otherwise use format:
   * `projects/&lt;Project ID&gt;/locations/&lt;LocationID&gt;/agents/
   * &lt;AgentID&gt;/testCases/&lt;TestCase ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The unique identifier of the test case.
   * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
   * will populate the name automatically. Otherwise use format:
   * `projects/&lt;Project ID&gt;/locations/&lt;LocationID&gt;/agents/
   * &lt;AgentID&gt;/testCases/&lt;TestCase ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @return A list containing the tags.
   */
  java.util.List<java.lang.String> getTagsList();
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @return The count of tags.
   */
  int getTagsCount();
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  java.lang.String getTags(int index);
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  com.google.protobuf.ByteString getTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the test case, unique within the
   * agent. Limit of 200 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the test case, unique within the
   * agent. Limit of 200 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Additional freeform notes about the test case. Limit of 400 characters.
   * </pre>
   *
   * <code>string notes = 4;</code>
   *
   * @return The notes.
   */
  java.lang.String getNotes();
  /**
   *
   *
   * <pre>
   * Additional freeform notes about the test case. Limit of 400 characters.
   * </pre>
   *
   * <code>string notes = 4;</code>
   *
   * @return The bytes for notes.
   */
  com.google.protobuf.ByteString getNotesBytes();

  /**
   *
   *
   * <pre>
   * Config for the test case.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
   *
   * @return Whether the testConfig field is set.
   */
  boolean hasTestConfig();
  /**
   *
   *
   * <pre>
   * Config for the test case.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
   *
   * @return The testConfig.
   */
  com.google.cloud.dialogflow.cx.v3beta1.TestConfig getTestConfig();
  /**
   *
   *
   * <pre>
   * Config for the test case.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.TestConfigOrBuilder getTestConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>
      getTestCaseConversationTurnsList();
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn getTestCaseConversationTurns(int index);
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  int getTestCaseConversationTurnsCount();
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder>
      getTestCaseConversationTurnsOrBuilderList();
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder
      getTestCaseConversationTurnsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. When the test was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the creationTime field is set.
   */
  boolean hasCreationTime();
  /**
   *
   *
   * <pre>
   * Output only. When the test was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationTime.
   */
  com.google.protobuf.Timestamp getCreationTime();
  /**
   *
   *
   * <pre>
   * Output only. When the test was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The latest test result.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
   *
   * @return Whether the lastTestResult field is set.
   */
  boolean hasLastTestResult();
  /**
   *
   *
   * <pre>
   * The latest test result.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
   *
   * @return The lastTestResult.
   */
  com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult getLastTestResult();
  /**
   *
   *
   * <pre>
   * The latest test result.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultOrBuilder getLastTestResultOrBuilder();
}
