/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/session.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The top-level message returned from the
 * [StreamingDetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent]
 * method.
 *
 * Multiple response messages (N) can be returned in order.
 *
 * The first (N-1) responses set either the `recognition_result` or
 * `detect_intent_response` field, depending on the request:
 *
 * *   If the `StreamingDetectIntentRequest.query_input.audio` field was
 *     set, and the `StreamingDetectIntentRequest.enable_partial_response`
 *     field was false, the `recognition_result` field is populated for each
 *     of the (N-1) responses.
 *     See the
 *     [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult]
 *     message for details about the result message sequence.
 *
 * *   If the `StreamingDetectIntentRequest.enable_partial_response` field was
 *     true, the `detect_intent_response` field is populated for each
 *     of the (N-1) responses, where 1 &lt;= N &lt;= 4.
 *     These responses set the
 *     [DetectIntentResponse.response_type][google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type]
 *     field to `PARTIAL`.
 *
 * For the final Nth response message, the `detect_intent_response` is fully
 * populated, and
 * [DetectIntentResponse.response_type][google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type]
 * is set to `FINAL`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse}
 */
public final class StreamingDetectIntentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse)
    StreamingDetectIntentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingDetectIntentResponse.newBuilder() to construct.
  private StreamingDetectIntentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingDetectIntentResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingDetectIntentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_StreamingDetectIntentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_StreamingDetectIntentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.class,
            com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.Builder.class);
  }

  private int responseCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object response_;

  public enum ResponseCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RECOGNITION_RESULT(1),
    DETECT_INTENT_RESPONSE(2),
    RESPONSE_NOT_SET(0);
    private final int value;

    private ResponseCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResponseCase forNumber(int value) {
      switch (value) {
        case 1:
          return RECOGNITION_RESULT;
        case 2:
          return DETECT_INTENT_RESPONSE;
        case 0:
          return RESPONSE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResponseCase getResponseCase() {
    return ResponseCase.forNumber(responseCase_);
  }

  public static final int RECOGNITION_RESULT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The result of speech recognition.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
   * </code>
   *
   * @return Whether the recognitionResult field is set.
   */
  @java.lang.Override
  public boolean hasRecognitionResult() {
    return responseCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The result of speech recognition.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
   * </code>
   *
   * @return The recognitionResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult getRecognitionResult() {
    if (responseCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The result of speech recognition.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResultOrBuilder
      getRecognitionResultOrBuilder() {
    if (responseCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.getDefaultInstance();
  }

  public static final int DETECT_INTENT_RESPONSE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The response from detect intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
   * </code>
   *
   * @return Whether the detectIntentResponse field is set.
   */
  @java.lang.Override
  public boolean hasDetectIntentResponse() {
    return responseCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The response from detect intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
   * </code>
   *
   * @return The detectIntentResponse.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getDetectIntentResponse() {
    if (responseCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The response from detect intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
      getDetectIntentResponseOrBuilder() {
    if (responseCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance();
  }

  public static final int DEBUGGING_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debuggingInfo_;
  /**
   *
   *
   * <pre>
   * Debugging info that would get populated when
   * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
   * </code>
   *
   * @return Whether the debuggingInfo field is set.
   */
  @java.lang.Override
  public boolean hasDebuggingInfo() {
    return debuggingInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Debugging info that would get populated when
   * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
   * </code>
   *
   * @return The debuggingInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo getDebuggingInfo() {
    return debuggingInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.getDefaultInstance()
        : debuggingInfo_;
  }
  /**
   *
   *
   * <pre>
   * Debugging info that would get populated when
   * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfoOrBuilder
      getDebuggingInfoOrBuilder() {
    return debuggingInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.getDefaultInstance()
        : debuggingInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (responseCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_);
    }
    if (responseCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_);
    }
    if (debuggingInfo_ != null) {
      output.writeMessage(4, getDebuggingInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (responseCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_);
    }
    if (responseCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_);
    }
    if (debuggingInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDebuggingInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse other =
        (com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse) obj;

    if (hasDebuggingInfo() != other.hasDebuggingInfo()) return false;
    if (hasDebuggingInfo()) {
      if (!getDebuggingInfo().equals(other.getDebuggingInfo())) return false;
    }
    if (!getResponseCase().equals(other.getResponseCase())) return false;
    switch (responseCase_) {
      case 1:
        if (!getRecognitionResult().equals(other.getRecognitionResult())) return false;
        break;
      case 2:
        if (!getDetectIntentResponse().equals(other.getDetectIntentResponse())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDebuggingInfo()) {
      hash = (37 * hash) + DEBUGGING_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDebuggingInfo().hashCode();
    }
    switch (responseCase_) {
      case 1:
        hash = (37 * hash) + RECOGNITION_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getRecognitionResult().hashCode();
        break;
      case 2:
        hash = (37 * hash) + DETECT_INTENT_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getDetectIntentResponse().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message returned from the
   * [StreamingDetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent]
   * method.
   *
   * Multiple response messages (N) can be returned in order.
   *
   * The first (N-1) responses set either the `recognition_result` or
   * `detect_intent_response` field, depending on the request:
   *
   * *   If the `StreamingDetectIntentRequest.query_input.audio` field was
   *     set, and the `StreamingDetectIntentRequest.enable_partial_response`
   *     field was false, the `recognition_result` field is populated for each
   *     of the (N-1) responses.
   *     See the
   *     [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult]
   *     message for details about the result message sequence.
   *
   * *   If the `StreamingDetectIntentRequest.enable_partial_response` field was
   *     true, the `detect_intent_response` field is populated for each
   *     of the (N-1) responses, where 1 &lt;= N &lt;= 4.
   *     These responses set the
   *     [DetectIntentResponse.response_type][google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type]
   *     field to `PARTIAL`.
   *
   * For the final Nth response message, the `detect_intent_response` is fully
   * populated, and
   * [DetectIntentResponse.response_type][google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.response_type]
   * is set to `FINAL`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse)
      com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_StreamingDetectIntentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_StreamingDetectIntentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.class,
              com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (recognitionResultBuilder_ != null) {
        recognitionResultBuilder_.clear();
      }
      if (detectIntentResponseBuilder_ != null) {
        detectIntentResponseBuilder_.clear();
      }
      debuggingInfo_ = null;
      if (debuggingInfoBuilder_ != null) {
        debuggingInfoBuilder_.dispose();
        debuggingInfoBuilder_ = null;
      }
      responseCase_ = 0;
      response_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_StreamingDetectIntentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse build() {
      com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse result =
          new com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.debuggingInfo_ =
            debuggingInfoBuilder_ == null ? debuggingInfo_ : debuggingInfoBuilder_.build();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse result) {
      result.responseCase_ = responseCase_;
      result.response_ = this.response_;
      if (responseCase_ == 1 && recognitionResultBuilder_ != null) {
        result.response_ = recognitionResultBuilder_.build();
      }
      if (responseCase_ == 2 && detectIntentResponseBuilder_ != null) {
        result.response_ = detectIntentResponseBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse) {
        return mergeFrom(
            (com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse other) {
      if (other
          == com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
              .getDefaultInstance()) return this;
      if (other.hasDebuggingInfo()) {
        mergeDebuggingInfo(other.getDebuggingInfo());
      }
      switch (other.getResponseCase()) {
        case RECOGNITION_RESULT:
          {
            mergeRecognitionResult(other.getRecognitionResult());
            break;
          }
        case DETECT_INTENT_RESPONSE:
          {
            mergeDetectIntentResponse(other.getDetectIntentResponse());
            break;
          }
        case RESPONSE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getRecognitionResultFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getDetectIntentResponseFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getDebuggingInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int responseCase_ = 0;
    private java.lang.Object response_;

    public ResponseCase getResponseCase() {
      return ResponseCase.forNumber(responseCase_);
    }

    public Builder clearResponse() {
      responseCase_ = 0;
      response_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult,
            com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResultOrBuilder>
        recognitionResultBuilder_;
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     *
     * @return Whether the recognitionResult field is set.
     */
    @java.lang.Override
    public boolean hasRecognitionResult() {
      return responseCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     *
     * @return The recognitionResult.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
        getRecognitionResult() {
      if (recognitionResultBuilder_ == null) {
        if (responseCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
            .getDefaultInstance();
      } else {
        if (responseCase_ == 1) {
          return recognitionResultBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    public Builder setRecognitionResult(
        com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult value) {
      if (recognitionResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        recognitionResultBuilder_.setMessage(value);
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    public Builder setRecognitionResult(
        com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.Builder builderForValue) {
      if (recognitionResultBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        recognitionResultBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    public Builder mergeRecognitionResult(
        com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult value) {
      if (recognitionResultBuilder_ == null) {
        if (responseCase_ == 1
            && response_
                != com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
                    .getDefaultInstance()) {
          response_ =
              com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 1) {
          recognitionResultBuilder_.mergeFrom(value);
        } else {
          recognitionResultBuilder_.setMessage(value);
        }
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    public Builder clearRecognitionResult() {
      if (recognitionResultBuilder_ == null) {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
        }
        recognitionResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.Builder
        getRecognitionResultBuilder() {
      return getRecognitionResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResultOrBuilder
        getRecognitionResultOrBuilder() {
      if ((responseCase_ == 1) && (recognitionResultBuilder_ != null)) {
        return recognitionResultBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult recognition_result = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult,
            com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResultOrBuilder>
        getRecognitionResultFieldBuilder() {
      if (recognitionResultBuilder_ == null) {
        if (!(responseCase_ == 1)) {
          response_ =
              com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
                  .getDefaultInstance();
        }
        recognitionResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult,
                com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResultOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult) response_,
                getParentForChildren(),
                isClean());
        response_ = null;
      }
      responseCase_ = 1;
      onChanged();
      return recognitionResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
            com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
        detectIntentResponseBuilder_;
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     *
     * @return Whether the detectIntentResponse field is set.
     */
    @java.lang.Override
    public boolean hasDetectIntentResponse() {
      return responseCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     *
     * @return The detectIntentResponse.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getDetectIntentResponse() {
      if (detectIntentResponseBuilder_ == null) {
        if (responseCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance();
      } else {
        if (responseCase_ == 2) {
          return detectIntentResponseBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    public Builder setDetectIntentResponse(
        com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
      if (detectIntentResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        detectIntentResponseBuilder_.setMessage(value);
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    public Builder setDetectIntentResponse(
        com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder builderForValue) {
      if (detectIntentResponseBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        detectIntentResponseBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    public Builder mergeDetectIntentResponse(
        com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
      if (detectIntentResponseBuilder_ == null) {
        if (responseCase_ == 2
            && response_
                != com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
                    .getDefaultInstance()) {
          response_ =
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 2) {
          detectIntentResponseBuilder_.mergeFrom(value);
        } else {
          detectIntentResponseBuilder_.setMessage(value);
        }
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    public Builder clearDetectIntentResponse() {
      if (detectIntentResponseBuilder_ == null) {
        if (responseCase_ == 2) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 2) {
          responseCase_ = 0;
          response_ = null;
        }
        detectIntentResponseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder
        getDetectIntentResponseBuilder() {
      return getDetectIntentResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
        getDetectIntentResponseOrBuilder() {
      if ((responseCase_ == 2) && (detectIntentResponseBuilder_ != null)) {
        return detectIntentResponseBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The response from detect intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse detect_intent_response = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
            com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
        getDetectIntentResponseFieldBuilder() {
      if (detectIntentResponseBuilder_ == null) {
        if (!(responseCase_ == 2)) {
          response_ =
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance();
        }
        detectIntentResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
                com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse) response_,
                getParentForChildren(),
                isClean());
        response_ = null;
      }
      responseCase_ = 2;
      onChanged();
      return detectIntentResponseBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debuggingInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo,
            com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfoOrBuilder>
        debuggingInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     *
     * @return Whether the debuggingInfo field is set.
     */
    public boolean hasDebuggingInfo() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     *
     * @return The debuggingInfo.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo
        getDebuggingInfo() {
      if (debuggingInfoBuilder_ == null) {
        return debuggingInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo
                .getDefaultInstance()
            : debuggingInfo_;
      } else {
        return debuggingInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    public Builder setDebuggingInfo(
        com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo value) {
      if (debuggingInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        debuggingInfo_ = value;
      } else {
        debuggingInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    public Builder setDebuggingInfo(
        com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.Builder
            builderForValue) {
      if (debuggingInfoBuilder_ == null) {
        debuggingInfo_ = builderForValue.build();
      } else {
        debuggingInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    public Builder mergeDebuggingInfo(
        com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo value) {
      if (debuggingInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && debuggingInfo_ != null
            && debuggingInfo_
                != com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo
                    .getDefaultInstance()) {
          getDebuggingInfoBuilder().mergeFrom(value);
        } else {
          debuggingInfo_ = value;
        }
      } else {
        debuggingInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    public Builder clearDebuggingInfo() {
      bitField0_ = (bitField0_ & ~0x00000004);
      debuggingInfo_ = null;
      if (debuggingInfoBuilder_ != null) {
        debuggingInfoBuilder_.dispose();
        debuggingInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.Builder
        getDebuggingInfoBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDebuggingInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfoOrBuilder
        getDebuggingInfoOrBuilder() {
      if (debuggingInfoBuilder_ != null) {
        return debuggingInfoBuilder_.getMessageOrBuilder();
      } else {
        return debuggingInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo
                .getDefaultInstance()
            : debuggingInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Debugging info that would get populated when
     * `StreamingDetectIntentRequest.enable_debugging_info` is set to true.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo debugging_info = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo,
            com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfoOrBuilder>
        getDebuggingInfoFieldBuilder() {
      if (debuggingInfoBuilder_ == null) {
        debuggingInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo,
                com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfo.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.CloudConversationDebuggingInfoOrBuilder>(
                getDebuggingInfo(), getParentForChildren(), isClean());
        debuggingInfo_ = null;
      }
      return debuggingInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse)
  private static final com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingDetectIntentResponse> PARSER =
      new com.google.protobuf.AbstractParser<StreamingDetectIntentResponse>() {
        @java.lang.Override
        public StreamingDetectIntentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingDetectIntentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingDetectIntentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
