/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/agent.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [Agents.RestoreAgent][google.cloud.dialogflow.cx.v3beta1.Agents.RestoreAgent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest}
 */
public final class RestoreAgentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest)
    RestoreAgentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreAgentRequest.newBuilder() to construct.
  private RestoreAgentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreAgentRequest() {
    name_ = "";
    restoreOption_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreAgentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.class,
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Restore option.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption}
   */
  public enum RestoreOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Treated as KEEP.
     * </pre>
     *
     * <code>RESTORE_OPTION_UNSPECIFIED = 0;</code>
     */
    RESTORE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Always respect the settings from the exported agent file. It may cause
     * a restoration failure if some settings (e.g. model type) are not
     * supported in the target agent.
     * </pre>
     *
     * <code>KEEP = 1;</code>
     */
    KEEP(1),
    /**
     *
     *
     * <pre>
     * Fallback to default settings if some settings are not supported in the
     * target agent.
     * </pre>
     *
     * <code>FALLBACK = 2;</code>
     */
    FALLBACK(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Treated as KEEP.
     * </pre>
     *
     * <code>RESTORE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int RESTORE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Always respect the settings from the exported agent file. It may cause
     * a restoration failure if some settings (e.g. model type) are not
     * supported in the target agent.
     * </pre>
     *
     * <code>KEEP = 1;</code>
     */
    public static final int KEEP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Fallback to default settings if some settings are not supported in the
     * target agent.
     * </pre>
     *
     * <code>FALLBACK = 2;</code>
     */
    public static final int FALLBACK_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RestoreOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RestoreOption forNumber(int value) {
      switch (value) {
        case 0:
          return RESTORE_OPTION_UNSPECIFIED;
        case 1:
          return KEEP;
        case 2:
          return FALLBACK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RestoreOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RestoreOption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RestoreOption>() {
          public RestoreOption findValueByNumber(int number) {
            return RestoreOption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RestoreOption[] VALUES = values();

    public static RestoreOption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RestoreOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption)
  }

  public interface GitSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * tracking branch for the git pull
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The trackingBranch.
     */
    java.lang.String getTrackingBranch();
    /**
     *
     *
     * <pre>
     * tracking branch for the git pull
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The bytes for trackingBranch.
     */
    com.google.protobuf.ByteString getTrackingBranchBytes();
  }
  /**
   *
   *
   * <pre>
   * Settings for restoring from a git branch
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource}
   */
  public static final class GitSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource)
      GitSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GitSource.newBuilder() to construct.
    private GitSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GitSource() {
      trackingBranch_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GitSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_GitSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_GitSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.class,
              com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder.class);
    }

    public static final int TRACKING_BRANCH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object trackingBranch_ = "";
    /**
     *
     *
     * <pre>
     * tracking branch for the git pull
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The trackingBranch.
     */
    @java.lang.Override
    public java.lang.String getTrackingBranch() {
      java.lang.Object ref = trackingBranch_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trackingBranch_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * tracking branch for the git pull
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The bytes for trackingBranch.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTrackingBranchBytes() {
      java.lang.Object ref = trackingBranch_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trackingBranch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingBranch_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, trackingBranch_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingBranch_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, trackingBranch_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource other =
          (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) obj;

      if (!getTrackingBranch().equals(other.getTrackingBranch())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TRACKING_BRANCH_FIELD_NUMBER;
      hash = (53 * hash) + getTrackingBranch().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for restoring from a git branch
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource)
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_GitSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_GitSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.class,
                com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        trackingBranch_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_GitSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource build() {
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource result =
            new com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.trackingBranch_ = trackingBranch_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
                .getDefaultInstance()) return this;
        if (!other.getTrackingBranch().isEmpty()) {
          trackingBranch_ = other.trackingBranch_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  trackingBranch_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object trackingBranch_ = "";
      /**
       *
       *
       * <pre>
       * tracking branch for the git pull
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @return The trackingBranch.
       */
      public java.lang.String getTrackingBranch() {
        java.lang.Object ref = trackingBranch_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          trackingBranch_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * tracking branch for the git pull
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @return The bytes for trackingBranch.
       */
      public com.google.protobuf.ByteString getTrackingBranchBytes() {
        java.lang.Object ref = trackingBranch_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          trackingBranch_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * tracking branch for the git pull
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @param value The trackingBranch to set.
       * @return This builder for chaining.
       */
      public Builder setTrackingBranch(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        trackingBranch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * tracking branch for the git pull
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrackingBranch() {
        trackingBranch_ = getDefaultInstance().getTrackingBranch();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * tracking branch for the git pull
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @param value The bytes for trackingBranch to set.
       * @return This builder for chaining.
       */
      public Builder setTrackingBranchBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        trackingBranch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource)
    private static final com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GitSource> PARSER =
        new com.google.protobuf.AbstractParser<GitSource>() {
          @java.lang.Override
          public GitSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GitSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GitSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int agentCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object agent_;

  public enum AgentCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AGENT_URI(2),
    AGENT_CONTENT(3),
    GIT_SOURCE(6),
    AGENT_NOT_SET(0);
    private final int value;

    private AgentCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AgentCase valueOf(int value) {
      return forNumber(value);
    }

    public static AgentCase forNumber(int value) {
      switch (value) {
        case 2:
          return AGENT_URI;
        case 3:
          return AGENT_CONTENT;
        case 6:
          return GIT_SOURCE;
        case 0:
          return AGENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AgentCase getAgentCase() {
    return AgentCase.forNumber(agentCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to restore into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to restore into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGENT_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to restore agent from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2;</code>
   *
   * @return Whether the agentUri field is set.
   */
  public boolean hasAgentUri() {
    return agentCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to restore agent from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2;</code>
   *
   * @return The agentUri.
   */
  public java.lang.String getAgentUri() {
    java.lang.Object ref = "";
    if (agentCase_ == 2) {
      ref = agent_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (agentCase_ == 2) {
        agent_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to restore agent from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2;</code>
   *
   * @return The bytes for agentUri.
   */
  public com.google.protobuf.ByteString getAgentUriBytes() {
    java.lang.Object ref = "";
    if (agentCase_ == 2) {
      ref = agent_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (agentCase_ == 2) {
        agent_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGENT_CONTENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for agent.
   * </pre>
   *
   * <code>bytes agent_content = 3;</code>
   *
   * @return Whether the agentContent field is set.
   */
  @java.lang.Override
  public boolean hasAgentContent() {
    return agentCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for agent.
   * </pre>
   *
   * <code>bytes agent_content = 3;</code>
   *
   * @return The agentContent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentContent() {
    if (agentCase_ == 3) {
      return (com.google.protobuf.ByteString) agent_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int GIT_SOURCE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Setting for restoring from a git branch
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;</code>
   *
   * @return Whether the gitSource field is set.
   */
  @java.lang.Override
  public boolean hasGitSource() {
    return agentCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Setting for restoring from a git branch
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;</code>
   *
   * @return The gitSource.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource getGitSource() {
    if (agentCase_ == 6) {
      return (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Setting for restoring from a git branch
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSourceOrBuilder
      getGitSourceOrBuilder() {
    if (agentCase_ == 6) {
      return (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
        .getDefaultInstance();
  }

  public static final int RESTORE_OPTION_FIELD_NUMBER = 5;
  private int restoreOption_ = 0;
  /**
   *
   *
   * <pre>
   * Agent restore mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for restoreOption.
   */
  @java.lang.Override
  public int getRestoreOptionValue() {
    return restoreOption_;
  }
  /**
   *
   *
   * <pre>
   * Agent restore mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
   * </code>
   *
   * @return The restoreOption.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption
      getRestoreOption() {
    com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption result =
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption.forNumber(
            restoreOption_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (agentCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, agent_);
    }
    if (agentCase_ == 3) {
      output.writeBytes(3, (com.google.protobuf.ByteString) agent_);
    }
    if (restoreOption_
        != com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption
            .RESTORE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, restoreOption_);
    }
    if (agentCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (agentCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, agent_);
    }
    if (agentCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              3, (com.google.protobuf.ByteString) agent_);
    }
    if (restoreOption_
        != com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption
            .RESTORE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, restoreOption_);
    }
    if (agentCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest other =
        (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (restoreOption_ != other.restoreOption_) return false;
    if (!getAgentCase().equals(other.getAgentCase())) return false;
    switch (agentCase_) {
      case 2:
        if (!getAgentUri().equals(other.getAgentUri())) return false;
        break;
      case 3:
        if (!getAgentContent().equals(other.getAgentContent())) return false;
        break;
      case 6:
        if (!getGitSource().equals(other.getGitSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + RESTORE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + restoreOption_;
    switch (agentCase_) {
      case 2:
        hash = (37 * hash) + AGENT_URI_FIELD_NUMBER;
        hash = (53 * hash) + getAgentUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AGENT_CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getAgentContent().hashCode();
        break;
      case 6:
        hash = (37 * hash) + GIT_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGitSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Agents.RestoreAgent][google.cloud.dialogflow.cx.v3beta1.Agents.RestoreAgent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest)
      com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.class,
              com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (gitSourceBuilder_ != null) {
        gitSourceBuilder_.clear();
      }
      restoreOption_ = 0;
      agentCase_ = 0;
      agent_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_RestoreAgentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest build() {
      com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest result =
          new com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.restoreOption_ = restoreOption_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest result) {
      result.agentCase_ = agentCase_;
      result.agent_ = this.agent_;
      if (agentCase_ == 6 && gitSourceBuilder_ != null) {
        result.agent_ = gitSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.restoreOption_ != 0) {
        setRestoreOptionValue(other.getRestoreOptionValue());
      }
      switch (other.getAgentCase()) {
        case AGENT_URI:
          {
            agentCase_ = 2;
            agent_ = other.agent_;
            onChanged();
            break;
          }
        case AGENT_CONTENT:
          {
            setAgentContent(other.getAgentContent());
            break;
          }
        case GIT_SOURCE:
          {
            mergeGitSource(other.getGitSource());
            break;
          }
        case AGENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                agentCase_ = 2;
                agent_ = s;
                break;
              } // case 18
            case 26:
              {
                agent_ = input.readBytes();
                agentCase_ = 3;
                break;
              } // case 26
            case 40:
              {
                restoreOption_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getGitSourceFieldBuilder().getBuilder(), extensionRegistry);
                agentCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int agentCase_ = 0;
    private java.lang.Object agent_;

    public AgentCase getAgentCase() {
      return AgentCase.forNumber(agentCase_);
    }

    public Builder clearAgent() {
      agentCase_ = 0;
      agent_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to restore into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to restore into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to restore into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to restore into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to restore into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to restore agent from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2;</code>
     *
     * @return Whether the agentUri field is set.
     */
    @java.lang.Override
    public boolean hasAgentUri() {
      return agentCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to restore agent from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2;</code>
     *
     * @return The agentUri.
     */
    @java.lang.Override
    public java.lang.String getAgentUri() {
      java.lang.Object ref = "";
      if (agentCase_ == 2) {
        ref = agent_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (agentCase_ == 2) {
          agent_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to restore agent from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2;</code>
     *
     * @return The bytes for agentUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAgentUriBytes() {
      java.lang.Object ref = "";
      if (agentCase_ == 2) {
        ref = agent_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (agentCase_ == 2) {
          agent_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to restore agent from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2;</code>
     *
     * @param value The agentUri to set.
     * @return This builder for chaining.
     */
    public Builder setAgentUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentCase_ = 2;
      agent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to restore agent from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentUri() {
      if (agentCase_ == 2) {
        agentCase_ = 0;
        agent_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to restore agent from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2;</code>
     *
     * @param value The bytes for agentUri to set.
     * @return This builder for chaining.
     */
    public Builder setAgentUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agentCase_ = 2;
      agent_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for agent.
     * </pre>
     *
     * <code>bytes agent_content = 3;</code>
     *
     * @return Whether the agentContent field is set.
     */
    public boolean hasAgentContent() {
      return agentCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for agent.
     * </pre>
     *
     * <code>bytes agent_content = 3;</code>
     *
     * @return The agentContent.
     */
    public com.google.protobuf.ByteString getAgentContent() {
      if (agentCase_ == 3) {
        return (com.google.protobuf.ByteString) agent_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for agent.
     * </pre>
     *
     * <code>bytes agent_content = 3;</code>
     *
     * @param value The agentContent to set.
     * @return This builder for chaining.
     */
    public Builder setAgentContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentCase_ = 3;
      agent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for agent.
     * </pre>
     *
     * <code>bytes agent_content = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentContent() {
      if (agentCase_ == 3) {
        agentCase_ = 0;
        agent_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource,
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSourceOrBuilder>
        gitSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     *
     * @return Whether the gitSource field is set.
     */
    @java.lang.Override
    public boolean hasGitSource() {
      return agentCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     *
     * @return The gitSource.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource getGitSource() {
      if (gitSourceBuilder_ == null) {
        if (agentCase_ == 6) {
          return (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
            .getDefaultInstance();
      } else {
        if (agentCase_ == 6) {
          return gitSourceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    public Builder setGitSource(
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource value) {
      if (gitSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        agent_ = value;
        onChanged();
      } else {
        gitSourceBuilder_.setMessage(value);
      }
      agentCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    public Builder setGitSource(
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder
            builderForValue) {
      if (gitSourceBuilder_ == null) {
        agent_ = builderForValue.build();
        onChanged();
      } else {
        gitSourceBuilder_.setMessage(builderForValue.build());
      }
      agentCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    public Builder mergeGitSource(
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource value) {
      if (gitSourceBuilder_ == null) {
        if (agentCase_ == 6
            && agent_
                != com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
                    .getDefaultInstance()) {
          agent_ =
              com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          agent_ = value;
        }
        onChanged();
      } else {
        if (agentCase_ == 6) {
          gitSourceBuilder_.mergeFrom(value);
        } else {
          gitSourceBuilder_.setMessage(value);
        }
      }
      agentCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    public Builder clearGitSource() {
      if (gitSourceBuilder_ == null) {
        if (agentCase_ == 6) {
          agentCase_ = 0;
          agent_ = null;
          onChanged();
        }
      } else {
        if (agentCase_ == 6) {
          agentCase_ = 0;
          agent_ = null;
        }
        gitSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder
        getGitSourceBuilder() {
      return getGitSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSourceOrBuilder
        getGitSourceOrBuilder() {
      if ((agentCase_ == 6) && (gitSourceBuilder_ != null)) {
        return gitSourceBuilder_.getMessageOrBuilder();
      } else {
        if (agentCase_ == 6) {
          return (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Setting for restoring from a git branch
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource git_source = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource,
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSourceOrBuilder>
        getGitSourceFieldBuilder() {
      if (gitSourceBuilder_ == null) {
        if (!(agentCase_ == 6)) {
          agent_ =
              com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource
                  .getDefaultInstance();
        }
        gitSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource,
                com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSourceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.GitSource) agent_,
                getParentForChildren(),
                isClean());
        agent_ = null;
      }
      agentCase_ = 6;
      onChanged();
      return gitSourceBuilder_;
    }

    private int restoreOption_ = 0;
    /**
     *
     *
     * <pre>
     * Agent restore mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for restoreOption.
     */
    @java.lang.Override
    public int getRestoreOptionValue() {
      return restoreOption_;
    }
    /**
     *
     *
     * <pre>
     * Agent restore mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for restoreOption to set.
     * @return This builder for chaining.
     */
    public Builder setRestoreOptionValue(int value) {
      restoreOption_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent restore mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
     * </code>
     *
     * @return The restoreOption.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption
        getRestoreOption() {
      com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption result =
          com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption.forNumber(
              restoreOption_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Agent restore mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
     * </code>
     *
     * @param value The restoreOption to set.
     * @return This builder for chaining.
     */
    public Builder setRestoreOption(
        com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      restoreOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent restore mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest.RestoreOption restore_option = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestoreOption() {
      bitField0_ = (bitField0_ & ~0x00000010);
      restoreOption_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest)
  private static final com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreAgentRequest> PARSER =
      new com.google.protobuf.AbstractParser<RestoreAgentRequest>() {
        @java.lang.Override
        public RestoreAgentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreAgentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreAgentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
