/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/response_message.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Represents a response message that can be returned by a conversational agent.
 *
 * Response messages are also used for output audio synthesis. The approach is
 * as follows:
 *
 * * If at least one OutputAudioText response is present, then all
 *   OutputAudioText responses are linearly concatenated, and the result is used
 *   for output audio synthesis.
 * * If the OutputAudioText responses are a mixture of text and SSML, then the
 *   concatenated result is treated as SSML; otherwise, the result is treated as
 *   either text or SSML as appropriate. The agent designer should ideally use
 *   either text or SSML consistently throughout the bot design.
 * * Otherwise, all Text responses are linearly concatenated, and the result is
 *   used for output audio synthesis.
 *
 * This approach allows for more sophisticated user experience scenarios, where
 * the text displayed to the user may differ from what is heard.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage}
 */
public final class ResponseMessage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage)
    ResponseMessageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResponseMessage.newBuilder() to construct.
  private ResponseMessage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResponseMessage() {
    channel_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResponseMessage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.class,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Builder.class);
  }

  public interface TextOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the text.
     */
    java.util.List<java.lang.String> getTextList();
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of text.
     */
    int getTextCount();
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The text at the given index.
     */
    java.lang.String getText(int index);
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the text at the given index.
     */
    com.google.protobuf.ByteString getTextBytes(int index);

    /**
     *
     *
     * <pre>
     * Output only. Whether the playback of this message can be interrupted by
     * the end user's speech and the client can then starts the next Dialogflow
     * request.
     * </pre>
     *
     * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowPlaybackInterruption.
     */
    boolean getAllowPlaybackInterruption();
  }
  /**
   *
   *
   * <pre>
   * The text response message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text}
   */
  public static final class Text extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text)
      TextOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Text.newBuilder() to construct.
    private Text(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Text() {
      text_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Text();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_Text_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_Text_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList text_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the text.
     */
    public com.google.protobuf.ProtocolStringList getTextList() {
      return text_;
    }
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of text.
     */
    public int getTextCount() {
      return text_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The text at the given index.
     */
    public java.lang.String getText(int index) {
      return text_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A collection of text responses.
     * </pre>
     *
     * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the text at the given index.
     */
    public com.google.protobuf.ByteString getTextBytes(int index) {
      return text_.getByteString(index);
    }

    public static final int ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER = 2;
    private boolean allowPlaybackInterruption_ = false;
    /**
     *
     *
     * <pre>
     * Output only. Whether the playback of this message can be interrupted by
     * the end user's speech and the client can then starts the next Dialogflow
     * request.
     * </pre>
     *
     * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowPlaybackInterruption.
     */
    @java.lang.Override
    public boolean getAllowPlaybackInterruption() {
      return allowPlaybackInterruption_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < text_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_.getRaw(i));
      }
      if (allowPlaybackInterruption_ != false) {
        output.writeBool(2, allowPlaybackInterruption_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < text_.size(); i++) {
          dataSize += computeStringSizeNoTag(text_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTextList().size();
      }
      if (allowPlaybackInterruption_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowPlaybackInterruption_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) obj;

      if (!getTextList().equals(other.getTextList())) return false;
      if (getAllowPlaybackInterruption() != other.getAllowPlaybackInterruption()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTextCount() > 0) {
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getTextList().hashCode();
      }
      hash = (37 * hash) + ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowPlaybackInterruption());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The text response message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TextOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_Text_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_Text_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = com.google.protobuf.LazyStringArrayList.emptyList();
        allowPlaybackInterruption_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_Text_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          text_.makeImmutable();
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allowPlaybackInterruption_ = allowPlaybackInterruption_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance())
          return this;
        if (!other.text_.isEmpty()) {
          if (text_.isEmpty()) {
            text_ = other.text_;
            bitField0_ |= 0x00000001;
          } else {
            ensureTextIsMutable();
            text_.addAll(other.text_);
          }
          onChanged();
        }
        if (other.getAllowPlaybackInterruption() != false) {
          setAllowPlaybackInterruption(other.getAllowPlaybackInterruption());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTextIsMutable();
                  text_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  allowPlaybackInterruption_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList text_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTextIsMutable() {
        if (!text_.isModifiable()) {
          text_ = new com.google.protobuf.LazyStringArrayList(text_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the text.
       */
      public com.google.protobuf.ProtocolStringList getTextList() {
        text_.makeImmutable();
        return text_;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of text.
       */
      public int getTextCount() {
        return text_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The text at the given index.
       */
      public java.lang.String getText(int index) {
        return text_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the text at the given index.
       */
      public com.google.protobuf.ByteString getTextBytes(int index) {
        return text_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index to set the value at.
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextIsMutable();
        text_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The text to add.
       * @return This builder for chaining.
       */
      public Builder addText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextIsMutable();
        text_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param values The text to add.
       * @return This builder for chaining.
       */
      public Builder addAllText(java.lang.Iterable<java.lang.String> values) {
        ensureTextIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, text_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of text responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes of the text to add.
       * @return This builder for chaining.
       */
      public Builder addTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTextIsMutable();
        text_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean allowPlaybackInterruption_;
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The allowPlaybackInterruption.
       */
      @java.lang.Override
      public boolean getAllowPlaybackInterruption() {
        return allowPlaybackInterruption_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The allowPlaybackInterruption to set.
       * @return This builder for chaining.
       */
      public Builder setAllowPlaybackInterruption(boolean value) {

        allowPlaybackInterruption_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowPlaybackInterruption() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allowPlaybackInterruption_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Text> PARSER =
        new com.google.protobuf.AbstractParser<Text>() {
          @java.lang.Override
          public Text parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Text> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Text> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LiveAgentHandoffOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Custom metadata for your handoff procedure. Dialogflow doesn't impose
     * any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Custom metadata for your handoff procedure. Dialogflow doesn't impose
     * any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return The metadata.
     */
    com.google.protobuf.Struct getMetadata();
    /**
     *
     *
     * <pre>
     * Custom metadata for your handoff procedure. Dialogflow doesn't impose
     * any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     */
    com.google.protobuf.StructOrBuilder getMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Indicates that the conversation should be handed off to a live agent.
   *
   * Dialogflow only uses this to determine which conversations were handed off
   * to a human agent for measurement purposes. What else to do with this signal
   * is up to you and your handoff procedures.
   *
   * You may set this, for example:
   * * In the
   * [entry_fulfillment][google.cloud.dialogflow.cx.v3beta1.Page.entry_fulfillment]
   * of a [Page][google.cloud.dialogflow.cx.v3beta1.Page] if
   *   entering the page indicates something went extremely wrong in the
   *   conversation.
   * * In a webhook response when you determine that the customer issue can only
   *   be handled by a human.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff}
   */
  public static final class LiveAgentHandoff extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)
      LiveAgentHandoffOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LiveAgentHandoff.newBuilder() to construct.
    private LiveAgentHandoff(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LiveAgentHandoff() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LiveAgentHandoff();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_LiveAgentHandoff_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_LiveAgentHandoff_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder
                  .class);
    }

    public static final int METADATA_FIELD_NUMBER = 1;
    private com.google.protobuf.Struct metadata_;
    /**
     *
     *
     * <pre>
     * Custom metadata for your handoff procedure. Dialogflow doesn't impose
     * any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    @java.lang.Override
    public boolean hasMetadata() {
      return metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata for your handoff procedure. Dialogflow doesn't impose
     * any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return The metadata.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getMetadata() {
      return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata for your handoff procedure. Dialogflow doesn't impose
     * any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
      return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (metadata_ != null) {
        output.writeMessage(1, getMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (metadata_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) obj;

      if (hasMetadata() != other.hasMetadata()) return false;
      if (hasMetadata()) {
        if (!getMetadata().equals(other.getMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation should be handed off to a live agent.
     *
     * Dialogflow only uses this to determine which conversations were handed off
     * to a human agent for measurement purposes. What else to do with this signal
     * is up to you and your handoff procedures.
     *
     * You may set this, for example:
     * * In the
     * [entry_fulfillment][google.cloud.dialogflow.cx.v3beta1.Page.entry_fulfillment]
     * of a [Page][google.cloud.dialogflow.cx.v3beta1.Page] if
     *   entering the page indicates something went extremely wrong in the
     *   conversation.
     * * In a webhook response when you determine that the customer issue can only
     *   be handled by a human.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoffOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_LiveAgentHandoff_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_LiveAgentHandoff_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_LiveAgentHandoff_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
                .getDefaultInstance()) return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Struct metadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       *
       * @return Whether the metadata field is set.
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       *
       * @return The metadata.
       */
      public com.google.protobuf.Struct getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder setMetadata(com.google.protobuf.Struct value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder setMetadata(com.google.protobuf.Struct.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder mergeMetadata(com.google.protobuf.Struct value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && metadata_ != null
              && metadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getMetadataBuilder().mergeFrom(value);
          } else {
            metadata_ = value;
          }
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000001);
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public com.google.protobuf.Struct.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Custom metadata for your handoff procedure. Dialogflow doesn't impose
       * any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LiveAgentHandoff> PARSER =
        new com.google.protobuf.AbstractParser<LiveAgentHandoff>() {
          @java.lang.Override
          public LiveAgentHandoff parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LiveAgentHandoff> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LiveAgentHandoff> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConversationSuccessOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Custom metadata. Dialogflow doesn't impose any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Custom metadata. Dialogflow doesn't impose any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return The metadata.
     */
    com.google.protobuf.Struct getMetadata();
    /**
     *
     *
     * <pre>
     * Custom metadata. Dialogflow doesn't impose any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     */
    com.google.protobuf.StructOrBuilder getMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Indicates that the conversation succeeded, i.e., the bot handled the issue
   * that the customer talked to it about.
   *
   * Dialogflow only uses this to determine which conversations should be
   * counted as successful and doesn't process the metadata in this message in
   * any way. Note that Dialogflow also considers conversations that get to the
   * conversation end page as successful even if they don't return
   * [ConversationSuccess][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess].
   *
   * You may set this, for example:
   * * In the
   * [entry_fulfillment][google.cloud.dialogflow.cx.v3beta1.Page.entry_fulfillment]
   * of a [Page][google.cloud.dialogflow.cx.v3beta1.Page] if
   *   entering the page indicates that the conversation succeeded.
   * * In a webhook response when you determine that you handled the customer
   *   issue.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess}
   */
  public static final class ConversationSuccess extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
      ConversationSuccessOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConversationSuccess.newBuilder() to construct.
    private ConversationSuccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConversationSuccess() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConversationSuccess();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_ConversationSuccess_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_ConversationSuccess_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder
                  .class);
    }

    public static final int METADATA_FIELD_NUMBER = 1;
    private com.google.protobuf.Struct metadata_;
    /**
     *
     *
     * <pre>
     * Custom metadata. Dialogflow doesn't impose any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    @java.lang.Override
    public boolean hasMetadata() {
      return metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata. Dialogflow doesn't impose any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     *
     * @return The metadata.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getMetadata() {
      return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata. Dialogflow doesn't impose any structure on this.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
      return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (metadata_ != null) {
        output.writeMessage(1, getMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (metadata_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess) obj;

      if (hasMetadata() != other.hasMetadata()) return false;
      if (hasMetadata()) {
        if (!getMetadata().equals(other.getMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded, i.e., the bot handled the issue
     * that the customer talked to it about.
     *
     * Dialogflow only uses this to determine which conversations should be
     * counted as successful and doesn't process the metadata in this message in
     * any way. Note that Dialogflow also considers conversations that get to the
     * conversation end page as successful even if they don't return
     * [ConversationSuccess][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess].
     *
     * You may set this, for example:
     * * In the
     * [entry_fulfillment][google.cloud.dialogflow.cx.v3beta1.Page.entry_fulfillment]
     * of a [Page][google.cloud.dialogflow.cx.v3beta1.Page] if
     *   entering the page indicates that the conversation succeeded.
     * * In a webhook response when you determine that you handled the customer
     *   issue.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccessOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_ConversationSuccess_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_ConversationSuccess_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_ConversationSuccess_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
                .getDefaultInstance()) return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Struct metadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       *
       * @return Whether the metadata field is set.
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       *
       * @return The metadata.
       */
      public com.google.protobuf.Struct getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder setMetadata(com.google.protobuf.Struct value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder setMetadata(com.google.protobuf.Struct.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder mergeMetadata(com.google.protobuf.Struct value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && metadata_ != null
              && metadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getMetadataBuilder().mergeFrom(value);
          } else {
            metadata_ = value;
          }
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000001);
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public com.google.protobuf.Struct.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Custom metadata. Dialogflow doesn't impose any structure on this.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConversationSuccess> PARSER =
        new com.google.protobuf.AbstractParser<ConversationSuccess>() {
          @java.lang.Override
          public ConversationSuccess parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConversationSuccess> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConversationSuccess> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OutputAudioTextOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    boolean hasText();
    /**
     *
     *
     * <pre>
     * The raw text to be synthesized.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * The raw text to be synthesized.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * The SSML text to be synthesized. For more information, see
     * [SSML](/speech/text-to-speech/docs/ssml).
     * </pre>
     *
     * <code>string ssml = 2;</code>
     *
     * @return Whether the ssml field is set.
     */
    boolean hasSsml();
    /**
     *
     *
     * <pre>
     * The SSML text to be synthesized. For more information, see
     * [SSML](/speech/text-to-speech/docs/ssml).
     * </pre>
     *
     * <code>string ssml = 2;</code>
     *
     * @return The ssml.
     */
    java.lang.String getSsml();
    /**
     *
     *
     * <pre>
     * The SSML text to be synthesized. For more information, see
     * [SSML](/speech/text-to-speech/docs/ssml).
     * </pre>
     *
     * <code>string ssml = 2;</code>
     *
     * @return The bytes for ssml.
     */
    com.google.protobuf.ByteString getSsmlBytes();

    /**
     *
     *
     * <pre>
     * Output only. Whether the playback of this message can be interrupted by
     * the end user's speech and the client can then starts the next Dialogflow
     * request.
     * </pre>
     *
     * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowPlaybackInterruption.
     */
    boolean getAllowPlaybackInterruption();

    com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.SourceCase
        getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * A text or ssml response that is preferentially used for TTS output audio
   * synthesis, as described in the comment on the ResponseMessage message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText}
   */
  public static final class OutputAudioText extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)
      OutputAudioTextOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputAudioText.newBuilder() to construct.
    private OutputAudioText(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputAudioText() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputAudioText();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_OutputAudioText_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_OutputAudioText_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder.class);
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT(1),
      SSML(2),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return TEXT;
          case 2:
            return SSML;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int TEXT_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The raw text to be synthesized.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    public boolean hasText() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The raw text to be synthesized.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (sourceCase_ == 1) {
        ref = source_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 1) {
          source_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The raw text to be synthesized.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 1) {
        ref = source_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 1) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SSML_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The SSML text to be synthesized. For more information, see
     * [SSML](/speech/text-to-speech/docs/ssml).
     * </pre>
     *
     * <code>string ssml = 2;</code>
     *
     * @return Whether the ssml field is set.
     */
    public boolean hasSsml() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The SSML text to be synthesized. For more information, see
     * [SSML](/speech/text-to-speech/docs/ssml).
     * </pre>
     *
     * <code>string ssml = 2;</code>
     *
     * @return The ssml.
     */
    public java.lang.String getSsml() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 2) {
          source_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The SSML text to be synthesized. For more information, see
     * [SSML](/speech/text-to-speech/docs/ssml).
     * </pre>
     *
     * <code>string ssml = 2;</code>
     *
     * @return The bytes for ssml.
     */
    public com.google.protobuf.ByteString getSsmlBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 2) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER = 3;
    private boolean allowPlaybackInterruption_ = false;
    /**
     *
     *
     * <pre>
     * Output only. Whether the playback of this message can be interrupted by
     * the end user's speech and the client can then starts the next Dialogflow
     * request.
     * </pre>
     *
     * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowPlaybackInterruption.
     */
    @java.lang.Override
    public boolean getAllowPlaybackInterruption() {
      return allowPlaybackInterruption_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, source_);
      }
      if (sourceCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
      }
      if (allowPlaybackInterruption_ != false) {
        output.writeBool(3, allowPlaybackInterruption_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, source_);
      }
      if (sourceCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
      }
      if (allowPlaybackInterruption_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(3, allowPlaybackInterruption_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) obj;

      if (getAllowPlaybackInterruption() != other.getAllowPlaybackInterruption()) return false;
      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getText().equals(other.getText())) return false;
          break;
        case 2:
          if (!getSsml().equals(other.getSsml())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowPlaybackInterruption());
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + TEXT_FIELD_NUMBER;
          hash = (53 * hash) + getText().hashCode();
          break;
        case 2:
          hash = (37 * hash) + SSML_FIELD_NUMBER;
          hash = (53 * hash) + getSsml().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioTextOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_OutputAudioText_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_OutputAudioText_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allowPlaybackInterruption_ = false;
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_OutputAudioText_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.allowPlaybackInterruption_ = allowPlaybackInterruption_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
                .getDefaultInstance()) return this;
        if (other.getAllowPlaybackInterruption() != false) {
          setAllowPlaybackInterruption(other.getAllowPlaybackInterruption());
        }
        switch (other.getSourceCase()) {
          case TEXT:
            {
              sourceCase_ = 1;
              source_ = other.source_;
              onChanged();
              break;
            }
          case SSML:
            {
              sourceCase_ = 2;
              source_ = other.source_;
              onChanged();
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  sourceCase_ = 1;
                  source_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  sourceCase_ = 2;
                  source_ = s;
                  break;
                } // case 18
              case 24:
                {
                  allowPlaybackInterruption_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The raw text to be synthesized.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return Whether the text field is set.
       */
      @java.lang.Override
      public boolean hasText() {
        return sourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The raw text to be synthesized.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      @java.lang.Override
      public java.lang.String getText() {
        java.lang.Object ref = "";
        if (sourceCase_ == 1) {
          ref = source_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (sourceCase_ == 1) {
            source_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The raw text to be synthesized.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = "";
        if (sourceCase_ == 1) {
          ref = source_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (sourceCase_ == 1) {
            source_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The raw text to be synthesized.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceCase_ = 1;
        source_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The raw text to be synthesized.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The raw text to be synthesized.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceCase_ = 1;
        source_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SSML text to be synthesized. For more information, see
       * [SSML](/speech/text-to-speech/docs/ssml).
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return Whether the ssml field is set.
       */
      @java.lang.Override
      public boolean hasSsml() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The SSML text to be synthesized. For more information, see
       * [SSML](/speech/text-to-speech/docs/ssml).
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return The ssml.
       */
      @java.lang.Override
      public java.lang.String getSsml() {
        java.lang.Object ref = "";
        if (sourceCase_ == 2) {
          ref = source_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (sourceCase_ == 2) {
            source_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The SSML text to be synthesized. For more information, see
       * [SSML](/speech/text-to-speech/docs/ssml).
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return The bytes for ssml.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSsmlBytes() {
        java.lang.Object ref = "";
        if (sourceCase_ == 2) {
          ref = source_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (sourceCase_ == 2) {
            source_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The SSML text to be synthesized. For more information, see
       * [SSML](/speech/text-to-speech/docs/ssml).
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @param value The ssml to set.
       * @return This builder for chaining.
       */
      public Builder setSsml(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceCase_ = 2;
        source_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The SSML text to be synthesized. For more information, see
       * [SSML](/speech/text-to-speech/docs/ssml).
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSsml() {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The SSML text to be synthesized. For more information, see
       * [SSML](/speech/text-to-speech/docs/ssml).
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @param value The bytes for ssml to set.
       * @return This builder for chaining.
       */
      public Builder setSsmlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceCase_ = 2;
        source_ = value;
        onChanged();
        return this;
      }

      private boolean allowPlaybackInterruption_;
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The allowPlaybackInterruption.
       */
      @java.lang.Override
      public boolean getAllowPlaybackInterruption() {
        return allowPlaybackInterruption_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The allowPlaybackInterruption to set.
       * @return This builder for chaining.
       */
      public Builder setAllowPlaybackInterruption(boolean value) {

        allowPlaybackInterruption_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowPlaybackInterruption() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allowPlaybackInterruption_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputAudioText> PARSER =
        new com.google.protobuf.AbstractParser<OutputAudioText>() {
          @java.lang.Override
          public OutputAudioText parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OutputAudioText> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputAudioText> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EndInteractionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Indicates that interaction with the Dialogflow agent has ended.
   * This message is generated by Dialogflow only and not supposed to be
   * defined by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction}
   */
  public static final class EndInteraction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)
      EndInteractionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EndInteraction.newBuilder() to construct.
    private EndInteraction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EndInteraction() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EndInteraction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_EndInteraction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_EndInteraction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Indicates that interaction with the Dialogflow agent has ended.
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteractionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_EndInteraction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_EndInteraction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_EndInteraction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EndInteraction> PARSER =
        new com.google.protobuf.AbstractParser<EndInteraction>() {
          @java.lang.Override
          public EndInteraction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EndInteraction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EndInteraction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PlayAudioOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. URI of the audio clip. Dialogflow does not impose any
     * validation on this value. It is specific to the client that reads it.
     * </pre>
     *
     * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The audioUri.
     */
    java.lang.String getAudioUri();
    /**
     *
     *
     * <pre>
     * Required. URI of the audio clip. Dialogflow does not impose any
     * validation on this value. It is specific to the client that reads it.
     * </pre>
     *
     * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for audioUri.
     */
    com.google.protobuf.ByteString getAudioUriBytes();

    /**
     *
     *
     * <pre>
     * Output only. Whether the playback of this message can be interrupted by
     * the end user's speech and the client can then starts the next Dialogflow
     * request.
     * </pre>
     *
     * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowPlaybackInterruption.
     */
    boolean getAllowPlaybackInterruption();
  }
  /**
   *
   *
   * <pre>
   * Specifies an audio clip to be played by the client as part of the response.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio}
   */
  public static final class PlayAudio extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio)
      PlayAudioOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PlayAudio.newBuilder() to construct.
    private PlayAudio(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PlayAudio() {
      audioUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PlayAudio();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_PlayAudio_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_PlayAudio_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder.class);
    }

    public static final int AUDIO_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object audioUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. URI of the audio clip. Dialogflow does not impose any
     * validation on this value. It is specific to the client that reads it.
     * </pre>
     *
     * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The audioUri.
     */
    @java.lang.Override
    public java.lang.String getAudioUri() {
      java.lang.Object ref = audioUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audioUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URI of the audio clip. Dialogflow does not impose any
     * validation on this value. It is specific to the client that reads it.
     * </pre>
     *
     * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for audioUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAudioUriBytes() {
      java.lang.Object ref = audioUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audioUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER = 2;
    private boolean allowPlaybackInterruption_ = false;
    /**
     *
     *
     * <pre>
     * Output only. Whether the playback of this message can be interrupted by
     * the end user's speech and the client can then starts the next Dialogflow
     * request.
     * </pre>
     *
     * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowPlaybackInterruption.
     */
    @java.lang.Override
    public boolean getAllowPlaybackInterruption() {
      return allowPlaybackInterruption_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audioUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, audioUri_);
      }
      if (allowPlaybackInterruption_ != false) {
        output.writeBool(2, allowPlaybackInterruption_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audioUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, audioUri_);
      }
      if (allowPlaybackInterruption_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowPlaybackInterruption_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) obj;

      if (!getAudioUri().equals(other.getAudioUri())) return false;
      if (getAllowPlaybackInterruption() != other.getAllowPlaybackInterruption()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AUDIO_URI_FIELD_NUMBER;
      hash = (53 * hash) + getAudioUri().hashCode();
      hash = (37 * hash) + ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowPlaybackInterruption());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies an audio clip to be played by the client as part of the response.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudioOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_PlayAudio_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_PlayAudio_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        audioUri_ = "";
        allowPlaybackInterruption_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_PlayAudio_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.audioUri_ = audioUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allowPlaybackInterruption_ = allowPlaybackInterruption_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
                .getDefaultInstance()) return this;
        if (!other.getAudioUri().isEmpty()) {
          audioUri_ = other.audioUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getAllowPlaybackInterruption() != false) {
          setAllowPlaybackInterruption(other.getAllowPlaybackInterruption());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  audioUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  allowPlaybackInterruption_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object audioUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. URI of the audio clip. Dialogflow does not impose any
       * validation on this value. It is specific to the client that reads it.
       * </pre>
       *
       * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The audioUri.
       */
      public java.lang.String getAudioUri() {
        java.lang.Object ref = audioUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          audioUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the audio clip. Dialogflow does not impose any
       * validation on this value. It is specific to the client that reads it.
       * </pre>
       *
       * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for audioUri.
       */
      public com.google.protobuf.ByteString getAudioUriBytes() {
        java.lang.Object ref = audioUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          audioUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the audio clip. Dialogflow does not impose any
       * validation on this value. It is specific to the client that reads it.
       * </pre>
       *
       * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The audioUri to set.
       * @return This builder for chaining.
       */
      public Builder setAudioUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the audio clip. Dialogflow does not impose any
       * validation on this value. It is specific to the client that reads it.
       * </pre>
       *
       * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudioUri() {
        audioUri_ = getDefaultInstance().getAudioUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the audio clip. Dialogflow does not impose any
       * validation on this value. It is specific to the client that reads it.
       * </pre>
       *
       * <code>string audio_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for audioUri to set.
       * @return This builder for chaining.
       */
      public Builder setAudioUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        audioUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean allowPlaybackInterruption_;
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The allowPlaybackInterruption.
       */
      @java.lang.Override
      public boolean getAllowPlaybackInterruption() {
        return allowPlaybackInterruption_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The allowPlaybackInterruption to set.
       * @return This builder for chaining.
       */
      public Builder setAllowPlaybackInterruption(boolean value) {

        allowPlaybackInterruption_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this message can be interrupted by
       * the end user's speech and the client can then starts the next Dialogflow
       * request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowPlaybackInterruption() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allowPlaybackInterruption_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PlayAudio> PARSER =
        new com.google.protobuf.AbstractParser<PlayAudio>() {
          @java.lang.Override
          public PlayAudio parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PlayAudio> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PlayAudio> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MixedAudioOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>
        getSegmentsList();
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment getSegments(
        int index);
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    int getSegmentsCount();
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder>
        getSegmentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder
        getSegmentsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents an audio message that is composed of both segments
   * synthesized from the Dialogflow agent prompts and ones hosted externally
   * at the specified URIs.
   * The external URIs are specified via
   * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
   * This message is generated by Dialogflow only and not supposed to be
   * defined by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio}
   */
  public static final class MixedAudio extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio)
      MixedAudioOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MixedAudio.newBuilder() to construct.
    private MixedAudio(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MixedAudio() {
      segments_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MixedAudio();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder.class);
    }

    public interface SegmentOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Raw audio synthesized from the Dialogflow agent's response using
       * the output config specified in the request.
       * </pre>
       *
       * <code>bytes audio = 1;</code>
       *
       * @return Whether the audio field is set.
       */
      boolean hasAudio();
      /**
       *
       *
       * <pre>
       * Raw audio synthesized from the Dialogflow agent's response using
       * the output config specified in the request.
       * </pre>
       *
       * <code>bytes audio = 1;</code>
       *
       * @return The audio.
       */
      com.google.protobuf.ByteString getAudio();

      /**
       *
       *
       * <pre>
       * Client-specific URI that points to an audio clip accessible to the
       * client. Dialogflow does not impose any validation on it.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return Whether the uri field is set.
       */
      boolean hasUri();
      /**
       *
       *
       * <pre>
       * Client-specific URI that points to an audio clip accessible to the
       * client. Dialogflow does not impose any validation on it.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();
      /**
       *
       *
       * <pre>
       * Client-specific URI that points to an audio clip accessible to the
       * client. Dialogflow does not impose any validation on it.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();

      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this segment can be interrupted by
       * the end user's speech and the client should then start the next
       * Dialogflow request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The allowPlaybackInterruption.
       */
      boolean getAllowPlaybackInterruption();

      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.ContentCase
          getContentCase();
    }
    /**
     *
     *
     * <pre>
     * Represents one segment of audio.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment}
     */
    public static final class Segment extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment)
        SegmentOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Segment.newBuilder() to construct.
      private Segment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Segment() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Segment();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_Segment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_Segment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
                    .class);
      }

      private int contentCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object content_;

      public enum ContentCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        AUDIO(1),
        URI(2),
        CONTENT_NOT_SET(0);
        private final int value;

        private ContentCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ContentCase valueOf(int value) {
          return forNumber(value);
        }

        public static ContentCase forNumber(int value) {
          switch (value) {
            case 1:
              return AUDIO;
            case 2:
              return URI;
            case 0:
              return CONTENT_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ContentCase getContentCase() {
        return ContentCase.forNumber(contentCase_);
      }

      public static final int AUDIO_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Raw audio synthesized from the Dialogflow agent's response using
       * the output config specified in the request.
       * </pre>
       *
       * <code>bytes audio = 1;</code>
       *
       * @return Whether the audio field is set.
       */
      @java.lang.Override
      public boolean hasAudio() {
        return contentCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Raw audio synthesized from the Dialogflow agent's response using
       * the output config specified in the request.
       * </pre>
       *
       * <code>bytes audio = 1;</code>
       *
       * @return The audio.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAudio() {
        if (contentCase_ == 1) {
          return (com.google.protobuf.ByteString) content_;
        }
        return com.google.protobuf.ByteString.EMPTY;
      }

      public static final int URI_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Client-specific URI that points to an audio clip accessible to the
       * client. Dialogflow does not impose any validation on it.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return Whether the uri field is set.
       */
      public boolean hasUri() {
        return contentCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Client-specific URI that points to an audio clip accessible to the
       * client. Dialogflow does not impose any validation on it.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = "";
        if (contentCase_ == 2) {
          ref = content_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (contentCase_ == 2) {
            content_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Client-specific URI that points to an audio clip accessible to the
       * client. Dialogflow does not impose any validation on it.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = "";
        if (contentCase_ == 2) {
          ref = content_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (contentCase_ == 2) {
            content_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER = 3;
      private boolean allowPlaybackInterruption_ = false;
      /**
       *
       *
       * <pre>
       * Output only. Whether the playback of this segment can be interrupted by
       * the end user's speech and the client should then start the next
       * Dialogflow request.
       * </pre>
       *
       * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The allowPlaybackInterruption.
       */
      @java.lang.Override
      public boolean getAllowPlaybackInterruption() {
        return allowPlaybackInterruption_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (contentCase_ == 1) {
          output.writeBytes(1, (com.google.protobuf.ByteString) content_);
        }
        if (contentCase_ == 2) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
        }
        if (allowPlaybackInterruption_ != false) {
          output.writeBool(3, allowPlaybackInterruption_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (contentCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBytesSize(
                  1, (com.google.protobuf.ByteString) content_);
        }
        if (contentCase_ == 2) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
        }
        if (allowPlaybackInterruption_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(3, allowPlaybackInterruption_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment other =
            (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment) obj;

        if (getAllowPlaybackInterruption() != other.getAllowPlaybackInterruption()) return false;
        if (!getContentCase().equals(other.getContentCase())) return false;
        switch (contentCase_) {
          case 1:
            if (!getAudio().equals(other.getAudio())) return false;
            break;
          case 2:
            if (!getUri().equals(other.getUri())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ALLOW_PLAYBACK_INTERRUPTION_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowPlaybackInterruption());
        switch (contentCase_) {
          case 1:
            hash = (37 * hash) + AUDIO_FIELD_NUMBER;
            hash = (53 * hash) + getAudio().hashCode();
            break;
          case 2:
            hash = (37 * hash) + URI_FIELD_NUMBER;
            hash = (53 * hash) + getUri().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents one segment of audio.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment)
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_Segment_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_Segment_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.class,
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          allowPlaybackInterruption_ = false;
          contentCase_ = 0;
          content_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_Segment_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment build() {
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment result =
              new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.allowPlaybackInterruption_ = allowPlaybackInterruption_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment result) {
          result.contentCase_ = contentCase_;
          result.content_ = this.content_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
                  .getDefaultInstance()) return this;
          if (other.getAllowPlaybackInterruption() != false) {
            setAllowPlaybackInterruption(other.getAllowPlaybackInterruption());
          }
          switch (other.getContentCase()) {
            case AUDIO:
              {
                setAudio(other.getAudio());
                break;
              }
            case URI:
              {
                contentCase_ = 2;
                content_ = other.content_;
                onChanged();
                break;
              }
            case CONTENT_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    content_ = input.readBytes();
                    contentCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    contentCase_ = 2;
                    content_ = s;
                    break;
                  } // case 18
                case 24:
                  {
                    allowPlaybackInterruption_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int contentCase_ = 0;
        private java.lang.Object content_;

        public ContentCase getContentCase() {
          return ContentCase.forNumber(contentCase_);
        }

        public Builder clearContent() {
          contentCase_ = 0;
          content_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Raw audio synthesized from the Dialogflow agent's response using
         * the output config specified in the request.
         * </pre>
         *
         * <code>bytes audio = 1;</code>
         *
         * @return Whether the audio field is set.
         */
        public boolean hasAudio() {
          return contentCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Raw audio synthesized from the Dialogflow agent's response using
         * the output config specified in the request.
         * </pre>
         *
         * <code>bytes audio = 1;</code>
         *
         * @return The audio.
         */
        public com.google.protobuf.ByteString getAudio() {
          if (contentCase_ == 1) {
            return (com.google.protobuf.ByteString) content_;
          }
          return com.google.protobuf.ByteString.EMPTY;
        }
        /**
         *
         *
         * <pre>
         * Raw audio synthesized from the Dialogflow agent's response using
         * the output config specified in the request.
         * </pre>
         *
         * <code>bytes audio = 1;</code>
         *
         * @param value The audio to set.
         * @return This builder for chaining.
         */
        public Builder setAudio(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          contentCase_ = 1;
          content_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Raw audio synthesized from the Dialogflow agent's response using
         * the output config specified in the request.
         * </pre>
         *
         * <code>bytes audio = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAudio() {
          if (contentCase_ == 1) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Client-specific URI that points to an audio clip accessible to the
         * client. Dialogflow does not impose any validation on it.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return Whether the uri field is set.
         */
        @java.lang.Override
        public boolean hasUri() {
          return contentCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Client-specific URI that points to an audio clip accessible to the
         * client. Dialogflow does not impose any validation on it.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The uri.
         */
        @java.lang.Override
        public java.lang.String getUri() {
          java.lang.Object ref = "";
          if (contentCase_ == 2) {
            ref = content_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (contentCase_ == 2) {
              content_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Client-specific URI that points to an audio clip accessible to the
         * client. Dialogflow does not impose any validation on it.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The bytes for uri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = "";
          if (contentCase_ == 2) {
            ref = content_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (contentCase_ == 2) {
              content_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Client-specific URI that points to an audio clip accessible to the
         * client. Dialogflow does not impose any validation on it.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          contentCase_ = 2;
          content_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Client-specific URI that points to an audio clip accessible to the
         * client. Dialogflow does not impose any validation on it.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          if (contentCase_ == 2) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Client-specific URI that points to an audio clip accessible to the
         * client. Dialogflow does not impose any validation on it.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          contentCase_ = 2;
          content_ = value;
          onChanged();
          return this;
        }

        private boolean allowPlaybackInterruption_;
        /**
         *
         *
         * <pre>
         * Output only. Whether the playback of this segment can be interrupted by
         * the end user's speech and the client should then start the next
         * Dialogflow request.
         * </pre>
         *
         * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The allowPlaybackInterruption.
         */
        @java.lang.Override
        public boolean getAllowPlaybackInterruption() {
          return allowPlaybackInterruption_;
        }
        /**
         *
         *
         * <pre>
         * Output only. Whether the playback of this segment can be interrupted by
         * the end user's speech and the client should then start the next
         * Dialogflow request.
         * </pre>
         *
         * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The allowPlaybackInterruption to set.
         * @return This builder for chaining.
         */
        public Builder setAllowPlaybackInterruption(boolean value) {

          allowPlaybackInterruption_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. Whether the playback of this segment can be interrupted by
         * the end user's speech and the client should then start the next
         * Dialogflow request.
         * </pre>
         *
         * <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAllowPlaybackInterruption() {
          bitField0_ = (bitField0_ & ~0x00000004);
          allowPlaybackInterruption_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment)
      private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Segment> PARSER =
          new com.google.protobuf.AbstractParser<Segment>() {
            @java.lang.Override
            public Segment parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Segment> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Segment> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int SEGMENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>
        segments_;
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>
        getSegmentsList() {
      return segments_;
    }
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder>
        getSegmentsOrBuilderList() {
      return segments_;
    }
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    @java.lang.Override
    public int getSegmentsCount() {
      return segments_.size();
    }
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment getSegments(
        int index) {
      return segments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Segments this audio response is composed of.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder
        getSegmentsOrBuilder(int index) {
      return segments_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < segments_.size(); i++) {
        output.writeMessage(1, segments_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < segments_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, segments_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) obj;

      if (!getSegmentsList().equals(other.getSegmentsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSegmentsCount() > 0) {
        hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getSegmentsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an audio message that is composed of both segments
     * synthesized from the Dialogflow agent prompts and ones hosted externally
     * at the specified URIs.
     * The external URIs are specified via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudioOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (segmentsBuilder_ == null) {
          segments_ = java.util.Collections.emptyList();
        } else {
          segments_ = null;
          segmentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_MixedAudio_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio result) {
        if (segmentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            segments_ = java.util.Collections.unmodifiableList(segments_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.segments_ = segments_;
        } else {
          result.segments_ = segmentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
                .getDefaultInstance()) return this;
        if (segmentsBuilder_ == null) {
          if (!other.segments_.isEmpty()) {
            if (segments_.isEmpty()) {
              segments_ = other.segments_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSegmentsIsMutable();
              segments_.addAll(other.segments_);
            }
            onChanged();
          }
        } else {
          if (!other.segments_.isEmpty()) {
            if (segmentsBuilder_.isEmpty()) {
              segmentsBuilder_.dispose();
              segmentsBuilder_ = null;
              segments_ = other.segments_;
              bitField0_ = (bitField0_ & ~0x00000001);
              segmentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSegmentsFieldBuilder()
                      : null;
            } else {
              segmentsBuilder_.addAllMessages(other.segments_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
                              .parser(),
                          extensionRegistry);
                  if (segmentsBuilder_ == null) {
                    ensureSegmentsIsMutable();
                    segments_.add(m);
                  } else {
                    segmentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>
          segments_ = java.util.Collections.emptyList();

      private void ensureSegmentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          segments_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>(
                  segments_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder>
          segmentsBuilder_;

      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>
          getSegmentsList() {
        if (segmentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(segments_);
        } else {
          return segmentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public int getSegmentsCount() {
        if (segmentsBuilder_ == null) {
          return segments_.size();
        } else {
          return segmentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment getSegments(
          int index) {
        if (segmentsBuilder_ == null) {
          return segments_.get(index);
        } else {
          return segmentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder setSegments(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment value) {
        if (segmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSegmentsIsMutable();
          segments_.set(index, value);
          onChanged();
        } else {
          segmentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder setSegments(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
              builderForValue) {
        if (segmentsBuilder_ == null) {
          ensureSegmentsIsMutable();
          segments_.set(index, builderForValue.build());
          onChanged();
        } else {
          segmentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder addSegments(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment value) {
        if (segmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSegmentsIsMutable();
          segments_.add(value);
          onChanged();
        } else {
          segmentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder addSegments(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment value) {
        if (segmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSegmentsIsMutable();
          segments_.add(index, value);
          onChanged();
        } else {
          segmentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder addSegments(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
              builderForValue) {
        if (segmentsBuilder_ == null) {
          ensureSegmentsIsMutable();
          segments_.add(builderForValue.build());
          onChanged();
        } else {
          segmentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder addSegments(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
              builderForValue) {
        if (segmentsBuilder_ == null) {
          ensureSegmentsIsMutable();
          segments_.add(index, builderForValue.build());
          onChanged();
        } else {
          segmentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder addAllSegments(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment>
              values) {
        if (segmentsBuilder_ == null) {
          ensureSegmentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
          onChanged();
        } else {
          segmentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder clearSegments() {
        if (segmentsBuilder_ == null) {
          segments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          segmentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public Builder removeSegments(int index) {
        if (segmentsBuilder_ == null) {
          ensureSegmentsIsMutable();
          segments_.remove(index);
          onChanged();
        } else {
          segmentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
          getSegmentsBuilder(int index) {
        return getSegmentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder
          getSegmentsOrBuilder(int index) {
        if (segmentsBuilder_ == null) {
          return segments_.get(index);
        } else {
          return segmentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
                      .SegmentOrBuilder>
          getSegmentsOrBuilderList() {
        if (segmentsBuilder_ != null) {
          return segmentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(segments_);
        }
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
          addSegmentsBuilder() {
        return getSegmentsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder
          addSegmentsBuilder(int index) {
        return getSegmentsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Segments this audio response is composed of.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment segments = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder>
          getSegmentsBuilderList() {
        return getSegmentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.SegmentOrBuilder>
          getSegmentsFieldBuilder() {
        if (segmentsBuilder_ == null) {
          segmentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment,
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Segment.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
                      .SegmentOrBuilder>(
                  segments_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          segments_ = null;
        }
        return segmentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MixedAudio> PARSER =
        new com.google.protobuf.AbstractParser<MixedAudio>() {
          @java.lang.Override
          public MixedAudio parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MixedAudio> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MixedAudio> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TelephonyTransferCallOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Transfer the call to a phone number
     * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
     * </pre>
     *
     * <code>string phone_number = 1;</code>
     *
     * @return Whether the phoneNumber field is set.
     */
    boolean hasPhoneNumber();
    /**
     *
     *
     * <pre>
     * Transfer the call to a phone number
     * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
     * </pre>
     *
     * <code>string phone_number = 1;</code>
     *
     * @return The phoneNumber.
     */
    java.lang.String getPhoneNumber();
    /**
     *
     *
     * <pre>
     * Transfer the call to a phone number
     * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
     * </pre>
     *
     * <code>string phone_number = 1;</code>
     *
     * @return The bytes for phoneNumber.
     */
    com.google.protobuf.ByteString getPhoneNumberBytes();

    com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.EndpointCase
        getEndpointCase();
  }
  /**
   *
   *
   * <pre>
   * Represents the signal that telles the client to transfer the phone call
   * connected to the agent to a third-party endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall}
   */
  public static final class TelephonyTransferCall extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
      TelephonyTransferCallOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TelephonyTransferCall.newBuilder() to construct.
    private TelephonyTransferCall(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TelephonyTransferCall() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TelephonyTransferCall();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_TelephonyTransferCall_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_TelephonyTransferCall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.Builder
                  .class);
    }

    private int endpointCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object endpoint_;

    public enum EndpointCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PHONE_NUMBER(1),
      ENDPOINT_NOT_SET(0);
      private final int value;

      private EndpointCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EndpointCase valueOf(int value) {
        return forNumber(value);
      }

      public static EndpointCase forNumber(int value) {
        switch (value) {
          case 1:
            return PHONE_NUMBER;
          case 0:
            return ENDPOINT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public EndpointCase getEndpointCase() {
      return EndpointCase.forNumber(endpointCase_);
    }

    public static final int PHONE_NUMBER_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Transfer the call to a phone number
     * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
     * </pre>
     *
     * <code>string phone_number = 1;</code>
     *
     * @return Whether the phoneNumber field is set.
     */
    public boolean hasPhoneNumber() {
      return endpointCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Transfer the call to a phone number
     * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
     * </pre>
     *
     * <code>string phone_number = 1;</code>
     *
     * @return The phoneNumber.
     */
    public java.lang.String getPhoneNumber() {
      java.lang.Object ref = "";
      if (endpointCase_ == 1) {
        ref = endpoint_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (endpointCase_ == 1) {
          endpoint_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Transfer the call to a phone number
     * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
     * </pre>
     *
     * <code>string phone_number = 1;</code>
     *
     * @return The bytes for phoneNumber.
     */
    public com.google.protobuf.ByteString getPhoneNumberBytes() {
      java.lang.Object ref = "";
      if (endpointCase_ == 1) {
        ref = endpoint_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (endpointCase_ == 1) {
          endpoint_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (endpointCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (endpointCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall) obj;

      if (!getEndpointCase().equals(other.getEndpointCase())) return false;
      switch (endpointCase_) {
        case 1:
          if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (endpointCase_) {
        case 1:
          hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
          hash = (53 * hash) + getPhoneNumber().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the signal that telles the client to transfer the phone call
     * connected to the agent to a third-party endpoint.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCallOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_TelephonyTransferCall_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_TelephonyTransferCall_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpointCase_ = 0;
        endpoint_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_TelephonyTransferCall_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall result) {
        result.endpointCase_ = endpointCase_;
        result.endpoint_ = this.endpoint_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
                .getDefaultInstance()) return this;
        switch (other.getEndpointCase()) {
          case PHONE_NUMBER:
            {
              endpointCase_ = 1;
              endpoint_ = other.endpoint_;
              onChanged();
              break;
            }
          case ENDPOINT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  endpointCase_ = 1;
                  endpoint_ = s;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int endpointCase_ = 0;
      private java.lang.Object endpoint_;

      public EndpointCase getEndpointCase() {
        return EndpointCase.forNumber(endpointCase_);
      }

      public Builder clearEndpoint() {
        endpointCase_ = 0;
        endpoint_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Transfer the call to a phone number
       * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
       * </pre>
       *
       * <code>string phone_number = 1;</code>
       *
       * @return Whether the phoneNumber field is set.
       */
      @java.lang.Override
      public boolean hasPhoneNumber() {
        return endpointCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Transfer the call to a phone number
       * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
       * </pre>
       *
       * <code>string phone_number = 1;</code>
       *
       * @return The phoneNumber.
       */
      @java.lang.Override
      public java.lang.String getPhoneNumber() {
        java.lang.Object ref = "";
        if (endpointCase_ == 1) {
          ref = endpoint_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (endpointCase_ == 1) {
            endpoint_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Transfer the call to a phone number
       * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
       * </pre>
       *
       * <code>string phone_number = 1;</code>
       *
       * @return The bytes for phoneNumber.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPhoneNumberBytes() {
        java.lang.Object ref = "";
        if (endpointCase_ == 1) {
          ref = endpoint_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (endpointCase_ == 1) {
            endpoint_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Transfer the call to a phone number
       * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
       * </pre>
       *
       * <code>string phone_number = 1;</code>
       *
       * @param value The phoneNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointCase_ = 1;
        endpoint_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transfer the call to a phone number
       * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
       * </pre>
       *
       * <code>string phone_number = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPhoneNumber() {
        if (endpointCase_ == 1) {
          endpointCase_ = 0;
          endpoint_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transfer the call to a phone number
       * in [E.164 format](https://en.wikipedia.org/wiki/E.164).
       * </pre>
       *
       * <code>string phone_number = 1;</code>
       *
       * @param value The bytes for phoneNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpointCase_ = 1;
        endpoint_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage
            .TelephonyTransferCall
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TelephonyTransferCall> PARSER =
        new com.google.protobuf.AbstractParser<TelephonyTransferCall>() {
          @java.lang.Override
          public TelephonyTransferCall parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TelephonyTransferCall> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TelephonyTransferCall> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface KnowledgeInfoCardOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Represents info card response. If the response contains generative
   * knowledge prediction, Dialogflow will return a payload with Infobot
   * Messenger compatible info card.
   *
   * Otherwise, the info card response is skipped.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard}
   */
  public static final class KnowledgeInfoCard extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
      KnowledgeInfoCardOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use KnowledgeInfoCard.newBuilder() to construct.
    private KnowledgeInfoCard(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private KnowledgeInfoCard() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new KnowledgeInfoCard();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_KnowledgeInfoCard_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_KnowledgeInfoCard_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder
                  .class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard other =
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents info card response. If the response contains generative
     * knowledge prediction, Dialogflow will return a payload with Infobot
     * Messenger compatible info card.
     *
     * Otherwise, the info card response is skipped.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCardOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_KnowledgeInfoCard_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_KnowledgeInfoCard_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.class,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_KnowledgeInfoCard_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard build() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard result =
            new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<KnowledgeInfoCard> PARSER =
        new com.google.protobuf.AbstractParser<KnowledgeInfoCard>() {
          @java.lang.Override
          public KnowledgeInfoCard parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<KnowledgeInfoCard> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<KnowledgeInfoCard> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int messageCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object message_;

  public enum MessageCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(1),
    PAYLOAD(2),
    CONVERSATION_SUCCESS(9),
    OUTPUT_AUDIO_TEXT(8),
    LIVE_AGENT_HANDOFF(10),
    END_INTERACTION(11),
    PLAY_AUDIO(12),
    MIXED_AUDIO(13),
    TELEPHONY_TRANSFER_CALL(18),
    KNOWLEDGE_INFO_CARD(20),
    MESSAGE_NOT_SET(0);
    private final int value;

    private MessageCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MessageCase valueOf(int value) {
      return forNumber(value);
    }

    public static MessageCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT;
        case 2:
          return PAYLOAD;
        case 9:
          return CONVERSATION_SUCCESS;
        case 8:
          return OUTPUT_AUDIO_TEXT;
        case 10:
          return LIVE_AGENT_HANDOFF;
        case 11:
          return END_INTERACTION;
        case 12:
          return PLAY_AUDIO;
        case 13:
          return MIXED_AUDIO;
        case 18:
          return TELEPHONY_TRANSFER_CALL;
        case 20:
          return KNOWLEDGE_INFO_CARD;
        case 0:
          return MESSAGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MessageCase getMessageCase() {
    return MessageCase.forNumber(messageCase_);
  }

  public static final int TEXT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Returns a text response.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
   *
   * @return Whether the text field is set.
   */
  @java.lang.Override
  public boolean hasText() {
    return messageCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Returns a text response.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text getText() {
    if (messageCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Returns a text response.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TextOrBuilder getTextOrBuilder() {
    if (messageCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
  }

  public static final int PAYLOAD_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Returns a response containing a custom, platform-specific payload.
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 2;</code>
   *
   * @return Whether the payload field is set.
   */
  @java.lang.Override
  public boolean hasPayload() {
    return messageCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Returns a response containing a custom, platform-specific payload.
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 2;</code>
   *
   * @return The payload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPayload() {
    if (messageCase_ == 2) {
      return (com.google.protobuf.Struct) message_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Returns a response containing a custom, platform-specific payload.
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
    if (messageCase_ == 2) {
      return (com.google.protobuf.Struct) message_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }

  public static final int CONVERSATION_SUCCESS_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Indicates that the conversation succeeded.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
   * </code>
   *
   * @return Whether the conversationSuccess field is set.
   */
  @java.lang.Override
  public boolean hasConversationSuccess() {
    return messageCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Indicates that the conversation succeeded.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
   * </code>
   *
   * @return The conversationSuccess.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
      getConversationSuccess() {
    if (messageCase_ == 9) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Indicates that the conversation succeeded.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccessOrBuilder
      getConversationSuccessOrBuilder() {
    if (messageCase_ == 9) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        .getDefaultInstance();
  }

  public static final int OUTPUT_AUDIO_TEXT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * A text or ssml response that is preferentially used for TTS output audio
   * synthesis, as described in the comment on the ResponseMessage message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
   * </code>
   *
   * @return Whether the outputAudioText field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioText() {
    return messageCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * A text or ssml response that is preferentially used for TTS output audio
   * synthesis, as described in the comment on the ResponseMessage message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
   * </code>
   *
   * @return The outputAudioText.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
      getOutputAudioText() {
    if (messageCase_ == 8) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A text or ssml response that is preferentially used for TTS output audio
   * synthesis, as described in the comment on the ResponseMessage message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioTextOrBuilder
      getOutputAudioTextOrBuilder() {
    if (messageCase_ == 8) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        .getDefaultInstance();
  }

  public static final int LIVE_AGENT_HANDOFF_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Hands off conversation to a human agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
   * </code>
   *
   * @return Whether the liveAgentHandoff field is set.
   */
  @java.lang.Override
  public boolean hasLiveAgentHandoff() {
    return messageCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Hands off conversation to a human agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
   * </code>
   *
   * @return The liveAgentHandoff.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
      getLiveAgentHandoff() {
    if (messageCase_ == 10) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Hands off conversation to a human agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoffOrBuilder
      getLiveAgentHandoffOrBuilder() {
    if (messageCase_ == 10) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        .getDefaultInstance();
  }

  public static final int END_INTERACTION_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Output only. A signal that indicates the interaction with the Dialogflow
   * agent has ended. This message is generated by Dialogflow only when the
   * conversation reaches `END_SESSION` page. It is not supposed to be defined
   * by the user.
   *
   * It's guaranteed that there is at most one such message in each response.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endInteraction field is set.
   */
  @java.lang.Override
  public boolean hasEndInteraction() {
    return messageCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Output only. A signal that indicates the interaction with the Dialogflow
   * agent has ended. This message is generated by Dialogflow only when the
   * conversation reaches `END_SESSION` page. It is not supposed to be defined
   * by the user.
   *
   * It's guaranteed that there is at most one such message in each response.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endInteraction.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction getEndInteraction() {
    if (messageCase_ == 11) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A signal that indicates the interaction with the Dialogflow
   * agent has ended. This message is generated by Dialogflow only when the
   * conversation reaches `END_SESSION` page. It is not supposed to be defined
   * by the user.
   *
   * It's guaranteed that there is at most one such message in each response.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteractionOrBuilder
      getEndInteractionOrBuilder() {
    if (messageCase_ == 11) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        .getDefaultInstance();
  }

  public static final int PLAY_AUDIO_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Signal that the client should play an audio clip hosted at a
   * client-specific URI. Dialogflow uses this to construct
   * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
   * However, Dialogflow itself does not try to read or process the URI in any
   * way.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
   *
   * @return Whether the playAudio field is set.
   */
  @java.lang.Override
  public boolean hasPlayAudio() {
    return messageCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Signal that the client should play an audio clip hosted at a
   * client-specific URI. Dialogflow uses this to construct
   * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
   * However, Dialogflow itself does not try to read or process the URI in any
   * way.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
   *
   * @return The playAudio.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio getPlayAudio() {
    if (messageCase_ == 12) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Signal that the client should play an audio clip hosted at a
   * client-specific URI. Dialogflow uses this to construct
   * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
   * However, Dialogflow itself does not try to read or process the URI in any
   * way.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudioOrBuilder
      getPlayAudioOrBuilder() {
    if (messageCase_ == 12) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.getDefaultInstance();
  }

  public static final int MIXED_AUDIO_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Output only. An audio response message composed of both the synthesized
   * Dialogflow agent responses and responses defined via
   * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
   * This message is generated by Dialogflow only and not supposed to be
   * defined by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the mixedAudio field is set.
   */
  @java.lang.Override
  public boolean hasMixedAudio() {
    return messageCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Output only. An audio response message composed of both the synthesized
   * Dialogflow agent responses and responses defined via
   * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
   * This message is generated by Dialogflow only and not supposed to be
   * defined by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The mixedAudio.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio getMixedAudio() {
    if (messageCase_ == 13) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. An audio response message composed of both the synthesized
   * Dialogflow agent responses and responses defined via
   * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
   * This message is generated by Dialogflow only and not supposed to be
   * defined by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudioOrBuilder
      getMixedAudioOrBuilder() {
    if (messageCase_ == 13) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.getDefaultInstance();
  }

  public static final int TELEPHONY_TRANSFER_CALL_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * A signal that the client should transfer the phone call connected to
   * this agent to a third-party endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
   * </code>
   *
   * @return Whether the telephonyTransferCall field is set.
   */
  @java.lang.Override
  public boolean hasTelephonyTransferCall() {
    return messageCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * A signal that the client should transfer the phone call connected to
   * this agent to a third-party endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
   * </code>
   *
   * @return The telephonyTransferCall.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
      getTelephonyTransferCall() {
    if (messageCase_ == 18) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
          message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A signal that the client should transfer the phone call connected to
   * this agent to a third-party endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCallOrBuilder
      getTelephonyTransferCallOrBuilder() {
    if (messageCase_ == 18) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
          message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        .getDefaultInstance();
  }

  public static final int KNOWLEDGE_INFO_CARD_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Represents info card for knowledge answers, to be better rendered in
   * Dialogflow Messenger.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
   * </code>
   *
   * @return Whether the knowledgeInfoCard field is set.
   */
  @java.lang.Override
  public boolean hasKnowledgeInfoCard() {
    return messageCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Represents info card for knowledge answers, to be better rendered in
   * Dialogflow Messenger.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
   * </code>
   *
   * @return The knowledgeInfoCard.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
      getKnowledgeInfoCard() {
    if (messageCase_ == 20) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Represents info card for knowledge answers, to be better rendered in
   * Dialogflow Messenger.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCardOrBuilder
      getKnowledgeInfoCardOrBuilder() {
    if (messageCase_ == 20) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) message_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        .getDefaultInstance();
  }

  public static final int CHANNEL_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object channel_ = "";
  /**
   *
   *
   * <pre>
   * The channel which the response is associated with. Clients can specify the
   * channel via
   * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
   * and only associated channel response will be returned.
   * </pre>
   *
   * <code>string channel = 19;</code>
   *
   * @return The channel.
   */
  @java.lang.Override
  public java.lang.String getChannel() {
    java.lang.Object ref = channel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      channel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The channel which the response is associated with. Clients can specify the
   * channel via
   * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
   * and only associated channel response will be returned.
   * </pre>
   *
   * <code>string channel = 19;</code>
   *
   * @return The bytes for channel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChannelBytes() {
    java.lang.Object ref = channel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      channel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (messageCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_);
    }
    if (messageCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.Struct) message_);
    }
    if (messageCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_);
    }
    if (messageCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess) message_);
    }
    if (messageCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_);
    }
    if (messageCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_);
    }
    if (messageCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_);
    }
    if (messageCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_);
    }
    if (messageCase_ == 18) {
      output.writeMessage(
          18,
          (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall) message_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, channel_);
    }
    if (messageCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) message_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (messageCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_);
    }
    if (messageCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.protobuf.Struct) message_);
    }
    if (messageCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_);
    }
    if (messageCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
                  message_);
    }
    if (messageCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10,
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_);
    }
    if (messageCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_);
    }
    if (messageCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_);
    }
    if (messageCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_);
    }
    if (messageCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18,
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
                  message_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, channel_);
    }
    if (messageCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20,
              (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) message_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage other =
        (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage) obj;

    if (!getChannel().equals(other.getChannel())) return false;
    if (!getMessageCase().equals(other.getMessageCase())) return false;
    switch (messageCase_) {
      case 1:
        if (!getText().equals(other.getText())) return false;
        break;
      case 2:
        if (!getPayload().equals(other.getPayload())) return false;
        break;
      case 9:
        if (!getConversationSuccess().equals(other.getConversationSuccess())) return false;
        break;
      case 8:
        if (!getOutputAudioText().equals(other.getOutputAudioText())) return false;
        break;
      case 10:
        if (!getLiveAgentHandoff().equals(other.getLiveAgentHandoff())) return false;
        break;
      case 11:
        if (!getEndInteraction().equals(other.getEndInteraction())) return false;
        break;
      case 12:
        if (!getPlayAudio().equals(other.getPlayAudio())) return false;
        break;
      case 13:
        if (!getMixedAudio().equals(other.getMixedAudio())) return false;
        break;
      case 18:
        if (!getTelephonyTransferCall().equals(other.getTelephonyTransferCall())) return false;
        break;
      case 20:
        if (!getKnowledgeInfoCard().equals(other.getKnowledgeInfoCard())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + getChannel().hashCode();
    switch (messageCase_) {
      case 1:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getPayload().hashCode();
        break;
      case 9:
        hash = (37 * hash) + CONVERSATION_SUCCESS_FIELD_NUMBER;
        hash = (53 * hash) + getConversationSuccess().hashCode();
        break;
      case 8:
        hash = (37 * hash) + OUTPUT_AUDIO_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getOutputAudioText().hashCode();
        break;
      case 10:
        hash = (37 * hash) + LIVE_AGENT_HANDOFF_FIELD_NUMBER;
        hash = (53 * hash) + getLiveAgentHandoff().hashCode();
        break;
      case 11:
        hash = (37 * hash) + END_INTERACTION_FIELD_NUMBER;
        hash = (53 * hash) + getEndInteraction().hashCode();
        break;
      case 12:
        hash = (37 * hash) + PLAY_AUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getPlayAudio().hashCode();
        break;
      case 13:
        hash = (37 * hash) + MIXED_AUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getMixedAudio().hashCode();
        break;
      case 18:
        hash = (37 * hash) + TELEPHONY_TRANSFER_CALL_FIELD_NUMBER;
        hash = (53 * hash) + getTelephonyTransferCall().hashCode();
        break;
      case 20:
        hash = (37 * hash) + KNOWLEDGE_INFO_CARD_FIELD_NUMBER;
        hash = (53 * hash) + getKnowledgeInfoCard().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a response message that can be returned by a conversational agent.
   *
   * Response messages are also used for output audio synthesis. The approach is
   * as follows:
   *
   * * If at least one OutputAudioText response is present, then all
   *   OutputAudioText responses are linearly concatenated, and the result is used
   *   for output audio synthesis.
   * * If the OutputAudioText responses are a mixture of text and SSML, then the
   *   concatenated result is treated as SSML; otherwise, the result is treated as
   *   either text or SSML as appropriate. The agent designer should ideally use
   *   either text or SSML consistently throughout the bot design.
   * * Otherwise, all Text responses are linearly concatenated, and the result is
   *   used for output audio synthesis.
   *
   * This approach allows for more sophisticated user experience scenarios, where
   * the text displayed to the user may differ from what is heard.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ResponseMessage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ResponseMessage)
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.class,
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (textBuilder_ != null) {
        textBuilder_.clear();
      }
      if (payloadBuilder_ != null) {
        payloadBuilder_.clear();
      }
      if (conversationSuccessBuilder_ != null) {
        conversationSuccessBuilder_.clear();
      }
      if (outputAudioTextBuilder_ != null) {
        outputAudioTextBuilder_.clear();
      }
      if (liveAgentHandoffBuilder_ != null) {
        liveAgentHandoffBuilder_.clear();
      }
      if (endInteractionBuilder_ != null) {
        endInteractionBuilder_.clear();
      }
      if (playAudioBuilder_ != null) {
        playAudioBuilder_.clear();
      }
      if (mixedAudioBuilder_ != null) {
        mixedAudioBuilder_.clear();
      }
      if (telephonyTransferCallBuilder_ != null) {
        telephonyTransferCallBuilder_.clear();
      }
      if (knowledgeInfoCardBuilder_ != null) {
        knowledgeInfoCardBuilder_.clear();
      }
      channel_ = "";
      messageCase_ = 0;
      message_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ResponseMessage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage build() {
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage result =
          new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.channel_ = channel_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage result) {
      result.messageCase_ = messageCase_;
      result.message_ = this.message_;
      if (messageCase_ == 1 && textBuilder_ != null) {
        result.message_ = textBuilder_.build();
      }
      if (messageCase_ == 2 && payloadBuilder_ != null) {
        result.message_ = payloadBuilder_.build();
      }
      if (messageCase_ == 9 && conversationSuccessBuilder_ != null) {
        result.message_ = conversationSuccessBuilder_.build();
      }
      if (messageCase_ == 8 && outputAudioTextBuilder_ != null) {
        result.message_ = outputAudioTextBuilder_.build();
      }
      if (messageCase_ == 10 && liveAgentHandoffBuilder_ != null) {
        result.message_ = liveAgentHandoffBuilder_.build();
      }
      if (messageCase_ == 11 && endInteractionBuilder_ != null) {
        result.message_ = endInteractionBuilder_.build();
      }
      if (messageCase_ == 12 && playAudioBuilder_ != null) {
        result.message_ = playAudioBuilder_.build();
      }
      if (messageCase_ == 13 && mixedAudioBuilder_ != null) {
        result.message_ = mixedAudioBuilder_.build();
      }
      if (messageCase_ == 18 && telephonyTransferCallBuilder_ != null) {
        result.message_ = telephonyTransferCallBuilder_.build();
      }
      if (messageCase_ == 20 && knowledgeInfoCardBuilder_ != null) {
        result.message_ = knowledgeInfoCardBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.getDefaultInstance())
        return this;
      if (!other.getChannel().isEmpty()) {
        channel_ = other.channel_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getMessageCase()) {
        case TEXT:
          {
            mergeText(other.getText());
            break;
          }
        case PAYLOAD:
          {
            mergePayload(other.getPayload());
            break;
          }
        case CONVERSATION_SUCCESS:
          {
            mergeConversationSuccess(other.getConversationSuccess());
            break;
          }
        case OUTPUT_AUDIO_TEXT:
          {
            mergeOutputAudioText(other.getOutputAudioText());
            break;
          }
        case LIVE_AGENT_HANDOFF:
          {
            mergeLiveAgentHandoff(other.getLiveAgentHandoff());
            break;
          }
        case END_INTERACTION:
          {
            mergeEndInteraction(other.getEndInteraction());
            break;
          }
        case PLAY_AUDIO:
          {
            mergePlayAudio(other.getPlayAudio());
            break;
          }
        case MIXED_AUDIO:
          {
            mergeMixedAudio(other.getMixedAudio());
            break;
          }
        case TELEPHONY_TRANSFER_CALL:
          {
            mergeTelephonyTransferCall(other.getTelephonyTransferCall());
            break;
          }
        case KNOWLEDGE_INFO_CARD:
          {
            mergeKnowledgeInfoCard(other.getKnowledgeInfoCard());
            break;
          }
        case MESSAGE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTextFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPayloadFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 2;
                break;
              } // case 18
            case 66:
              {
                input.readMessage(getOutputAudioTextFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getConversationSuccessFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getLiveAgentHandoffFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getEndInteractionFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getPlayAudioFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getMixedAudioFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 13;
                break;
              } // case 106
            case 146:
              {
                input.readMessage(
                    getTelephonyTransferCallFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                channel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getKnowledgeInfoCardFieldBuilder().getBuilder(), extensionRegistry);
                messageCase_ = 20;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int messageCase_ = 0;
    private java.lang.Object message_;

    public MessageCase getMessageCase() {
      return MessageCase.forNumber(messageCase_);
    }

    public Builder clearMessage() {
      messageCase_ = 0;
      message_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TextOrBuilder>
        textBuilder_;
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return messageCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text getText() {
      if (textBuilder_ == null) {
        if (messageCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
      } else {
        if (messageCase_ == 1) {
          return textBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    public Builder setText(com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text value) {
      if (textBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        textBuilder_.setMessage(value);
      }
      messageCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    public Builder setText(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder builderForValue) {
      if (textBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        textBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    public Builder mergeText(com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text value) {
      if (textBuilder_ == null) {
        if (messageCase_ == 1
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 1) {
          textBuilder_.mergeFrom(value);
        } else {
          textBuilder_.setMessage(value);
        }
      }
      messageCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    public Builder clearText() {
      if (textBuilder_ == null) {
        if (messageCase_ == 1) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 1) {
          messageCase_ = 0;
          message_ = null;
        }
        textBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder getTextBuilder() {
      return getTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TextOrBuilder getTextOrBuilder() {
      if ((messageCase_ == 1) && (textBuilder_ != null)) {
        return textBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Returns a text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text text = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TextOrBuilder>
        getTextFieldBuilder() {
      if (textBuilder_ == null) {
        if (!(messageCase_ == 1)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.getDefaultInstance();
        }
        textBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TextOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 1;
      onChanged();
      return textBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        payloadBuilder_;
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     *
     * @return Whether the payload field is set.
     */
    @java.lang.Override
    public boolean hasPayload() {
      return messageCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     *
     * @return The payload.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getPayload() {
      if (payloadBuilder_ == null) {
        if (messageCase_ == 2) {
          return (com.google.protobuf.Struct) message_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      } else {
        if (messageCase_ == 2) {
          return payloadBuilder_.getMessage();
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        payloadBuilder_.setMessage(value);
      }
      messageCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (payloadBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        payloadBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    public Builder mergePayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (messageCase_ == 2 && message_ != com.google.protobuf.Struct.getDefaultInstance()) {
          message_ =
              com.google.protobuf.Struct.newBuilder((com.google.protobuf.Struct) message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 2) {
          payloadBuilder_.mergeFrom(value);
        } else {
          payloadBuilder_.setMessage(value);
        }
      }
      messageCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    public Builder clearPayload() {
      if (payloadBuilder_ == null) {
        if (messageCase_ == 2) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 2) {
          messageCase_ = 0;
          message_ = null;
        }
        payloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    public com.google.protobuf.Struct.Builder getPayloadBuilder() {
      return getPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
      if ((messageCase_ == 2) && (payloadBuilder_ != null)) {
        return payloadBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 2) {
          return (com.google.protobuf.Struct) message_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Returns a response containing a custom, platform-specific payload.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPayloadFieldBuilder() {
      if (payloadBuilder_ == null) {
        if (!(messageCase_ == 2)) {
          message_ = com.google.protobuf.Struct.getDefaultInstance();
        }
        payloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                (com.google.protobuf.Struct) message_, getParentForChildren(), isClean());
        message_ = null;
      }
      messageCase_ = 2;
      onChanged();
      return payloadBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccessOrBuilder>
        conversationSuccessBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     *
     * @return Whether the conversationSuccess field is set.
     */
    @java.lang.Override
    public boolean hasConversationSuccess() {
      return messageCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     *
     * @return The conversationSuccess.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
        getConversationSuccess() {
      if (conversationSuccessBuilder_ == null) {
        if (messageCase_ == 9) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
              message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
            .getDefaultInstance();
      } else {
        if (messageCase_ == 9) {
          return conversationSuccessBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    public Builder setConversationSuccess(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess value) {
      if (conversationSuccessBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        conversationSuccessBuilder_.setMessage(value);
      }
      messageCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    public Builder setConversationSuccess(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder
            builderForValue) {
      if (conversationSuccessBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        conversationSuccessBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    public Builder mergeConversationSuccess(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess value) {
      if (conversationSuccessBuilder_ == null) {
        if (messageCase_ == 9
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
                          message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 9) {
          conversationSuccessBuilder_.mergeFrom(value);
        } else {
          conversationSuccessBuilder_.setMessage(value);
        }
      }
      messageCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    public Builder clearConversationSuccess() {
      if (conversationSuccessBuilder_ == null) {
        if (messageCase_ == 9) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 9) {
          messageCase_ = 0;
          message_ = null;
        }
        conversationSuccessBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder
        getConversationSuccessBuilder() {
      return getConversationSuccessFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccessOrBuilder
        getConversationSuccessOrBuilder() {
      if ((messageCase_ == 9) && (conversationSuccessBuilder_ != null)) {
        return conversationSuccessBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 9) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
              message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates that the conversation succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess conversation_success = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccessOrBuilder>
        getConversationSuccessFieldBuilder() {
      if (conversationSuccessBuilder_ == null) {
        if (!(messageCase_ == 9)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess
                  .getDefaultInstance();
        }
        conversationSuccessBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage
                    .ConversationSuccessOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.ConversationSuccess)
                    message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 9;
      onChanged();
      return conversationSuccessBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioTextOrBuilder>
        outputAudioTextBuilder_;
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     *
     * @return Whether the outputAudioText field is set.
     */
    @java.lang.Override
    public boolean hasOutputAudioText() {
      return messageCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     *
     * @return The outputAudioText.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
        getOutputAudioText() {
      if (outputAudioTextBuilder_ == null) {
        if (messageCase_ == 8) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
            .getDefaultInstance();
      } else {
        if (messageCase_ == 8) {
          return outputAudioTextBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    public Builder setOutputAudioText(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText value) {
      if (outputAudioTextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        outputAudioTextBuilder_.setMessage(value);
      }
      messageCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    public Builder setOutputAudioText(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder
            builderForValue) {
      if (outputAudioTextBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        outputAudioTextBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    public Builder mergeOutputAudioText(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText value) {
      if (outputAudioTextBuilder_ == null) {
        if (messageCase_ == 8
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText)
                          message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 8) {
          outputAudioTextBuilder_.mergeFrom(value);
        } else {
          outputAudioTextBuilder_.setMessage(value);
        }
      }
      messageCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    public Builder clearOutputAudioText() {
      if (outputAudioTextBuilder_ == null) {
        if (messageCase_ == 8) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 8) {
          messageCase_ = 0;
          message_ = null;
        }
        outputAudioTextBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder
        getOutputAudioTextBuilder() {
      return getOutputAudioTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioTextOrBuilder
        getOutputAudioTextOrBuilder() {
      if ((messageCase_ == 8) && (outputAudioTextBuilder_ != null)) {
        return outputAudioTextBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 8) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText output_audio_text = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioTextOrBuilder>
        getOutputAudioTextFieldBuilder() {
      if (outputAudioTextBuilder_ == null) {
        if (!(messageCase_ == 8)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText
                  .getDefaultInstance();
        }
        outputAudioTextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioTextOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.OutputAudioText) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 8;
      onChanged();
      return outputAudioTextBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoffOrBuilder>
        liveAgentHandoffBuilder_;
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     *
     * @return Whether the liveAgentHandoff field is set.
     */
    @java.lang.Override
    public boolean hasLiveAgentHandoff() {
      return messageCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     *
     * @return The liveAgentHandoff.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
        getLiveAgentHandoff() {
      if (liveAgentHandoffBuilder_ == null) {
        if (messageCase_ == 10) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
            .getDefaultInstance();
      } else {
        if (messageCase_ == 10) {
          return liveAgentHandoffBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    public Builder setLiveAgentHandoff(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff value) {
      if (liveAgentHandoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        liveAgentHandoffBuilder_.setMessage(value);
      }
      messageCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    public Builder setLiveAgentHandoff(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder
            builderForValue) {
      if (liveAgentHandoffBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        liveAgentHandoffBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    public Builder mergeLiveAgentHandoff(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff value) {
      if (liveAgentHandoffBuilder_ == null) {
        if (messageCase_ == 10
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff)
                          message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 10) {
          liveAgentHandoffBuilder_.mergeFrom(value);
        } else {
          liveAgentHandoffBuilder_.setMessage(value);
        }
      }
      messageCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    public Builder clearLiveAgentHandoff() {
      if (liveAgentHandoffBuilder_ == null) {
        if (messageCase_ == 10) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 10) {
          messageCase_ = 0;
          message_ = null;
        }
        liveAgentHandoffBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder
        getLiveAgentHandoffBuilder() {
      return getLiveAgentHandoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoffOrBuilder
        getLiveAgentHandoffOrBuilder() {
      if ((messageCase_ == 10) && (liveAgentHandoffBuilder_ != null)) {
        return liveAgentHandoffBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 10) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoffOrBuilder>
        getLiveAgentHandoffFieldBuilder() {
      if (liveAgentHandoffBuilder_ == null) {
        if (!(messageCase_ == 10)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff
                  .getDefaultInstance();
        }
        liveAgentHandoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoffOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.LiveAgentHandoff) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 10;
      onChanged();
      return liveAgentHandoffBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteractionOrBuilder>
        endInteractionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endInteraction field is set.
     */
    @java.lang.Override
    public boolean hasEndInteraction() {
      return messageCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endInteraction.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
        getEndInteraction() {
      if (endInteractionBuilder_ == null) {
        if (messageCase_ == 11) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
            .getDefaultInstance();
      } else {
        if (messageCase_ == 11) {
          return endInteractionBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndInteraction(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction value) {
      if (endInteractionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        endInteractionBuilder_.setMessage(value);
      }
      messageCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndInteraction(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder
            builderForValue) {
      if (endInteractionBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        endInteractionBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndInteraction(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction value) {
      if (endInteractionBuilder_ == null) {
        if (messageCase_ == 11
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction)
                          message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 11) {
          endInteractionBuilder_.mergeFrom(value);
        } else {
          endInteractionBuilder_.setMessage(value);
        }
      }
      messageCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndInteraction() {
      if (endInteractionBuilder_ == null) {
        if (messageCase_ == 11) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 11) {
          messageCase_ = 0;
          message_ = null;
        }
        endInteractionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder
        getEndInteractionBuilder() {
      return getEndInteractionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteractionOrBuilder
        getEndInteractionOrBuilder() {
      if ((messageCase_ == 11) && (endInteractionBuilder_ != null)) {
        return endInteractionBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 11) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     *
     * It's guaranteed that there is at most one such message in each response.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteractionOrBuilder>
        getEndInteractionFieldBuilder() {
      if (endInteractionBuilder_ == null) {
        if (!(messageCase_ == 11)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction
                  .getDefaultInstance();
        }
        endInteractionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteractionOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.EndInteraction) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 11;
      onChanged();
      return endInteractionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudioOrBuilder>
        playAudioBuilder_;
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     *
     * @return Whether the playAudio field is set.
     */
    @java.lang.Override
    public boolean hasPlayAudio() {
      return messageCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     *
     * @return The playAudio.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio getPlayAudio() {
      if (playAudioBuilder_ == null) {
        if (messageCase_ == 12) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
            .getDefaultInstance();
      } else {
        if (messageCase_ == 12) {
          return playAudioBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    public Builder setPlayAudio(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio value) {
      if (playAudioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        playAudioBuilder_.setMessage(value);
      }
      messageCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    public Builder setPlayAudio(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder builderForValue) {
      if (playAudioBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        playAudioBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    public Builder mergePlayAudio(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio value) {
      if (playAudioBuilder_ == null) {
        if (messageCase_ == 12
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 12) {
          playAudioBuilder_.mergeFrom(value);
        } else {
          playAudioBuilder_.setMessage(value);
        }
      }
      messageCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    public Builder clearPlayAudio() {
      if (playAudioBuilder_ == null) {
        if (messageCase_ == 12) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 12) {
          messageCase_ = 0;
          message_ = null;
        }
        playAudioBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder
        getPlayAudioBuilder() {
      return getPlayAudioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudioOrBuilder
        getPlayAudioOrBuilder() {
      if ((messageCase_ == 12) && (playAudioBuilder_ != null)) {
        return playAudioBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 12) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio play_audio = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudioOrBuilder>
        getPlayAudioFieldBuilder() {
      if (playAudioBuilder_ == null) {
        if (!(messageCase_ == 12)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.getDefaultInstance();
        }
        playAudioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudioOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.PlayAudio) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 12;
      onChanged();
      return playAudioBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudioOrBuilder>
        mixedAudioBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the mixedAudio field is set.
     */
    @java.lang.Override
    public boolean hasMixedAudio() {
      return messageCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The mixedAudio.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio getMixedAudio() {
      if (mixedAudioBuilder_ == null) {
        if (messageCase_ == 13) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
            .getDefaultInstance();
      } else {
        if (messageCase_ == 13) {
          return mixedAudioBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMixedAudio(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio value) {
      if (mixedAudioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        mixedAudioBuilder_.setMessage(value);
      }
      messageCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMixedAudio(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder builderForValue) {
      if (mixedAudioBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        mixedAudioBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMixedAudio(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio value) {
      if (mixedAudioBuilder_ == null) {
        if (messageCase_ == 13
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 13) {
          mixedAudioBuilder_.mergeFrom(value);
        } else {
          mixedAudioBuilder_.setMessage(value);
        }
      }
      messageCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMixedAudio() {
      if (mixedAudioBuilder_ == null) {
        if (messageCase_ == 13) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 13) {
          messageCase_ = 0;
          message_ = null;
        }
        mixedAudioBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder
        getMixedAudioBuilder() {
      return getMixedAudioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudioOrBuilder
        getMixedAudioOrBuilder() {
      if ((messageCase_ == 13) && (mixedAudioBuilder_ != null)) {
        return mixedAudioBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 13) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudioOrBuilder>
        getMixedAudioFieldBuilder() {
      if (mixedAudioBuilder_ == null) {
        if (!(messageCase_ == 13)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio
                  .getDefaultInstance();
        }
        mixedAudioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudioOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.MixedAudio) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 13;
      onChanged();
      return mixedAudioBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCallOrBuilder>
        telephonyTransferCallBuilder_;
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     *
     * @return Whether the telephonyTransferCall field is set.
     */
    @java.lang.Override
    public boolean hasTelephonyTransferCall() {
      return messageCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     *
     * @return The telephonyTransferCall.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
        getTelephonyTransferCall() {
      if (telephonyTransferCallBuilder_ == null) {
        if (messageCase_ == 18) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
              message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
            .getDefaultInstance();
      } else {
        if (messageCase_ == 18) {
          return telephonyTransferCallBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    public Builder setTelephonyTransferCall(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall value) {
      if (telephonyTransferCallBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        telephonyTransferCallBuilder_.setMessage(value);
      }
      messageCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    public Builder setTelephonyTransferCall(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.Builder
            builderForValue) {
      if (telephonyTransferCallBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        telephonyTransferCallBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    public Builder mergeTelephonyTransferCall(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall value) {
      if (telephonyTransferCallBuilder_ == null) {
        if (messageCase_ == 18
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
                  .newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
                          message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 18) {
          telephonyTransferCallBuilder_.mergeFrom(value);
        } else {
          telephonyTransferCallBuilder_.setMessage(value);
        }
      }
      messageCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    public Builder clearTelephonyTransferCall() {
      if (telephonyTransferCallBuilder_ == null) {
        if (messageCase_ == 18) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 18) {
          messageCase_ = 0;
          message_ = null;
        }
        telephonyTransferCallBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.Builder
        getTelephonyTransferCallBuilder() {
      return getTelephonyTransferCallFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCallOrBuilder
        getTelephonyTransferCallOrBuilder() {
      if ((messageCase_ == 18) && (telephonyTransferCallBuilder_ != null)) {
        return telephonyTransferCallBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 18) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
              message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCallOrBuilder>
        getTelephonyTransferCallFieldBuilder() {
      if (telephonyTransferCallBuilder_ == null) {
        if (!(messageCase_ == 18)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
                  .getDefaultInstance();
        }
        telephonyTransferCallBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall
                    .Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage
                    .TelephonyTransferCallOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.TelephonyTransferCall)
                    message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 18;
      onChanged();
      return telephonyTransferCallBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCardOrBuilder>
        knowledgeInfoCardBuilder_;
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     *
     * @return Whether the knowledgeInfoCard field is set.
     */
    @java.lang.Override
    public boolean hasKnowledgeInfoCard() {
      return messageCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     *
     * @return The knowledgeInfoCard.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
        getKnowledgeInfoCard() {
      if (knowledgeInfoCardBuilder_ == null) {
        if (messageCase_ == 20) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
              message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
            .getDefaultInstance();
      } else {
        if (messageCase_ == 20) {
          return knowledgeInfoCardBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    public Builder setKnowledgeInfoCard(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard value) {
      if (knowledgeInfoCardBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        onChanged();
      } else {
        knowledgeInfoCardBuilder_.setMessage(value);
      }
      messageCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    public Builder setKnowledgeInfoCard(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder
            builderForValue) {
      if (knowledgeInfoCardBuilder_ == null) {
        message_ = builderForValue.build();
        onChanged();
      } else {
        knowledgeInfoCardBuilder_.setMessage(builderForValue.build());
      }
      messageCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    public Builder mergeKnowledgeInfoCard(
        com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard value) {
      if (knowledgeInfoCardBuilder_ == null) {
        if (messageCase_ == 20
            && message_
                != com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
                    .getDefaultInstance()) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
                          message_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          message_ = value;
        }
        onChanged();
      } else {
        if (messageCase_ == 20) {
          knowledgeInfoCardBuilder_.mergeFrom(value);
        } else {
          knowledgeInfoCardBuilder_.setMessage(value);
        }
      }
      messageCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    public Builder clearKnowledgeInfoCard() {
      if (knowledgeInfoCardBuilder_ == null) {
        if (messageCase_ == 20) {
          messageCase_ = 0;
          message_ = null;
          onChanged();
        }
      } else {
        if (messageCase_ == 20) {
          messageCase_ = 0;
          message_ = null;
        }
        knowledgeInfoCardBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder
        getKnowledgeInfoCardBuilder() {
      return getKnowledgeInfoCardFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCardOrBuilder
        getKnowledgeInfoCardOrBuilder() {
      if ((messageCase_ == 20) && (knowledgeInfoCardBuilder_ != null)) {
        return knowledgeInfoCardBuilder_.getMessageOrBuilder();
      } else {
        if (messageCase_ == 20) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard)
              message_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCardOrBuilder>
        getKnowledgeInfoCardFieldBuilder() {
      if (knowledgeInfoCardBuilder_ == null) {
        if (!(messageCase_ == 20)) {
          message_ =
              com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard
                  .getDefaultInstance();
        }
        knowledgeInfoCardBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCardOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage.KnowledgeInfoCard) message_,
                getParentForChildren(),
                isClean());
        message_ = null;
      }
      messageCase_ = 20;
      onChanged();
      return knowledgeInfoCardBuilder_;
    }

    private java.lang.Object channel_ = "";
    /**
     *
     *
     * <pre>
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
     * and only associated channel response will be returned.
     * </pre>
     *
     * <code>string channel = 19;</code>
     *
     * @return The channel.
     */
    public java.lang.String getChannel() {
      java.lang.Object ref = channel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        channel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
     * and only associated channel response will be returned.
     * </pre>
     *
     * <code>string channel = 19;</code>
     *
     * @return The bytes for channel.
     */
    public com.google.protobuf.ByteString getChannelBytes() {
      java.lang.Object ref = channel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        channel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
     * and only associated channel response will be returned.
     * </pre>
     *
     * <code>string channel = 19;</code>
     *
     * @param value The channel to set.
     * @return This builder for chaining.
     */
    public Builder setChannel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      channel_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
     * and only associated channel response will be returned.
     * </pre>
     *
     * <code>string channel = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannel() {
      channel_ = getDefaultInstance().getChannel();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3beta1.QueryParameters.channel],
     * and only associated channel response will be returned.
     * </pre>
     *
     * <code>string channel = 19;</code>
     *
     * @param value The bytes for channel to set.
     * @return This builder for chaining.
     */
    public Builder setChannelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      channel_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ResponseMessage)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResponseMessage> PARSER =
      new com.google.protobuf.AbstractParser<ResponseMessage>() {
        @java.lang.Override
        public ResponseMessage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResponseMessage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResponseMessage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResponseMessage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
