/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/session.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Response of [MatchIntent][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse}
 */
public final class MatchIntentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse)
    MatchIntentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MatchIntentResponse.newBuilder() to construct.
  private MatchIntentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MatchIntentResponse() {
    matches_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MatchIntentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_MatchIntentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_MatchIntentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.class,
            com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.Builder.class);
  }

  private int queryCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object query_;

  public enum QueryCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(1),
    TRIGGER_INTENT(2),
    TRANSCRIPT(3),
    TRIGGER_EVENT(6),
    QUERY_NOT_SET(0);
    private final int value;

    private QueryCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT;
        case 2:
          return TRIGGER_INTENT;
        case 3:
          return TRANSCRIPT;
        case 6:
          return TRIGGER_EVENT;
        case 0:
          return QUERY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryCase getQueryCase() {
    return QueryCase.forNumber(queryCase_);
  }

  public static final int TEXT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
   * was provided as input, this field will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return Whether the text field is set.
   */
  public boolean hasText() {
    return queryCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
   * was provided as input, this field will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The text.
   */
  public java.lang.String getText() {
    java.lang.Object ref = "";
    if (queryCase_ == 1) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 1) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
   * was provided as input, this field will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The bytes for text.
   */
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 1) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 1) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_INTENT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
   * provided as input, this field will contain a copy of the intent
   * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the triggerIntent field is set.
   */
  public boolean hasTriggerIntent() {
    return queryCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
   * provided as input, this field will contain a copy of the intent
   * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The triggerIntent.
   */
  public java.lang.String getTriggerIntent() {
    java.lang.Object ref = "";
    if (queryCase_ == 2) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 2) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
   * provided as input, this field will contain a copy of the intent
   * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for triggerIntent.
   */
  public com.google.protobuf.ByteString getTriggerIntentBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 2) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 2) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * If [natural language speech
   * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
   * input, this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 3;</code>
   *
   * @return Whether the transcript field is set.
   */
  public boolean hasTranscript() {
    return queryCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * If [natural language speech
   * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
   * input, this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 3;</code>
   *
   * @return The transcript.
   */
  public java.lang.String getTranscript() {
    java.lang.Object ref = "";
    if (queryCase_ == 3) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 3) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [natural language speech
   * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
   * input, this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 3;</code>
   *
   * @return The bytes for transcript.
   */
  public com.google.protobuf.ByteString getTranscriptBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 3) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 3) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_EVENT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
   * as input, this field will contain a copy of the event name.
   * </pre>
   *
   * <code>string trigger_event = 6;</code>
   *
   * @return Whether the triggerEvent field is set.
   */
  public boolean hasTriggerEvent() {
    return queryCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
   * as input, this field will contain a copy of the event name.
   * </pre>
   *
   * <code>string trigger_event = 6;</code>
   *
   * @return The triggerEvent.
   */
  public java.lang.String getTriggerEvent() {
    java.lang.Object ref = "";
    if (queryCase_ == 6) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 6) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
   * as input, this field will contain a copy of the event name.
   * </pre>
   *
   * <code>string trigger_event = 6;</code>
   *
   * @return The bytes for triggerEvent.
   */
  public com.google.protobuf.ByteString getTriggerEventBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 6) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 6) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCHES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Match> matches_;
  /**
   *
   *
   * <pre>
   * Match results, if more than one, ordered descendingly by the confidence
   * we have that the particular intent matches the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Match> getMatchesList() {
    return matches_;
  }
  /**
   *
   *
   * <pre>
   * Match results, if more than one, ordered descendingly by the confidence
   * we have that the particular intent matches the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder>
      getMatchesOrBuilderList() {
    return matches_;
  }
  /**
   *
   *
   * <pre>
   * Match results, if more than one, ordered descendingly by the confidence
   * we have that the particular intent matches the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
   */
  @java.lang.Override
  public int getMatchesCount() {
    return matches_.size();
  }
  /**
   *
   *
   * <pre>
   * Match results, if more than one, ordered descendingly by the confidence
   * we have that the particular intent matches the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Match getMatches(int index) {
    return matches_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Match results, if more than one, ordered descendingly by the confidence
   * we have that the particular intent matches the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder getMatchesOrBuilder(int index) {
    return matches_.get(index);
  }

  public static final int CURRENT_PAGE_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3beta1.Page currentPage_;
  /**
   *
   *
   * <pre>
   * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
   *
   * @return Whether the currentPage field is set.
   */
  @java.lang.Override
  public boolean hasCurrentPage() {
    return currentPage_ != null;
  }
  /**
   *
   *
   * <pre>
   * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
   *
   * @return The currentPage.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Page getCurrentPage() {
    return currentPage_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance()
        : currentPage_;
  }
  /**
   *
   *
   * <pre>
   * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder getCurrentPageOrBuilder() {
    return currentPage_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance()
        : currentPage_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (queryCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
    }
    if (queryCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, query_);
    }
    if (queryCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, query_);
    }
    for (int i = 0; i < matches_.size(); i++) {
      output.writeMessage(4, matches_.get(i));
    }
    if (currentPage_ != null) {
      output.writeMessage(5, getCurrentPage());
    }
    if (queryCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, query_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (queryCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
    }
    if (queryCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, query_);
    }
    if (queryCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, query_);
    }
    for (int i = 0; i < matches_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, matches_.get(i));
    }
    if (currentPage_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCurrentPage());
    }
    if (queryCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, query_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse other =
        (com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse) obj;

    if (!getMatchesList().equals(other.getMatchesList())) return false;
    if (hasCurrentPage() != other.hasCurrentPage()) return false;
    if (hasCurrentPage()) {
      if (!getCurrentPage().equals(other.getCurrentPage())) return false;
    }
    if (!getQueryCase().equals(other.getQueryCase())) return false;
    switch (queryCase_) {
      case 1:
        if (!getText().equals(other.getText())) return false;
        break;
      case 2:
        if (!getTriggerIntent().equals(other.getTriggerIntent())) return false;
        break;
      case 3:
        if (!getTranscript().equals(other.getTranscript())) return false;
        break;
      case 6:
        if (!getTriggerEvent().equals(other.getTriggerEvent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMatchesCount() > 0) {
      hash = (37 * hash) + MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + getMatchesList().hashCode();
    }
    if (hasCurrentPage()) {
      hash = (37 * hash) + CURRENT_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentPage().hashCode();
    }
    switch (queryCase_) {
      case 1:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 2:
        hash = (37 * hash) + TRIGGER_INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerIntent().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TRANSCRIPT_FIELD_NUMBER;
        hash = (53 * hash) + getTranscript().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TRIGGER_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerEvent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response of [MatchIntent][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse)
      com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_MatchIntentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_MatchIntentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.class,
              com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (matchesBuilder_ == null) {
        matches_ = java.util.Collections.emptyList();
      } else {
        matches_ = null;
        matchesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      currentPage_ = null;
      if (currentPageBuilder_ != null) {
        currentPageBuilder_.dispose();
        currentPageBuilder_ = null;
      }
      queryCase_ = 0;
      query_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_MatchIntentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse build() {
      com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse result =
          new com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse result) {
      if (matchesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          matches_ = java.util.Collections.unmodifiableList(matches_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.matches_ = matches_;
      } else {
        result.matches_ = matchesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.currentPage_ =
            currentPageBuilder_ == null ? currentPage_ : currentPageBuilder_.build();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse result) {
      result.queryCase_ = queryCase_;
      result.query_ = this.query_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.getDefaultInstance())
        return this;
      if (matchesBuilder_ == null) {
        if (!other.matches_.isEmpty()) {
          if (matches_.isEmpty()) {
            matches_ = other.matches_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureMatchesIsMutable();
            matches_.addAll(other.matches_);
          }
          onChanged();
        }
      } else {
        if (!other.matches_.isEmpty()) {
          if (matchesBuilder_.isEmpty()) {
            matchesBuilder_.dispose();
            matchesBuilder_ = null;
            matches_ = other.matches_;
            bitField0_ = (bitField0_ & ~0x00000010);
            matchesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMatchesFieldBuilder()
                    : null;
          } else {
            matchesBuilder_.addAllMessages(other.matches_);
          }
        }
      }
      if (other.hasCurrentPage()) {
        mergeCurrentPage(other.getCurrentPage());
      }
      switch (other.getQueryCase()) {
        case TEXT:
          {
            queryCase_ = 1;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRIGGER_INTENT:
          {
            queryCase_ = 2;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRANSCRIPT:
          {
            queryCase_ = 3;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRIGGER_EVENT:
          {
            queryCase_ = 6;
            query_ = other.query_;
            onChanged();
            break;
          }
        case QUERY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 1;
                query_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 2;
                query_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 3;
                query_ = s;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Match m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Match.parser(), extensionRegistry);
                if (matchesBuilder_ == null) {
                  ensureMatchesIsMutable();
                  matches_.add(m);
                } else {
                  matchesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCurrentPageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 6;
                query_ = s;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryCase_ = 0;
    private java.lang.Object query_;

    public QueryCase getQueryCase() {
      return QueryCase.forNumber(queryCase_);
    }

    public Builder clearQuery() {
      queryCase_ = 0;
      query_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
     * was provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return queryCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
     * was provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (queryCase_ == 1) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 1) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
     * was provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 1) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 1) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
     * was provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 1;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
     * was provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      if (queryCase_ == 1) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput]
     * was provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 1;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
     * provided as input, this field will contain a copy of the intent
     * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the triggerIntent field is set.
     */
    @java.lang.Override
    public boolean hasTriggerIntent() {
      return queryCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
     * provided as input, this field will contain a copy of the intent
     * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The triggerIntent.
     */
    @java.lang.Override
    public java.lang.String getTriggerIntent() {
      java.lang.Object ref = "";
      if (queryCase_ == 2) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 2) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
     * provided as input, this field will contain a copy of the intent
     * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for triggerIntent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTriggerIntentBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 2) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 2) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
     * provided as input, this field will contain a copy of the intent
     * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The triggerIntent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerIntent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 2;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
     * provided as input, this field will contain a copy of the intent
     * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerIntent() {
      if (queryCase_ == 2) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was
     * provided as input, this field will contain a copy of the intent
     * identifier. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for triggerIntent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerIntentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 2;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
     * input, this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 3;</code>
     *
     * @return Whether the transcript field is set.
     */
    @java.lang.Override
    public boolean hasTranscript() {
      return queryCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
     * input, this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 3;</code>
     *
     * @return The transcript.
     */
    @java.lang.Override
    public java.lang.String getTranscript() {
      java.lang.Object ref = "";
      if (queryCase_ == 3) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 3) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
     * input, this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 3;</code>
     *
     * @return The bytes for transcript.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTranscriptBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 3) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 3) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
     * input, this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 3;</code>
     *
     * @param value The transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 3;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
     * input, this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranscript() {
      if (queryCase_ == 3) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as
     * input, this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 3;</code>
     *
     * @param value The bytes for transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 3;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
     * as input, this field will contain a copy of the event name.
     * </pre>
     *
     * <code>string trigger_event = 6;</code>
     *
     * @return Whether the triggerEvent field is set.
     */
    @java.lang.Override
    public boolean hasTriggerEvent() {
      return queryCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
     * as input, this field will contain a copy of the event name.
     * </pre>
     *
     * <code>string trigger_event = 6;</code>
     *
     * @return The triggerEvent.
     */
    @java.lang.Override
    public java.lang.String getTriggerEvent() {
      java.lang.Object ref = "";
      if (queryCase_ == 6) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 6) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
     * as input, this field will contain a copy of the event name.
     * </pre>
     *
     * <code>string trigger_event = 6;</code>
     *
     * @return The bytes for triggerEvent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTriggerEventBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 6) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 6) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
     * as input, this field will contain a copy of the event name.
     * </pre>
     *
     * <code>string trigger_event = 6;</code>
     *
     * @param value The triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 6;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
     * as input, this field will contain a copy of the event name.
     * </pre>
     *
     * <code>string trigger_event = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerEvent() {
      if (queryCase_ == 6) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided
     * as input, this field will contain a copy of the event name.
     * </pre>
     *
     * <code>string trigger_event = 6;</code>
     *
     * @param value The bytes for triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 6;
      query_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Match> matches_ =
        java.util.Collections.emptyList();

    private void ensureMatchesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        matches_ = new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Match>(matches_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Match,
            com.google.cloud.dialogflow.cx.v3beta1.Match.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder>
        matchesBuilder_;

    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Match> getMatchesList() {
      if (matchesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(matches_);
      } else {
        return matchesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public int getMatchesCount() {
      if (matchesBuilder_ == null) {
        return matches_.size();
      } else {
        return matchesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Match getMatches(int index) {
      if (matchesBuilder_ == null) {
        return matches_.get(index);
      } else {
        return matchesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder setMatches(int index, com.google.cloud.dialogflow.cx.v3beta1.Match value) {
      if (matchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchesIsMutable();
        matches_.set(index, value);
        onChanged();
      } else {
        matchesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder setMatches(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Match.Builder builderForValue) {
      if (matchesBuilder_ == null) {
        ensureMatchesIsMutable();
        matches_.set(index, builderForValue.build());
        onChanged();
      } else {
        matchesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder addMatches(com.google.cloud.dialogflow.cx.v3beta1.Match value) {
      if (matchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchesIsMutable();
        matches_.add(value);
        onChanged();
      } else {
        matchesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder addMatches(int index, com.google.cloud.dialogflow.cx.v3beta1.Match value) {
      if (matchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchesIsMutable();
        matches_.add(index, value);
        onChanged();
      } else {
        matchesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder addMatches(
        com.google.cloud.dialogflow.cx.v3beta1.Match.Builder builderForValue) {
      if (matchesBuilder_ == null) {
        ensureMatchesIsMutable();
        matches_.add(builderForValue.build());
        onChanged();
      } else {
        matchesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder addMatches(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Match.Builder builderForValue) {
      if (matchesBuilder_ == null) {
        ensureMatchesIsMutable();
        matches_.add(index, builderForValue.build());
        onChanged();
      } else {
        matchesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder addAllMatches(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Match> values) {
      if (matchesBuilder_ == null) {
        ensureMatchesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matches_);
        onChanged();
      } else {
        matchesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder clearMatches() {
      if (matchesBuilder_ == null) {
        matches_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        matchesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public Builder removeMatches(int index) {
      if (matchesBuilder_ == null) {
        ensureMatchesIsMutable();
        matches_.remove(index);
        onChanged();
      } else {
        matchesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Match.Builder getMatchesBuilder(int index) {
      return getMatchesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder getMatchesOrBuilder(int index) {
      if (matchesBuilder_ == null) {
        return matches_.get(index);
      } else {
        return matchesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder>
        getMatchesOrBuilderList() {
      if (matchesBuilder_ != null) {
        return matchesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(matches_);
      }
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Match.Builder addMatchesBuilder() {
      return getMatchesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Match.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Match.Builder addMatchesBuilder(int index) {
      return getMatchesFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Match.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Match results, if more than one, ordered descendingly by the confidence
     * we have that the particular intent matches the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Match matches = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Match.Builder>
        getMatchesBuilderList() {
      return getMatchesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Match,
            com.google.cloud.dialogflow.cx.v3beta1.Match.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder>
        getMatchesFieldBuilder() {
      if (matchesBuilder_ == null) {
        matchesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Match,
                com.google.cloud.dialogflow.cx.v3beta1.Match.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.MatchOrBuilder>(
                matches_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        matches_ = null;
      }
      return matchesBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Page currentPage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Page,
            com.google.cloud.dialogflow.cx.v3beta1.Page.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
        currentPageBuilder_;
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     *
     * @return Whether the currentPage field is set.
     */
    public boolean hasCurrentPage() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     *
     * @return The currentPage.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Page getCurrentPage() {
      if (currentPageBuilder_ == null) {
        return currentPage_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance()
            : currentPage_;
      } else {
        return currentPageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    public Builder setCurrentPage(com.google.cloud.dialogflow.cx.v3beta1.Page value) {
      if (currentPageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentPage_ = value;
      } else {
        currentPageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    public Builder setCurrentPage(
        com.google.cloud.dialogflow.cx.v3beta1.Page.Builder builderForValue) {
      if (currentPageBuilder_ == null) {
        currentPage_ = builderForValue.build();
      } else {
        currentPageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    public Builder mergeCurrentPage(com.google.cloud.dialogflow.cx.v3beta1.Page value) {
      if (currentPageBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && currentPage_ != null
            && currentPage_ != com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance()) {
          getCurrentPageBuilder().mergeFrom(value);
        } else {
          currentPage_ = value;
        }
      } else {
        currentPageBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    public Builder clearCurrentPage() {
      bitField0_ = (bitField0_ & ~0x00000020);
      currentPage_ = null;
      if (currentPageBuilder_ != null) {
        currentPageBuilder_.dispose();
        currentPageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Page.Builder getCurrentPageBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCurrentPageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder getCurrentPageOrBuilder() {
      if (currentPageBuilder_ != null) {
        return currentPageBuilder_.getMessageOrBuilder();
      } else {
        return currentPage_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance()
            : currentPage_;
      }
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Page current_page = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Page,
            com.google.cloud.dialogflow.cx.v3beta1.Page.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
        getCurrentPageFieldBuilder() {
      if (currentPageBuilder_ == null) {
        currentPageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Page,
                com.google.cloud.dialogflow.cx.v3beta1.Page.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>(
                getCurrentPage(), getParentForChildren(), isClean());
        currentPage_ = null;
      }
      return currentPageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse)
  private static final com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MatchIntentResponse> PARSER =
      new com.google.protobuf.AbstractParser<MatchIntentResponse>() {
        @java.lang.Override
        public MatchIntentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MatchIntentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MatchIntentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
