/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/test_case.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Intent coverage represents the percentage of all possible intents in the
 * agent that are triggered in any of a parent's test cases.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.IntentCoverage}
 */
public final class IntentCoverage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.IntentCoverage)
    IntentCoverageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IntentCoverage.newBuilder() to construct.
  private IntentCoverage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IntentCoverage() {
    intents_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IntentCoverage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.class,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder.class);
  }

  public interface IntentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The intent full resource name
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The intent.
     */
    java.lang.String getIntent();
    /**
     *
     *
     * <pre>
     * The intent full resource name
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for intent.
     */
    com.google.protobuf.ByteString getIntentBytes();

    /**
     *
     *
     * <pre>
     * Whether the intent is covered by at least one of the agent's
     * test cases.
     * </pre>
     *
     * <code>bool covered = 2;</code>
     *
     * @return The covered.
     */
    boolean getCovered();
  }
  /**
   *
   *
   * <pre>
   * The agent's intent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent}
   */
  public static final class Intent extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent)
      IntentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Intent.newBuilder() to construct.
    private Intent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Intent() {
      intent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Intent();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_Intent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_Intent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.class,
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder.class);
    }

    public static final int INTENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object intent_ = "";
    /**
     *
     *
     * <pre>
     * The intent full resource name
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The intent.
     */
    @java.lang.Override
    public java.lang.String getIntent() {
      java.lang.Object ref = intent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        intent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The intent full resource name
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for intent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIntentBytes() {
      java.lang.Object ref = intent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        intent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COVERED_FIELD_NUMBER = 2;
    private boolean covered_ = false;
    /**
     *
     *
     * <pre>
     * Whether the intent is covered by at least one of the agent's
     * test cases.
     * </pre>
     *
     * <code>bool covered = 2;</code>
     *
     * @return The covered.
     */
    @java.lang.Override
    public boolean getCovered() {
      return covered_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, intent_);
      }
      if (covered_ != false) {
        output.writeBool(2, covered_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, intent_);
      }
      if (covered_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, covered_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent other =
          (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent) obj;

      if (!getIntent().equals(other.getIntent())) return false;
      if (getCovered() != other.getCovered()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getIntent().hashCode();
      hash = (37 * hash) + COVERED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCovered());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The agent's intent.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent)
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_Intent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_Intent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.class,
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        intent_ = "";
        covered_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_Intent_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent build() {
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent result =
            new com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.intent_ = intent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.covered_ = covered_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.getDefaultInstance())
          return this;
        if (!other.getIntent().isEmpty()) {
          intent_ = other.intent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getCovered() != false) {
          setCovered(other.getCovered());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  intent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  covered_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object intent_ = "";
      /**
       *
       *
       * <pre>
       * The intent full resource name
       * </pre>
       *
       * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The intent.
       */
      public java.lang.String getIntent() {
        java.lang.Object ref = intent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          intent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The intent full resource name
       * </pre>
       *
       * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for intent.
       */
      public com.google.protobuf.ByteString getIntentBytes() {
        java.lang.Object ref = intent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          intent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The intent full resource name
       * </pre>
       *
       * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The intent to set.
       * @return This builder for chaining.
       */
      public Builder setIntent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        intent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The intent full resource name
       * </pre>
       *
       * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIntent() {
        intent_ = getDefaultInstance().getIntent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The intent full resource name
       * </pre>
       *
       * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for intent to set.
       * @return This builder for chaining.
       */
      public Builder setIntentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        intent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean covered_;
      /**
       *
       *
       * <pre>
       * Whether the intent is covered by at least one of the agent's
       * test cases.
       * </pre>
       *
       * <code>bool covered = 2;</code>
       *
       * @return The covered.
       */
      @java.lang.Override
      public boolean getCovered() {
        return covered_;
      }
      /**
       *
       *
       * <pre>
       * Whether the intent is covered by at least one of the agent's
       * test cases.
       * </pre>
       *
       * <code>bool covered = 2;</code>
       *
       * @param value The covered to set.
       * @return This builder for chaining.
       */
      public Builder setCovered(boolean value) {

        covered_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the intent is covered by at least one of the agent's
       * test cases.
       * </pre>
       *
       * <code>bool covered = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCovered() {
        bitField0_ = (bitField0_ & ~0x00000002);
        covered_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent)
    private static final com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Intent> PARSER =
        new com.google.protobuf.AbstractParser<Intent>() {
          @java.lang.Override
          public Intent parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Intent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Intent> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INTENTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent> intents_;
  /**
   *
   *
   * <pre>
   * The list of Intents present in the agent
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent>
      getIntentsList() {
    return intents_;
  }
  /**
   *
   *
   * <pre>
   * The list of Intents present in the agent
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder>
      getIntentsOrBuilderList() {
    return intents_;
  }
  /**
   *
   *
   * <pre>
   * The list of Intents present in the agent
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
   */
  @java.lang.Override
  public int getIntentsCount() {
    return intents_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of Intents present in the agent
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent getIntents(int index) {
    return intents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of Intents present in the agent
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder getIntentsOrBuilder(
      int index) {
    return intents_.get(index);
  }

  public static final int COVERAGE_SCORE_FIELD_NUMBER = 2;
  private float coverageScore_ = 0F;
  /**
   *
   *
   * <pre>
   * The percent of intents in the agent that are covered.
   * </pre>
   *
   * <code>float coverage_score = 2;</code>
   *
   * @return The coverageScore.
   */
  @java.lang.Override
  public float getCoverageScore() {
    return coverageScore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < intents_.size(); i++) {
      output.writeMessage(1, intents_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
      output.writeFloat(2, coverageScore_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < intents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, intents_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, coverageScore_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage other =
        (com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) obj;

    if (!getIntentsList().equals(other.getIntentsList())) return false;
    if (java.lang.Float.floatToIntBits(getCoverageScore())
        != java.lang.Float.floatToIntBits(other.getCoverageScore())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIntentsCount() > 0) {
      hash = (37 * hash) + INTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getIntentsList().hashCode();
    }
    hash = (37 * hash) + COVERAGE_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getCoverageScore());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Intent coverage represents the percentage of all possible intents in the
   * agent that are triggered in any of a parent's test cases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.IntentCoverage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.IntentCoverage)
      com.google.cloud.dialogflow.cx.v3beta1.IntentCoverageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.class,
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (intentsBuilder_ == null) {
        intents_ = java.util.Collections.emptyList();
      } else {
        intents_ = null;
        intentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      coverageScore_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_IntentCoverage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage build() {
      com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage result =
          new com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage result) {
      if (intentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          intents_ = java.util.Collections.unmodifiableList(intents_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.intents_ = intents_;
      } else {
        result.intents_ = intentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.coverageScore_ = coverageScore_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.getDefaultInstance())
        return this;
      if (intentsBuilder_ == null) {
        if (!other.intents_.isEmpty()) {
          if (intents_.isEmpty()) {
            intents_ = other.intents_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureIntentsIsMutable();
            intents_.addAll(other.intents_);
          }
          onChanged();
        }
      } else {
        if (!other.intents_.isEmpty()) {
          if (intentsBuilder_.isEmpty()) {
            intentsBuilder_.dispose();
            intentsBuilder_ = null;
            intents_ = other.intents_;
            bitField0_ = (bitField0_ & ~0x00000001);
            intentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIntentsFieldBuilder()
                    : null;
          } else {
            intentsBuilder_.addAllMessages(other.intents_);
          }
        }
      }
      if (other.getCoverageScore() != 0F) {
        setCoverageScore(other.getCoverageScore());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.parser(),
                        extensionRegistry);
                if (intentsBuilder_ == null) {
                  ensureIntentsIsMutable();
                  intents_.add(m);
                } else {
                  intentsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 21:
              {
                coverageScore_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent> intents_ =
        java.util.Collections.emptyList();

    private void ensureIntentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        intents_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent>(
                intents_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder>
        intentsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent>
        getIntentsList() {
      if (intentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(intents_);
      } else {
        return intentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public int getIntentsCount() {
      if (intentsBuilder_ == null) {
        return intents_.size();
      } else {
        return intentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent getIntents(int index) {
      if (intentsBuilder_ == null) {
        return intents_.get(index);
      } else {
        return intentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder setIntents(
        int index, com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent value) {
      if (intentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntentsIsMutable();
        intents_.set(index, value);
        onChanged();
      } else {
        intentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder setIntents(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder builderForValue) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.set(index, builderForValue.build());
        onChanged();
      } else {
        intentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder addIntents(com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent value) {
      if (intentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntentsIsMutable();
        intents_.add(value);
        onChanged();
      } else {
        intentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder addIntents(
        int index, com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent value) {
      if (intentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntentsIsMutable();
        intents_.add(index, value);
        onChanged();
      } else {
        intentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder addIntents(
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder builderForValue) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.add(builderForValue.build());
        onChanged();
      } else {
        intentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder addIntents(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder builderForValue) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.add(index, builderForValue.build());
        onChanged();
      } else {
        intentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder addAllIntents(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent>
            values) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intents_);
        onChanged();
      } else {
        intentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder clearIntents() {
      if (intentsBuilder_ == null) {
        intents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        intentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public Builder removeIntents(int index) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.remove(index);
        onChanged();
      } else {
        intentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder getIntentsBuilder(
        int index) {
      return getIntentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder
        getIntentsOrBuilder(int index) {
      if (intentsBuilder_ == null) {
        return intents_.get(index);
      } else {
        return intentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder>
        getIntentsOrBuilderList() {
      if (intentsBuilder_ != null) {
        return intentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(intents_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder
        addIntentsBuilder() {
      return getIntentsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder addIntentsBuilder(
        int index) {
      return getIntentsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of Intents present in the agent
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent intents = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder>
        getIntentsBuilderList() {
      return getIntentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder>
        getIntentsFieldBuilder() {
      if (intentsBuilder_ == null) {
        intentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent,
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage.IntentOrBuilder>(
                intents_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        intents_ = null;
      }
      return intentsBuilder_;
    }

    private float coverageScore_;
    /**
     *
     *
     * <pre>
     * The percent of intents in the agent that are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @return The coverageScore.
     */
    @java.lang.Override
    public float getCoverageScore() {
      return coverageScore_;
    }
    /**
     *
     *
     * <pre>
     * The percent of intents in the agent that are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @param value The coverageScore to set.
     * @return This builder for chaining.
     */
    public Builder setCoverageScore(float value) {

      coverageScore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percent of intents in the agent that are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCoverageScore() {
      bitField0_ = (bitField0_ & ~0x00000002);
      coverageScore_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.IntentCoverage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.IntentCoverage)
  private static final com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IntentCoverage> PARSER =
      new com.google.protobuf.AbstractParser<IntentCoverage>() {
        @java.lang.Override
        public IntentCoverage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IntentCoverage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IntentCoverage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.IntentCoverage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
