/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/intent.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * An intent represents a user's intent to interact with a conversational agent.
 *
 * You can provide information for the Dialogflow API to use to match user input
 * to an intent by adding training phrases (i.e., examples of user input) to
 * your intent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent}
 */
public final class Intent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Intent)
    IntentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Intent.newBuilder() to construct.
  private Intent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Intent() {
    name_ = "";
    displayName_ = "";
    trainingPhrases_ = java.util.Collections.emptyList();
    parameters_ = java.util.Collections.emptyList();
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Intent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Intent.class,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder.class);
  }

  public interface TrainingPhraseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the training phrase.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the training phrase.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>
        getPartsList();
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part getParts(int index);
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getPartsCount();
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder>
        getPartsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder getPartsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Indicates how many times this example was added to the intent.
     * </pre>
     *
     * <code>int32 repeat_count = 3;</code>
     *
     * @return The repeatCount.
     */
    int getRepeatCount();
  }
  /**
   *
   *
   * <pre>
   * Represents an example that the agent is trained on to identify the intent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase}
   */
  public static final class TrainingPhrase extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase)
      TrainingPhraseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TrainingPhrase.newBuilder() to construct.
    private TrainingPhrase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TrainingPhrase() {
      id_ = "";
      parts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TrainingPhrase();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.class,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder.class);
    }

    public interface PartOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The text.
       */
      java.lang.String getText();
      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for text.
       */
      com.google.protobuf.ByteString getTextBytes();

      /**
       *
       *
       * <pre>
       * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
       * used to annotate this part of the training phrase. This field is
       * required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string parameter_id = 2;</code>
       *
       * @return The parameterId.
       */
      java.lang.String getParameterId();
      /**
       *
       *
       * <pre>
       * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
       * used to annotate this part of the training phrase. This field is
       * required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string parameter_id = 2;</code>
       *
       * @return The bytes for parameterId.
       */
      com.google.protobuf.ByteString getParameterIdBytes();
    }
    /**
     *
     *
     * <pre>
     * Represents a part of a training phrase.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part}
     */
    public static final class Part extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part)
        PartOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Part.newBuilder() to construct.
      private Part(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Part() {
        text_ = "";
        parameterId_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Part();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_Part_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_Part_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.class,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder.class);
      }

      public static final int TEXT_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The text.
       */
      @java.lang.Override
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for text.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PARAMETER_ID_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object parameterId_ = "";
      /**
       *
       *
       * <pre>
       * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
       * used to annotate this part of the training phrase. This field is
       * required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string parameter_id = 2;</code>
       *
       * @return The parameterId.
       */
      @java.lang.Override
      public java.lang.String getParameterId() {
        java.lang.Object ref = parameterId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parameterId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
       * used to annotate this part of the training phrase. This field is
       * required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string parameter_id = 2;</code>
       *
       * @return The bytes for parameterId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getParameterIdBytes() {
        java.lang.Object ref = parameterId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parameterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parameterId_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parameterId_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part other =
            (com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part) obj;

        if (!getText().equals(other.getText())) return false;
        if (!getParameterId().equals(other.getParameterId())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        hash = (37 * hash) + PARAMETER_ID_FIELD_NUMBER;
        hash = (53 * hash) + getParameterId().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a part of a training phrase.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part)
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_Part_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_Part_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          text_ = "";
          parameterId_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_Part_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part build() {
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part result =
              new com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.text_ = text_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.parameterId_ = parameterId_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
                  .getDefaultInstance()) return this;
          if (!other.getText().isEmpty()) {
            text_ = other.text_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getParameterId().isEmpty()) {
            parameterId_ = other.parameterId_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    text_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    parameterId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object text_ = "";
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The text.
         */
        public java.lang.String getText() {
          java.lang.Object ref = text_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            text_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for text.
         */
        public com.google.protobuf.ByteString getTextBytes() {
          java.lang.Object ref = text_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            text_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The text to set.
         * @return This builder for chaining.
         */
        public Builder setText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          text_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearText() {
          text_ = getDefaultInstance().getText();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for text to set.
         * @return This builder for chaining.
         */
        public Builder setTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          text_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object parameterId_ = "";
        /**
         *
         *
         * <pre>
         * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
         * used to annotate this part of the training phrase. This field is
         * required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string parameter_id = 2;</code>
         *
         * @return The parameterId.
         */
        public java.lang.String getParameterId() {
          java.lang.Object ref = parameterId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            parameterId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
         * used to annotate this part of the training phrase. This field is
         * required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string parameter_id = 2;</code>
         *
         * @return The bytes for parameterId.
         */
        public com.google.protobuf.ByteString getParameterIdBytes() {
          java.lang.Object ref = parameterId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            parameterId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
         * used to annotate this part of the training phrase. This field is
         * required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string parameter_id = 2;</code>
         *
         * @param value The parameterId to set.
         * @return This builder for chaining.
         */
        public Builder setParameterId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
         * used to annotate this part of the training phrase. This field is
         * required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string parameter_id = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearParameterId() {
          parameterId_ = getDefaultInstance().getParameterId();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
         * used to annotate this part of the training phrase. This field is
         * required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string parameter_id = 2;</code>
         *
         * @param value The bytes for parameterId to set.
         * @return This builder for chaining.
         */
        public Builder setParameterIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          parameterId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Part> PARSER =
          new com.google.protobuf.AbstractParser<Part>() {
            @java.lang.Override
            public Part parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Part> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Part> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the training phrase.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the training phrase.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>
        parts_;
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>
        getPartsList() {
      return parts_;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder>
        getPartsOrBuilderList() {
      return parts_;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getPartsCount() {
      return parts_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part getParts(int index) {
      return parts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     *
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     *
     * Note: Do not forget to include whitespace at part boundaries, so the
     * training phrase is well formatted when the parts are concatenated.
     *
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the
     * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
     * field set.
     *
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     *
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `parameter_id` field is set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder
        getPartsOrBuilder(int index) {
      return parts_.get(index);
    }

    public static final int REPEAT_COUNT_FIELD_NUMBER = 3;
    private int repeatCount_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates how many times this example was added to the intent.
     * </pre>
     *
     * <code>int32 repeat_count = 3;</code>
     *
     * @return The repeatCount.
     */
    @java.lang.Override
    public int getRepeatCount() {
      return repeatCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      for (int i = 0; i < parts_.size(); i++) {
        output.writeMessage(2, parts_.get(i));
      }
      if (repeatCount_ != 0) {
        output.writeInt32(3, repeatCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      for (int i = 0; i < parts_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parts_.get(i));
      }
      if (repeatCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, repeatCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase other =
          (com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getPartsList().equals(other.getPartsList())) return false;
      if (getRepeatCount() != other.getRepeatCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (getPartsCount() > 0) {
        hash = (37 * hash) + PARTS_FIELD_NUMBER;
        hash = (53 * hash) + getPartsList().hashCode();
      }
      hash = (37 * hash) + REPEAT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRepeatCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an example that the agent is trained on to identify the intent.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase)
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.class,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        if (partsBuilder_ == null) {
          parts_ = java.util.Collections.emptyList();
        } else {
          parts_ = null;
          partsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        repeatCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_TrainingPhrase_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase build() {
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase result =
            new com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase result) {
        if (partsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            parts_ = java.util.Collections.unmodifiableList(parts_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.parts_ = parts_;
        } else {
          result.parts_ = partsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.repeatCount_ = repeatCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (partsBuilder_ == null) {
          if (!other.parts_.isEmpty()) {
            if (parts_.isEmpty()) {
              parts_ = other.parts_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensurePartsIsMutable();
              parts_.addAll(other.parts_);
            }
            onChanged();
          }
        } else {
          if (!other.parts_.isEmpty()) {
            if (partsBuilder_.isEmpty()) {
              partsBuilder_.dispose();
              partsBuilder_ = null;
              parts_ = other.parts_;
              bitField0_ = (bitField0_ & ~0x00000002);
              partsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPartsFieldBuilder()
                      : null;
            } else {
              partsBuilder_.addAllMessages(other.parts_);
            }
          }
        }
        if (other.getRepeatCount() != 0) {
          setRepeatCount(other.getRepeatCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
                              .parser(),
                          extensionRegistry);
                  if (partsBuilder_ == null) {
                    ensurePartsIsMutable();
                    parts_.add(m);
                  } else {
                    partsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  repeatCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of the training phrase.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of the training phrase.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of the training phrase.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of the training phrase.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of the training phrase.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>
          parts_ = java.util.Collections.emptyList();

      private void ensurePartsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          parts_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>(parts_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder>
          partsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>
          getPartsList() {
        if (partsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(parts_);
        } else {
          return partsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getPartsCount() {
        if (partsBuilder_ == null) {
          return parts_.size();
        } else {
          return partsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part getParts(int index) {
        if (partsBuilder_ == null) {
          return parts_.get(index);
        } else {
          return partsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setParts(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part value) {
        if (partsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartsIsMutable();
          parts_.set(index, value);
          onChanged();
        } else {
          partsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setParts(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder
              builderForValue) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.set(index, builderForValue.build());
          onChanged();
        } else {
          partsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part value) {
        if (partsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartsIsMutable();
          parts_.add(value);
          onChanged();
        } else {
          partsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part value) {
        if (partsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartsIsMutable();
          parts_.add(index, value);
          onChanged();
        } else {
          partsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder
              builderForValue) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.add(builderForValue.build());
          onChanged();
        } else {
          partsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder
              builderForValue) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.add(index, builderForValue.build());
          onChanged();
        } else {
          partsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllParts(
          java.lang.Iterable<
                  ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part>
              values) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parts_);
          onChanged();
        } else {
          partsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearParts() {
        if (partsBuilder_ == null) {
          parts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          partsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeParts(int index) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.remove(index);
          onChanged();
        } else {
          partsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder
          getPartsBuilder(int index) {
        return getPartsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder
          getPartsOrBuilder(int index) {
        if (partsBuilder_ == null) {
          return parts_.get(index);
        } else {
          return partsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder>
          getPartsOrBuilderList() {
        if (partsBuilder_ != null) {
          return partsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(parts_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder
          addPartsBuilder() {
        return getPartsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder
          addPartsBuilder(int index) {
        return getPartsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       *
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       *
       * Note: Do not forget to include whitespace at part boundaries, so the
       * training phrase is well formatted when the parts are concatenated.
       *
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the
       * [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
       * field set.
       *
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       *
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `parameter_id` field is set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part parts = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder>
          getPartsBuilderList() {
        return getPartsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder>
          getPartsFieldBuilder() {
        if (partsBuilder_ == null) {
          partsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part,
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.PartOrBuilder>(
                  parts_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          parts_ = null;
        }
        return partsBuilder_;
      }

      private int repeatCount_;
      /**
       *
       *
       * <pre>
       * Indicates how many times this example was added to the intent.
       * </pre>
       *
       * <code>int32 repeat_count = 3;</code>
       *
       * @return The repeatCount.
       */
      @java.lang.Override
      public int getRepeatCount() {
        return repeatCount_;
      }
      /**
       *
       *
       * <pre>
       * Indicates how many times this example was added to the intent.
       * </pre>
       *
       * <code>int32 repeat_count = 3;</code>
       *
       * @param value The repeatCount to set.
       * @return This builder for chaining.
       */
      public Builder setRepeatCount(int value) {

        repeatCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates how many times this example was added to the intent.
       * </pre>
       *
       * <code>int32 repeat_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRepeatCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        repeatCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrainingPhrase> PARSER =
        new com.google.protobuf.AbstractParser<TrainingPhrase>() {
          @java.lang.Override
          public TrainingPhrase parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TrainingPhrase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrainingPhrase> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParameterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Intent.Parameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the parameter. This field
     * is used by [training
     * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
     * annotate their
     * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the parameter. This field
     * is used by [training
     * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
     * annotate their
     * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
     * ID&gt;` for system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    java.lang.String getEntityType();
    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
     * ID&gt;` for system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    com.google.protobuf.ByteString getEntityTypeBytes();

    /**
     *
     *
     * <pre>
     * Indicates whether the parameter represents a list of values.
     * </pre>
     *
     * <code>bool is_list = 3;</code>
     *
     * @return The isList.
     */
    boolean getIsList();

    /**
     *
     *
     * <pre>
     * Indicates whether the parameter content should be redacted in log. If
     * redaction is enabled, the parameter content will be replaced by parameter
     * name during logging.
     * Note: the parameter content is subject to redaction if either parameter
     * level redaction or [entity type level
     * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
     * enabled.
     * </pre>
     *
     * <code>bool redact = 4;</code>
     *
     * @return The redact.
     */
    boolean getRedact();
  }
  /**
   *
   *
   * <pre>
   * Represents an intent parameter.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent.Parameter}
   */
  public static final class Parameter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Intent.Parameter)
      ParameterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Parameter.newBuilder() to construct.
    private Parameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parameter() {
      id_ = "";
      entityType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parameter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_Parameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_Parameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.class,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the parameter. This field
     * is used by [training
     * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
     * annotate their
     * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the parameter. This field
     * is used by [training
     * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
     * annotate their
     * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENTITY_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object entityType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
     * ID&gt;` for system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    @java.lang.Override
    public java.lang.String getEntityType() {
      java.lang.Object ref = entityType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entity type of the parameter.
     * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
     * ID&gt;` for system entity types (for example,
     * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
     * </pre>
     *
     * <code>
     * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityTypeBytes() {
      java.lang.Object ref = entityType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_LIST_FIELD_NUMBER = 3;
    private boolean isList_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether the parameter represents a list of values.
     * </pre>
     *
     * <code>bool is_list = 3;</code>
     *
     * @return The isList.
     */
    @java.lang.Override
    public boolean getIsList() {
      return isList_;
    }

    public static final int REDACT_FIELD_NUMBER = 4;
    private boolean redact_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether the parameter content should be redacted in log. If
     * redaction is enabled, the parameter content will be replaced by parameter
     * name during logging.
     * Note: the parameter content is subject to redaction if either parameter
     * level redaction or [entity type level
     * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
     * enabled.
     * </pre>
     *
     * <code>bool redact = 4;</code>
     *
     * @return The redact.
     */
    @java.lang.Override
    public boolean getRedact() {
      return redact_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityType_);
      }
      if (isList_ != false) {
        output.writeBool(3, isList_);
      }
      if (redact_ != false) {
        output.writeBool(4, redact_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entityType_);
      }
      if (isList_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isList_);
      }
      if (redact_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, redact_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter other =
          (com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getEntityType().equals(other.getEntityType())) return false;
      if (getIsList() != other.getIsList()) return false;
      if (getRedact() != other.getRedact()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getEntityType().hashCode();
      hash = (37 * hash) + IS_LIST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsList());
      hash = (37 * hash) + REDACT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRedact());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an intent parameter.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent.Parameter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Intent.Parameter)
        com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_Parameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_Parameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.class,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        entityType_ = "";
        isList_ = false;
        redact_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_Parameter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter build() {
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter result =
            new com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.entityType_ = entityType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.isList_ = isList_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.redact_ = redact_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getEntityType().isEmpty()) {
          entityType_ = other.entityType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getIsList() != false) {
          setIsList(other.getIsList());
        }
        if (other.getRedact() != false) {
          setRedact(other.getRedact());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  entityType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  isList_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  redact_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Required. The unique identifier of the parameter. This field
       * is used by [training
       * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
       * annotate their
       * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The unique identifier of the parameter. This field
       * is used by [training
       * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
       * annotate their
       * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The unique identifier of the parameter. This field
       * is used by [training
       * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
       * annotate their
       * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The unique identifier of the parameter. This field
       * is used by [training
       * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
       * annotate their
       * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The unique identifier of the parameter. This field
       * is used by [training
       * phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
       * annotate their
       * [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object entityType_ = "";
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
       * ID&gt;` for system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The entityType.
       */
      public java.lang.String getEntityType() {
        java.lang.Object ref = entityType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entityType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
       * ID&gt;` for system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for entityType.
       */
      public com.google.protobuf.ByteString getEntityTypeBytes() {
        java.lang.Object ref = entityType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entityType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
       * ID&gt;` for system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The entityType to set.
       * @return This builder for chaining.
       */
      public Builder setEntityType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
       * ID&gt;` for system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityType() {
        entityType_ = getDefaultInstance().getEntityType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The entity type of the parameter.
       * Format: `projects/-/locations/-/agents/-/entityTypes/&lt;System Entity Type
       * ID&gt;` for system entity types (for example,
       * `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/entityTypes/&lt;Entity Type ID&gt;` for developer entity types.
       * </pre>
       *
       * <code>
       * string entity_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for entityType to set.
       * @return This builder for chaining.
       */
      public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        entityType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean isList_;
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 3;</code>
       *
       * @return The isList.
       */
      @java.lang.Override
      public boolean getIsList() {
        return isList_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 3;</code>
       *
       * @param value The isList to set.
       * @return This builder for chaining.
       */
      public Builder setIsList(boolean value) {

        isList_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsList() {
        bitField0_ = (bitField0_ & ~0x00000004);
        isList_ = false;
        onChanged();
        return this;
      }

      private boolean redact_;
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter content should be redacted in log. If
       * redaction is enabled, the parameter content will be replaced by parameter
       * name during logging.
       * Note: the parameter content is subject to redaction if either parameter
       * level redaction or [entity type level
       * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
       * enabled.
       * </pre>
       *
       * <code>bool redact = 4;</code>
       *
       * @return The redact.
       */
      @java.lang.Override
      public boolean getRedact() {
        return redact_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter content should be redacted in log. If
       * redaction is enabled, the parameter content will be replaced by parameter
       * name during logging.
       * Note: the parameter content is subject to redaction if either parameter
       * level redaction or [entity type level
       * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
       * enabled.
       * </pre>
       *
       * <code>bool redact = 4;</code>
       *
       * @param value The redact to set.
       * @return This builder for chaining.
       */
      public Builder setRedact(boolean value) {

        redact_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the parameter content should be redacted in log. If
       * redaction is enabled, the parameter content will be replaced by parameter
       * name during logging.
       * Note: the parameter content is subject to redaction if either parameter
       * level redaction or [entity type level
       * redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
       * enabled.
       * </pre>
       *
       * <code>bool redact = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRedact() {
        bitField0_ = (bitField0_ & ~0x00000008);
        redact_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Intent.Parameter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Intent.Parameter)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parameter> PARSER =
        new com.google.protobuf.AbstractParser<Parameter>() {
          @java.lang.Override
          public Parameter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Parameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parameter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the intent.
   * Required for the
   * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
   * method.
   * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
   * populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the intent.
   * Required for the
   * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
   * method.
   * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
   * populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the intent, unique within the agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the intent, unique within the agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAINING_PHRASES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase>
      trainingPhrases_;
  /**
   *
   *
   * <pre>
   * The collection of training phrases the agent is trained on to identify the
   * intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase>
      getTrainingPhrasesList() {
    return trainingPhrases_;
  }
  /**
   *
   *
   * <pre>
   * The collection of training phrases the agent is trained on to identify the
   * intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder>
      getTrainingPhrasesOrBuilderList() {
    return trainingPhrases_;
  }
  /**
   *
   *
   * <pre>
   * The collection of training phrases the agent is trained on to identify the
   * intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
   * </code>
   */
  @java.lang.Override
  public int getTrainingPhrasesCount() {
    return trainingPhrases_.size();
  }
  /**
   *
   *
   * <pre>
   * The collection of training phrases the agent is trained on to identify the
   * intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase getTrainingPhrases(
      int index) {
    return trainingPhrases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The collection of training phrases the agent is trained on to identify the
   * intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder
      getTrainingPhrasesOrBuilder(int index) {
    return trainingPhrases_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter> parameters_;
  /**
   *
   *
   * <pre>
   * The collection of parameters associated with the intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter>
      getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * The collection of parameters associated with the intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * The collection of parameters associated with the intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * The collection of parameters associated with the intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The collection of parameters associated with the intent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder getParametersOrBuilder(
      int index) {
    return parameters_.get(index);
  }

  public static final int PRIORITY_FIELD_NUMBER = 5;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * The priority of this intent. Higher numbers represent higher
   * priorities.
   *
   * - If the supplied value is unspecified or 0, the service
   *   translates the value to 500,000, which corresponds to the
   *   `Normal` priority in the console.
   * - If the supplied value is negative, the intent is ignored
   *   in runtime detect intent requests.
   * </pre>
   *
   * <code>int32 priority = 5;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int IS_FALLBACK_FIELD_NUMBER = 6;
  private boolean isFallback_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether this is a fallback intent. Currently only default
   * fallback intent is allowed in the agent, which is added upon agent
   * creation.
   * Adding training phrases to fallback intent is useful in the case of
   * requests that are mistakenly matched, since training phrases assigned to
   * fallback intents act as negative examples that triggers no-match event.
   * </pre>
   *
   * <code>bool is_fallback = 6;</code>
   *
   * @return The isFallback.
   */
  @java.lang.Override
  public boolean getIsFallback() {
    return isFallback_;
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dialogflow.cx.v3beta1.IntentProto
                .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The key/value metadata to label an intent. Labels can contain
   * lowercase letters, digits and the symbols '-' and '_'. International
   * characters are allowed, including letters from unicase alphabets. Keys must
   * start with a letter. Keys and values can be no longer than 63 characters
   * and no more than 128 bytes.
   *
   * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
   * Dialogflow defined labels include:
   * * sys-head
   * * sys-contextual
   * The above labels do not require value. "sys-head" means the intent is a
   * head intent. "sys-contextual" means the intent is a contextual intent.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The key/value metadata to label an intent. Labels can contain
   * lowercase letters, digits and the symbols '-' and '_'. International
   * characters are allowed, including letters from unicase alphabets. Keys must
   * start with a letter. Keys and values can be no longer than 63 characters
   * and no more than 128 bytes.
   *
   * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
   * Dialogflow defined labels include:
   * * sys-head
   * * sys-contextual
   * The above labels do not require value. "sys-head" means the intent is a
   * head intent. "sys-contextual" means the intent is a contextual intent.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The key/value metadata to label an intent. Labels can contain
   * lowercase letters, digits and the symbols '-' and '_'. International
   * characters are allowed, including letters from unicase alphabets. Keys must
   * start with a letter. Keys and values can be no longer than 63 characters
   * and no more than 128 bytes.
   *
   * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
   * Dialogflow defined labels include:
   * * sys-head
   * * sys-contextual
   * The above labels do not require value. "sys-head" means the intent is a
   * head intent. "sys-contextual" means the intent is a contextual intent.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The key/value metadata to label an intent. Labels can contain
   * lowercase letters, digits and the symbols '-' and '_'. International
   * characters are allowed, including letters from unicase alphabets. Keys must
   * start with a letter. Keys and values can be no longer than 63 characters
   * and no more than 128 bytes.
   *
   * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
   * Dialogflow defined labels include:
   * * sys-head
   * * sys-contextual
   * The above labels do not require value. "sys-head" means the intent is a
   * head intent. "sys-contextual" means the intent is a contextual intent.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Human readable description for better understanding an intent like its
   * scope, content, result etc. Maximum character limit: 140 characters.
   * </pre>
   *
   * <code>string description = 8;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human readable description for better understanding an intent like its
   * scope, content, result etc. Maximum character limit: 140 characters.
   * </pre>
   *
   * <code>string description = 8;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < trainingPhrases_.size(); i++) {
      output.writeMessage(3, trainingPhrases_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(4, parameters_.get(i));
    }
    if (priority_ != 0) {
      output.writeInt32(5, priority_);
    }
    if (isFallback_ != false) {
      output.writeBool(6, isFallback_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (int i = 0; i < trainingPhrases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, trainingPhrases_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, parameters_.get(i));
    }
    if (priority_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, priority_);
    }
    if (isFallback_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, isFallback_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Intent other =
        (com.google.cloud.dialogflow.cx.v3beta1.Intent) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getTrainingPhrasesList().equals(other.getTrainingPhrasesList())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (getPriority() != other.getPriority()) return false;
    if (getIsFallback() != other.getIsFallback()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getTrainingPhrasesCount() > 0) {
      hash = (37 * hash) + TRAINING_PHRASES_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingPhrasesList().hashCode();
    }
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + getPriority();
    hash = (37 * hash) + IS_FALLBACK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsFallback());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Intent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An intent represents a user's intent to interact with a conversational agent.
   *
   * You can provide information for the Dialogflow API to use to match user input
   * to an intent by adding training phrases (i.e., examples of user input) to
   * your intent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Intent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Intent)
      com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Intent.class,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Intent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (trainingPhrasesBuilder_ == null) {
        trainingPhrases_ = java.util.Collections.emptyList();
      } else {
        trainingPhrases_ = null;
        trainingPhrasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      priority_ = 0;
      isFallback_ = false;
      internalGetMutableLabels().clear();
      description_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Intent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Intent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent build() {
      com.google.cloud.dialogflow.cx.v3beta1.Intent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Intent buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Intent result =
          new com.google.cloud.dialogflow.cx.v3beta1.Intent(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.cx.v3beta1.Intent result) {
      if (trainingPhrasesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          trainingPhrases_ = java.util.Collections.unmodifiableList(trainingPhrases_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.trainingPhrases_ = trainingPhrases_;
      } else {
        result.trainingPhrases_ = trainingPhrasesBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Intent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.priority_ = priority_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.isFallback_ = isFallback_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Intent) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Intent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Intent other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Intent.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (trainingPhrasesBuilder_ == null) {
        if (!other.trainingPhrases_.isEmpty()) {
          if (trainingPhrases_.isEmpty()) {
            trainingPhrases_ = other.trainingPhrases_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureTrainingPhrasesIsMutable();
            trainingPhrases_.addAll(other.trainingPhrases_);
          }
          onChanged();
        }
      } else {
        if (!other.trainingPhrases_.isEmpty()) {
          if (trainingPhrasesBuilder_.isEmpty()) {
            trainingPhrasesBuilder_.dispose();
            trainingPhrasesBuilder_ = null;
            trainingPhrases_ = other.trainingPhrases_;
            bitField0_ = (bitField0_ & ~0x00000004);
            trainingPhrasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrainingPhrasesFieldBuilder()
                    : null;
          } else {
            trainingPhrasesBuilder_.addAllMessages(other.trainingPhrases_);
          }
        }
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.getPriority() != 0) {
        setPriority(other.getPriority());
      }
      if (other.getIsFallback() != false) {
        setIsFallback(other.getIsFallback());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.parser(),
                        extensionRegistry);
                if (trainingPhrasesBuilder_ == null) {
                  ensureTrainingPhrasesIsMutable();
                  trainingPhrases_.add(m);
                } else {
                  trainingPhrasesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.parser(),
                        extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                isFallback_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the intent, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the intent, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the intent, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the intent, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the intent, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase>
        trainingPhrases_ = java.util.Collections.emptyList();

    private void ensureTrainingPhrasesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        trainingPhrases_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase>(
                trainingPhrases_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder>
        trainingPhrasesBuilder_;

    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase>
        getTrainingPhrasesList() {
      if (trainingPhrasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trainingPhrases_);
      } else {
        return trainingPhrasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public int getTrainingPhrasesCount() {
      if (trainingPhrasesBuilder_ == null) {
        return trainingPhrases_.size();
      } else {
        return trainingPhrasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase getTrainingPhrases(
        int index) {
      if (trainingPhrasesBuilder_ == null) {
        return trainingPhrases_.get(index);
      } else {
        return trainingPhrasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder setTrainingPhrases(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase value) {
      if (trainingPhrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.set(index, value);
        onChanged();
      } else {
        trainingPhrasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder setTrainingPhrases(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder builderForValue) {
      if (trainingPhrasesBuilder_ == null) {
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.set(index, builderForValue.build());
        onChanged();
      } else {
        trainingPhrasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder addTrainingPhrases(
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase value) {
      if (trainingPhrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.add(value);
        onChanged();
      } else {
        trainingPhrasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder addTrainingPhrases(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase value) {
      if (trainingPhrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.add(index, value);
        onChanged();
      } else {
        trainingPhrasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder addTrainingPhrases(
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder builderForValue) {
      if (trainingPhrasesBuilder_ == null) {
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.add(builderForValue.build());
        onChanged();
      } else {
        trainingPhrasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder addTrainingPhrases(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder builderForValue) {
      if (trainingPhrasesBuilder_ == null) {
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.add(index, builderForValue.build());
        onChanged();
      } else {
        trainingPhrasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder addAllTrainingPhrases(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase>
            values) {
      if (trainingPhrasesBuilder_ == null) {
        ensureTrainingPhrasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trainingPhrases_);
        onChanged();
      } else {
        trainingPhrasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder clearTrainingPhrases() {
      if (trainingPhrasesBuilder_ == null) {
        trainingPhrases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        trainingPhrasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public Builder removeTrainingPhrases(int index) {
      if (trainingPhrasesBuilder_ == null) {
        ensureTrainingPhrasesIsMutable();
        trainingPhrases_.remove(index);
        onChanged();
      } else {
        trainingPhrasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder
        getTrainingPhrasesBuilder(int index) {
      return getTrainingPhrasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder
        getTrainingPhrasesOrBuilder(int index) {
      if (trainingPhrasesBuilder_ == null) {
        return trainingPhrases_.get(index);
      } else {
        return trainingPhrasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder>
        getTrainingPhrasesOrBuilderList() {
      if (trainingPhrasesBuilder_ != null) {
        return trainingPhrasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trainingPhrases_);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder
        addTrainingPhrasesBuilder() {
      return getTrainingPhrasesFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder
        addTrainingPhrasesBuilder(int index) {
      return getTrainingPhrasesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase training_phrases = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder>
        getTrainingPhrasesBuilderList() {
      return getTrainingPhrasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder>
        getTrainingPhrasesFieldBuilder() {
      if (trainingPhrasesBuilder_ == null) {
        trainingPhrasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhraseOrBuilder>(
                trainingPhrases_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        trainingPhrases_ = null;
      }
      return trainingPhrasesBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter>(
                parameters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter>
        getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder setParameters(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder setParameters(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder addParameters(com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder addParameters(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder addParameters(
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder addParameters(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter>
            values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder getParametersBuilder(
        int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder getParametersOrBuilder(
        int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder addParametersBuilder(
        int index) {
      return getParametersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters associated with the intent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent.Parameter parameters = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.Parameter.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.ParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * The priority of this intent. Higher numbers represent higher
     * priorities.
     *
     * - If the supplied value is unspecified or 0, the service
     *   translates the value to 500,000, which corresponds to the
     *   `Normal` priority in the console.
     * - If the supplied value is negative, the intent is ignored
     *   in runtime detect intent requests.
     * </pre>
     *
     * <code>int32 priority = 5;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * The priority of this intent. Higher numbers represent higher
     * priorities.
     *
     * - If the supplied value is unspecified or 0, the service
     *   translates the value to 500,000, which corresponds to the
     *   `Normal` priority in the console.
     * - If the supplied value is negative, the intent is ignored
     *   in runtime detect intent requests.
     * </pre>
     *
     * <code>int32 priority = 5;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of this intent. Higher numbers represent higher
     * priorities.
     *
     * - If the supplied value is unspecified or 0, the service
     *   translates the value to 500,000, which corresponds to the
     *   `Normal` priority in the console.
     * - If the supplied value is negative, the intent is ignored
     *   in runtime detect intent requests.
     * </pre>
     *
     * <code>int32 priority = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000010);
      priority_ = 0;
      onChanged();
      return this;
    }

    private boolean isFallback_;
    /**
     *
     *
     * <pre>
     * Indicates whether this is a fallback intent. Currently only default
     * fallback intent is allowed in the agent, which is added upon agent
     * creation.
     * Adding training phrases to fallback intent is useful in the case of
     * requests that are mistakenly matched, since training phrases assigned to
     * fallback intents act as negative examples that triggers no-match event.
     * </pre>
     *
     * <code>bool is_fallback = 6;</code>
     *
     * @return The isFallback.
     */
    @java.lang.Override
    public boolean getIsFallback() {
      return isFallback_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this is a fallback intent. Currently only default
     * fallback intent is allowed in the agent, which is added upon agent
     * creation.
     * Adding training phrases to fallback intent is useful in the case of
     * requests that are mistakenly matched, since training phrases assigned to
     * fallback intents act as negative examples that triggers no-match event.
     * </pre>
     *
     * <code>bool is_fallback = 6;</code>
     *
     * @param value The isFallback to set.
     * @return This builder for chaining.
     */
    public Builder setIsFallback(boolean value) {

      isFallback_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether this is a fallback intent. Currently only default
     * fallback intent is allowed in the agent, which is added upon agent
     * creation.
     * Adding training phrases to fallback intent is useful in the case of
     * requests that are mistakenly matched, since training phrases assigned to
     * fallback intents act as negative examples that triggers no-match event.
     * </pre>
     *
     * <code>bool is_fallback = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsFallback() {
      bitField0_ = (bitField0_ & ~0x00000020);
      isFallback_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     *
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys-contextual" means the intent is a contextual intent.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     * </pre>
     *
     * <code>string description = 8;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Intent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Intent)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Intent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Intent();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Intent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Intent> PARSER =
      new com.google.protobuf.AbstractParser<Intent>() {
        @java.lang.Override
        public Intent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Intent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Intent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Intent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
