/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/intent.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [Intents.ImportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest}
 */
public final class ImportIntentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest)
    ImportIntentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportIntentsRequest.newBuilder() to construct.
  private ImportIntentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportIntentsRequest() {
    parent_ = "";
    mergeOption_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportIntentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportIntentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportIntentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.class,
            com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Merge option when display name conflicts exist during import.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption}
   */
  public enum MergeOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Should not be used.
     * </pre>
     *
     * <code>MERGE_OPTION_UNSPECIFIED = 0;</code>
     */
    MERGE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * DEPRECATED: Please use
     * [REPORT_CONFLICT][ImportIntentsRequest.REPORT_CONFLICT] instead.
     * Fail the request if there are intents whose display names conflict with
     * the display names of intents in the agent.
     * </pre>
     *
     * <code>REJECT = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    REJECT(1),
    /**
     *
     *
     * <pre>
     * Replace the original intent in the agent with the new intent when display
     * name conflicts exist.
     * </pre>
     *
     * <code>REPLACE = 2;</code>
     */
    REPLACE(2),
    /**
     *
     *
     * <pre>
     * Merge the original intent with the new intent when display name conflicts
     * exist.
     * </pre>
     *
     * <code>MERGE = 3;</code>
     */
    MERGE(3),
    /**
     *
     *
     * <pre>
     * Create new intents with new display names to differentiate them from the
     * existing intents when display name conflicts exist.
     * </pre>
     *
     * <code>RENAME = 4;</code>
     */
    RENAME(4),
    /**
     *
     *
     * <pre>
     * Report conflict information if display names conflict is detected.
     * Otherwise, import intents.
     * </pre>
     *
     * <code>REPORT_CONFLICT = 5;</code>
     */
    REPORT_CONFLICT(5),
    /**
     *
     *
     * <pre>
     * Keep the original intent and discard the conflicting new intent when
     * display name conflicts exist.
     * </pre>
     *
     * <code>KEEP = 6;</code>
     */
    KEEP(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Should not be used.
     * </pre>
     *
     * <code>MERGE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int MERGE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * DEPRECATED: Please use
     * [REPORT_CONFLICT][ImportIntentsRequest.REPORT_CONFLICT] instead.
     * Fail the request if there are intents whose display names conflict with
     * the display names of intents in the agent.
     * </pre>
     *
     * <code>REJECT = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int REJECT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Replace the original intent in the agent with the new intent when display
     * name conflicts exist.
     * </pre>
     *
     * <code>REPLACE = 2;</code>
     */
    public static final int REPLACE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Merge the original intent with the new intent when display name conflicts
     * exist.
     * </pre>
     *
     * <code>MERGE = 3;</code>
     */
    public static final int MERGE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Create new intents with new display names to differentiate them from the
     * existing intents when display name conflicts exist.
     * </pre>
     *
     * <code>RENAME = 4;</code>
     */
    public static final int RENAME_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Report conflict information if display names conflict is detected.
     * Otherwise, import intents.
     * </pre>
     *
     * <code>REPORT_CONFLICT = 5;</code>
     */
    public static final int REPORT_CONFLICT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Keep the original intent and discard the conflicting new intent when
     * display name conflicts exist.
     * </pre>
     *
     * <code>KEEP = 6;</code>
     */
    public static final int KEEP_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MergeOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MergeOption forNumber(int value) {
      switch (value) {
        case 0:
          return MERGE_OPTION_UNSPECIFIED;
        case 1:
          return REJECT;
        case 2:
          return REPLACE;
        case 3:
          return MERGE;
        case 4:
          return RENAME;
        case 5:
          return REPORT_CONFLICT;
        case 6:
          return KEEP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MergeOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MergeOption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MergeOption>() {
          public MergeOption findValueByNumber(int number) {
            return MergeOption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MergeOption[] VALUES = values();

    public static MergeOption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MergeOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption)
  }

  private int intentsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object intents_;

  public enum IntentsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTENTS_URI(2),
    INTENTS_CONTENT(3),
    INTENTS_NOT_SET(0);
    private final int value;

    private IntentsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IntentsCase valueOf(int value) {
      return forNumber(value);
    }

    public static IntentsCase forNumber(int value) {
      switch (value) {
        case 2:
          return INTENTS_URI;
        case 3:
          return INTENTS_CONTENT;
        case 0:
          return INTENTS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IntentsCase getIntentsCase() {
    return IntentsCase.forNumber(intentsCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The agent to import the intents into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The agent to import the intents into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENTS_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import intents from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string intents_uri = 2;</code>
   *
   * @return Whether the intentsUri field is set.
   */
  public boolean hasIntentsUri() {
    return intentsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import intents from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string intents_uri = 2;</code>
   *
   * @return The intentsUri.
   */
  public java.lang.String getIntentsUri() {
    java.lang.Object ref = "";
    if (intentsCase_ == 2) {
      ref = intents_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (intentsCase_ == 2) {
        intents_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import intents from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string intents_uri = 2;</code>
   *
   * @return The bytes for intentsUri.
   */
  public com.google.protobuf.ByteString getIntentsUriBytes() {
    java.lang.Object ref = "";
    if (intentsCase_ == 2) {
      ref = intents_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (intentsCase_ == 2) {
        intents_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENTS_CONTENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Uncompressed byte content of intents.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
   *
   * @return Whether the intentsContent field is set.
   */
  @java.lang.Override
  public boolean hasIntentsContent() {
    return intentsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Uncompressed byte content of intents.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
   *
   * @return The intentsContent.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.InlineSource getIntentsContent() {
    if (intentsCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Uncompressed byte content of intents.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder getIntentsContentOrBuilder() {
    if (intentsCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
  }

  public static final int MERGE_OPTION_FIELD_NUMBER = 4;
  private int mergeOption_ = 0;
  /**
   *
   *
   * <pre>
   * Merge option for importing intents. If not specified, `REJECT` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for mergeOption.
   */
  @java.lang.Override
  public int getMergeOptionValue() {
    return mergeOption_;
  }
  /**
   *
   *
   * <pre>
   * Merge option for importing intents. If not specified, `REJECT` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
   * </code>
   *
   * @return The mergeOption.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption getMergeOption() {
    com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption result =
        com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption.forNumber(
            mergeOption_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (intentsCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, intents_);
    }
    if (intentsCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_);
    }
    if (mergeOption_
        != com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption
            .MERGE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, mergeOption_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (intentsCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, intents_);
    }
    if (intentsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_);
    }
    if (mergeOption_
        != com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption
            .MERGE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, mergeOption_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest other =
        (com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (mergeOption_ != other.mergeOption_) return false;
    if (!getIntentsCase().equals(other.getIntentsCase())) return false;
    switch (intentsCase_) {
      case 2:
        if (!getIntentsUri().equals(other.getIntentsUri())) return false;
        break;
      case 3:
        if (!getIntentsContent().equals(other.getIntentsContent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + MERGE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + mergeOption_;
    switch (intentsCase_) {
      case 2:
        hash = (37 * hash) + INTENTS_URI_FIELD_NUMBER;
        hash = (53 * hash) + getIntentsUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + INTENTS_CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getIntentsContent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Intents.ImportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest)
      com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportIntentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportIntentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.class,
              com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (intentsContentBuilder_ != null) {
        intentsContentBuilder_.clear();
      }
      mergeOption_ = 0;
      intentsCase_ = 0;
      intents_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ImportIntentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest build() {
      com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest result =
          new com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mergeOption_ = mergeOption_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest result) {
      result.intentsCase_ = intentsCase_;
      result.intents_ = this.intents_;
      if (intentsCase_ == 3 && intentsContentBuilder_ != null) {
        result.intents_ = intentsContentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.mergeOption_ != 0) {
        setMergeOptionValue(other.getMergeOptionValue());
      }
      switch (other.getIntentsCase()) {
        case INTENTS_URI:
          {
            intentsCase_ = 2;
            intents_ = other.intents_;
            onChanged();
            break;
          }
        case INTENTS_CONTENT:
          {
            mergeIntentsContent(other.getIntentsContent());
            break;
          }
        case INTENTS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                intentsCase_ = 2;
                intents_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getIntentsContentFieldBuilder().getBuilder(), extensionRegistry);
                intentsCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                mergeOption_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int intentsCase_ = 0;
    private java.lang.Object intents_;

    public IntentsCase getIntentsCase() {
      return IntentsCase.forNumber(intentsCase_);
    }

    public Builder clearIntents() {
      intentsCase_ = 0;
      intents_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The agent to import the intents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the intents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the intents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the intents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the intents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import intents from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 2;</code>
     *
     * @return Whether the intentsUri field is set.
     */
    @java.lang.Override
    public boolean hasIntentsUri() {
      return intentsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import intents from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 2;</code>
     *
     * @return The intentsUri.
     */
    @java.lang.Override
    public java.lang.String getIntentsUri() {
      java.lang.Object ref = "";
      if (intentsCase_ == 2) {
        ref = intents_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (intentsCase_ == 2) {
          intents_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import intents from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 2;</code>
     *
     * @return The bytes for intentsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIntentsUriBytes() {
      java.lang.Object ref = "";
      if (intentsCase_ == 2) {
        ref = intents_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (intentsCase_ == 2) {
          intents_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import intents from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 2;</code>
     *
     * @param value The intentsUri to set.
     * @return This builder for chaining.
     */
    public Builder setIntentsUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      intentsCase_ = 2;
      intents_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import intents from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntentsUri() {
      if (intentsCase_ == 2) {
        intentsCase_ = 0;
        intents_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import intents from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 2;</code>
     *
     * @param value The bytes for intentsUri to set.
     * @return This builder for chaining.
     */
    public Builder setIntentsUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      intentsCase_ = 2;
      intents_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder>
        intentsContentBuilder_;
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     *
     * @return Whether the intentsContent field is set.
     */
    @java.lang.Override
    public boolean hasIntentsContent() {
      return intentsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     *
     * @return The intentsContent.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.InlineSource getIntentsContent() {
      if (intentsContentBuilder_ == null) {
        if (intentsCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
      } else {
        if (intentsCase_ == 3) {
          return intentsContentBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    public Builder setIntentsContent(com.google.cloud.dialogflow.cx.v3beta1.InlineSource value) {
      if (intentsContentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intents_ = value;
        onChanged();
      } else {
        intentsContentBuilder_.setMessage(value);
      }
      intentsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    public Builder setIntentsContent(
        com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder builderForValue) {
      if (intentsContentBuilder_ == null) {
        intents_ = builderForValue.build();
        onChanged();
      } else {
        intentsContentBuilder_.setMessage(builderForValue.build());
      }
      intentsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    public Builder mergeIntentsContent(com.google.cloud.dialogflow.cx.v3beta1.InlineSource value) {
      if (intentsContentBuilder_ == null) {
        if (intentsCase_ == 3
            && intents_
                != com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance()) {
          intents_ =
              com.google.cloud.dialogflow.cx.v3beta1.InlineSource.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          intents_ = value;
        }
        onChanged();
      } else {
        if (intentsCase_ == 3) {
          intentsContentBuilder_.mergeFrom(value);
        } else {
          intentsContentBuilder_.setMessage(value);
        }
      }
      intentsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    public Builder clearIntentsContent() {
      if (intentsContentBuilder_ == null) {
        if (intentsCase_ == 3) {
          intentsCase_ = 0;
          intents_ = null;
          onChanged();
        }
      } else {
        if (intentsCase_ == 3) {
          intentsCase_ = 0;
          intents_ = null;
        }
        intentsContentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder getIntentsContentBuilder() {
      return getIntentsContentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder
        getIntentsContentOrBuilder() {
      if ((intentsCase_ == 3) && (intentsContentBuilder_ != null)) {
        return intentsContentBuilder_.getMessageOrBuilder();
      } else {
        if (intentsCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uncompressed byte content of intents.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.InlineSource intents_content = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder>
        getIntentsContentFieldBuilder() {
      if (intentsContentBuilder_ == null) {
        if (!(intentsCase_ == 3)) {
          intents_ = com.google.cloud.dialogflow.cx.v3beta1.InlineSource.getDefaultInstance();
        }
        intentsContentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.InlineSource,
                com.google.cloud.dialogflow.cx.v3beta1.InlineSource.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.InlineSourceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.InlineSource) intents_,
                getParentForChildren(),
                isClean());
        intents_ = null;
      }
      intentsCase_ = 3;
      onChanged();
      return intentsContentBuilder_;
    }

    private int mergeOption_ = 0;
    /**
     *
     *
     * <pre>
     * Merge option for importing intents. If not specified, `REJECT` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for mergeOption.
     */
    @java.lang.Override
    public int getMergeOptionValue() {
      return mergeOption_;
    }
    /**
     *
     *
     * <pre>
     * Merge option for importing intents. If not specified, `REJECT` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for mergeOption to set.
     * @return This builder for chaining.
     */
    public Builder setMergeOptionValue(int value) {
      mergeOption_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Merge option for importing intents. If not specified, `REJECT` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
     * </code>
     *
     * @return The mergeOption.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption
        getMergeOption() {
      com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption result =
          com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption.forNumber(
              mergeOption_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Merge option for importing intents. If not specified, `REJECT` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
     * </code>
     *
     * @param value The mergeOption to set.
     * @return This builder for chaining.
     */
    public Builder setMergeOption(
        com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      mergeOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Merge option for importing intents. If not specified, `REJECT` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption merge_option = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMergeOption() {
      bitField0_ = (bitField0_ & ~0x00000008);
      mergeOption_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportIntentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportIntentsRequest>() {
        @java.lang.Override
        public ImportIntentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportIntentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportIntentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
