/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/flow.proto

package com.google.cloud.dialogflow.cx.v3beta1;

public interface ImportFlowRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ImportFlowRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The agent to import the flow into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The agent to import the flow into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import flow from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string flow_uri = 2;</code>
   *
   * @return Whether the flowUri field is set.
   */
  boolean hasFlowUri();
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import flow from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string flow_uri = 2;</code>
   *
   * @return The flowUri.
   */
  java.lang.String getFlowUri();
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import flow from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string flow_uri = 2;</code>
   *
   * @return The bytes for flowUri.
   */
  com.google.protobuf.ByteString getFlowUriBytes();

  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for flow.
   * </pre>
   *
   * <code>bytes flow_content = 3;</code>
   *
   * @return Whether the flowContent field is set.
   */
  boolean hasFlowContent();
  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for flow.
   * </pre>
   *
   * <code>bytes flow_content = 3;</code>
   *
   * @return The flowContent.
   */
  com.google.protobuf.ByteString getFlowContent();

  /**
   *
   *
   * <pre>
   * Flow import mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ImportFlowRequest.ImportOption import_option = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for importOption.
   */
  int getImportOptionValue();
  /**
   *
   *
   * <pre>
   * Flow import mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ImportFlowRequest.ImportOption import_option = 4;
   * </code>
   *
   * @return The importOption.
   */
  com.google.cloud.dialogflow.cx.v3beta1.ImportFlowRequest.ImportOption getImportOption();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the import strategy used when resolving resource
   * conflicts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.FlowImportStrategy flow_import_strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the flowImportStrategy field is set.
   */
  boolean hasFlowImportStrategy();
  /**
   *
   *
   * <pre>
   * Optional. Specifies the import strategy used when resolving resource
   * conflicts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.FlowImportStrategy flow_import_strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The flowImportStrategy.
   */
  com.google.cloud.dialogflow.cx.v3beta1.FlowImportStrategy getFlowImportStrategy();
  /**
   *
   *
   * <pre>
   * Optional. Specifies the import strategy used when resolving resource
   * conflicts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.FlowImportStrategy flow_import_strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.cx.v3beta1.FlowImportStrategyOrBuilder
      getFlowImportStrategyOrBuilder();

  com.google.cloud.dialogflow.cx.v3beta1.ImportFlowRequest.FlowCase getFlowCase();
}
