/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/flow.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Flows represents the conversation flows when you build your chatbot agent.
 *
 * A flow consists of many pages connected by the transition routes.
 * Conversations always start with the built-in Start Flow (with an all-0 ID).
 * Transition routes can direct the conversation session from the current flow
 * (parent flow) to another flow (sub flow). When the sub flow is finished,
 * Dialogflow will bring the session back to the parent flow, where the sub flow
 * is started.
 *
 * Usually, when a transition route is followed by a matched intent, the intent
 * will be "consumed". This means the intent won't activate more transition
 * routes. However, when the followed transition route moves the conversation
 * session into a different flow, the matched intent can be carried over and to
 * be consumed in the target flow.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Flow}
 */
public final class Flow extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Flow)
    FlowOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Flow.newBuilder() to construct.
  private Flow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Flow() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    transitionRoutes_ = java.util.Collections.emptyList();
    eventHandlers_ = java.util.Collections.emptyList();
    transitionRouteGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Flow();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.FlowProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Flow_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.FlowProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Flow_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Flow.class,
            com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the flow.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the flow.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the flow.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the flow.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the flow. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the flow. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSITION_ROUTES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute> transitionRoutes_;
  /**
   *
   *
   * <pre>
   * A flow's transition routes serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * routes][Page.transition_routes] and can support use cases such as the user
   * saying "help" or "can I talk to a human?", which can be handled in a common
   * way regardless of the current page. Transition routes defined in the page
   * have higher priority than those defined in the flow.
   *
   * TransitionRoutes are evalauted in the following order:
   *
   * *   TransitionRoutes with intent specified.
   * *   TransitionRoutes with only condition specified.
   *
   * TransitionRoutes with intent specified are inherited by pages in the flow.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute>
      getTransitionRoutesList() {
    return transitionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * A flow's transition routes serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * routes][Page.transition_routes] and can support use cases such as the user
   * saying "help" or "can I talk to a human?", which can be handled in a common
   * way regardless of the current page. Transition routes defined in the page
   * have higher priority than those defined in the flow.
   *
   * TransitionRoutes are evalauted in the following order:
   *
   * *   TransitionRoutes with intent specified.
   * *   TransitionRoutes with only condition specified.
   *
   * TransitionRoutes with intent specified are inherited by pages in the flow.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>
      getTransitionRoutesOrBuilderList() {
    return transitionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * A flow's transition routes serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * routes][Page.transition_routes] and can support use cases such as the user
   * saying "help" or "can I talk to a human?", which can be handled in a common
   * way regardless of the current page. Transition routes defined in the page
   * have higher priority than those defined in the flow.
   *
   * TransitionRoutes are evalauted in the following order:
   *
   * *   TransitionRoutes with intent specified.
   * *   TransitionRoutes with only condition specified.
   *
   * TransitionRoutes with intent specified are inherited by pages in the flow.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
   * </code>
   */
  @java.lang.Override
  public int getTransitionRoutesCount() {
    return transitionRoutes_.size();
  }
  /**
   *
   *
   * <pre>
   * A flow's transition routes serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * routes][Page.transition_routes] and can support use cases such as the user
   * saying "help" or "can I talk to a human?", which can be handled in a common
   * way regardless of the current page. Transition routes defined in the page
   * have higher priority than those defined in the flow.
   *
   * TransitionRoutes are evalauted in the following order:
   *
   * *   TransitionRoutes with intent specified.
   * *   TransitionRoutes with only condition specified.
   *
   * TransitionRoutes with intent specified are inherited by pages in the flow.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute getTransitionRoutes(int index) {
    return transitionRoutes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A flow's transition routes serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * routes][Page.transition_routes] and can support use cases such as the user
   * saying "help" or "can I talk to a human?", which can be handled in a common
   * way regardless of the current page. Transition routes defined in the page
   * have higher priority than those defined in the flow.
   *
   * TransitionRoutes are evalauted in the following order:
   *
   * *   TransitionRoutes with intent specified.
   * *   TransitionRoutes with only condition specified.
   *
   * TransitionRoutes with intent specified are inherited by pages in the flow.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder
      getTransitionRoutesOrBuilder(int index) {
    return transitionRoutes_.get(index);
  }

  public static final int EVENT_HANDLERS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler> eventHandlers_;
  /**
   *
   *
   * <pre>
   * A flow's event handlers serve two purposes:
   *
   * *   They are responsible for handling events (e.g. no match,
   * webhook errors) in the flow.
   * *   They are inherited by every page's [event
   * handlers][Page.event_handlers], which can be used to handle common events
   * regardless of the current page. Event handlers defined in the page
   * have higher priority than those defined in the flow.
   *
   * Unlike
   * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
   * these handlers are evaluated on a first-match basis. The first one that
   * matches the event get executed, with the rest being ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
      getEventHandlersList() {
    return eventHandlers_;
  }
  /**
   *
   *
   * <pre>
   * A flow's event handlers serve two purposes:
   *
   * *   They are responsible for handling events (e.g. no match,
   * webhook errors) in the flow.
   * *   They are inherited by every page's [event
   * handlers][Page.event_handlers], which can be used to handle common events
   * regardless of the current page. Event handlers defined in the page
   * have higher priority than those defined in the flow.
   *
   * Unlike
   * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
   * these handlers are evaluated on a first-match basis. The first one that
   * matches the event get executed, with the rest being ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
      getEventHandlersOrBuilderList() {
    return eventHandlers_;
  }
  /**
   *
   *
   * <pre>
   * A flow's event handlers serve two purposes:
   *
   * *   They are responsible for handling events (e.g. no match,
   * webhook errors) in the flow.
   * *   They are inherited by every page's [event
   * handlers][Page.event_handlers], which can be used to handle common events
   * regardless of the current page. Event handlers defined in the page
   * have higher priority than those defined in the flow.
   *
   * Unlike
   * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
   * these handlers are evaluated on a first-match basis. The first one that
   * matches the event get executed, with the rest being ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public int getEventHandlersCount() {
    return eventHandlers_.size();
  }
  /**
   *
   *
   * <pre>
   * A flow's event handlers serve two purposes:
   *
   * *   They are responsible for handling events (e.g. no match,
   * webhook errors) in the flow.
   * *   They are inherited by every page's [event
   * handlers][Page.event_handlers], which can be used to handle common events
   * regardless of the current page. Event handlers defined in the page
   * have higher priority than those defined in the flow.
   *
   * Unlike
   * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
   * these handlers are evaluated on a first-match basis. The first one that
   * matches the event get executed, with the rest being ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.EventHandler getEventHandlers(int index) {
    return eventHandlers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A flow's event handlers serve two purposes:
   *
   * *   They are responsible for handling events (e.g. no match,
   * webhook errors) in the flow.
   * *   They are inherited by every page's [event
   * handlers][Page.event_handlers], which can be used to handle common events
   * regardless of the current page. Event handlers defined in the page
   * have higher priority than those defined in the flow.
   *
   * Unlike
   * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
   * these handlers are evaluated on a first-match basis. The first one that
   * matches the event get executed, with the rest being ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder getEventHandlersOrBuilder(
      int index) {
    return eventHandlers_.get(index);
  }

  public static final int TRANSITION_ROUTE_GROUPS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList transitionRouteGroups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A flow's transition route group serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * route groups][Page.transition_route_groups]. Transition route groups
   * defined in the page have higher priority than those defined in the flow.
   *
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
   * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
   * groups.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the transitionRouteGroups.
   */
  public com.google.protobuf.ProtocolStringList getTransitionRouteGroupsList() {
    return transitionRouteGroups_;
  }
  /**
   *
   *
   * <pre>
   * A flow's transition route group serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * route groups][Page.transition_route_groups]. Transition route groups
   * defined in the page have higher priority than those defined in the flow.
   *
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
   * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
   * groups.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of transitionRouteGroups.
   */
  public int getTransitionRouteGroupsCount() {
    return transitionRouteGroups_.size();
  }
  /**
   *
   *
   * <pre>
   * A flow's transition route group serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * route groups][Page.transition_route_groups]. Transition route groups
   * defined in the page have higher priority than those defined in the flow.
   *
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
   * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
   * groups.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The transitionRouteGroups at the given index.
   */
  public java.lang.String getTransitionRouteGroups(int index) {
    return transitionRouteGroups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A flow's transition route group serve two purposes:
   *
   * *   They are responsible for matching the user's first utterances in the
   * flow.
   * *   They are inherited by every page's [transition
   * route groups][Page.transition_route_groups]. Transition route groups
   * defined in the page have higher priority than those defined in the flow.
   *
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
   * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
   * groups.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the transitionRouteGroups at the given index.
   */
  public com.google.protobuf.ByteString getTransitionRouteGroupsBytes(int index) {
    return transitionRouteGroups_.getByteString(index);
  }

  public static final int NLU_SETTINGS_FIELD_NUMBER = 11;
  private com.google.cloud.dialogflow.cx.v3beta1.NluSettings nluSettings_;
  /**
   *
   *
   * <pre>
   * NLU related settings of the flow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
   *
   * @return Whether the nluSettings field is set.
   */
  @java.lang.Override
  public boolean hasNluSettings() {
    return nluSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * NLU related settings of the flow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
   *
   * @return The nluSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.NluSettings getNluSettings() {
    return nluSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.NluSettings.getDefaultInstance()
        : nluSettings_;
  }
  /**
   *
   *
   * <pre>
   * NLU related settings of the flow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.NluSettingsOrBuilder getNluSettingsOrBuilder() {
    return nluSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.NluSettings.getDefaultInstance()
        : nluSettings_;
  }

  public static final int ADVANCED_SETTINGS_FIELD_NUMBER = 14;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advancedSettings_;
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this flow. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
   *
   * @return Whether the advancedSettings field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedSettings() {
    return advancedSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this flow. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
   *
   * @return The advancedSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getAdvancedSettings() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this flow. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder
      getAdvancedSettingsOrBuilder() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }

  public static final int KNOWLEDGE_CONNECTOR_SETTINGS_FIELD_NUMBER = 18;
  private com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      knowledgeConnectorSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Knowledge connector configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the knowledgeConnectorSettings field is set.
   */
  @java.lang.Override
  public boolean hasKnowledgeConnectorSettings() {
    return knowledgeConnectorSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Knowledge connector configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The knowledgeConnectorSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
      getKnowledgeConnectorSettings() {
    return knowledgeConnectorSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.getDefaultInstance()
        : knowledgeConnectorSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Knowledge connector configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettingsOrBuilder
      getKnowledgeConnectorSettingsOrBuilder() {
    return knowledgeConnectorSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.getDefaultInstance()
        : knowledgeConnectorSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < transitionRoutes_.size(); i++) {
      output.writeMessage(4, transitionRoutes_.get(i));
    }
    for (int i = 0; i < eventHandlers_.size(); i++) {
      output.writeMessage(10, eventHandlers_.get(i));
    }
    if (nluSettings_ != null) {
      output.writeMessage(11, getNluSettings());
    }
    if (advancedSettings_ != null) {
      output.writeMessage(14, getAdvancedSettings());
    }
    for (int i = 0; i < transitionRouteGroups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 15, transitionRouteGroups_.getRaw(i));
    }
    if (knowledgeConnectorSettings_ != null) {
      output.writeMessage(18, getKnowledgeConnectorSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < transitionRoutes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, transitionRoutes_.get(i));
    }
    for (int i = 0; i < eventHandlers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, eventHandlers_.get(i));
    }
    if (nluSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getNluSettings());
    }
    if (advancedSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getAdvancedSettings());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < transitionRouteGroups_.size(); i++) {
        dataSize += computeStringSizeNoTag(transitionRouteGroups_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTransitionRouteGroupsList().size();
    }
    if (knowledgeConnectorSettings_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getKnowledgeConnectorSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Flow)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Flow other =
        (com.google.cloud.dialogflow.cx.v3beta1.Flow) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getTransitionRoutesList().equals(other.getTransitionRoutesList())) return false;
    if (!getEventHandlersList().equals(other.getEventHandlersList())) return false;
    if (!getTransitionRouteGroupsList().equals(other.getTransitionRouteGroupsList())) return false;
    if (hasNluSettings() != other.hasNluSettings()) return false;
    if (hasNluSettings()) {
      if (!getNluSettings().equals(other.getNluSettings())) return false;
    }
    if (hasAdvancedSettings() != other.hasAdvancedSettings()) return false;
    if (hasAdvancedSettings()) {
      if (!getAdvancedSettings().equals(other.getAdvancedSettings())) return false;
    }
    if (hasKnowledgeConnectorSettings() != other.hasKnowledgeConnectorSettings()) return false;
    if (hasKnowledgeConnectorSettings()) {
      if (!getKnowledgeConnectorSettings().equals(other.getKnowledgeConnectorSettings()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getTransitionRoutesCount() > 0) {
      hash = (37 * hash) + TRANSITION_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionRoutesList().hashCode();
    }
    if (getEventHandlersCount() > 0) {
      hash = (37 * hash) + EVENT_HANDLERS_FIELD_NUMBER;
      hash = (53 * hash) + getEventHandlersList().hashCode();
    }
    if (getTransitionRouteGroupsCount() > 0) {
      hash = (37 * hash) + TRANSITION_ROUTE_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionRouteGroupsList().hashCode();
    }
    if (hasNluSettings()) {
      hash = (37 * hash) + NLU_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getNluSettings().hashCode();
    }
    if (hasAdvancedSettings()) {
      hash = (37 * hash) + ADVANCED_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedSettings().hashCode();
    }
    if (hasKnowledgeConnectorSettings()) {
      hash = (37 * hash) + KNOWLEDGE_CONNECTOR_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getKnowledgeConnectorSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Flow prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Flows represents the conversation flows when you build your chatbot agent.
   *
   * A flow consists of many pages connected by the transition routes.
   * Conversations always start with the built-in Start Flow (with an all-0 ID).
   * Transition routes can direct the conversation session from the current flow
   * (parent flow) to another flow (sub flow). When the sub flow is finished,
   * Dialogflow will bring the session back to the parent flow, where the sub flow
   * is started.
   *
   * Usually, when a transition route is followed by a matched intent, the intent
   * will be "consumed". This means the intent won't activate more transition
   * routes. However, when the followed transition route moves the conversation
   * session into a different flow, the matched intent can be carried over and to
   * be consumed in the target flow.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Flow}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Flow)
      com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.FlowProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Flow_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.FlowProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Flow_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Flow.class,
              com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Flow.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (transitionRoutesBuilder_ == null) {
        transitionRoutes_ = java.util.Collections.emptyList();
      } else {
        transitionRoutes_ = null;
        transitionRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (eventHandlersBuilder_ == null) {
        eventHandlers_ = java.util.Collections.emptyList();
      } else {
        eventHandlers_ = null;
        eventHandlersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      transitionRouteGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nluSettings_ = null;
      if (nluSettingsBuilder_ != null) {
        nluSettingsBuilder_.dispose();
        nluSettingsBuilder_ = null;
      }
      advancedSettings_ = null;
      if (advancedSettingsBuilder_ != null) {
        advancedSettingsBuilder_.dispose();
        advancedSettingsBuilder_ = null;
      }
      knowledgeConnectorSettings_ = null;
      if (knowledgeConnectorSettingsBuilder_ != null) {
        knowledgeConnectorSettingsBuilder_.dispose();
        knowledgeConnectorSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.FlowProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Flow_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Flow getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Flow.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Flow build() {
      com.google.cloud.dialogflow.cx.v3beta1.Flow result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Flow buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Flow result =
          new com.google.cloud.dialogflow.cx.v3beta1.Flow(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.cx.v3beta1.Flow result) {
      if (transitionRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          transitionRoutes_ = java.util.Collections.unmodifiableList(transitionRoutes_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.transitionRoutes_ = transitionRoutes_;
      } else {
        result.transitionRoutes_ = transitionRoutesBuilder_.build();
      }
      if (eventHandlersBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          eventHandlers_ = java.util.Collections.unmodifiableList(eventHandlers_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.eventHandlers_ = eventHandlers_;
      } else {
        result.eventHandlers_ = eventHandlersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Flow result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        transitionRouteGroups_.makeImmutable();
        result.transitionRouteGroups_ = transitionRouteGroups_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.nluSettings_ =
            nluSettingsBuilder_ == null ? nluSettings_ : nluSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.advancedSettings_ =
            advancedSettingsBuilder_ == null ? advancedSettings_ : advancedSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.knowledgeConnectorSettings_ =
            knowledgeConnectorSettingsBuilder_ == null
                ? knowledgeConnectorSettings_
                : knowledgeConnectorSettingsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Flow) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Flow) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Flow other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Flow.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (transitionRoutesBuilder_ == null) {
        if (!other.transitionRoutes_.isEmpty()) {
          if (transitionRoutes_.isEmpty()) {
            transitionRoutes_ = other.transitionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTransitionRoutesIsMutable();
            transitionRoutes_.addAll(other.transitionRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.transitionRoutes_.isEmpty()) {
          if (transitionRoutesBuilder_.isEmpty()) {
            transitionRoutesBuilder_.dispose();
            transitionRoutesBuilder_ = null;
            transitionRoutes_ = other.transitionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000008);
            transitionRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransitionRoutesFieldBuilder()
                    : null;
          } else {
            transitionRoutesBuilder_.addAllMessages(other.transitionRoutes_);
          }
        }
      }
      if (eventHandlersBuilder_ == null) {
        if (!other.eventHandlers_.isEmpty()) {
          if (eventHandlers_.isEmpty()) {
            eventHandlers_ = other.eventHandlers_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureEventHandlersIsMutable();
            eventHandlers_.addAll(other.eventHandlers_);
          }
          onChanged();
        }
      } else {
        if (!other.eventHandlers_.isEmpty()) {
          if (eventHandlersBuilder_.isEmpty()) {
            eventHandlersBuilder_.dispose();
            eventHandlersBuilder_ = null;
            eventHandlers_ = other.eventHandlers_;
            bitField0_ = (bitField0_ & ~0x00000010);
            eventHandlersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEventHandlersFieldBuilder()
                    : null;
          } else {
            eventHandlersBuilder_.addAllMessages(other.eventHandlers_);
          }
        }
      }
      if (!other.transitionRouteGroups_.isEmpty()) {
        if (transitionRouteGroups_.isEmpty()) {
          transitionRouteGroups_ = other.transitionRouteGroups_;
          bitField0_ |= 0x00000020;
        } else {
          ensureTransitionRouteGroupsIsMutable();
          transitionRouteGroups_.addAll(other.transitionRouteGroups_);
        }
        onChanged();
      }
      if (other.hasNluSettings()) {
        mergeNluSettings(other.getNluSettings());
      }
      if (other.hasAdvancedSettings()) {
        mergeAdvancedSettings(other.getAdvancedSettings());
      }
      if (other.hasKnowledgeConnectorSettings()) {
        mergeKnowledgeConnectorSettings(other.getKnowledgeConnectorSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.parser(),
                        extensionRegistry);
                if (transitionRoutesBuilder_ == null) {
                  ensureTransitionRoutesIsMutable();
                  transitionRoutes_.add(m);
                } else {
                  transitionRoutesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 82:
              {
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.EventHandler.parser(),
                        extensionRegistry);
                if (eventHandlersBuilder_ == null) {
                  ensureEventHandlersIsMutable();
                  eventHandlers_.add(m);
                } else {
                  eventHandlersBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getNluSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            case 114:
              {
                input.readMessage(
                    getAdvancedSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTransitionRouteGroupsIsMutable();
                transitionRouteGroups_.add(s);
                break;
              } // case 122
            case 146:
              {
                input.readMessage(
                    getKnowledgeConnectorSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the flow.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the flow.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the flow.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the flow.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the flow.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the flow. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute>
        transitionRoutes_ = java.util.Collections.emptyList();

    private void ensureTransitionRoutesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        transitionRoutes_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute>(
                transitionRoutes_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>
        transitionRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute>
        getTransitionRoutesList() {
      if (transitionRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transitionRoutes_);
      } else {
        return transitionRoutesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public int getTransitionRoutesCount() {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.size();
      } else {
        return transitionRoutesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute getTransitionRoutes(int index) {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.get(index);
      } else {
        return transitionRoutesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder setTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.set(index, value);
        onChanged();
      } else {
        transitionRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder setTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder addTransitionRoutes(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(value);
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder addTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(index, value);
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder addTransitionRoutes(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder addTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder addAllTransitionRoutes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute>
            values) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitionRoutes_);
        onChanged();
      } else {
        transitionRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder clearTransitionRoutes() {
      if (transitionRoutesBuilder_ == null) {
        transitionRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        transitionRoutesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public Builder removeTransitionRoutes(int index) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.remove(index);
        onChanged();
      } else {
        transitionRoutesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder
        getTransitionRoutesBuilder(int index) {
      return getTransitionRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder
        getTransitionRoutesOrBuilder(int index) {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.get(index);
      } else {
        return transitionRoutesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>
        getTransitionRoutesOrBuilderList() {
      if (transitionRoutesBuilder_ != null) {
        return transitionRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transitionRoutes_);
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder
        addTransitionRoutesBuilder() {
      return getTransitionRoutesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder
        addTransitionRoutesBuilder(int index) {
      return getTransitionRoutesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A flow's transition routes serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * routes][Page.transition_routes] and can support use cases such as the user
     * saying "help" or "can I talk to a human?", which can be handled in a common
     * way regardless of the current page. Transition routes defined in the page
     * have higher priority than those defined in the flow.
     *
     * TransitionRoutes are evalauted in the following order:
     *
     * *   TransitionRoutes with intent specified.
     * *   TransitionRoutes with only condition specified.
     *
     * TransitionRoutes with intent specified are inherited by pages in the flow.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_routes = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder>
        getTransitionRoutesBuilderList() {
      return getTransitionRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>
        getTransitionRoutesFieldBuilder() {
      if (transitionRoutesBuilder_ == null) {
        transitionRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>(
                transitionRoutes_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        transitionRoutes_ = null;
      }
      return transitionRoutesBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler> eventHandlers_ =
        java.util.Collections.emptyList();

    private void ensureEventHandlersIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        eventHandlers_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>(
                eventHandlers_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler,
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
        eventHandlersBuilder_;

    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler>
        getEventHandlersList() {
      if (eventHandlersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(eventHandlers_);
      } else {
        return eventHandlersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public int getEventHandlersCount() {
      if (eventHandlersBuilder_ == null) {
        return eventHandlers_.size();
      } else {
        return eventHandlersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.EventHandler getEventHandlers(int index) {
      if (eventHandlersBuilder_ == null) {
        return eventHandlers_.get(index);
      } else {
        return eventHandlersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder setEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler value) {
      if (eventHandlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventHandlersIsMutable();
        eventHandlers_.set(index, value);
        onChanged();
      } else {
        eventHandlersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder setEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder builderForValue) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.set(index, builderForValue.build());
        onChanged();
      } else {
        eventHandlersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(com.google.cloud.dialogflow.cx.v3beta1.EventHandler value) {
      if (eventHandlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventHandlersIsMutable();
        eventHandlers_.add(value);
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler value) {
      if (eventHandlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventHandlersIsMutable();
        eventHandlers_.add(index, value);
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(
        com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder builderForValue) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.add(builderForValue.build());
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder builderForValue) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.add(index, builderForValue.build());
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder addAllEventHandlers(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandler> values) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, eventHandlers_);
        onChanged();
      } else {
        eventHandlersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder clearEventHandlers() {
      if (eventHandlersBuilder_ == null) {
        eventHandlers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        eventHandlersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public Builder removeEventHandlers(int index) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.remove(index);
        onChanged();
      } else {
        eventHandlersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder getEventHandlersBuilder(
        int index) {
      return getEventHandlersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder getEventHandlersOrBuilder(
        int index) {
      if (eventHandlersBuilder_ == null) {
        return eventHandlers_.get(index);
      } else {
        return eventHandlersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
        getEventHandlersOrBuilderList() {
      if (eventHandlersBuilder_ != null) {
        return eventHandlersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(eventHandlers_);
      }
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder addEventHandlersBuilder() {
      return getEventHandlersFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.EventHandler.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder addEventHandlersBuilder(
        int index) {
      return getEventHandlersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3beta1.EventHandler.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A flow's event handlers serve two purposes:
     *
     * *   They are responsible for handling events (e.g. no match,
     * webhook errors) in the flow.
     * *   They are inherited by every page's [event
     * handlers][Page.event_handlers], which can be used to handle common events
     * regardless of the current page. Event handlers defined in the page
     * have higher priority than those defined in the flow.
     *
     * Unlike
     * [transition_routes][google.cloud.dialogflow.cx.v3beta1.Flow.transition_routes],
     * these handlers are evaluated on a first-match basis. The first one that
     * matches the event get executed, with the rest being ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.EventHandler event_handlers = 10;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder>
        getEventHandlersBuilderList() {
      return getEventHandlersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler,
            com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>
        getEventHandlersFieldBuilder() {
      if (eventHandlersBuilder_ == null) {
        eventHandlersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler,
                com.google.cloud.dialogflow.cx.v3beta1.EventHandler.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.EventHandlerOrBuilder>(
                eventHandlers_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        eventHandlers_ = null;
      }
      return eventHandlersBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList transitionRouteGroups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTransitionRouteGroupsIsMutable() {
      if (!transitionRouteGroups_.isModifiable()) {
        transitionRouteGroups_ =
            new com.google.protobuf.LazyStringArrayList(transitionRouteGroups_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the transitionRouteGroups.
     */
    public com.google.protobuf.ProtocolStringList getTransitionRouteGroupsList() {
      transitionRouteGroups_.makeImmutable();
      return transitionRouteGroups_;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of transitionRouteGroups.
     */
    public int getTransitionRouteGroupsCount() {
      return transitionRouteGroups_.size();
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The transitionRouteGroups at the given index.
     */
    public java.lang.String getTransitionRouteGroups(int index) {
      return transitionRouteGroups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the transitionRouteGroups at the given index.
     */
    public com.google.protobuf.ByteString getTransitionRouteGroupsBytes(int index) {
      return transitionRouteGroups_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The transitionRouteGroups to set.
     * @return This builder for chaining.
     */
    public Builder setTransitionRouteGroups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTransitionRouteGroupsIsMutable();
      transitionRouteGroups_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The transitionRouteGroups to add.
     * @return This builder for chaining.
     */
    public Builder addTransitionRouteGroups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTransitionRouteGroupsIsMutable();
      transitionRouteGroups_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The transitionRouteGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAllTransitionRouteGroups(java.lang.Iterable<java.lang.String> values) {
      ensureTransitionRouteGroupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitionRouteGroups_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransitionRouteGroups() {
      transitionRouteGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flow's transition route group serve two purposes:
     *
     * *   They are responsible for matching the user's first utterances in the
     * flow.
     * *   They are inherited by every page's [transition
     * route groups][Page.transition_route_groups]. Transition route groups
     * defined in the page have higher priority than those defined in the flow.
     *
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`
     * or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;` for agent-level
     * groups.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 15 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the transitionRouteGroups to add.
     * @return This builder for chaining.
     */
    public Builder addTransitionRouteGroupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTransitionRouteGroupsIsMutable();
      transitionRouteGroups_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.NluSettings nluSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.NluSettings,
            com.google.cloud.dialogflow.cx.v3beta1.NluSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.NluSettingsOrBuilder>
        nluSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     *
     * @return Whether the nluSettings field is set.
     */
    public boolean hasNluSettings() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     *
     * @return The nluSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.NluSettings getNluSettings() {
      if (nluSettingsBuilder_ == null) {
        return nluSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.NluSettings.getDefaultInstance()
            : nluSettings_;
      } else {
        return nluSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    public Builder setNluSettings(com.google.cloud.dialogflow.cx.v3beta1.NluSettings value) {
      if (nluSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nluSettings_ = value;
      } else {
        nluSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    public Builder setNluSettings(
        com.google.cloud.dialogflow.cx.v3beta1.NluSettings.Builder builderForValue) {
      if (nluSettingsBuilder_ == null) {
        nluSettings_ = builderForValue.build();
      } else {
        nluSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    public Builder mergeNluSettings(com.google.cloud.dialogflow.cx.v3beta1.NluSettings value) {
      if (nluSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && nluSettings_ != null
            && nluSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.NluSettings.getDefaultInstance()) {
          getNluSettingsBuilder().mergeFrom(value);
        } else {
          nluSettings_ = value;
        }
      } else {
        nluSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    public Builder clearNluSettings() {
      bitField0_ = (bitField0_ & ~0x00000040);
      nluSettings_ = null;
      if (nluSettingsBuilder_ != null) {
        nluSettingsBuilder_.dispose();
        nluSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.NluSettings.Builder getNluSettingsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getNluSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.NluSettingsOrBuilder getNluSettingsOrBuilder() {
      if (nluSettingsBuilder_ != null) {
        return nluSettingsBuilder_.getMessageOrBuilder();
      } else {
        return nluSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.NluSettings.getDefaultInstance()
            : nluSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * NLU related settings of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.NluSettings nlu_settings = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.NluSettings,
            com.google.cloud.dialogflow.cx.v3beta1.NluSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.NluSettingsOrBuilder>
        getNluSettingsFieldBuilder() {
      if (nluSettingsBuilder_ == null) {
        nluSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.NluSettings,
                com.google.cloud.dialogflow.cx.v3beta1.NluSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.NluSettingsOrBuilder>(
                getNluSettings(), getParentForChildren(), isClean());
        nluSettings_ = null;
      }
      return nluSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advancedSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder>
        advancedSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     *
     * @return Whether the advancedSettings field is set.
     */
    public boolean hasAdvancedSettings() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     *
     * @return The advancedSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getAdvancedSettings() {
      if (advancedSettingsBuilder_ == null) {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      } else {
        return advancedSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    public Builder setAdvancedSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedSettings_ = value;
      } else {
        advancedSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    public Builder setAdvancedSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder builderForValue) {
      if (advancedSettingsBuilder_ == null) {
        advancedSettings_ = builderForValue.build();
      } else {
        advancedSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    public Builder mergeAdvancedSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && advancedSettings_ != null
            && advancedSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()) {
          getAdvancedSettingsBuilder().mergeFrom(value);
        } else {
          advancedSettings_ = value;
        }
      } else {
        advancedSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    public Builder clearAdvancedSettings() {
      bitField0_ = (bitField0_ & ~0x00000080);
      advancedSettings_ = null;
      if (advancedSettingsBuilder_ != null) {
        advancedSettingsBuilder_.dispose();
        advancedSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder
        getAdvancedSettingsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getAdvancedSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder
        getAdvancedSettingsOrBuilder() {
      if (advancedSettingsBuilder_ != null) {
        return advancedSettingsBuilder_.getMessageOrBuilder();
      } else {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this flow. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings advanced_settings = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder>
        getAdvancedSettingsFieldBuilder() {
      if (advancedSettingsBuilder_ == null) {
        advancedSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder>(
                getAdvancedSettings(), getParentForChildren(), isClean());
        advancedSettings_ = null;
      }
      return advancedSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
        knowledgeConnectorSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings,
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettingsOrBuilder>
        knowledgeConnectorSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the knowledgeConnectorSettings field is set.
     */
    public boolean hasKnowledgeConnectorSettings() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The knowledgeConnectorSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
        getKnowledgeConnectorSettings() {
      if (knowledgeConnectorSettingsBuilder_ == null) {
        return knowledgeConnectorSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.getDefaultInstance()
            : knowledgeConnectorSettings_;
      } else {
        return knowledgeConnectorSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKnowledgeConnectorSettings(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings value) {
      if (knowledgeConnectorSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        knowledgeConnectorSettings_ = value;
      } else {
        knowledgeConnectorSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKnowledgeConnectorSettings(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder builderForValue) {
      if (knowledgeConnectorSettingsBuilder_ == null) {
        knowledgeConnectorSettings_ = builderForValue.build();
      } else {
        knowledgeConnectorSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeKnowledgeConnectorSettings(
        com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings value) {
      if (knowledgeConnectorSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && knowledgeConnectorSettings_ != null
            && knowledgeConnectorSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
                    .getDefaultInstance()) {
          getKnowledgeConnectorSettingsBuilder().mergeFrom(value);
        } else {
          knowledgeConnectorSettings_ = value;
        }
      } else {
        knowledgeConnectorSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearKnowledgeConnectorSettings() {
      bitField0_ = (bitField0_ & ~0x00000100);
      knowledgeConnectorSettings_ = null;
      if (knowledgeConnectorSettingsBuilder_ != null) {
        knowledgeConnectorSettingsBuilder_.dispose();
        knowledgeConnectorSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder
        getKnowledgeConnectorSettingsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getKnowledgeConnectorSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettingsOrBuilder
        getKnowledgeConnectorSettingsOrBuilder() {
      if (knowledgeConnectorSettingsBuilder_ != null) {
        return knowledgeConnectorSettingsBuilder_.getMessageOrBuilder();
      } else {
        return knowledgeConnectorSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.getDefaultInstance()
            : knowledgeConnectorSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Knowledge connector configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings knowledge_connector_settings = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings,
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettingsOrBuilder>
        getKnowledgeConnectorSettingsFieldBuilder() {
      if (knowledgeConnectorSettingsBuilder_ == null) {
        knowledgeConnectorSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings,
                com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettingsOrBuilder>(
                getKnowledgeConnectorSettings(), getParentForChildren(), isClean());
        knowledgeConnectorSettings_ = null;
      }
      return knowledgeConnectorSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Flow)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Flow)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Flow DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Flow();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Flow getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Flow> PARSER =
      new com.google.protobuf.AbstractParser<Flow>() {
        @java.lang.Override
        public Flow parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Flow> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Flow> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Flow getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
