/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/data_store_connection.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * A data store connection. It represents a data store in Discovery Engine and
 * the type of the contents it contains.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.DataStoreConnection}
 */
public final class DataStoreConnection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.DataStoreConnection)
    DataStoreConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataStoreConnection.newBuilder() to construct.
  private DataStoreConnection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataStoreConnection() {
    dataStoreType_ = 0;
    dataStore_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataStoreConnection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_DataStoreConnection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_DataStoreConnection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.class,
            com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder.class);
  }

  public static final int DATA_STORE_TYPE_FIELD_NUMBER = 1;
  private int dataStoreType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the connected data store.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
   *
   * @return The enum numeric value on the wire for dataStoreType.
   */
  @java.lang.Override
  public int getDataStoreTypeValue() {
    return dataStoreType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the connected data store.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
   *
   * @return The dataStoreType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.DataStoreType getDataStoreType() {
    com.google.cloud.dialogflow.cx.v3beta1.DataStoreType result =
        com.google.cloud.dialogflow.cx.v3beta1.DataStoreType.forNumber(dataStoreType_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.DataStoreType.UNRECOGNIZED
        : result;
  }

  public static final int DATA_STORE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataStore_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the referenced data store.
   * Formats:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
   * `projects/{project}/locations/{location}/dataStores/{data_store}`
   * </pre>
   *
   * <code>string data_store = 2;</code>
   *
   * @return The dataStore.
   */
  @java.lang.Override
  public java.lang.String getDataStore() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataStore_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the referenced data store.
   * Formats:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
   * `projects/{project}/locations/{location}/dataStores/{data_store}`
   * </pre>
   *
   * <code>string data_store = 2;</code>
   *
   * @return The bytes for dataStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataStoreBytes() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataStoreType_
        != com.google.cloud.dialogflow.cx.v3beta1.DataStoreType.DATA_STORE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, dataStoreType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataStore_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataStoreType_
        != com.google.cloud.dialogflow.cx.v3beta1.DataStoreType.DATA_STORE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, dataStoreType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataStore_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection other =
        (com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection) obj;

    if (dataStoreType_ != other.dataStoreType_) return false;
    if (!getDataStore().equals(other.getDataStore())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_STORE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataStoreType_;
    hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getDataStore().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A data store connection. It represents a data store in Discovery Engine and
   * the type of the contents it contains.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.DataStoreConnection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.DataStoreConnection)
      com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_DataStoreConnection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_DataStoreConnection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.class,
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataStoreType_ = 0;
      dataStore_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_DataStoreConnection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection build() {
      com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection result =
          new com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataStoreType_ = dataStoreType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataStore_ = dataStore_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.getDefaultInstance())
        return this;
      if (other.dataStoreType_ != 0) {
        setDataStoreTypeValue(other.getDataStoreTypeValue());
      }
      if (!other.getDataStore().isEmpty()) {
        dataStore_ = other.dataStore_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                dataStoreType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                dataStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int dataStoreType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the connected data store.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
     *
     * @return The enum numeric value on the wire for dataStoreType.
     */
    @java.lang.Override
    public int getDataStoreTypeValue() {
      return dataStoreType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the connected data store.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for dataStoreType to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreTypeValue(int value) {
      dataStoreType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the connected data store.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
     *
     * @return The dataStoreType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreType getDataStoreType() {
      com.google.cloud.dialogflow.cx.v3beta1.DataStoreType result =
          com.google.cloud.dialogflow.cx.v3beta1.DataStoreType.forNumber(dataStoreType_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.DataStoreType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the connected data store.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
     *
     * @param value The dataStoreType to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreType(com.google.cloud.dialogflow.cx.v3beta1.DataStoreType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      dataStoreType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the connected data store.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DataStoreType data_store_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStoreType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      dataStoreType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the referenced data store.
     * Formats:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
     * `projects/{project}/locations/{location}/dataStores/{data_store}`
     * </pre>
     *
     * <code>string data_store = 2;</code>
     *
     * @return The dataStore.
     */
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the referenced data store.
     * Formats:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
     * `projects/{project}/locations/{location}/dataStores/{data_store}`
     * </pre>
     *
     * <code>string data_store = 2;</code>
     *
     * @return The bytes for dataStore.
     */
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the referenced data store.
     * Formats:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
     * `projects/{project}/locations/{location}/dataStores/{data_store}`
     * </pre>
     *
     * <code>string data_store = 2;</code>
     *
     * @param value The dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the referenced data store.
     * Formats:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
     * `projects/{project}/locations/{location}/dataStores/{data_store}`
     * </pre>
     *
     * <code>string data_store = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStore() {
      dataStore_ = getDefaultInstance().getDataStore();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the referenced data store.
     * Formats:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
     * `projects/{project}/locations/{location}/dataStores/{data_store}`
     * </pre>
     *
     * <code>string data_store = 2;</code>
     *
     * @param value The bytes for dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.DataStoreConnection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.DataStoreConnection)
  private static final com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataStoreConnection> PARSER =
      new com.google.protobuf.AbstractParser<DataStoreConnection>() {
        @java.lang.Override
        public DataStoreConnection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataStoreConnection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataStoreConnection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
