/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/environment.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Represents a result from running a test case in an agent environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult}
 */
public final class ContinuousTestResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult)
    ContinuousTestResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContinuousTestResult.newBuilder() to construct.
  private ContinuousTestResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContinuousTestResult() {
    name_ = "";
    result_ = 0;
    testCaseResults_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContinuousTestResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ContinuousTestResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ContinuousTestResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.class,
            com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The overall result for a continuous test run in an agent environment.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult}
   */
  public enum AggregatedTestResult implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. Should never be used.
     * </pre>
     *
     * <code>AGGREGATED_TEST_RESULT_UNSPECIFIED = 0;</code>
     */
    AGGREGATED_TEST_RESULT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All the tests passed.
     * </pre>
     *
     * <code>PASSED = 1;</code>
     */
    PASSED(1),
    /**
     *
     *
     * <pre>
     * At least one test did not pass.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. Should never be used.
     * </pre>
     *
     * <code>AGGREGATED_TEST_RESULT_UNSPECIFIED = 0;</code>
     */
    public static final int AGGREGATED_TEST_RESULT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * All the tests passed.
     * </pre>
     *
     * <code>PASSED = 1;</code>
     */
    public static final int PASSED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * At least one test did not pass.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AggregatedTestResult valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AggregatedTestResult forNumber(int value) {
      switch (value) {
        case 0:
          return AGGREGATED_TEST_RESULT_UNSPECIFIED;
        case 1:
          return PASSED;
        case 2:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AggregatedTestResult>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AggregatedTestResult>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AggregatedTestResult>() {
              public AggregatedTestResult findValueByNumber(int number) {
                return AggregatedTestResult.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AggregatedTestResult[] VALUES = values();

    public static AggregatedTestResult valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AggregatedTestResult(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name for the continuous test result. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/environments/&lt;Environment
   * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name for the continuous test result. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/environments/&lt;Environment
   * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESULT_FIELD_NUMBER = 2;
  private int result_ = 0;
  /**
   *
   *
   * <pre>
   * The result of this continuous test run, i.e. whether all the tests in this
   * continuous test run pass or not.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for result.
   */
  @java.lang.Override
  public int getResultValue() {
    return result_;
  }
  /**
   *
   *
   * <pre>
   * The result of this continuous test run, i.e. whether all the tests in this
   * continuous test run pass or not.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
   * </code>
   *
   * @return The result.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
      getResult() {
    com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result =
        com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult.forNumber(
            result_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
            .UNRECOGNIZED
        : result;
  }

  public static final int TEST_CASE_RESULTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList testCaseResults_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of individual test case results names in this continuous test run.
   * </pre>
   *
   * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the testCaseResults.
   */
  public com.google.protobuf.ProtocolStringList getTestCaseResultsList() {
    return testCaseResults_;
  }
  /**
   *
   *
   * <pre>
   * A list of individual test case results names in this continuous test run.
   * </pre>
   *
   * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of testCaseResults.
   */
  public int getTestCaseResultsCount() {
    return testCaseResults_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of individual test case results names in this continuous test run.
   * </pre>
   *
   * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The testCaseResults at the given index.
   */
  public java.lang.String getTestCaseResults(int index) {
    return testCaseResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of individual test case results names in this continuous test run.
   * </pre>
   *
   * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the testCaseResults at the given index.
   */
  public com.google.protobuf.ByteString getTestCaseResultsBytes(int index) {
    return testCaseResults_.getByteString(index);
  }

  public static final int RUN_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp runTime_;
  /**
   *
   *
   * <pre>
   * Time when the continuous testing run starts.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp run_time = 4;</code>
   *
   * @return Whether the runTime field is set.
   */
  @java.lang.Override
  public boolean hasRunTime() {
    return runTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the continuous testing run starts.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp run_time = 4;</code>
   *
   * @return The runTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRunTime() {
    return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the continuous testing run starts.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp run_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRunTimeOrBuilder() {
    return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (result_
        != com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
            .AGGREGATED_TEST_RESULT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, result_);
    }
    for (int i = 0; i < testCaseResults_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, testCaseResults_.getRaw(i));
    }
    if (runTime_ != null) {
      output.writeMessage(4, getRunTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (result_
        != com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
            .AGGREGATED_TEST_RESULT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, result_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < testCaseResults_.size(); i++) {
        dataSize += computeStringSizeNoTag(testCaseResults_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTestCaseResultsList().size();
    }
    if (runTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRunTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult other =
        (com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult) obj;

    if (!getName().equals(other.getName())) return false;
    if (result_ != other.result_) return false;
    if (!getTestCaseResultsList().equals(other.getTestCaseResultsList())) return false;
    if (hasRunTime() != other.hasRunTime()) return false;
    if (hasRunTime()) {
      if (!getRunTime().equals(other.getRunTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + RESULT_FIELD_NUMBER;
    hash = (53 * hash) + result_;
    if (getTestCaseResultsCount() > 0) {
      hash = (37 * hash) + TEST_CASE_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getTestCaseResultsList().hashCode();
    }
    if (hasRunTime()) {
      hash = (37 * hash) + RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRunTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a result from running a test case in an agent environment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult)
      com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ContinuousTestResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ContinuousTestResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.class,
              com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      result_ = 0;
      testCaseResults_ = com.google.protobuf.LazyStringArrayList.emptyList();
      runTime_ = null;
      if (runTimeBuilder_ != null) {
        runTimeBuilder_.dispose();
        runTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ContinuousTestResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult build() {
      com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult result =
          new com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.result_ = result_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        testCaseResults_.makeImmutable();
        result.testCaseResults_ = testCaseResults_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.runTime_ = runTimeBuilder_ == null ? runTime_ : runTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.result_ != 0) {
        setResultValue(other.getResultValue());
      }
      if (!other.testCaseResults_.isEmpty()) {
        if (testCaseResults_.isEmpty()) {
          testCaseResults_ = other.testCaseResults_;
          bitField0_ |= 0x00000004;
        } else {
          ensureTestCaseResultsIsMutable();
          testCaseResults_.addAll(other.testCaseResults_);
        }
        onChanged();
      }
      if (other.hasRunTime()) {
        mergeRunTime(other.getRunTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                result_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTestCaseResultsIsMutable();
                testCaseResults_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name for the continuous test result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment
     * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the continuous test result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment
     * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the continuous test result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment
     * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the continuous test result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment
     * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the continuous test result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment
     * ID&gt;/continuousTestResults/&lt;ContinuousTestResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int result_ = 0;
    /**
     *
     *
     * <pre>
     * The result of this continuous test run, i.e. whether all the tests in this
     * continuous test run pass or not.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for result.
     */
    @java.lang.Override
    public int getResultValue() {
      return result_;
    }
    /**
     *
     *
     * <pre>
     * The result of this continuous test run, i.e. whether all the tests in this
     * continuous test run pass or not.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for result to set.
     * @return This builder for chaining.
     */
    public Builder setResultValue(int value) {
      result_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of this continuous test run, i.e. whether all the tests in this
     * continuous test run pass or not.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
     * </code>
     *
     * @return The result.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
        getResult() {
      com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result =
          com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
              .forNumber(result_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The result of this continuous test run, i.e. whether all the tests in this
     * continuous test run pass or not.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
     * </code>
     *
     * @param value The result to set.
     * @return This builder for chaining.
     */
    public Builder setResult(
        com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      result_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of this continuous test run, i.e. whether all the tests in this
     * continuous test run pass or not.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult.AggregatedTestResult result = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResult() {
      bitField0_ = (bitField0_ & ~0x00000002);
      result_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList testCaseResults_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTestCaseResultsIsMutable() {
      if (!testCaseResults_.isModifiable()) {
        testCaseResults_ = new com.google.protobuf.LazyStringArrayList(testCaseResults_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the testCaseResults.
     */
    public com.google.protobuf.ProtocolStringList getTestCaseResultsList() {
      testCaseResults_.makeImmutable();
      return testCaseResults_;
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of testCaseResults.
     */
    public int getTestCaseResultsCount() {
      return testCaseResults_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The testCaseResults at the given index.
     */
    public java.lang.String getTestCaseResults(int index) {
      return testCaseResults_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the testCaseResults at the given index.
     */
    public com.google.protobuf.ByteString getTestCaseResultsBytes(int index) {
      return testCaseResults_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The testCaseResults to set.
     * @return This builder for chaining.
     */
    public Builder setTestCaseResults(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTestCaseResultsIsMutable();
      testCaseResults_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The testCaseResults to add.
     * @return This builder for chaining.
     */
    public Builder addTestCaseResults(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTestCaseResultsIsMutable();
      testCaseResults_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The testCaseResults to add.
     * @return This builder for chaining.
     */
    public Builder addAllTestCaseResults(java.lang.Iterable<java.lang.String> values) {
      ensureTestCaseResultsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, testCaseResults_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTestCaseResults() {
      testCaseResults_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of individual test case results names in this continuous test run.
     * </pre>
     *
     * <code>repeated string test_case_results = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the testCaseResults to add.
     * @return This builder for chaining.
     */
    public Builder addTestCaseResultsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTestCaseResultsIsMutable();
      testCaseResults_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp runTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        runTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     *
     * @return Whether the runTime field is set.
     */
    public boolean hasRunTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     *
     * @return The runTime.
     */
    public com.google.protobuf.Timestamp getRunTime() {
      if (runTimeBuilder_ == null) {
        return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
      } else {
        return runTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    public Builder setRunTime(com.google.protobuf.Timestamp value) {
      if (runTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runTime_ = value;
      } else {
        runTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    public Builder setRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (runTimeBuilder_ == null) {
        runTime_ = builderForValue.build();
      } else {
        runTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    public Builder mergeRunTime(com.google.protobuf.Timestamp value) {
      if (runTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && runTime_ != null
            && runTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRunTimeBuilder().mergeFrom(value);
        } else {
          runTime_ = value;
        }
      } else {
        runTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    public Builder clearRunTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      runTime_ = null;
      if (runTimeBuilder_ != null) {
        runTimeBuilder_.dispose();
        runTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRunTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRunTimeOrBuilder() {
      if (runTimeBuilder_ != null) {
        return runTimeBuilder_.getMessageOrBuilder();
      } else {
        return runTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : runTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the continuous testing run starts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp run_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRunTimeFieldBuilder() {
      if (runTimeBuilder_ == null) {
        runTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRunTime(), getParentForChildren(), isClean());
        runTime_ = null;
      }
      return runTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContinuousTestResult> PARSER =
      new com.google.protobuf.AbstractParser<ContinuousTestResult>() {
        @java.lang.Override
        public ContinuousTestResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContinuousTestResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContinuousTestResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
