/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/advanced_settings.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
 * Settings exposed at lower level overrides the settings exposed at higher
 * level. Overriding occurs at the sub-setting level. For example, the
 * playback_interruption_settings at fulfillment level only overrides the
 * playback_interruption_settings at the agent level, leaving other settings
 * at the agent level unchanged.
 *
 * DTMF settings does not override each other. DTMF settings set at different
 * levels define DTMF detections running in parallel.
 *
 * Hierarchy: Agent-&gt;Flow-&gt;Page-&gt;Fulfillment/Parameter.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings}
 */
public final class AdvancedSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
    AdvancedSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdvancedSettings.newBuilder() to construct.
  private AdvancedSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdvancedSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdvancedSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.class,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder.class);
  }

  public interface DtmfSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Max length of DTMF digits.
     * </pre>
     *
     * <code>int32 max_digits = 2;</code>
     *
     * @return The maxDigits.
     */
    int getMaxDigits();

    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The finishDigit.
     */
    java.lang.String getFinishDigit();
    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The bytes for finishDigit.
     */
    com.google.protobuf.ByteString getFinishDigitBytes();
  }
  /**
   *
   *
   * <pre>
   * Define behaviors for DTMF (dual tone multi frequency).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings}
   */
  public static final class DtmfSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
      DtmfSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DtmfSettings.newBuilder() to construct.
    private DtmfSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DtmfSettings() {
      finishDigit_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DtmfSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int MAX_DIGITS_FIELD_NUMBER = 2;
    private int maxDigits_ = 0;
    /**
     *
     *
     * <pre>
     * Max length of DTMF digits.
     * </pre>
     *
     * <code>int32 max_digits = 2;</code>
     *
     * @return The maxDigits.
     */
    @java.lang.Override
    public int getMaxDigits() {
      return maxDigits_;
    }

    public static final int FINISH_DIGIT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object finishDigit_ = "";
    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The finishDigit.
     */
    @java.lang.Override
    public java.lang.String getFinishDigit() {
      java.lang.Object ref = finishDigit_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finishDigit_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The bytes for finishDigit.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFinishDigitBytes() {
      java.lang.Object ref = finishDigit_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        finishDigit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      if (maxDigits_ != 0) {
        output.writeInt32(2, maxDigits_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finishDigit_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, finishDigit_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      if (maxDigits_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxDigits_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finishDigit_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, finishDigit_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings other =
          (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (getMaxDigits() != other.getMaxDigits()) return false;
      if (!getFinishDigit().equals(other.getFinishDigit())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (37 * hash) + MAX_DIGITS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDigits();
      hash = (37 * hash) + FINISH_DIGIT_FIELD_NUMBER;
      hash = (53 * hash) + getFinishDigit().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Define behaviors for DTMF (dual tone multi frequency).
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.class,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        maxDigits_ = 0;
        finishDigit_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings build() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings result =
            new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxDigits_ = maxDigits_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.finishDigit_ = finishDigit_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.getMaxDigits() != 0) {
          setMaxDigits(other.getMaxDigits());
        }
        if (!other.getFinishDigit().isEmpty()) {
          finishDigit_ = other.finishDigit_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  maxDigits_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  finishDigit_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * If true, incoming audio is processed for DTMF (dual tone multi frequency)
       * events. For example, if the caller presses a button on their telephone
       * keypad and DTMF processing is enabled, Dialogflow will detect the
       * event (e.g. a "3" was pressed) in the incoming audio and pass the event
       * to the bot to drive business logic (e.g. when 3 is pressed, return the
       * account balance).
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * If true, incoming audio is processed for DTMF (dual tone multi frequency)
       * events. For example, if the caller presses a button on their telephone
       * keypad and DTMF processing is enabled, Dialogflow will detect the
       * event (e.g. a "3" was pressed) in the incoming audio and pass the event
       * to the bot to drive business logic (e.g. when 3 is pressed, return the
       * account balance).
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, incoming audio is processed for DTMF (dual tone multi frequency)
       * events. For example, if the caller presses a button on their telephone
       * keypad and DTMF processing is enabled, Dialogflow will detect the
       * event (e.g. a "3" was pressed) in the incoming audio and pass the event
       * to the bot to drive business logic (e.g. when 3 is pressed, return the
       * account balance).
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private int maxDigits_;
      /**
       *
       *
       * <pre>
       * Max length of DTMF digits.
       * </pre>
       *
       * <code>int32 max_digits = 2;</code>
       *
       * @return The maxDigits.
       */
      @java.lang.Override
      public int getMaxDigits() {
        return maxDigits_;
      }
      /**
       *
       *
       * <pre>
       * Max length of DTMF digits.
       * </pre>
       *
       * <code>int32 max_digits = 2;</code>
       *
       * @param value The maxDigits to set.
       * @return This builder for chaining.
       */
      public Builder setMaxDigits(int value) {

        maxDigits_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Max length of DTMF digits.
       * </pre>
       *
       * <code>int32 max_digits = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxDigits() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxDigits_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object finishDigit_ = "";
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @return The finishDigit.
       */
      public java.lang.String getFinishDigit() {
        java.lang.Object ref = finishDigit_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          finishDigit_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @return The bytes for finishDigit.
       */
      public com.google.protobuf.ByteString getFinishDigitBytes() {
        java.lang.Object ref = finishDigit_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          finishDigit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @param value The finishDigit to set.
       * @return This builder for chaining.
       */
      public Builder setFinishDigit(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        finishDigit_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFinishDigit() {
        finishDigit_ = getDefaultInstance().getFinishDigit();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @param value The bytes for finishDigit to set.
       * @return This builder for chaining.
       */
      public Builder setFinishDigitBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        finishDigit_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
    private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DtmfSettings> PARSER =
        new com.google.protobuf.AbstractParser<DtmfSettings>() {
          @java.lang.Override
          public DtmfSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DtmfSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DtmfSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoggingSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If true, StackDriver logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 2;</code>
     *
     * @return The enableStackdriverLogging.
     */
    boolean getEnableStackdriverLogging();

    /**
     *
     *
     * <pre>
     * If true, DF Interaction logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_interaction_logging = 3;</code>
     *
     * @return The enableInteractionLogging.
     */
    boolean getEnableInteractionLogging();
  }
  /**
   *
   *
   * <pre>
   * Define behaviors on logging.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings}
   */
  public static final class LoggingSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
      LoggingSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LoggingSettings.newBuilder() to construct.
    private LoggingSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LoggingSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LoggingSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
                  .class);
    }

    public static final int ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER = 2;
    private boolean enableStackdriverLogging_ = false;
    /**
     *
     *
     * <pre>
     * If true, StackDriver logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 2;</code>
     *
     * @return The enableStackdriverLogging.
     */
    @java.lang.Override
    public boolean getEnableStackdriverLogging() {
      return enableStackdriverLogging_;
    }

    public static final int ENABLE_INTERACTION_LOGGING_FIELD_NUMBER = 3;
    private boolean enableInteractionLogging_ = false;
    /**
     *
     *
     * <pre>
     * If true, DF Interaction logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_interaction_logging = 3;</code>
     *
     * @return The enableInteractionLogging.
     */
    @java.lang.Override
    public boolean getEnableInteractionLogging() {
      return enableInteractionLogging_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableStackdriverLogging_ != false) {
        output.writeBool(2, enableStackdriverLogging_);
      }
      if (enableInteractionLogging_ != false) {
        output.writeBool(3, enableInteractionLogging_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableStackdriverLogging_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableStackdriverLogging_);
      }
      if (enableInteractionLogging_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableInteractionLogging_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings other =
          (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings) obj;

      if (getEnableStackdriverLogging() != other.getEnableStackdriverLogging()) return false;
      if (getEnableInteractionLogging() != other.getEnableInteractionLogging()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverLogging());
      hash = (37 * hash) + ENABLE_INTERACTION_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableInteractionLogging());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Define behaviors on logging.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.class,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableStackdriverLogging_ = false;
        enableInteractionLogging_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings build() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings result =
            new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableStackdriverLogging_ = enableStackdriverLogging_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enableInteractionLogging_ = enableInteractionLogging_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                .getDefaultInstance()) return this;
        if (other.getEnableStackdriverLogging() != false) {
          setEnableStackdriverLogging(other.getEnableStackdriverLogging());
        }
        if (other.getEnableInteractionLogging() != false) {
          setEnableInteractionLogging(other.getEnableInteractionLogging());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  enableStackdriverLogging_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 24:
                {
                  enableInteractionLogging_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableStackdriverLogging_;
      /**
       *
       *
       * <pre>
       * If true, StackDriver logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @return The enableStackdriverLogging.
       */
      @java.lang.Override
      public boolean getEnableStackdriverLogging() {
        return enableStackdriverLogging_;
      }
      /**
       *
       *
       * <pre>
       * If true, StackDriver logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @param value The enableStackdriverLogging to set.
       * @return This builder for chaining.
       */
      public Builder setEnableStackdriverLogging(boolean value) {

        enableStackdriverLogging_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, StackDriver logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableStackdriverLogging() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableStackdriverLogging_ = false;
        onChanged();
        return this;
      }

      private boolean enableInteractionLogging_;
      /**
       *
       *
       * <pre>
       * If true, DF Interaction logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @return The enableInteractionLogging.
       */
      @java.lang.Override
      public boolean getEnableInteractionLogging() {
        return enableInteractionLogging_;
      }
      /**
       *
       *
       * <pre>
       * If true, DF Interaction logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @param value The enableInteractionLogging to set.
       * @return This builder for chaining.
       */
      public Builder setEnableInteractionLogging(boolean value) {

        enableInteractionLogging_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, DF Interaction logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableInteractionLogging() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enableInteractionLogging_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
    private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LoggingSettings> PARSER =
        new com.google.protobuf.AbstractParser<LoggingSettings>() {
          @java.lang.Override
          public LoggingSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LoggingSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LoggingSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int AUDIO_EXPORT_GCS_DESTINATION_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3beta1.GcsDestination audioExportGcsDestination_;
  /**
   *
   *
   * <pre>
   * If present, incoming audio is exported by Dialogflow to the configured
   * Google Cloud Storage destination.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
   * </code>
   *
   * @return Whether the audioExportGcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasAudioExportGcsDestination() {
    return audioExportGcsDestination_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, incoming audio is exported by Dialogflow to the configured
   * Google Cloud Storage destination.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
   * </code>
   *
   * @return The audioExportGcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.GcsDestination getAudioExportGcsDestination() {
    return audioExportGcsDestination_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
        : audioExportGcsDestination_;
  }
  /**
   *
   *
   * <pre>
   * If present, incoming audio is exported by Dialogflow to the configured
   * Google Cloud Storage destination.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder
      getAudioExportGcsDestinationOrBuilder() {
    return audioExportGcsDestination_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
        : audioExportGcsDestination_;
  }

  public static final int DTMF_SETTINGS_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmfSettings_;
  /**
   *
   *
   * <pre>
   * Settings for DTMF.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
   * </code>
   *
   * @return Whether the dtmfSettings field is set.
   */
  @java.lang.Override
  public boolean hasDtmfSettings() {
    return dtmfSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for DTMF.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
   * </code>
   *
   * @return The dtmfSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings getDtmfSettings() {
    return dtmfSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.getDefaultInstance()
        : dtmfSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for DTMF.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder
      getDtmfSettingsOrBuilder() {
    return dtmfSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.getDefaultInstance()
        : dtmfSettings_;
  }

  public static final int LOGGING_SETTINGS_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings loggingSettings_;
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   *
   * @return Whether the loggingSettings field is set.
   */
  @java.lang.Override
  public boolean hasLoggingSettings() {
    return loggingSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   *
   * @return The loggingSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
      getLoggingSettings() {
    return loggingSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
            .getDefaultInstance()
        : loggingSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder
      getLoggingSettingsOrBuilder() {
    return loggingSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
            .getDefaultInstance()
        : loggingSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (audioExportGcsDestination_ != null) {
      output.writeMessage(2, getAudioExportGcsDestination());
    }
    if (dtmfSettings_ != null) {
      output.writeMessage(5, getDtmfSettings());
    }
    if (loggingSettings_ != null) {
      output.writeMessage(6, getLoggingSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (audioExportGcsDestination_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getAudioExportGcsDestination());
    }
    if (dtmfSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDtmfSettings());
    }
    if (loggingSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLoggingSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings other =
        (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings) obj;

    if (hasAudioExportGcsDestination() != other.hasAudioExportGcsDestination()) return false;
    if (hasAudioExportGcsDestination()) {
      if (!getAudioExportGcsDestination().equals(other.getAudioExportGcsDestination()))
        return false;
    }
    if (hasDtmfSettings() != other.hasDtmfSettings()) return false;
    if (hasDtmfSettings()) {
      if (!getDtmfSettings().equals(other.getDtmfSettings())) return false;
    }
    if (hasLoggingSettings() != other.hasLoggingSettings()) return false;
    if (hasLoggingSettings()) {
      if (!getLoggingSettings().equals(other.getLoggingSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAudioExportGcsDestination()) {
      hash = (37 * hash) + AUDIO_EXPORT_GCS_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getAudioExportGcsDestination().hashCode();
    }
    if (hasDtmfSettings()) {
      hash = (37 * hash) + DTMF_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getDtmfSettings().hashCode();
    }
    if (hasLoggingSettings()) {
      hash = (37 * hash) + LOGGING_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
   * Settings exposed at lower level overrides the settings exposed at higher
   * level. Overriding occurs at the sub-setting level. For example, the
   * playback_interruption_settings at fulfillment level only overrides the
   * playback_interruption_settings at the agent level, leaving other settings
   * at the agent level unchanged.
   *
   * DTMF settings does not override each other. DTMF settings set at different
   * levels define DTMF detections running in parallel.
   *
   * Hierarchy: Agent-&gt;Flow-&gt;Page-&gt;Fulfillment/Parameter.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audioExportGcsDestination_ = null;
      if (audioExportGcsDestinationBuilder_ != null) {
        audioExportGcsDestinationBuilder_.dispose();
        audioExportGcsDestinationBuilder_ = null;
      }
      dtmfSettings_ = null;
      if (dtmfSettingsBuilder_ != null) {
        dtmfSettingsBuilder_.dispose();
        dtmfSettingsBuilder_ = null;
      }
      loggingSettings_ = null;
      if (loggingSettingsBuilder_ != null) {
        loggingSettingsBuilder_.dispose();
        loggingSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings build() {
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings result =
          new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audioExportGcsDestination_ =
            audioExportGcsDestinationBuilder_ == null
                ? audioExportGcsDestination_
                : audioExportGcsDestinationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dtmfSettings_ =
            dtmfSettingsBuilder_ == null ? dtmfSettings_ : dtmfSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.loggingSettings_ =
            loggingSettingsBuilder_ == null ? loggingSettings_ : loggingSettingsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance())
        return this;
      if (other.hasAudioExportGcsDestination()) {
        mergeAudioExportGcsDestination(other.getAudioExportGcsDestination());
      }
      if (other.hasDtmfSettings()) {
        mergeDtmfSettings(other.getDtmfSettings());
      }
      if (other.hasLoggingSettings()) {
        mergeLoggingSettings(other.getLoggingSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getAudioExportGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 42:
              {
                input.readMessage(getDtmfSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getLoggingSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.cx.v3beta1.GcsDestination audioExportGcsDestination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder>
        audioExportGcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     *
     * @return Whether the audioExportGcsDestination field is set.
     */
    public boolean hasAudioExportGcsDestination() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     *
     * @return The audioExportGcsDestination.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.GcsDestination getAudioExportGcsDestination() {
      if (audioExportGcsDestinationBuilder_ == null) {
        return audioExportGcsDestination_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
            : audioExportGcsDestination_;
      } else {
        return audioExportGcsDestinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder setAudioExportGcsDestination(
        com.google.cloud.dialogflow.cx.v3beta1.GcsDestination value) {
      if (audioExportGcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioExportGcsDestination_ = value;
      } else {
        audioExportGcsDestinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder setAudioExportGcsDestination(
        com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder builderForValue) {
      if (audioExportGcsDestinationBuilder_ == null) {
        audioExportGcsDestination_ = builderForValue.build();
      } else {
        audioExportGcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder mergeAudioExportGcsDestination(
        com.google.cloud.dialogflow.cx.v3beta1.GcsDestination value) {
      if (audioExportGcsDestinationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && audioExportGcsDestination_ != null
            && audioExportGcsDestination_
                != com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()) {
          getAudioExportGcsDestinationBuilder().mergeFrom(value);
        } else {
          audioExportGcsDestination_ = value;
        }
      } else {
        audioExportGcsDestinationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder clearAudioExportGcsDestination() {
      bitField0_ = (bitField0_ & ~0x00000001);
      audioExportGcsDestination_ = null;
      if (audioExportGcsDestinationBuilder_ != null) {
        audioExportGcsDestinationBuilder_.dispose();
        audioExportGcsDestinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder
        getAudioExportGcsDestinationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAudioExportGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder
        getAudioExportGcsDestinationOrBuilder() {
      if (audioExportGcsDestinationBuilder_ != null) {
        return audioExportGcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        return audioExportGcsDestination_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
            : audioExportGcsDestination_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder>
        getAudioExportGcsDestinationFieldBuilder() {
      if (audioExportGcsDestinationBuilder_ == null) {
        audioExportGcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.GcsDestination,
                com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder>(
                getAudioExportGcsDestination(), getParentForChildren(), isClean());
        audioExportGcsDestination_ = null;
      }
      return audioExportGcsDestinationBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmfSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder>
        dtmfSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     *
     * @return Whether the dtmfSettings field is set.
     */
    public boolean hasDtmfSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     *
     * @return The dtmfSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings getDtmfSettings() {
      if (dtmfSettingsBuilder_ == null) {
        return dtmfSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                .getDefaultInstance()
            : dtmfSettings_;
      } else {
        return dtmfSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder setDtmfSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings value) {
      if (dtmfSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dtmfSettings_ = value;
      } else {
        dtmfSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder setDtmfSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder
            builderForValue) {
      if (dtmfSettingsBuilder_ == null) {
        dtmfSettings_ = builderForValue.build();
      } else {
        dtmfSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder mergeDtmfSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings value) {
      if (dtmfSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dtmfSettings_ != null
            && dtmfSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                    .getDefaultInstance()) {
          getDtmfSettingsBuilder().mergeFrom(value);
        } else {
          dtmfSettings_ = value;
        }
      } else {
        dtmfSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder clearDtmfSettings() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dtmfSettings_ = null;
      if (dtmfSettingsBuilder_ != null) {
        dtmfSettingsBuilder_.dispose();
        dtmfSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder
        getDtmfSettingsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDtmfSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder
        getDtmfSettingsOrBuilder() {
      if (dtmfSettingsBuilder_ != null) {
        return dtmfSettingsBuilder_.getMessageOrBuilder();
      } else {
        return dtmfSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                .getDefaultInstance()
            : dtmfSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder>
        getDtmfSettingsFieldBuilder() {
      if (dtmfSettingsBuilder_ == null) {
        dtmfSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder>(
                getDtmfSettings(), getParentForChildren(), isClean());
        dtmfSettings_ = null;
      }
      return dtmfSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        loggingSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder>
        loggingSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     *
     * @return Whether the loggingSettings field is set.
     */
    public boolean hasLoggingSettings() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     *
     * @return The loggingSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        getLoggingSettings() {
      if (loggingSettingsBuilder_ == null) {
        return loggingSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                .getDefaultInstance()
            : loggingSettings_;
      } else {
        return loggingSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder setLoggingSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings value) {
      if (loggingSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingSettings_ = value;
      } else {
        loggingSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder setLoggingSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
            builderForValue) {
      if (loggingSettingsBuilder_ == null) {
        loggingSettings_ = builderForValue.build();
      } else {
        loggingSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder mergeLoggingSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings value) {
      if (loggingSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && loggingSettings_ != null
            && loggingSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                    .getDefaultInstance()) {
          getLoggingSettingsBuilder().mergeFrom(value);
        } else {
          loggingSettings_ = value;
        }
      } else {
        loggingSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder clearLoggingSettings() {
      bitField0_ = (bitField0_ & ~0x00000004);
      loggingSettings_ = null;
      if (loggingSettingsBuilder_ != null) {
        loggingSettingsBuilder_.dispose();
        loggingSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
        getLoggingSettingsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getLoggingSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder
        getLoggingSettingsOrBuilder() {
      if (loggingSettingsBuilder_ != null) {
        return loggingSettingsBuilder_.getMessageOrBuilder();
      } else {
        return loggingSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                .getDefaultInstance()
            : loggingSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder>
        getLoggingSettingsFieldBuilder() {
      if (loggingSettingsBuilder_ == null) {
        loggingSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder>(
                getLoggingSettings(), getParentForChildren(), isClean());
        loggingSettings_ = null;
      }
      return loggingSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
  private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdvancedSettings> PARSER =
      new com.google.protobuf.AbstractParser<AdvancedSettings>() {
        @java.lang.Override
        public AdvancedSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdvancedSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdvancedSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
