/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/data.proto

package com.google.devtools.clouddebugger.v2;

public interface VariableOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.devtools.clouddebugger.v2.Variable)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Name of the variable, if any.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Name of the variable, if any.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Simple value of the variable.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return The value.
   */
  java.lang.String getValue();
  /**
   *
   *
   * <pre>
   * Simple value of the variable.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return The bytes for value.
   */
  com.google.protobuf.ByteString getValueBytes();

  /**
   *
   *
   * <pre>
   * Variable type (e.g. `MyClass`). If the variable is split with
   * `var_table_index`, `type` goes next to `value`. The interpretation of
   * a type is agent specific. It is recommended to include the dynamic type
   * rather than a static type of an object.
   * </pre>
   *
   * <code>string type = 6;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * Variable type (e.g. `MyClass`). If the variable is split with
   * `var_table_index`, `type` goes next to `value`. The interpretation of
   * a type is agent specific. It is recommended to include the dynamic type
   * rather than a static type of an object.
   * </pre>
   *
   * <code>string type = 6;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  java.util.List<com.google.devtools.clouddebugger.v2.Variable> getMembersList();
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  com.google.devtools.clouddebugger.v2.Variable getMembers(int index);
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  int getMembersCount();
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getMembersOrBuilderList();
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  com.google.devtools.clouddebugger.v2.VariableOrBuilder getMembersOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Reference to a variable in the shared variable table. More than
   * one variable can reference the same variable in the table. The
   * `var_table_index` field is an index into `variable_table` in Breakpoint.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
   *
   * @return Whether the varTableIndex field is set.
   */
  boolean hasVarTableIndex();
  /**
   *
   *
   * <pre>
   * Reference to a variable in the shared variable table. More than
   * one variable can reference the same variable in the table. The
   * `var_table_index` field is an index into `variable_table` in Breakpoint.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
   *
   * @return The varTableIndex.
   */
  com.google.protobuf.Int32Value getVarTableIndex();
  /**
   *
   *
   * <pre>
   * Reference to a variable in the shared variable table. More than
   * one variable can reference the same variable in the table. The
   * `var_table_index` field is an index into `variable_table` in Breakpoint.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
   */
  com.google.protobuf.Int32ValueOrBuilder getVarTableIndexOrBuilder();

  /**
   *
   *
   * <pre>
   * Status associated with the variable. This field will usually stay
   * unset. A status of a single variable only applies to that variable or
   * expression. The rest of breakpoint data still remains valid. Variables
   * might be reported in error state even when breakpoint is not in final
   * state.
   * The message may refer to variable name with `refers_to` set to
   * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
   * In either case variable value and members will be unset.
   * Example of error message applied to name: `Invalid expression syntax`.
   * Example of information message applied to value: `Not captured`.
   * Examples of error message applied to value:
   * *   `Malformed string`,
   * *   `Field f not found in class C`
   * *   `Null pointer dereference`
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();
  /**
   *
   *
   * <pre>
   * Status associated with the variable. This field will usually stay
   * unset. A status of a single variable only applies to that variable or
   * expression. The rest of breakpoint data still remains valid. Variables
   * might be reported in error state even when breakpoint is not in final
   * state.
   * The message may refer to variable name with `refers_to` set to
   * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
   * In either case variable value and members will be unset.
   * Example of error message applied to name: `Invalid expression syntax`.
   * Example of information message applied to value: `Not captured`.
   * Examples of error message applied to value:
   * *   `Malformed string`,
   * *   `Field f not found in class C`
   * *   `Null pointer dereference`
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
   *
   * @return The status.
   */
  com.google.devtools.clouddebugger.v2.StatusMessage getStatus();
  /**
   *
   *
   * <pre>
   * Status associated with the variable. This field will usually stay
   * unset. A status of a single variable only applies to that variable or
   * expression. The rest of breakpoint data still remains valid. Variables
   * might be reported in error state even when breakpoint is not in final
   * state.
   * The message may refer to variable name with `refers_to` set to
   * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
   * In either case variable value and members will be unset.
   * Example of error message applied to name: `Invalid expression syntax`.
   * Example of information message applied to value: `Not captured`.
   * Examples of error message applied to value:
   * *   `Malformed string`,
   * *   `Field f not found in class C`
   * *   `Null pointer dereference`
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
   */
  com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder();
}
