/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/data.proto

package com.google.devtools.clouddebugger.v2;

/**
 *
 *
 * <pre>
 * Represents a variable or an argument possibly of a compound object type.
 * Note how the following variables are represented:
 * 1) A simple variable:
 *     int x = 5
 *     { name: "x", value: "5", type: "int" }  // Captured variable
 * 2) A compound object:
 *     struct T {
 *         int m1;
 *         int m2;
 *     };
 *     T x = { 3, 7 };
 *     {  // Captured variable
 *         name: "x",
 *         type: "T",
 *         members { name: "m1", value: "3", type: "int" },
 *         members { name: "m2", value: "7", type: "int" }
 *     }
 * 3) A pointer where the pointee was captured:
 *     T x = { 3, 7 };
 *     T* p = &amp;x;
 *     {   // Captured variable
 *         name: "p",
 *         type: "T*",
 *         value: "0x00500500",
 *         members { name: "m1", value: "3", type: "int" },
 *         members { name: "m2", value: "7", type: "int" }
 *     }
 * 4) A pointer where the pointee was not captured:
 *     T* p = new T;
 *     {   // Captured variable
 *         name: "p",
 *         type: "T*",
 *         value: "0x00400400"
 *         status { is_error: true, description { format: "unavailable" } }
 *     }
 * The status should describe the reason for the missing value,
 * such as `&lt;optimized out&gt;`, `&lt;inaccessible&gt;`, `&lt;pointers limit reached&gt;`.
 * Note that a null pointer should not have members.
 * 5) An unnamed value:
 *     int* p = new int(7);
 *     {   // Captured variable
 *         name: "p",
 *         value: "0x00500500",
 *         type: "int*",
 *         members { value: "7", type: "int" } }
 * 6) An unnamed pointer where the pointee was not captured:
 *     int* p = new int(7);
 *     int** pp = &amp;p;
 *     {  // Captured variable
 *         name: "pp",
 *         value: "0x00500500",
 *         type: "int**",
 *         members {
 *             value: "0x00400400",
 *             type: "int*"
 *             status {
 *                 is_error: true,
 *                 description: { format: "unavailable" } }
 *             }
 *         }
 *     }
 * To optimize computation, memory and network traffic, variables that
 * repeat in the output multiple times can be stored once in a shared
 * variable table and be referenced using the `var_table_index` field.  The
 * variables stored in the shared table are nameless and are essentially
 * a partition of the complete variable. To reconstruct the complete
 * variable, merge the referencing variable with the referenced variable.
 * When using the shared variable table, the following variables:
 *     T x = { 3, 7 };
 *     T* p = &amp;x;
 *     T&amp; r = x;
 *     { name: "x", var_table_index: 3, type: "T" }  // Captured variables
 *     { name: "p", value "0x00500500", type="T*", var_table_index: 3 }
 *     { name: "r", type="T&amp;", var_table_index: 3 }
 *     {  // Shared variable table entry #3:
 *         members { name: "m1", value: "3", type: "int" },
 *         members { name: "m2", value: "7", type: "int" }
 *     }
 * Note that the pointer address is stored with the referencing variable
 * and not with the referenced variable. This allows the referenced variable
 * to be shared between pointers and references.
 * The type field is optional. The debugger agent may or may not support it.
 * </pre>
 *
 * Protobuf type {@code google.devtools.clouddebugger.v2.Variable}
 */
public final class Variable extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.clouddebugger.v2.Variable)
    VariableOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Variable.newBuilder() to construct.
  private Variable(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Variable() {
    name_ = "";
    value_ = "";
    type_ = "";
    members_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Variable();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_Variable_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_Variable_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.clouddebugger.v2.Variable.class,
            com.google.devtools.clouddebugger.v2.Variable.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Name of the variable, if any.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the variable, if any.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 2;
  private volatile java.lang.Object value_;
  /**
   *
   *
   * <pre>
   * Simple value of the variable.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public java.lang.String getValue() {
    java.lang.Object ref = value_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      value_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Simple value of the variable.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return The bytes for value.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValueBytes() {
    java.lang.Object ref = value_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      value_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 6;
  private volatile java.lang.Object type_;
  /**
   *
   *
   * <pre>
   * Variable type (e.g. `MyClass`). If the variable is split with
   * `var_table_index`, `type` goes next to `value`. The interpretation of
   * a type is agent specific. It is recommended to include the dynamic type
   * rather than a static type of an object.
   * </pre>
   *
   * <code>string type = 6;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Variable type (e.g. `MyClass`). If the variable is split with
   * `var_table_index`, `type` goes next to `value`. The interpretation of
   * a type is agent specific. It is recommended to include the dynamic type
   * rather than a static type of an object.
   * </pre>
   *
   * <code>string type = 6;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEMBERS_FIELD_NUMBER = 3;
  private java.util.List<com.google.devtools.clouddebugger.v2.Variable> members_;
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getMembersList() {
    return members_;
  }
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getMembersOrBuilderList() {
    return members_;
  }
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  @java.lang.Override
  public int getMembersCount() {
    return members_.size();
  }
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Variable getMembers(int index) {
    return members_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Members contained or pointed to by the variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.VariableOrBuilder getMembersOrBuilder(int index) {
    return members_.get(index);
  }

  public static final int VAR_TABLE_INDEX_FIELD_NUMBER = 4;
  private com.google.protobuf.Int32Value varTableIndex_;
  /**
   *
   *
   * <pre>
   * Reference to a variable in the shared variable table. More than
   * one variable can reference the same variable in the table. The
   * `var_table_index` field is an index into `variable_table` in Breakpoint.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
   *
   * @return Whether the varTableIndex field is set.
   */
  @java.lang.Override
  public boolean hasVarTableIndex() {
    return varTableIndex_ != null;
  }
  /**
   *
   *
   * <pre>
   * Reference to a variable in the shared variable table. More than
   * one variable can reference the same variable in the table. The
   * `var_table_index` field is an index into `variable_table` in Breakpoint.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
   *
   * @return The varTableIndex.
   */
  @java.lang.Override
  public com.google.protobuf.Int32Value getVarTableIndex() {
    return varTableIndex_ == null
        ? com.google.protobuf.Int32Value.getDefaultInstance()
        : varTableIndex_;
  }
  /**
   *
   *
   * <pre>
   * Reference to a variable in the shared variable table. More than
   * one variable can reference the same variable in the table. The
   * `var_table_index` field is an index into `variable_table` in Breakpoint.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int32ValueOrBuilder getVarTableIndexOrBuilder() {
    return getVarTableIndex();
  }

  public static final int STATUS_FIELD_NUMBER = 5;
  private com.google.devtools.clouddebugger.v2.StatusMessage status_;
  /**
   *
   *
   * <pre>
   * Status associated with the variable. This field will usually stay
   * unset. A status of a single variable only applies to that variable or
   * expression. The rest of breakpoint data still remains valid. Variables
   * might be reported in error state even when breakpoint is not in final
   * state.
   * The message may refer to variable name with `refers_to` set to
   * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
   * In either case variable value and members will be unset.
   * Example of error message applied to name: `Invalid expression syntax`.
   * Example of information message applied to value: `Not captured`.
   * Examples of error message applied to value:
   * *   `Malformed string`,
   * *   `Field f not found in class C`
   * *   `Null pointer dereference`
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Status associated with the variable. This field will usually stay
   * unset. A status of a single variable only applies to that variable or
   * expression. The rest of breakpoint data still remains valid. Variables
   * might be reported in error state even when breakpoint is not in final
   * state.
   * The message may refer to variable name with `refers_to` set to
   * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
   * In either case variable value and members will be unset.
   * Example of error message applied to name: `Invalid expression syntax`.
   * Example of information message applied to value: `Not captured`.
   * Examples of error message applied to value:
   * *   `Malformed string`,
   * *   `Field f not found in class C`
   * *   `Null pointer dereference`
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StatusMessage getStatus() {
    return status_ == null
        ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Status associated with the variable. This field will usually stay
   * unset. A status of a single variable only applies to that variable or
   * expression. The rest of breakpoint data still remains valid. Variables
   * might be reported in error state even when breakpoint is not in final
   * state.
   * The message may refer to variable name with `refers_to` set to
   * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
   * In either case variable value and members will be unset.
   * Example of error message applied to name: `Invalid expression syntax`.
   * Example of information message applied to value: `Not captured`.
   * Examples of error message applied to value:
   * *   `Malformed string`,
   * *   `Field f not found in class C`
   * *   `Null pointer dereference`
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
    }
    for (int i = 0; i < members_.size(); i++) {
      output.writeMessage(3, members_.get(i));
    }
    if (varTableIndex_ != null) {
      output.writeMessage(4, getVarTableIndex());
    }
    if (status_ != null) {
      output.writeMessage(5, getStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
    }
    for (int i = 0; i < members_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, members_.get(i));
    }
    if (varTableIndex_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getVarTableIndex());
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.clouddebugger.v2.Variable)) {
      return super.equals(obj);
    }
    com.google.devtools.clouddebugger.v2.Variable other =
        (com.google.devtools.clouddebugger.v2.Variable) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getValue().equals(other.getValue())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getMembersList().equals(other.getMembersList())) return false;
    if (hasVarTableIndex() != other.hasVarTableIndex()) return false;
    if (hasVarTableIndex()) {
      if (!getVarTableIndex().equals(other.getVarTableIndex())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getValue().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (getMembersCount() > 0) {
      hash = (37 * hash) + MEMBERS_FIELD_NUMBER;
      hash = (53 * hash) + getMembersList().hashCode();
    }
    if (hasVarTableIndex()) {
      hash = (37 * hash) + VAR_TABLE_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getVarTableIndex().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Variable parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.clouddebugger.v2.Variable prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a variable or an argument possibly of a compound object type.
   * Note how the following variables are represented:
   * 1) A simple variable:
   *     int x = 5
   *     { name: "x", value: "5", type: "int" }  // Captured variable
   * 2) A compound object:
   *     struct T {
   *         int m1;
   *         int m2;
   *     };
   *     T x = { 3, 7 };
   *     {  // Captured variable
   *         name: "x",
   *         type: "T",
   *         members { name: "m1", value: "3", type: "int" },
   *         members { name: "m2", value: "7", type: "int" }
   *     }
   * 3) A pointer where the pointee was captured:
   *     T x = { 3, 7 };
   *     T* p = &amp;x;
   *     {   // Captured variable
   *         name: "p",
   *         type: "T*",
   *         value: "0x00500500",
   *         members { name: "m1", value: "3", type: "int" },
   *         members { name: "m2", value: "7", type: "int" }
   *     }
   * 4) A pointer where the pointee was not captured:
   *     T* p = new T;
   *     {   // Captured variable
   *         name: "p",
   *         type: "T*",
   *         value: "0x00400400"
   *         status { is_error: true, description { format: "unavailable" } }
   *     }
   * The status should describe the reason for the missing value,
   * such as `&lt;optimized out&gt;`, `&lt;inaccessible&gt;`, `&lt;pointers limit reached&gt;`.
   * Note that a null pointer should not have members.
   * 5) An unnamed value:
   *     int* p = new int(7);
   *     {   // Captured variable
   *         name: "p",
   *         value: "0x00500500",
   *         type: "int*",
   *         members { value: "7", type: "int" } }
   * 6) An unnamed pointer where the pointee was not captured:
   *     int* p = new int(7);
   *     int** pp = &amp;p;
   *     {  // Captured variable
   *         name: "pp",
   *         value: "0x00500500",
   *         type: "int**",
   *         members {
   *             value: "0x00400400",
   *             type: "int*"
   *             status {
   *                 is_error: true,
   *                 description: { format: "unavailable" } }
   *             }
   *         }
   *     }
   * To optimize computation, memory and network traffic, variables that
   * repeat in the output multiple times can be stored once in a shared
   * variable table and be referenced using the `var_table_index` field.  The
   * variables stored in the shared table are nameless and are essentially
   * a partition of the complete variable. To reconstruct the complete
   * variable, merge the referencing variable with the referenced variable.
   * When using the shared variable table, the following variables:
   *     T x = { 3, 7 };
   *     T* p = &amp;x;
   *     T&amp; r = x;
   *     { name: "x", var_table_index: 3, type: "T" }  // Captured variables
   *     { name: "p", value "0x00500500", type="T*", var_table_index: 3 }
   *     { name: "r", type="T&amp;", var_table_index: 3 }
   *     {  // Shared variable table entry #3:
   *         members { name: "m1", value: "3", type: "int" },
   *         members { name: "m2", value: "7", type: "int" }
   *     }
   * Note that the pointer address is stored with the referencing variable
   * and not with the referenced variable. This allows the referenced variable
   * to be shared between pointers and references.
   * The type field is optional. The debugger agent may or may not support it.
   * </pre>
   *
   * Protobuf type {@code google.devtools.clouddebugger.v2.Variable}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.clouddebugger.v2.Variable)
      com.google.devtools.clouddebugger.v2.VariableOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Variable_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Variable_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.clouddebugger.v2.Variable.class,
              com.google.devtools.clouddebugger.v2.Variable.Builder.class);
    }

    // Construct using com.google.devtools.clouddebugger.v2.Variable.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      value_ = "";

      type_ = "";

      if (membersBuilder_ == null) {
        members_ = java.util.Collections.emptyList();
      } else {
        members_ = null;
        membersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (varTableIndexBuilder_ == null) {
        varTableIndex_ = null;
      } else {
        varTableIndex_ = null;
        varTableIndexBuilder_ = null;
      }
      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Variable_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Variable getDefaultInstanceForType() {
      return com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Variable build() {
      com.google.devtools.clouddebugger.v2.Variable result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Variable buildPartial() {
      com.google.devtools.clouddebugger.v2.Variable result =
          new com.google.devtools.clouddebugger.v2.Variable(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.value_ = value_;
      result.type_ = type_;
      if (membersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          members_ = java.util.Collections.unmodifiableList(members_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.members_ = members_;
      } else {
        result.members_ = membersBuilder_.build();
      }
      if (varTableIndexBuilder_ == null) {
        result.varTableIndex_ = varTableIndex_;
      } else {
        result.varTableIndex_ = varTableIndexBuilder_.build();
      }
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.clouddebugger.v2.Variable) {
        return mergeFrom((com.google.devtools.clouddebugger.v2.Variable) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.clouddebugger.v2.Variable other) {
      if (other == com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getValue().isEmpty()) {
        value_ = other.value_;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        onChanged();
      }
      if (membersBuilder_ == null) {
        if (!other.members_.isEmpty()) {
          if (members_.isEmpty()) {
            members_ = other.members_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMembersIsMutable();
            members_.addAll(other.members_);
          }
          onChanged();
        }
      } else {
        if (!other.members_.isEmpty()) {
          if (membersBuilder_.isEmpty()) {
            membersBuilder_.dispose();
            membersBuilder_ = null;
            members_ = other.members_;
            bitField0_ = (bitField0_ & ~0x00000001);
            membersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMembersFieldBuilder()
                    : null;
          } else {
            membersBuilder_.addAllMessages(other.members_);
          }
        }
      }
      if (other.hasVarTableIndex()) {
        mergeVarTableIndex(other.getVarTableIndex());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                value_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.devtools.clouddebugger.v2.Variable m =
                    input.readMessage(
                        com.google.devtools.clouddebugger.v2.Variable.parser(), extensionRegistry);
                if (membersBuilder_ == null) {
                  ensureMembersIsMutable();
                  members_.add(m);
                } else {
                  membersBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getVarTableIndexFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                type_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the variable, if any.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the variable, if any.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the variable, if any.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the variable, if any.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the variable, if any.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * Simple value of the variable.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Simple value of the variable.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Simple value of the variable.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Simple value of the variable.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {

      value_ = getDefaultInstance().getValue();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Simple value of the variable.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @param value The bytes for value to set.
     * @return This builder for chaining.
     */
    public Builder setValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      value_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Variable type (e.g. `MyClass`). If the variable is split with
     * `var_table_index`, `type` goes next to `value`. The interpretation of
     * a type is agent specific. It is recommended to include the dynamic type
     * rather than a static type of an object.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Variable type (e.g. `MyClass`). If the variable is split with
     * `var_table_index`, `type` goes next to `value`. The interpretation of
     * a type is agent specific. It is recommended to include the dynamic type
     * rather than a static type of an object.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Variable type (e.g. `MyClass`). If the variable is split with
     * `var_table_index`, `type` goes next to `value`. The interpretation of
     * a type is agent specific. It is recommended to include the dynamic type
     * rather than a static type of an object.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Variable type (e.g. `MyClass`). If the variable is split with
     * `var_table_index`, `type` goes next to `value`. The interpretation of
     * a type is agent specific. It is recommended to include the dynamic type
     * rather than a static type of an object.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = getDefaultInstance().getType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Variable type (e.g. `MyClass`). If the variable is split with
     * `var_table_index`, `type` goes next to `value`. The interpretation of
     * a type is agent specific. It is recommended to include the dynamic type
     * rather than a static type of an object.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      type_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.devtools.clouddebugger.v2.Variable> members_ =
        java.util.Collections.emptyList();

    private void ensureMembersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        members_ = new java.util.ArrayList<com.google.devtools.clouddebugger.v2.Variable>(members_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        membersBuilder_;

    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getMembersList() {
      if (membersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(members_);
      } else {
        return membersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public int getMembersCount() {
      if (membersBuilder_ == null) {
        return members_.size();
      } else {
        return membersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable getMembers(int index) {
      if (membersBuilder_ == null) {
        return members_.get(index);
      } else {
        return membersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder setMembers(int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (membersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembersIsMutable();
        members_.set(index, value);
        onChanged();
      } else {
        membersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder setMembers(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (membersBuilder_ == null) {
        ensureMembersIsMutable();
        members_.set(index, builderForValue.build());
        onChanged();
      } else {
        membersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder addMembers(com.google.devtools.clouddebugger.v2.Variable value) {
      if (membersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembersIsMutable();
        members_.add(value);
        onChanged();
      } else {
        membersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder addMembers(int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (membersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembersIsMutable();
        members_.add(index, value);
        onChanged();
      } else {
        membersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder addMembers(
        com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (membersBuilder_ == null) {
        ensureMembersIsMutable();
        members_.add(builderForValue.build());
        onChanged();
      } else {
        membersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder addMembers(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (membersBuilder_ == null) {
        ensureMembersIsMutable();
        members_.add(index, builderForValue.build());
        onChanged();
      } else {
        membersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder addAllMembers(
        java.lang.Iterable<? extends com.google.devtools.clouddebugger.v2.Variable> values) {
      if (membersBuilder_ == null) {
        ensureMembersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, members_);
        onChanged();
      } else {
        membersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder clearMembers() {
      if (membersBuilder_ == null) {
        members_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        membersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public Builder removeMembers(int index) {
      if (membersBuilder_ == null) {
        ensureMembersIsMutable();
        members_.remove(index);
        onChanged();
      } else {
        membersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder getMembersBuilder(int index) {
      return getMembersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.VariableOrBuilder getMembersOrBuilder(int index) {
      if (membersBuilder_ == null) {
        return members_.get(index);
      } else {
        return membersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getMembersOrBuilderList() {
      if (membersBuilder_ != null) {
        return membersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(members_);
      }
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addMembersBuilder() {
      return getMembersFieldBuilder()
          .addBuilder(com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addMembersBuilder(int index) {
      return getMembersFieldBuilder()
          .addBuilder(index, com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Members contained or pointed to by the variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable members = 3;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable.Builder>
        getMembersBuilderList() {
      return getMembersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getMembersFieldBuilder() {
      if (membersBuilder_ == null) {
        membersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.Variable,
                com.google.devtools.clouddebugger.v2.Variable.Builder,
                com.google.devtools.clouddebugger.v2.VariableOrBuilder>(
                members_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        members_ = null;
      }
      return membersBuilder_;
    }

    private com.google.protobuf.Int32Value varTableIndex_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        varTableIndexBuilder_;
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     *
     * @return Whether the varTableIndex field is set.
     */
    public boolean hasVarTableIndex() {
      return varTableIndexBuilder_ != null || varTableIndex_ != null;
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     *
     * @return The varTableIndex.
     */
    public com.google.protobuf.Int32Value getVarTableIndex() {
      if (varTableIndexBuilder_ == null) {
        return varTableIndex_ == null
            ? com.google.protobuf.Int32Value.getDefaultInstance()
            : varTableIndex_;
      } else {
        return varTableIndexBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    public Builder setVarTableIndex(com.google.protobuf.Int32Value value) {
      if (varTableIndexBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        varTableIndex_ = value;
        onChanged();
      } else {
        varTableIndexBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    public Builder setVarTableIndex(com.google.protobuf.Int32Value.Builder builderForValue) {
      if (varTableIndexBuilder_ == null) {
        varTableIndex_ = builderForValue.build();
        onChanged();
      } else {
        varTableIndexBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    public Builder mergeVarTableIndex(com.google.protobuf.Int32Value value) {
      if (varTableIndexBuilder_ == null) {
        if (varTableIndex_ != null) {
          varTableIndex_ =
              com.google.protobuf.Int32Value.newBuilder(varTableIndex_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          varTableIndex_ = value;
        }
        onChanged();
      } else {
        varTableIndexBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    public Builder clearVarTableIndex() {
      if (varTableIndexBuilder_ == null) {
        varTableIndex_ = null;
        onChanged();
      } else {
        varTableIndex_ = null;
        varTableIndexBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    public com.google.protobuf.Int32Value.Builder getVarTableIndexBuilder() {

      onChanged();
      return getVarTableIndexFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    public com.google.protobuf.Int32ValueOrBuilder getVarTableIndexOrBuilder() {
      if (varTableIndexBuilder_ != null) {
        return varTableIndexBuilder_.getMessageOrBuilder();
      } else {
        return varTableIndex_ == null
            ? com.google.protobuf.Int32Value.getDefaultInstance()
            : varTableIndex_;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to a variable in the shared variable table. More than
     * one variable can reference the same variable in the table. The
     * `var_table_index` field is an index into `variable_table` in Breakpoint.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value var_table_index = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        getVarTableIndexFieldBuilder() {
      if (varTableIndexBuilder_ == null) {
        varTableIndexBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int32Value,
                com.google.protobuf.Int32Value.Builder,
                com.google.protobuf.Int32ValueOrBuilder>(
                getVarTableIndex(), getParentForChildren(), isClean());
        varTableIndex_ = null;
      }
      return varTableIndexBuilder_;
    }

    private com.google.devtools.clouddebugger.v2.StatusMessage status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StatusMessage,
            com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
            com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     *
     * @return The status.
     */
    public com.google.devtools.clouddebugger.v2.StatusMessage getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    public Builder setStatus(com.google.devtools.clouddebugger.v2.StatusMessage value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    public Builder setStatus(
        com.google.devtools.clouddebugger.v2.StatusMessage.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    public Builder mergeStatus(com.google.devtools.clouddebugger.v2.StatusMessage value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ =
              com.google.devtools.clouddebugger.v2.StatusMessage.newBuilder(status_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    public com.google.devtools.clouddebugger.v2.StatusMessage.Builder getStatusBuilder() {

      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    public com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Status associated with the variable. This field will usually stay
     * unset. A status of a single variable only applies to that variable or
     * expression. The rest of breakpoint data still remains valid. Variables
     * might be reported in error state even when breakpoint is not in final
     * state.
     * The message may refer to variable name with `refers_to` set to
     * `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
     * In either case variable value and members will be unset.
     * Example of error message applied to name: `Invalid expression syntax`.
     * Example of information message applied to value: `Not captured`.
     * Examples of error message applied to value:
     * *   `Malformed string`,
     * *   `Field f not found in class C`
     * *   `Null pointer dereference`
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StatusMessage,
            com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
            com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.StatusMessage,
                com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
                com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.clouddebugger.v2.Variable)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.clouddebugger.v2.Variable)
  private static final com.google.devtools.clouddebugger.v2.Variable DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.clouddebugger.v2.Variable();
  }

  public static com.google.devtools.clouddebugger.v2.Variable getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Variable> PARSER =
      new com.google.protobuf.AbstractParser<Variable>() {
        @java.lang.Override
        public Variable parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Variable> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Variable> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Variable getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
