/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/data.proto

package com.google.devtools.clouddebugger.v2;

/**
 *
 *
 * <pre>
 * Represents a stack frame context.
 * </pre>
 *
 * Protobuf type {@code google.devtools.clouddebugger.v2.StackFrame}
 */
public final class StackFrame extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.clouddebugger.v2.StackFrame)
    StackFrameOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StackFrame.newBuilder() to construct.
  private StackFrame(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StackFrame() {
    function_ = "";
    arguments_ = java.util.Collections.emptyList();
    locals_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StackFrame();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_StackFrame_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_StackFrame_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.clouddebugger.v2.StackFrame.class,
            com.google.devtools.clouddebugger.v2.StackFrame.Builder.class);
  }

  public static final int FUNCTION_FIELD_NUMBER = 1;
  private volatile java.lang.Object function_;
  /**
   *
   *
   * <pre>
   * Demangled function name at the call site.
   * </pre>
   *
   * <code>string function = 1;</code>
   *
   * @return The function.
   */
  @java.lang.Override
  public java.lang.String getFunction() {
    java.lang.Object ref = function_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      function_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Demangled function name at the call site.
   * </pre>
   *
   * <code>string function = 1;</code>
   *
   * @return The bytes for function.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFunctionBytes() {
    java.lang.Object ref = function_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      function_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 2;
  private com.google.devtools.clouddebugger.v2.SourceLocation location_;
  /**
   *
   *
   * <pre>
   * Source location of the call site.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return location_ != null;
  }
  /**
   *
   *
   * <pre>
   * Source location of the call site.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.SourceLocation getLocation() {
    return location_ == null
        ? com.google.devtools.clouddebugger.v2.SourceLocation.getDefaultInstance()
        : location_;
  }
  /**
   *
   *
   * <pre>
   * Source location of the call site.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder getLocationOrBuilder() {
    return getLocation();
  }

  public static final int ARGUMENTS_FIELD_NUMBER = 3;
  private java.util.List<com.google.devtools.clouddebugger.v2.Variable> arguments_;
  /**
   *
   *
   * <pre>
   * Set of arguments passed to this function.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getArgumentsList() {
    return arguments_;
  }
  /**
   *
   *
   * <pre>
   * Set of arguments passed to this function.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getArgumentsOrBuilderList() {
    return arguments_;
  }
  /**
   *
   *
   * <pre>
   * Set of arguments passed to this function.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
   */
  @java.lang.Override
  public int getArgumentsCount() {
    return arguments_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of arguments passed to this function.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Variable getArguments(int index) {
    return arguments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of arguments passed to this function.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.VariableOrBuilder getArgumentsOrBuilder(int index) {
    return arguments_.get(index);
  }

  public static final int LOCALS_FIELD_NUMBER = 4;
  private java.util.List<com.google.devtools.clouddebugger.v2.Variable> locals_;
  /**
   *
   *
   * <pre>
   * Set of local variables at the stack frame location.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getLocalsList() {
    return locals_;
  }
  /**
   *
   *
   * <pre>
   * Set of local variables at the stack frame location.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getLocalsOrBuilderList() {
    return locals_;
  }
  /**
   *
   *
   * <pre>
   * Set of local variables at the stack frame location.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
   */
  @java.lang.Override
  public int getLocalsCount() {
    return locals_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of local variables at the stack frame location.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Variable getLocals(int index) {
    return locals_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of local variables at the stack frame location.
   * Note that this might not be populated for all stack frames.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.VariableOrBuilder getLocalsOrBuilder(int index) {
    return locals_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(function_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, function_);
    }
    if (location_ != null) {
      output.writeMessage(2, getLocation());
    }
    for (int i = 0; i < arguments_.size(); i++) {
      output.writeMessage(3, arguments_.get(i));
    }
    for (int i = 0; i < locals_.size(); i++) {
      output.writeMessage(4, locals_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(function_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, function_);
    }
    if (location_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLocation());
    }
    for (int i = 0; i < arguments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, arguments_.get(i));
    }
    for (int i = 0; i < locals_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, locals_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.clouddebugger.v2.StackFrame)) {
      return super.equals(obj);
    }
    com.google.devtools.clouddebugger.v2.StackFrame other =
        (com.google.devtools.clouddebugger.v2.StackFrame) obj;

    if (!getFunction().equals(other.getFunction())) return false;
    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (!getArgumentsList().equals(other.getArgumentsList())) return false;
    if (!getLocalsList().equals(other.getLocalsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FUNCTION_FIELD_NUMBER;
    hash = (53 * hash) + getFunction().hashCode();
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    if (getArgumentsCount() > 0) {
      hash = (37 * hash) + ARGUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getArgumentsList().hashCode();
    }
    if (getLocalsCount() > 0) {
      hash = (37 * hash) + LOCALS_FIELD_NUMBER;
      hash = (53 * hash) + getLocalsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.clouddebugger.v2.StackFrame prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a stack frame context.
   * </pre>
   *
   * Protobuf type {@code google.devtools.clouddebugger.v2.StackFrame}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.clouddebugger.v2.StackFrame)
      com.google.devtools.clouddebugger.v2.StackFrameOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_StackFrame_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_StackFrame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.clouddebugger.v2.StackFrame.class,
              com.google.devtools.clouddebugger.v2.StackFrame.Builder.class);
    }

    // Construct using com.google.devtools.clouddebugger.v2.StackFrame.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      function_ = "";

      if (locationBuilder_ == null) {
        location_ = null;
      } else {
        location_ = null;
        locationBuilder_ = null;
      }
      if (argumentsBuilder_ == null) {
        arguments_ = java.util.Collections.emptyList();
      } else {
        arguments_ = null;
        argumentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (localsBuilder_ == null) {
        locals_ = java.util.Collections.emptyList();
      } else {
        locals_ = null;
        localsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_StackFrame_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.StackFrame getDefaultInstanceForType() {
      return com.google.devtools.clouddebugger.v2.StackFrame.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.StackFrame build() {
      com.google.devtools.clouddebugger.v2.StackFrame result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.StackFrame buildPartial() {
      com.google.devtools.clouddebugger.v2.StackFrame result =
          new com.google.devtools.clouddebugger.v2.StackFrame(this);
      int from_bitField0_ = bitField0_;
      result.function_ = function_;
      if (locationBuilder_ == null) {
        result.location_ = location_;
      } else {
        result.location_ = locationBuilder_.build();
      }
      if (argumentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          arguments_ = java.util.Collections.unmodifiableList(arguments_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.arguments_ = arguments_;
      } else {
        result.arguments_ = argumentsBuilder_.build();
      }
      if (localsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          locals_ = java.util.Collections.unmodifiableList(locals_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.locals_ = locals_;
      } else {
        result.locals_ = localsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.clouddebugger.v2.StackFrame) {
        return mergeFrom((com.google.devtools.clouddebugger.v2.StackFrame) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.clouddebugger.v2.StackFrame other) {
      if (other == com.google.devtools.clouddebugger.v2.StackFrame.getDefaultInstance())
        return this;
      if (!other.getFunction().isEmpty()) {
        function_ = other.function_;
        onChanged();
      }
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (argumentsBuilder_ == null) {
        if (!other.arguments_.isEmpty()) {
          if (arguments_.isEmpty()) {
            arguments_ = other.arguments_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureArgumentsIsMutable();
            arguments_.addAll(other.arguments_);
          }
          onChanged();
        }
      } else {
        if (!other.arguments_.isEmpty()) {
          if (argumentsBuilder_.isEmpty()) {
            argumentsBuilder_.dispose();
            argumentsBuilder_ = null;
            arguments_ = other.arguments_;
            bitField0_ = (bitField0_ & ~0x00000001);
            argumentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getArgumentsFieldBuilder()
                    : null;
          } else {
            argumentsBuilder_.addAllMessages(other.arguments_);
          }
        }
      }
      if (localsBuilder_ == null) {
        if (!other.locals_.isEmpty()) {
          if (locals_.isEmpty()) {
            locals_ = other.locals_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLocalsIsMutable();
            locals_.addAll(other.locals_);
          }
          onChanged();
        }
      } else {
        if (!other.locals_.isEmpty()) {
          if (localsBuilder_.isEmpty()) {
            localsBuilder_.dispose();
            localsBuilder_ = null;
            locals_ = other.locals_;
            bitField0_ = (bitField0_ & ~0x00000002);
            localsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocalsFieldBuilder()
                    : null;
          } else {
            localsBuilder_.addAllMessages(other.locals_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                function_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                com.google.devtools.clouddebugger.v2.Variable m =
                    input.readMessage(
                        com.google.devtools.clouddebugger.v2.Variable.parser(), extensionRegistry);
                if (argumentsBuilder_ == null) {
                  ensureArgumentsIsMutable();
                  arguments_.add(m);
                } else {
                  argumentsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.devtools.clouddebugger.v2.Variable m =
                    input.readMessage(
                        com.google.devtools.clouddebugger.v2.Variable.parser(), extensionRegistry);
                if (localsBuilder_ == null) {
                  ensureLocalsIsMutable();
                  locals_.add(m);
                } else {
                  localsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object function_ = "";
    /**
     *
     *
     * <pre>
     * Demangled function name at the call site.
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @return The function.
     */
    public java.lang.String getFunction() {
      java.lang.Object ref = function_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        function_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Demangled function name at the call site.
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @return The bytes for function.
     */
    public com.google.protobuf.ByteString getFunctionBytes() {
      java.lang.Object ref = function_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        function_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Demangled function name at the call site.
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @param value The function to set.
     * @return This builder for chaining.
     */
    public Builder setFunction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      function_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Demangled function name at the call site.
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFunction() {

      function_ = getDefaultInstance().getFunction();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Demangled function name at the call site.
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @param value The bytes for function to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      function_ = value;
      onChanged();
      return this;
    }

    private com.google.devtools.clouddebugger.v2.SourceLocation location_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.SourceLocation,
            com.google.devtools.clouddebugger.v2.SourceLocation.Builder,
            com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder>
        locationBuilder_;
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return locationBuilder_ != null || location_ != null;
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     *
     * @return The location.
     */
    public com.google.devtools.clouddebugger.v2.SourceLocation getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null
            ? com.google.devtools.clouddebugger.v2.SourceLocation.getDefaultInstance()
            : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder setLocation(com.google.devtools.clouddebugger.v2.SourceLocation value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        locationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder setLocation(
        com.google.devtools.clouddebugger.v2.SourceLocation.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder mergeLocation(com.google.devtools.clouddebugger.v2.SourceLocation value) {
      if (locationBuilder_ == null) {
        if (location_ != null) {
          location_ =
              com.google.devtools.clouddebugger.v2.SourceLocation.newBuilder(location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        locationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder clearLocation() {
      if (locationBuilder_ == null) {
        location_ = null;
        onChanged();
      } else {
        location_ = null;
        locationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public com.google.devtools.clouddebugger.v2.SourceLocation.Builder getLocationBuilder() {

      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null
            ? com.google.devtools.clouddebugger.v2.SourceLocation.getDefaultInstance()
            : location_;
      }
    }
    /**
     *
     *
     * <pre>
     * Source location of the call site.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.SourceLocation,
            com.google.devtools.clouddebugger.v2.SourceLocation.Builder,
            com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder>
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.SourceLocation,
                com.google.devtools.clouddebugger.v2.SourceLocation.Builder,
                com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder>(
                getLocation(), getParentForChildren(), isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private java.util.List<com.google.devtools.clouddebugger.v2.Variable> arguments_ =
        java.util.Collections.emptyList();

    private void ensureArgumentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        arguments_ =
            new java.util.ArrayList<com.google.devtools.clouddebugger.v2.Variable>(arguments_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        argumentsBuilder_;

    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getArgumentsList() {
      if (argumentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(arguments_);
      } else {
        return argumentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public int getArgumentsCount() {
      if (argumentsBuilder_ == null) {
        return arguments_.size();
      } else {
        return argumentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable getArguments(int index) {
      if (argumentsBuilder_ == null) {
        return arguments_.get(index);
      } else {
        return argumentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder setArguments(int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (argumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgumentsIsMutable();
        arguments_.set(index, value);
        onChanged();
      } else {
        argumentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder setArguments(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (argumentsBuilder_ == null) {
        ensureArgumentsIsMutable();
        arguments_.set(index, builderForValue.build());
        onChanged();
      } else {
        argumentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder addArguments(com.google.devtools.clouddebugger.v2.Variable value) {
      if (argumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgumentsIsMutable();
        arguments_.add(value);
        onChanged();
      } else {
        argumentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder addArguments(int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (argumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgumentsIsMutable();
        arguments_.add(index, value);
        onChanged();
      } else {
        argumentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder addArguments(
        com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (argumentsBuilder_ == null) {
        ensureArgumentsIsMutable();
        arguments_.add(builderForValue.build());
        onChanged();
      } else {
        argumentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder addArguments(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (argumentsBuilder_ == null) {
        ensureArgumentsIsMutable();
        arguments_.add(index, builderForValue.build());
        onChanged();
      } else {
        argumentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder addAllArguments(
        java.lang.Iterable<? extends com.google.devtools.clouddebugger.v2.Variable> values) {
      if (argumentsBuilder_ == null) {
        ensureArgumentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, arguments_);
        onChanged();
      } else {
        argumentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder clearArguments() {
      if (argumentsBuilder_ == null) {
        arguments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        argumentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public Builder removeArguments(int index) {
      if (argumentsBuilder_ == null) {
        ensureArgumentsIsMutable();
        arguments_.remove(index);
        onChanged();
      } else {
        argumentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder getArgumentsBuilder(int index) {
      return getArgumentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.VariableOrBuilder getArgumentsOrBuilder(int index) {
      if (argumentsBuilder_ == null) {
        return arguments_.get(index);
      } else {
        return argumentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getArgumentsOrBuilderList() {
      if (argumentsBuilder_ != null) {
        return argumentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(arguments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addArgumentsBuilder() {
      return getArgumentsFieldBuilder()
          .addBuilder(com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addArgumentsBuilder(int index) {
      return getArgumentsFieldBuilder()
          .addBuilder(index, com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of arguments passed to this function.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable arguments = 3;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable.Builder>
        getArgumentsBuilderList() {
      return getArgumentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getArgumentsFieldBuilder() {
      if (argumentsBuilder_ == null) {
        argumentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.Variable,
                com.google.devtools.clouddebugger.v2.Variable.Builder,
                com.google.devtools.clouddebugger.v2.VariableOrBuilder>(
                arguments_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        arguments_ = null;
      }
      return argumentsBuilder_;
    }

    private java.util.List<com.google.devtools.clouddebugger.v2.Variable> locals_ =
        java.util.Collections.emptyList();

    private void ensureLocalsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        locals_ = new java.util.ArrayList<com.google.devtools.clouddebugger.v2.Variable>(locals_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        localsBuilder_;

    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getLocalsList() {
      if (localsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(locals_);
      } else {
        return localsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public int getLocalsCount() {
      if (localsBuilder_ == null) {
        return locals_.size();
      } else {
        return localsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable getLocals(int index) {
      if (localsBuilder_ == null) {
        return locals_.get(index);
      } else {
        return localsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder setLocals(int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (localsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalsIsMutable();
        locals_.set(index, value);
        onChanged();
      } else {
        localsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder setLocals(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (localsBuilder_ == null) {
        ensureLocalsIsMutable();
        locals_.set(index, builderForValue.build());
        onChanged();
      } else {
        localsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder addLocals(com.google.devtools.clouddebugger.v2.Variable value) {
      if (localsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalsIsMutable();
        locals_.add(value);
        onChanged();
      } else {
        localsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder addLocals(int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (localsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalsIsMutable();
        locals_.add(index, value);
        onChanged();
      } else {
        localsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder addLocals(
        com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (localsBuilder_ == null) {
        ensureLocalsIsMutable();
        locals_.add(builderForValue.build());
        onChanged();
      } else {
        localsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder addLocals(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (localsBuilder_ == null) {
        ensureLocalsIsMutable();
        locals_.add(index, builderForValue.build());
        onChanged();
      } else {
        localsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder addAllLocals(
        java.lang.Iterable<? extends com.google.devtools.clouddebugger.v2.Variable> values) {
      if (localsBuilder_ == null) {
        ensureLocalsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locals_);
        onChanged();
      } else {
        localsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder clearLocals() {
      if (localsBuilder_ == null) {
        locals_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        localsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public Builder removeLocals(int index) {
      if (localsBuilder_ == null) {
        ensureLocalsIsMutable();
        locals_.remove(index);
        onChanged();
      } else {
        localsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder getLocalsBuilder(int index) {
      return getLocalsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public com.google.devtools.clouddebugger.v2.VariableOrBuilder getLocalsOrBuilder(int index) {
      if (localsBuilder_ == null) {
        return locals_.get(index);
      } else {
        return localsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getLocalsOrBuilderList() {
      if (localsBuilder_ != null) {
        return localsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(locals_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addLocalsBuilder() {
      return getLocalsFieldBuilder()
          .addBuilder(com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addLocalsBuilder(int index) {
      return getLocalsFieldBuilder()
          .addBuilder(index, com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of local variables at the stack frame location.
     * Note that this might not be populated for all stack frames.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable locals = 4;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable.Builder>
        getLocalsBuilderList() {
      return getLocalsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getLocalsFieldBuilder() {
      if (localsBuilder_ == null) {
        localsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.Variable,
                com.google.devtools.clouddebugger.v2.Variable.Builder,
                com.google.devtools.clouddebugger.v2.VariableOrBuilder>(
                locals_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        locals_ = null;
      }
      return localsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.clouddebugger.v2.StackFrame)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.clouddebugger.v2.StackFrame)
  private static final com.google.devtools.clouddebugger.v2.StackFrame DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.clouddebugger.v2.StackFrame();
  }

  public static com.google.devtools.clouddebugger.v2.StackFrame getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StackFrame> PARSER =
      new com.google.protobuf.AbstractParser<StackFrame>() {
        @java.lang.Override
        public StackFrame parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StackFrame> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StackFrame> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StackFrame getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
