/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/debugger.proto

package com.google.devtools.clouddebugger.v2;

/**
 *
 *
 * <pre>
 * Request to list breakpoints.
 * </pre>
 *
 * Protobuf type {@code google.devtools.clouddebugger.v2.ListBreakpointsRequest}
 */
public final class ListBreakpointsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.clouddebugger.v2.ListBreakpointsRequest)
    ListBreakpointsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListBreakpointsRequest.newBuilder() to construct.
  private ListBreakpointsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListBreakpointsRequest() {
    debuggeeId_ = "";
    waitToken_ = "";
    clientVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListBreakpointsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.clouddebugger.v2.DebuggerProto
        .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.clouddebugger.v2.DebuggerProto
        .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.class,
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.Builder.class);
  }

  public interface BreakpointActionValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Only breakpoints with the specified action will pass the filter.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
     *
     * @return The enum numeric value on the wire for value.
     */
    int getValueValue();
    /**
     *
     *
     * <pre>
     * Only breakpoints with the specified action will pass the filter.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
     *
     * @return The value.
     */
    com.google.devtools.clouddebugger.v2.Breakpoint.Action getValue();
  }
  /**
   *
   *
   * <pre>
   * Wrapper message for `Breakpoint.Action`. Defines a filter on the action
   * field of breakpoints.
   * </pre>
   *
   * Protobuf type {@code
   * google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue}
   */
  public static final class BreakpointActionValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)
      BreakpointActionValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BreakpointActionValue.newBuilder() to construct.
    private BreakpointActionValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BreakpointActionValue() {
      value_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BreakpointActionValue();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.DebuggerProto
          .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_BreakpointActionValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.clouddebugger.v2.DebuggerProto
          .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_BreakpointActionValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                  .class,
              com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                  .Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private int value_;
    /**
     *
     *
     * <pre>
     * Only breakpoints with the specified action will pass the filter.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
     *
     * @return The enum numeric value on the wire for value.
     */
    @java.lang.Override
    public int getValueValue() {
      return value_;
    }
    /**
     *
     *
     * <pre>
     * Only breakpoints with the specified action will pass the filter.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Breakpoint.Action getValue() {
      @SuppressWarnings("deprecation")
      com.google.devtools.clouddebugger.v2.Breakpoint.Action result =
          com.google.devtools.clouddebugger.v2.Breakpoint.Action.valueOf(value_);
      return result == null
          ? com.google.devtools.clouddebugger.v2.Breakpoint.Action.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (value_ != com.google.devtools.clouddebugger.v2.Breakpoint.Action.CAPTURE.getNumber()) {
        output.writeEnum(1, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (value_ != com.google.devtools.clouddebugger.v2.Breakpoint.Action.CAPTURE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)) {
        return super.equals(obj);
      }
      com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue other =
          (com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue) obj;

      if (value_ != other.value_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + value_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Wrapper message for `Breakpoint.Action`. Defines a filter on the action
     * field of breakpoints.
     * </pre>
     *
     * Protobuf type {@code
     * google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.devtools.clouddebugger.v2.DebuggerProto
            .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_BreakpointActionValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.devtools.clouddebugger.v2.DebuggerProto
            .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_BreakpointActionValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                    .class,
                com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                    .Builder.class);
      }

      // Construct using
      // com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        value_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.devtools.clouddebugger.v2.DebuggerProto
            .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_BreakpointActionValue_descriptor;
      }

      @java.lang.Override
      public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
          getDefaultInstanceForType() {
        return com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
          build() {
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
          buildPartial() {
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue result =
            new com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue(
                this);
        result.value_ = value_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue) {
          return mergeFrom(
              (com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue other) {
        if (other
            == com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                .getDefaultInstance()) return this;
        if (other.value_ != 0) {
          setValueValue(other.getValueValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  value_ = input.readEnum();

                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int value_ = 0;
      /**
       *
       *
       * <pre>
       * Only breakpoints with the specified action will pass the filter.
       * </pre>
       *
       * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
       *
       * @return The enum numeric value on the wire for value.
       */
      @java.lang.Override
      public int getValueValue() {
        return value_;
      }
      /**
       *
       *
       * <pre>
       * Only breakpoints with the specified action will pass the filter.
       * </pre>
       *
       * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
       *
       * @param value The enum numeric value on the wire for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueValue(int value) {

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only breakpoints with the specified action will pass the filter.
       * </pre>
       *
       * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.devtools.clouddebugger.v2.Breakpoint.Action getValue() {
        @SuppressWarnings("deprecation")
        com.google.devtools.clouddebugger.v2.Breakpoint.Action result =
            com.google.devtools.clouddebugger.v2.Breakpoint.Action.valueOf(value_);
        return result == null
            ? com.google.devtools.clouddebugger.v2.Breakpoint.Action.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Only breakpoints with the specified action will pass the filter.
       * </pre>
       *
       * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(com.google.devtools.clouddebugger.v2.Breakpoint.Action value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only breakpoints with the specified action will pass the filter.
       * </pre>
       *
       * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue)
    private static final com.google.devtools.clouddebugger.v2.ListBreakpointsRequest
            .BreakpointActionValue
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue();
    }

    public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BreakpointActionValue> PARSER =
        new com.google.protobuf.AbstractParser<BreakpointActionValue>() {
          @java.lang.Override
          public BreakpointActionValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BreakpointActionValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BreakpointActionValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DEBUGGEE_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object debuggeeId_;
  /**
   *
   *
   * <pre>
   * Required. ID of the debuggee whose breakpoints to list.
   * </pre>
   *
   * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The debuggeeId.
   */
  @java.lang.Override
  public java.lang.String getDebuggeeId() {
    java.lang.Object ref = debuggeeId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      debuggeeId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the debuggee whose breakpoints to list.
   * </pre>
   *
   * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for debuggeeId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDebuggeeIdBytes() {
    java.lang.Object ref = debuggeeId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      debuggeeId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_ALL_USERS_FIELD_NUMBER = 2;
  private boolean includeAllUsers_;
  /**
   *
   *
   * <pre>
   * When set to `true`, the response includes the list of breakpoints set by
   * any user. Otherwise, it includes only breakpoints set by the caller.
   * </pre>
   *
   * <code>bool include_all_users = 2;</code>
   *
   * @return The includeAllUsers.
   */
  @java.lang.Override
  public boolean getIncludeAllUsers() {
    return includeAllUsers_;
  }

  public static final int INCLUDE_INACTIVE_FIELD_NUMBER = 3;
  private boolean includeInactive_;
  /**
   *
   *
   * <pre>
   * When set to `true`, the response includes active and inactive
   * breakpoints. Otherwise, it includes only active breakpoints.
   * </pre>
   *
   * <code>bool include_inactive = 3;</code>
   *
   * @return The includeInactive.
   */
  @java.lang.Override
  public boolean getIncludeInactive() {
    return includeInactive_;
  }

  public static final int ACTION_FIELD_NUMBER = 4;
  private com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action_;
  /**
   *
   *
   * <pre>
   * When set, the response includes only breakpoints with the specified action.
   * </pre>
   *
   * <code>
   * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
   * </code>
   *
   * @return Whether the action field is set.
   */
  @java.lang.Override
  public boolean hasAction() {
    return action_ != null;
  }
  /**
   *
   *
   * <pre>
   * When set, the response includes only breakpoints with the specified action.
   * </pre>
   *
   * <code>
   * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
   * </code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
      getAction() {
    return action_ == null
        ? com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
            .getDefaultInstance()
        : action_;
  }
  /**
   *
   *
   * <pre>
   * When set, the response includes only breakpoints with the specified action.
   * </pre>
   *
   * <code>
   * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValueOrBuilder
      getActionOrBuilder() {
    return getAction();
  }

  public static final int STRIP_RESULTS_FIELD_NUMBER = 5;
  private boolean stripResults_;
  /**
   *
   *
   * <pre>
   * This field is deprecated. The following fields are always stripped out of
   * the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
   * </pre>
   *
   * <code>bool strip_results = 5 [deprecated = true];</code>
   *
   * @deprecated google.devtools.clouddebugger.v2.ListBreakpointsRequest.strip_results is
   *     deprecated. See google/devtools/clouddebugger/v2/debugger.proto;l=172
   * @return The stripResults.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getStripResults() {
    return stripResults_;
  }

  public static final int WAIT_TOKEN_FIELD_NUMBER = 6;
  private volatile java.lang.Object waitToken_;
  /**
   *
   *
   * <pre>
   * A wait token that, if specified, blocks the call until the breakpoints
   * list has changed, or a server selected timeout has expired.  The value
   * should be set from the last response. The error code
   * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
   * should be called again with the same `wait_token`.
   * </pre>
   *
   * <code>string wait_token = 6;</code>
   *
   * @return The waitToken.
   */
  @java.lang.Override
  public java.lang.String getWaitToken() {
    java.lang.Object ref = waitToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      waitToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A wait token that, if specified, blocks the call until the breakpoints
   * list has changed, or a server selected timeout has expired.  The value
   * should be set from the last response. The error code
   * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
   * should be called again with the same `wait_token`.
   * </pre>
   *
   * <code>string wait_token = 6;</code>
   *
   * @return The bytes for waitToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWaitTokenBytes() {
    java.lang.Object ref = waitToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      waitToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_VERSION_FIELD_NUMBER = 8;
  private volatile java.lang.Object clientVersion_;
  /**
   *
   *
   * <pre>
   * Required. The client version making the call.
   * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
   * </pre>
   *
   * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clientVersion.
   */
  @java.lang.Override
  public java.lang.String getClientVersion() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The client version making the call.
   * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
   * </pre>
   *
   * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clientVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientVersionBytes() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(debuggeeId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, debuggeeId_);
    }
    if (includeAllUsers_ != false) {
      output.writeBool(2, includeAllUsers_);
    }
    if (includeInactive_ != false) {
      output.writeBool(3, includeInactive_);
    }
    if (action_ != null) {
      output.writeMessage(4, getAction());
    }
    if (stripResults_ != false) {
      output.writeBool(5, stripResults_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(waitToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, waitToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, clientVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(debuggeeId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, debuggeeId_);
    }
    if (includeAllUsers_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, includeAllUsers_);
    }
    if (includeInactive_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, includeInactive_);
    }
    if (action_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAction());
    }
    if (stripResults_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, stripResults_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(waitToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, waitToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, clientVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.clouddebugger.v2.ListBreakpointsRequest)) {
      return super.equals(obj);
    }
    com.google.devtools.clouddebugger.v2.ListBreakpointsRequest other =
        (com.google.devtools.clouddebugger.v2.ListBreakpointsRequest) obj;

    if (!getDebuggeeId().equals(other.getDebuggeeId())) return false;
    if (getIncludeAllUsers() != other.getIncludeAllUsers()) return false;
    if (getIncludeInactive() != other.getIncludeInactive()) return false;
    if (hasAction() != other.hasAction()) return false;
    if (hasAction()) {
      if (!getAction().equals(other.getAction())) return false;
    }
    if (getStripResults() != other.getStripResults()) return false;
    if (!getWaitToken().equals(other.getWaitToken())) return false;
    if (!getClientVersion().equals(other.getClientVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DEBUGGEE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDebuggeeId().hashCode();
    hash = (37 * hash) + INCLUDE_ALL_USERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeAllUsers());
    hash = (37 * hash) + INCLUDE_INACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeInactive());
    if (hasAction()) {
      hash = (37 * hash) + ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getAction().hashCode();
    }
    hash = (37 * hash) + STRIP_RESULTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStripResults());
    hash = (37 * hash) + WAIT_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getWaitToken().hashCode();
    hash = (37 * hash) + CLIENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getClientVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.devtools.clouddebugger.v2.ListBreakpointsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to list breakpoints.
   * </pre>
   *
   * Protobuf type {@code google.devtools.clouddebugger.v2.ListBreakpointsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.clouddebugger.v2.ListBreakpointsRequest)
      com.google.devtools.clouddebugger.v2.ListBreakpointsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.DebuggerProto
          .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.clouddebugger.v2.DebuggerProto
          .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.class,
              com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.Builder.class);
    }

    // Construct using com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      debuggeeId_ = "";

      includeAllUsers_ = false;

      includeInactive_ = false;

      if (actionBuilder_ == null) {
        action_ = null;
      } else {
        action_ = null;
        actionBuilder_ = null;
      }
      stripResults_ = false;

      waitToken_ = "";

      clientVersion_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.clouddebugger.v2.DebuggerProto
          .internal_static_google_devtools_clouddebugger_v2_ListBreakpointsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest getDefaultInstanceForType() {
      return com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest build() {
      com.google.devtools.clouddebugger.v2.ListBreakpointsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest buildPartial() {
      com.google.devtools.clouddebugger.v2.ListBreakpointsRequest result =
          new com.google.devtools.clouddebugger.v2.ListBreakpointsRequest(this);
      result.debuggeeId_ = debuggeeId_;
      result.includeAllUsers_ = includeAllUsers_;
      result.includeInactive_ = includeInactive_;
      if (actionBuilder_ == null) {
        result.action_ = action_;
      } else {
        result.action_ = actionBuilder_.build();
      }
      result.stripResults_ = stripResults_;
      result.waitToken_ = waitToken_;
      result.clientVersion_ = clientVersion_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.clouddebugger.v2.ListBreakpointsRequest) {
        return mergeFrom((com.google.devtools.clouddebugger.v2.ListBreakpointsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.clouddebugger.v2.ListBreakpointsRequest other) {
      if (other == com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.getDefaultInstance())
        return this;
      if (!other.getDebuggeeId().isEmpty()) {
        debuggeeId_ = other.debuggeeId_;
        onChanged();
      }
      if (other.getIncludeAllUsers() != false) {
        setIncludeAllUsers(other.getIncludeAllUsers());
      }
      if (other.getIncludeInactive() != false) {
        setIncludeInactive(other.getIncludeInactive());
      }
      if (other.hasAction()) {
        mergeAction(other.getAction());
      }
      if (other.getStripResults() != false) {
        setStripResults(other.getStripResults());
      }
      if (!other.getWaitToken().isEmpty()) {
        waitToken_ = other.waitToken_;
        onChanged();
      }
      if (!other.getClientVersion().isEmpty()) {
        clientVersion_ = other.clientVersion_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                debuggeeId_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                includeAllUsers_ = input.readBool();

                break;
              } // case 16
            case 24:
              {
                includeInactive_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(getActionFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                stripResults_ = input.readBool();

                break;
              } // case 40
            case 50:
              {
                waitToken_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 66:
              {
                clientVersion_ = input.readStringRequireUtf8();

                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object debuggeeId_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the debuggee whose breakpoints to list.
     * </pre>
     *
     * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The debuggeeId.
     */
    public java.lang.String getDebuggeeId() {
      java.lang.Object ref = debuggeeId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        debuggeeId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the debuggee whose breakpoints to list.
     * </pre>
     *
     * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for debuggeeId.
     */
    public com.google.protobuf.ByteString getDebuggeeIdBytes() {
      java.lang.Object ref = debuggeeId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        debuggeeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the debuggee whose breakpoints to list.
     * </pre>
     *
     * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The debuggeeId to set.
     * @return This builder for chaining.
     */
    public Builder setDebuggeeId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      debuggeeId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the debuggee whose breakpoints to list.
     * </pre>
     *
     * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDebuggeeId() {

      debuggeeId_ = getDefaultInstance().getDebuggeeId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the debuggee whose breakpoints to list.
     * </pre>
     *
     * <code>string debuggee_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for debuggeeId to set.
     * @return This builder for chaining.
     */
    public Builder setDebuggeeIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      debuggeeId_ = value;
      onChanged();
      return this;
    }

    private boolean includeAllUsers_;
    /**
     *
     *
     * <pre>
     * When set to `true`, the response includes the list of breakpoints set by
     * any user. Otherwise, it includes only breakpoints set by the caller.
     * </pre>
     *
     * <code>bool include_all_users = 2;</code>
     *
     * @return The includeAllUsers.
     */
    @java.lang.Override
    public boolean getIncludeAllUsers() {
      return includeAllUsers_;
    }
    /**
     *
     *
     * <pre>
     * When set to `true`, the response includes the list of breakpoints set by
     * any user. Otherwise, it includes only breakpoints set by the caller.
     * </pre>
     *
     * <code>bool include_all_users = 2;</code>
     *
     * @param value The includeAllUsers to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeAllUsers(boolean value) {

      includeAllUsers_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When set to `true`, the response includes the list of breakpoints set by
     * any user. Otherwise, it includes only breakpoints set by the caller.
     * </pre>
     *
     * <code>bool include_all_users = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeAllUsers() {

      includeAllUsers_ = false;
      onChanged();
      return this;
    }

    private boolean includeInactive_;
    /**
     *
     *
     * <pre>
     * When set to `true`, the response includes active and inactive
     * breakpoints. Otherwise, it includes only active breakpoints.
     * </pre>
     *
     * <code>bool include_inactive = 3;</code>
     *
     * @return The includeInactive.
     */
    @java.lang.Override
    public boolean getIncludeInactive() {
      return includeInactive_;
    }
    /**
     *
     *
     * <pre>
     * When set to `true`, the response includes active and inactive
     * breakpoints. Otherwise, it includes only active breakpoints.
     * </pre>
     *
     * <code>bool include_inactive = 3;</code>
     *
     * @param value The includeInactive to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeInactive(boolean value) {

      includeInactive_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When set to `true`, the response includes active and inactive
     * breakpoints. Otherwise, it includes only active breakpoints.
     * </pre>
     *
     * <code>bool include_inactive = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeInactive() {

      includeInactive_ = false;
      onChanged();
      return this;
    }

    private com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        action_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue,
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                .Builder,
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest
                .BreakpointActionValueOrBuilder>
        actionBuilder_;
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     *
     * @return Whether the action field is set.
     */
    public boolean hasAction() {
      return actionBuilder_ != null || action_ != null;
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     *
     * @return The action.
     */
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
        getAction() {
      if (actionBuilder_ == null) {
        return action_ == null
            ? com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                .getDefaultInstance()
            : action_;
      } else {
        return actionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    public Builder setAction(
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue value) {
      if (actionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        actionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    public Builder setAction(
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue.Builder
            builderForValue) {
      if (actionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        actionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    public Builder mergeAction(
        com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue value) {
      if (actionBuilder_ == null) {
        if (action_ != null) {
          action_ =
              com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                  .newBuilder(action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        actionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    public Builder clearAction() {
      if (actionBuilder_ == null) {
        action_ = null;
        onChanged();
      } else {
        action_ = null;
        actionBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue.Builder
        getActionBuilder() {

      onChanged();
      return getActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest
            .BreakpointActionValueOrBuilder
        getActionOrBuilder() {
      if (actionBuilder_ != null) {
        return actionBuilder_.getMessageOrBuilder();
      } else {
        return action_ == null
            ? com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                .getDefaultInstance()
            : action_;
      }
    }
    /**
     *
     *
     * <pre>
     * When set, the response includes only breakpoints with the specified action.
     * </pre>
     *
     * <code>
     * .google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue action = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue,
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                .Builder,
            com.google.devtools.clouddebugger.v2.ListBreakpointsRequest
                .BreakpointActionValueOrBuilder>
        getActionFieldBuilder() {
      if (actionBuilder_ == null) {
        actionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue,
                com.google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
                    .Builder,
                com.google.devtools.clouddebugger.v2.ListBreakpointsRequest
                    .BreakpointActionValueOrBuilder>(
                getAction(), getParentForChildren(), isClean());
        action_ = null;
      }
      return actionBuilder_;
    }

    private boolean stripResults_;
    /**
     *
     *
     * <pre>
     * This field is deprecated. The following fields are always stripped out of
     * the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
     * </pre>
     *
     * <code>bool strip_results = 5 [deprecated = true];</code>
     *
     * @deprecated google.devtools.clouddebugger.v2.ListBreakpointsRequest.strip_results is
     *     deprecated. See google/devtools/clouddebugger/v2/debugger.proto;l=172
     * @return The stripResults.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getStripResults() {
      return stripResults_;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. The following fields are always stripped out of
     * the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
     * </pre>
     *
     * <code>bool strip_results = 5 [deprecated = true];</code>
     *
     * @deprecated google.devtools.clouddebugger.v2.ListBreakpointsRequest.strip_results is
     *     deprecated. See google/devtools/clouddebugger/v2/debugger.proto;l=172
     * @param value The stripResults to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStripResults(boolean value) {

      stripResults_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. The following fields are always stripped out of
     * the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
     * </pre>
     *
     * <code>bool strip_results = 5 [deprecated = true];</code>
     *
     * @deprecated google.devtools.clouddebugger.v2.ListBreakpointsRequest.strip_results is
     *     deprecated. See google/devtools/clouddebugger/v2/debugger.proto;l=172
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearStripResults() {

      stripResults_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object waitToken_ = "";
    /**
     *
     *
     * <pre>
     * A wait token that, if specified, blocks the call until the breakpoints
     * list has changed, or a server selected timeout has expired.  The value
     * should be set from the last response. The error code
     * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
     * should be called again with the same `wait_token`.
     * </pre>
     *
     * <code>string wait_token = 6;</code>
     *
     * @return The waitToken.
     */
    public java.lang.String getWaitToken() {
      java.lang.Object ref = waitToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        waitToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A wait token that, if specified, blocks the call until the breakpoints
     * list has changed, or a server selected timeout has expired.  The value
     * should be set from the last response. The error code
     * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
     * should be called again with the same `wait_token`.
     * </pre>
     *
     * <code>string wait_token = 6;</code>
     *
     * @return The bytes for waitToken.
     */
    public com.google.protobuf.ByteString getWaitTokenBytes() {
      java.lang.Object ref = waitToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        waitToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A wait token that, if specified, blocks the call until the breakpoints
     * list has changed, or a server selected timeout has expired.  The value
     * should be set from the last response. The error code
     * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
     * should be called again with the same `wait_token`.
     * </pre>
     *
     * <code>string wait_token = 6;</code>
     *
     * @param value The waitToken to set.
     * @return This builder for chaining.
     */
    public Builder setWaitToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      waitToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A wait token that, if specified, blocks the call until the breakpoints
     * list has changed, or a server selected timeout has expired.  The value
     * should be set from the last response. The error code
     * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
     * should be called again with the same `wait_token`.
     * </pre>
     *
     * <code>string wait_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWaitToken() {

      waitToken_ = getDefaultInstance().getWaitToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A wait token that, if specified, blocks the call until the breakpoints
     * list has changed, or a server selected timeout has expired.  The value
     * should be set from the last response. The error code
     * `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
     * should be called again with the same `wait_token`.
     * </pre>
     *
     * <code>string wait_token = 6;</code>
     *
     * @param value The bytes for waitToken to set.
     * @return This builder for chaining.
     */
    public Builder setWaitTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      waitToken_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object clientVersion_ = "";
    /**
     *
     *
     * <pre>
     * Required. The client version making the call.
     * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
     * </pre>
     *
     * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clientVersion.
     */
    public java.lang.String getClientVersion() {
      java.lang.Object ref = clientVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The client version making the call.
     * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
     * </pre>
     *
     * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clientVersion.
     */
    public com.google.protobuf.ByteString getClientVersionBytes() {
      java.lang.Object ref = clientVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The client version making the call.
     * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
     * </pre>
     *
     * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clientVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The client version making the call.
     * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
     * </pre>
     *
     * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientVersion() {

      clientVersion_ = getDefaultInstance().getClientVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The client version making the call.
     * Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
     * </pre>
     *
     * <code>string client_version = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clientVersion_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.clouddebugger.v2.ListBreakpointsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.clouddebugger.v2.ListBreakpointsRequest)
  private static final com.google.devtools.clouddebugger.v2.ListBreakpointsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.clouddebugger.v2.ListBreakpointsRequest();
  }

  public static com.google.devtools.clouddebugger.v2.ListBreakpointsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListBreakpointsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListBreakpointsRequest>() {
        @java.lang.Override
        public ListBreakpointsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListBreakpointsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListBreakpointsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.ListBreakpointsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
