/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/data.proto

package com.google.devtools.clouddebugger.v2;

/**
 *
 *
 * <pre>
 * Represents the debugged application. The application may include one or more
 * replicated processes executing the same code. Each of these processes is
 * attached with a debugger agent, carrying out the debugging commands.
 * Agents attached to the same debuggee identify themselves as such by using
 * exactly the same Debuggee message value when registering.
 * </pre>
 *
 * Protobuf type {@code google.devtools.clouddebugger.v2.Debuggee}
 */
public final class Debuggee extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.clouddebugger.v2.Debuggee)
    DebuggeeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Debuggee.newBuilder() to construct.
  private Debuggee(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Debuggee() {
    id_ = "";
    project_ = "";
    uniquifier_ = "";
    description_ = "";
    agentVersion_ = "";
    sourceContexts_ = java.util.Collections.emptyList();
    extSourceContexts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Debuggee();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_Debuggee_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_Debuggee_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.clouddebugger.v2.Debuggee.class,
            com.google.devtools.clouddebugger.v2.Debuggee.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Unique identifier for the debuggee generated by the controller service.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for the debuggee generated by the controller service.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 2;
  private volatile java.lang.Object project_;
  /**
   *
   *
   * <pre>
   * Project the debuggee is associated with.
   * Use project number or id when registering a Google Cloud Platform project.
   * </pre>
   *
   * <code>string project = 2;</code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project the debuggee is associated with.
   * Use project number or id when registering a Google Cloud Platform project.
   * </pre>
   *
   * <code>string project = 2;</code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIQUIFIER_FIELD_NUMBER = 3;
  private volatile java.lang.Object uniquifier_;
  /**
   *
   *
   * <pre>
   * Uniquifier to further distinguish the application.
   * It is possible that different applications might have identical values in
   * the debuggee message, thus, incorrectly identified as a single application
   * by the Controller service. This field adds salt to further distinguish the
   * application. Agents should consider seeding this field with value that
   * identifies the code, binary, configuration and environment.
   * </pre>
   *
   * <code>string uniquifier = 3;</code>
   *
   * @return The uniquifier.
   */
  @java.lang.Override
  public java.lang.String getUniquifier() {
    java.lang.Object ref = uniquifier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uniquifier_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Uniquifier to further distinguish the application.
   * It is possible that different applications might have identical values in
   * the debuggee message, thus, incorrectly identified as a single application
   * by the Controller service. This field adds salt to further distinguish the
   * application. Agents should consider seeding this field with value that
   * identifies the code, binary, configuration and environment.
   * </pre>
   *
   * <code>string uniquifier = 3;</code>
   *
   * @return The bytes for uniquifier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUniquifierBytes() {
    java.lang.Object ref = uniquifier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uniquifier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Human readable description of the debuggee.
   * Including a human-readable project name, environment name and version
   * information is recommended.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human readable description of the debuggee.
   * Including a human-readable project name, environment name and version
   * information is recommended.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_INACTIVE_FIELD_NUMBER = 5;
  private boolean isInactive_;
  /**
   *
   *
   * <pre>
   * If set to `true`, indicates that Controller service does not detect any
   * activity from the debuggee agents and the application is possibly stopped.
   * </pre>
   *
   * <code>bool is_inactive = 5;</code>
   *
   * @return The isInactive.
   */
  @java.lang.Override
  public boolean getIsInactive() {
    return isInactive_;
  }

  public static final int AGENT_VERSION_FIELD_NUMBER = 6;
  private volatile java.lang.Object agentVersion_;
  /**
   *
   *
   * <pre>
   * Version ID of the agent.
   * Schema: `domain/language-platform/vmajor.minor` (for example
   * `google.com/java-gcp/v1.1`).
   * </pre>
   *
   * <code>string agent_version = 6;</code>
   *
   * @return The agentVersion.
   */
  @java.lang.Override
  public java.lang.String getAgentVersion() {
    java.lang.Object ref = agentVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Version ID of the agent.
   * Schema: `domain/language-platform/vmajor.minor` (for example
   * `google.com/java-gcp/v1.1`).
   * </pre>
   *
   * <code>string agent_version = 6;</code>
   *
   * @return The bytes for agentVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentVersionBytes() {
    java.lang.Object ref = agentVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_DISABLED_FIELD_NUMBER = 7;
  private boolean isDisabled_;
  /**
   *
   *
   * <pre>
   * If set to `true`, indicates that the agent should disable itself and
   * detach from the debuggee.
   * </pre>
   *
   * <code>bool is_disabled = 7;</code>
   *
   * @return The isDisabled.
   */
  @java.lang.Override
  public boolean getIsDisabled() {
    return isDisabled_;
  }

  public static final int STATUS_FIELD_NUMBER = 8;
  private com.google.devtools.clouddebugger.v2.StatusMessage status_;
  /**
   *
   *
   * <pre>
   * Human readable message to be displayed to the user about this debuggee.
   * Absence of this field indicates no status. The message can be either
   * informational or an error status.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Human readable message to be displayed to the user about this debuggee.
   * Absence of this field indicates no status. The message can be either
   * informational or an error status.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StatusMessage getStatus() {
    return status_ == null
        ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Human readable message to be displayed to the user about this debuggee.
   * Absence of this field indicates no status. The message can be either
   * informational or an error status.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  public static final int SOURCE_CONTEXTS_FIELD_NUMBER = 9;
  private java.util.List<com.google.devtools.source.v1.SourceContext> sourceContexts_;
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.source.v1.SourceContext> getSourceContextsList() {
    return sourceContexts_;
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.source.v1.SourceContextOrBuilder>
      getSourceContextsOrBuilderList() {
    return sourceContexts_;
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
   */
  @java.lang.Override
  public int getSourceContextsCount() {
    return sourceContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.SourceContext getSourceContexts(int index) {
    return sourceContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.SourceContextOrBuilder getSourceContextsOrBuilder(
      int index) {
    return sourceContexts_.get(index);
  }

  public static final int EXT_SOURCE_CONTEXTS_FIELD_NUMBER = 13;
  private java.util.List<com.google.devtools.source.v1.ExtendedSourceContext> extSourceContexts_;
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.devtools.source.v1.ExtendedSourceContext>
      getExtSourceContextsList() {
    return extSourceContexts_;
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.devtools.source.v1.ExtendedSourceContextOrBuilder>
      getExtSourceContextsOrBuilderList() {
    return extSourceContexts_;
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getExtSourceContextsCount() {
    return extSourceContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.devtools.source.v1.ExtendedSourceContext getExtSourceContexts(int index) {
    return extSourceContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * References to the locations and revisions of the source code used in the
   * deployed application.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.devtools.source.v1.ExtendedSourceContextOrBuilder getExtSourceContextsOrBuilder(
      int index) {
    return extSourceContexts_.get(index);
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.devtools.clouddebugger.v2.DataProto
                .internal_static_google_devtools_clouddebugger_v2_Debuggee_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A set of custom debuggee properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom debuggee properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom debuggee properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A set of custom debuggee properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniquifier_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uniquifier_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    if (isInactive_ != false) {
      output.writeBool(5, isInactive_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, agentVersion_);
    }
    if (isDisabled_ != false) {
      output.writeBool(7, isDisabled_);
    }
    if (status_ != null) {
      output.writeMessage(8, getStatus());
    }
    for (int i = 0; i < sourceContexts_.size(); i++) {
      output.writeMessage(9, sourceContexts_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    for (int i = 0; i < extSourceContexts_.size(); i++) {
      output.writeMessage(13, extSourceContexts_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniquifier_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uniquifier_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    if (isInactive_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, isInactive_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, agentVersion_);
    }
    if (isDisabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, isDisabled_);
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getStatus());
    }
    for (int i = 0; i < sourceContexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, sourceContexts_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    for (int i = 0; i < extSourceContexts_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, extSourceContexts_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.clouddebugger.v2.Debuggee)) {
      return super.equals(obj);
    }
    com.google.devtools.clouddebugger.v2.Debuggee other =
        (com.google.devtools.clouddebugger.v2.Debuggee) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (!getUniquifier().equals(other.getUniquifier())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getIsInactive() != other.getIsInactive()) return false;
    if (!getAgentVersion().equals(other.getAgentVersion())) return false;
    if (getIsDisabled() != other.getIsDisabled()) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getSourceContextsList().equals(other.getSourceContextsList())) return false;
    if (!getExtSourceContextsList().equals(other.getExtSourceContextsList())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + UNIQUIFIER_FIELD_NUMBER;
    hash = (53 * hash) + getUniquifier().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + IS_INACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsInactive());
    hash = (37 * hash) + AGENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getAgentVersion().hashCode();
    hash = (37 * hash) + IS_DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDisabled());
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getSourceContextsCount() > 0) {
      hash = (37 * hash) + SOURCE_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceContextsList().hashCode();
    }
    if (getExtSourceContextsCount() > 0) {
      hash = (37 * hash) + EXT_SOURCE_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getExtSourceContextsList().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.clouddebugger.v2.Debuggee prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the debugged application. The application may include one or more
   * replicated processes executing the same code. Each of these processes is
   * attached with a debugger agent, carrying out the debugging commands.
   * Agents attached to the same debuggee identify themselves as such by using
   * exactly the same Debuggee message value when registering.
   * </pre>
   *
   * Protobuf type {@code google.devtools.clouddebugger.v2.Debuggee}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.clouddebugger.v2.Debuggee)
      com.google.devtools.clouddebugger.v2.DebuggeeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Debuggee_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Debuggee_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.clouddebugger.v2.Debuggee.class,
              com.google.devtools.clouddebugger.v2.Debuggee.Builder.class);
    }

    // Construct using com.google.devtools.clouddebugger.v2.Debuggee.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      project_ = "";

      uniquifier_ = "";

      description_ = "";

      isInactive_ = false;

      agentVersion_ = "";

      isDisabled_ = false;

      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      if (sourceContextsBuilder_ == null) {
        sourceContexts_ = java.util.Collections.emptyList();
      } else {
        sourceContexts_ = null;
        sourceContextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (extSourceContextsBuilder_ == null) {
        extSourceContexts_ = java.util.Collections.emptyList();
      } else {
        extSourceContexts_ = null;
        extSourceContextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Debuggee_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Debuggee getDefaultInstanceForType() {
      return com.google.devtools.clouddebugger.v2.Debuggee.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Debuggee build() {
      com.google.devtools.clouddebugger.v2.Debuggee result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Debuggee buildPartial() {
      com.google.devtools.clouddebugger.v2.Debuggee result =
          new com.google.devtools.clouddebugger.v2.Debuggee(this);
      int from_bitField0_ = bitField0_;
      result.id_ = id_;
      result.project_ = project_;
      result.uniquifier_ = uniquifier_;
      result.description_ = description_;
      result.isInactive_ = isInactive_;
      result.agentVersion_ = agentVersion_;
      result.isDisabled_ = isDisabled_;
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      if (sourceContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          sourceContexts_ = java.util.Collections.unmodifiableList(sourceContexts_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.sourceContexts_ = sourceContexts_;
      } else {
        result.sourceContexts_ = sourceContextsBuilder_.build();
      }
      if (extSourceContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          extSourceContexts_ = java.util.Collections.unmodifiableList(extSourceContexts_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.extSourceContexts_ = extSourceContexts_;
      } else {
        result.extSourceContexts_ = extSourceContextsBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.clouddebugger.v2.Debuggee) {
        return mergeFrom((com.google.devtools.clouddebugger.v2.Debuggee) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.clouddebugger.v2.Debuggee other) {
      if (other == com.google.devtools.clouddebugger.v2.Debuggee.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        onChanged();
      }
      if (!other.getUniquifier().isEmpty()) {
        uniquifier_ = other.uniquifier_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.getIsInactive() != false) {
        setIsInactive(other.getIsInactive());
      }
      if (!other.getAgentVersion().isEmpty()) {
        agentVersion_ = other.agentVersion_;
        onChanged();
      }
      if (other.getIsDisabled() != false) {
        setIsDisabled(other.getIsDisabled());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (sourceContextsBuilder_ == null) {
        if (!other.sourceContexts_.isEmpty()) {
          if (sourceContexts_.isEmpty()) {
            sourceContexts_ = other.sourceContexts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSourceContextsIsMutable();
            sourceContexts_.addAll(other.sourceContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.sourceContexts_.isEmpty()) {
          if (sourceContextsBuilder_.isEmpty()) {
            sourceContextsBuilder_.dispose();
            sourceContextsBuilder_ = null;
            sourceContexts_ = other.sourceContexts_;
            bitField0_ = (bitField0_ & ~0x00000001);
            sourceContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSourceContextsFieldBuilder()
                    : null;
          } else {
            sourceContextsBuilder_.addAllMessages(other.sourceContexts_);
          }
        }
      }
      if (extSourceContextsBuilder_ == null) {
        if (!other.extSourceContexts_.isEmpty()) {
          if (extSourceContexts_.isEmpty()) {
            extSourceContexts_ = other.extSourceContexts_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExtSourceContextsIsMutable();
            extSourceContexts_.addAll(other.extSourceContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.extSourceContexts_.isEmpty()) {
          if (extSourceContextsBuilder_.isEmpty()) {
            extSourceContextsBuilder_.dispose();
            extSourceContextsBuilder_ = null;
            extSourceContexts_ = other.extSourceContexts_;
            bitField0_ = (bitField0_ & ~0x00000002);
            extSourceContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExtSourceContextsFieldBuilder()
                    : null;
          } else {
            extSourceContextsBuilder_.addAllMessages(other.extSourceContexts_);
          }
        }
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                project_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                uniquifier_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 40:
              {
                isInactive_ = input.readBool();

                break;
              } // case 40
            case 50:
              {
                agentVersion_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 56:
              {
                isDisabled_ = input.readBool();

                break;
              } // case 56
            case 66:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                com.google.devtools.source.v1.SourceContext m =
                    input.readMessage(
                        com.google.devtools.source.v1.SourceContext.parser(), extensionRegistry);
                if (sourceContextsBuilder_ == null) {
                  ensureSourceContextsIsMutable();
                  sourceContexts_.add(m);
                } else {
                  sourceContextsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 90
            case 106:
              {
                com.google.devtools.source.v1.ExtendedSourceContext m =
                    input.readMessage(
                        com.google.devtools.source.v1.ExtendedSourceContext.parser(),
                        extensionRegistry);
                if (extSourceContextsBuilder_ == null) {
                  ensureExtSourceContextsIsMutable();
                  extSourceContexts_.add(m);
                } else {
                  extSourceContextsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier for the debuggee generated by the controller service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the debuggee generated by the controller service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the debuggee generated by the controller service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the debuggee generated by the controller service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the debuggee generated by the controller service.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      project_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {

      project_ = getDefaultInstance().getProject();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      project_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object uniquifier_ = "";
    /**
     *
     *
     * <pre>
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     * </pre>
     *
     * <code>string uniquifier = 3;</code>
     *
     * @return The uniquifier.
     */
    public java.lang.String getUniquifier() {
      java.lang.Object ref = uniquifier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uniquifier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     * </pre>
     *
     * <code>string uniquifier = 3;</code>
     *
     * @return The bytes for uniquifier.
     */
    public com.google.protobuf.ByteString getUniquifierBytes() {
      java.lang.Object ref = uniquifier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uniquifier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     * </pre>
     *
     * <code>string uniquifier = 3;</code>
     *
     * @param value The uniquifier to set.
     * @return This builder for chaining.
     */
    public Builder setUniquifier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uniquifier_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     * </pre>
     *
     * <code>string uniquifier = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUniquifier() {

      uniquifier_ = getDefaultInstance().getUniquifier();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     * </pre>
     *
     * <code>string uniquifier = 3;</code>
     *
     * @param value The bytes for uniquifier to set.
     * @return This builder for chaining.
     */
    public Builder setUniquifierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uniquifier_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private boolean isInactive_;
    /**
     *
     *
     * <pre>
     * If set to `true`, indicates that Controller service does not detect any
     * activity from the debuggee agents and the application is possibly stopped.
     * </pre>
     *
     * <code>bool is_inactive = 5;</code>
     *
     * @return The isInactive.
     */
    @java.lang.Override
    public boolean getIsInactive() {
      return isInactive_;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, indicates that Controller service does not detect any
     * activity from the debuggee agents and the application is possibly stopped.
     * </pre>
     *
     * <code>bool is_inactive = 5;</code>
     *
     * @param value The isInactive to set.
     * @return This builder for chaining.
     */
    public Builder setIsInactive(boolean value) {

      isInactive_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, indicates that Controller service does not detect any
     * activity from the debuggee agents and the application is possibly stopped.
     * </pre>
     *
     * <code>bool is_inactive = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsInactive() {

      isInactive_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object agentVersion_ = "";
    /**
     *
     *
     * <pre>
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     * </pre>
     *
     * <code>string agent_version = 6;</code>
     *
     * @return The agentVersion.
     */
    public java.lang.String getAgentVersion() {
      java.lang.Object ref = agentVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     * </pre>
     *
     * <code>string agent_version = 6;</code>
     *
     * @return The bytes for agentVersion.
     */
    public com.google.protobuf.ByteString getAgentVersionBytes() {
      java.lang.Object ref = agentVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     * </pre>
     *
     * <code>string agent_version = 6;</code>
     *
     * @param value The agentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAgentVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      agentVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     * </pre>
     *
     * <code>string agent_version = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentVersion() {

      agentVersion_ = getDefaultInstance().getAgentVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     * </pre>
     *
     * <code>string agent_version = 6;</code>
     *
     * @param value The bytes for agentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAgentVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      agentVersion_ = value;
      onChanged();
      return this;
    }

    private boolean isDisabled_;
    /**
     *
     *
     * <pre>
     * If set to `true`, indicates that the agent should disable itself and
     * detach from the debuggee.
     * </pre>
     *
     * <code>bool is_disabled = 7;</code>
     *
     * @return The isDisabled.
     */
    @java.lang.Override
    public boolean getIsDisabled() {
      return isDisabled_;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, indicates that the agent should disable itself and
     * detach from the debuggee.
     * </pre>
     *
     * <code>bool is_disabled = 7;</code>
     *
     * @param value The isDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setIsDisabled(boolean value) {

      isDisabled_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, indicates that the agent should disable itself and
     * detach from the debuggee.
     * </pre>
     *
     * <code>bool is_disabled = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDisabled() {

      isDisabled_ = false;
      onChanged();
      return this;
    }

    private com.google.devtools.clouddebugger.v2.StatusMessage status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StatusMessage,
            com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
            com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     *
     * @return The status.
     */
    public com.google.devtools.clouddebugger.v2.StatusMessage getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    public Builder setStatus(com.google.devtools.clouddebugger.v2.StatusMessage value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    public Builder setStatus(
        com.google.devtools.clouddebugger.v2.StatusMessage.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    public Builder mergeStatus(com.google.devtools.clouddebugger.v2.StatusMessage value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ =
              com.google.devtools.clouddebugger.v2.StatusMessage.newBuilder(status_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.StatusMessage.Builder getStatusBuilder() {

      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StatusMessage,
            com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
            com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.StatusMessage,
                com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
                com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.devtools.source.v1.SourceContext> sourceContexts_ =
        java.util.Collections.emptyList();

    private void ensureSourceContextsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sourceContexts_ =
            new java.util.ArrayList<com.google.devtools.source.v1.SourceContext>(sourceContexts_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.source.v1.SourceContext,
            com.google.devtools.source.v1.SourceContext.Builder,
            com.google.devtools.source.v1.SourceContextOrBuilder>
        sourceContextsBuilder_;

    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public java.util.List<com.google.devtools.source.v1.SourceContext> getSourceContextsList() {
      if (sourceContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sourceContexts_);
      } else {
        return sourceContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public int getSourceContextsCount() {
      if (sourceContextsBuilder_ == null) {
        return sourceContexts_.size();
      } else {
        return sourceContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public com.google.devtools.source.v1.SourceContext getSourceContexts(int index) {
      if (sourceContextsBuilder_ == null) {
        return sourceContexts_.get(index);
      } else {
        return sourceContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder setSourceContexts(int index, com.google.devtools.source.v1.SourceContext value) {
      if (sourceContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceContextsIsMutable();
        sourceContexts_.set(index, value);
        onChanged();
      } else {
        sourceContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder setSourceContexts(
        int index, com.google.devtools.source.v1.SourceContext.Builder builderForValue) {
      if (sourceContextsBuilder_ == null) {
        ensureSourceContextsIsMutable();
        sourceContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        sourceContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder addSourceContexts(com.google.devtools.source.v1.SourceContext value) {
      if (sourceContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceContextsIsMutable();
        sourceContexts_.add(value);
        onChanged();
      } else {
        sourceContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder addSourceContexts(int index, com.google.devtools.source.v1.SourceContext value) {
      if (sourceContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceContextsIsMutable();
        sourceContexts_.add(index, value);
        onChanged();
      } else {
        sourceContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder addSourceContexts(
        com.google.devtools.source.v1.SourceContext.Builder builderForValue) {
      if (sourceContextsBuilder_ == null) {
        ensureSourceContextsIsMutable();
        sourceContexts_.add(builderForValue.build());
        onChanged();
      } else {
        sourceContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder addSourceContexts(
        int index, com.google.devtools.source.v1.SourceContext.Builder builderForValue) {
      if (sourceContextsBuilder_ == null) {
        ensureSourceContextsIsMutable();
        sourceContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        sourceContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder addAllSourceContexts(
        java.lang.Iterable<? extends com.google.devtools.source.v1.SourceContext> values) {
      if (sourceContextsBuilder_ == null) {
        ensureSourceContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceContexts_);
        onChanged();
      } else {
        sourceContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder clearSourceContexts() {
      if (sourceContextsBuilder_ == null) {
        sourceContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        sourceContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public Builder removeSourceContexts(int index) {
      if (sourceContextsBuilder_ == null) {
        ensureSourceContextsIsMutable();
        sourceContexts_.remove(index);
        onChanged();
      } else {
        sourceContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public com.google.devtools.source.v1.SourceContext.Builder getSourceContextsBuilder(int index) {
      return getSourceContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public com.google.devtools.source.v1.SourceContextOrBuilder getSourceContextsOrBuilder(
        int index) {
      if (sourceContextsBuilder_ == null) {
        return sourceContexts_.get(index);
      } else {
        return sourceContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public java.util.List<? extends com.google.devtools.source.v1.SourceContextOrBuilder>
        getSourceContextsOrBuilderList() {
      if (sourceContextsBuilder_ != null) {
        return sourceContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sourceContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public com.google.devtools.source.v1.SourceContext.Builder addSourceContextsBuilder() {
      return getSourceContextsFieldBuilder()
          .addBuilder(com.google.devtools.source.v1.SourceContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public com.google.devtools.source.v1.SourceContext.Builder addSourceContextsBuilder(int index) {
      return getSourceContextsFieldBuilder()
          .addBuilder(index, com.google.devtools.source.v1.SourceContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    public java.util.List<com.google.devtools.source.v1.SourceContext.Builder>
        getSourceContextsBuilderList() {
      return getSourceContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.source.v1.SourceContext,
            com.google.devtools.source.v1.SourceContext.Builder,
            com.google.devtools.source.v1.SourceContextOrBuilder>
        getSourceContextsFieldBuilder() {
      if (sourceContextsBuilder_ == null) {
        sourceContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.source.v1.SourceContext,
                com.google.devtools.source.v1.SourceContext.Builder,
                com.google.devtools.source.v1.SourceContextOrBuilder>(
                sourceContexts_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        sourceContexts_ = null;
      }
      return sourceContextsBuilder_;
    }

    private java.util.List<com.google.devtools.source.v1.ExtendedSourceContext> extSourceContexts_ =
        java.util.Collections.emptyList();

    private void ensureExtSourceContextsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        extSourceContexts_ =
            new java.util.ArrayList<com.google.devtools.source.v1.ExtendedSourceContext>(
                extSourceContexts_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.source.v1.ExtendedSourceContext,
            com.google.devtools.source.v1.ExtendedSourceContext.Builder,
            com.google.devtools.source.v1.ExtendedSourceContextOrBuilder>
        extSourceContextsBuilder_;

    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.devtools.source.v1.ExtendedSourceContext>
        getExtSourceContextsList() {
      if (extSourceContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(extSourceContexts_);
      } else {
        return extSourceContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getExtSourceContextsCount() {
      if (extSourceContextsBuilder_ == null) {
        return extSourceContexts_.size();
      } else {
        return extSourceContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.devtools.source.v1.ExtendedSourceContext getExtSourceContexts(int index) {
      if (extSourceContextsBuilder_ == null) {
        return extSourceContexts_.get(index);
      } else {
        return extSourceContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setExtSourceContexts(
        int index, com.google.devtools.source.v1.ExtendedSourceContext value) {
      if (extSourceContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.set(index, value);
        onChanged();
      } else {
        extSourceContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setExtSourceContexts(
        int index, com.google.devtools.source.v1.ExtendedSourceContext.Builder builderForValue) {
      if (extSourceContextsBuilder_ == null) {
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        extSourceContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addExtSourceContexts(com.google.devtools.source.v1.ExtendedSourceContext value) {
      if (extSourceContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.add(value);
        onChanged();
      } else {
        extSourceContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addExtSourceContexts(
        int index, com.google.devtools.source.v1.ExtendedSourceContext value) {
      if (extSourceContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.add(index, value);
        onChanged();
      } else {
        extSourceContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addExtSourceContexts(
        com.google.devtools.source.v1.ExtendedSourceContext.Builder builderForValue) {
      if (extSourceContextsBuilder_ == null) {
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.add(builderForValue.build());
        onChanged();
      } else {
        extSourceContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addExtSourceContexts(
        int index, com.google.devtools.source.v1.ExtendedSourceContext.Builder builderForValue) {
      if (extSourceContextsBuilder_ == null) {
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        extSourceContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllExtSourceContexts(
        java.lang.Iterable<? extends com.google.devtools.source.v1.ExtendedSourceContext> values) {
      if (extSourceContextsBuilder_ == null) {
        ensureExtSourceContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extSourceContexts_);
        onChanged();
      } else {
        extSourceContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearExtSourceContexts() {
      if (extSourceContextsBuilder_ == null) {
        extSourceContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        extSourceContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeExtSourceContexts(int index) {
      if (extSourceContextsBuilder_ == null) {
        ensureExtSourceContextsIsMutable();
        extSourceContexts_.remove(index);
        onChanged();
      } else {
        extSourceContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.devtools.source.v1.ExtendedSourceContext.Builder getExtSourceContextsBuilder(
        int index) {
      return getExtSourceContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.devtools.source.v1.ExtendedSourceContextOrBuilder
        getExtSourceContextsOrBuilder(int index) {
      if (extSourceContextsBuilder_ == null) {
        return extSourceContexts_.get(index);
      } else {
        return extSourceContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.devtools.source.v1.ExtendedSourceContextOrBuilder>
        getExtSourceContextsOrBuilderList() {
      if (extSourceContextsBuilder_ != null) {
        return extSourceContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(extSourceContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.devtools.source.v1.ExtendedSourceContext.Builder
        addExtSourceContextsBuilder() {
      return getExtSourceContextsFieldBuilder()
          .addBuilder(com.google.devtools.source.v1.ExtendedSourceContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.devtools.source.v1.ExtendedSourceContext.Builder addExtSourceContextsBuilder(
        int index) {
      return getExtSourceContextsFieldBuilder()
          .addBuilder(
              index, com.google.devtools.source.v1.ExtendedSourceContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to the locations and revisions of the source code used in the
     * deployed application.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.devtools.source.v1.ExtendedSourceContext.Builder>
        getExtSourceContextsBuilderList() {
      return getExtSourceContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.source.v1.ExtendedSourceContext,
            com.google.devtools.source.v1.ExtendedSourceContext.Builder,
            com.google.devtools.source.v1.ExtendedSourceContextOrBuilder>
        getExtSourceContextsFieldBuilder() {
      if (extSourceContextsBuilder_ == null) {
        extSourceContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.source.v1.ExtendedSourceContext,
                com.google.devtools.source.v1.ExtendedSourceContext.Builder,
                com.google.devtools.source.v1.ExtendedSourceContextOrBuilder>(
                extSourceContexts_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        extSourceContexts_ = null;
      }
      return extSourceContextsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.clouddebugger.v2.Debuggee)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.clouddebugger.v2.Debuggee)
  private static final com.google.devtools.clouddebugger.v2.Debuggee DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.clouddebugger.v2.Debuggee();
  }

  public static com.google.devtools.clouddebugger.v2.Debuggee getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Debuggee> PARSER =
      new com.google.protobuf.AbstractParser<Debuggee>() {
        @java.lang.Override
        public Debuggee parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Debuggee> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Debuggee> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Debuggee getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
