/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/data.proto

package com.google.devtools.clouddebugger.v2;

public interface BreakpointOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.devtools.clouddebugger.v2.Breakpoint)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Breakpoint identifier, unique in the scope of the debuggee.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  java.lang.String getId();
  /**
   *
   *
   * <pre>
   * Breakpoint identifier, unique in the scope of the debuggee.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Action that the agent should perform when the code at the
   * breakpoint location is hit.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
   *
   * @return The enum numeric value on the wire for action.
   */
  int getActionValue();
  /**
   *
   *
   * <pre>
   * Action that the agent should perform when the code at the
   * breakpoint location is hit.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
   *
   * @return The action.
   */
  com.google.devtools.clouddebugger.v2.Breakpoint.Action getAction();

  /**
   *
   *
   * <pre>
   * Breakpoint source location.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   *
   * @return Whether the location field is set.
   */
  boolean hasLocation();
  /**
   *
   *
   * <pre>
   * Breakpoint source location.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   *
   * @return The location.
   */
  com.google.devtools.clouddebugger.v2.SourceLocation getLocation();
  /**
   *
   *
   * <pre>
   * Breakpoint source location.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   */
  com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder getLocationOrBuilder();

  /**
   *
   *
   * <pre>
   * Condition that triggers the breakpoint.
   * The condition is a compound boolean expression composed using expressions
   * in a programming language at the source location.
   * </pre>
   *
   * <code>string condition = 3;</code>
   *
   * @return The condition.
   */
  java.lang.String getCondition();
  /**
   *
   *
   * <pre>
   * Condition that triggers the breakpoint.
   * The condition is a compound boolean expression composed using expressions
   * in a programming language at the source location.
   * </pre>
   *
   * <code>string condition = 3;</code>
   *
   * @return The bytes for condition.
   */
  com.google.protobuf.ByteString getConditionBytes();

  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @return A list containing the expressions.
   */
  java.util.List<java.lang.String> getExpressionsList();
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @return The count of expressions.
   */
  int getExpressionsCount();
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The expressions at the given index.
   */
  java.lang.String getExpressions(int index);
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the expressions at the given index.
   */
  com.google.protobuf.ByteString getExpressionsBytes(int index);

  /**
   *
   *
   * <pre>
   * Only relevant when action is `LOG`. Defines the message to log when
   * the breakpoint hits. The message may include parameter placeholders `$0`,
   * `$1`, etc. These placeholders are replaced with the evaluated value
   * of the appropriate expression. Expressions not referenced in
   * `log_message_format` are not logged.
   * Example: `Message received, id = $0, count = $1` with
   * `expressions` = `[ message.id, message.count ]`.
   * </pre>
   *
   * <code>string log_message_format = 14;</code>
   *
   * @return The logMessageFormat.
   */
  java.lang.String getLogMessageFormat();
  /**
   *
   *
   * <pre>
   * Only relevant when action is `LOG`. Defines the message to log when
   * the breakpoint hits. The message may include parameter placeholders `$0`,
   * `$1`, etc. These placeholders are replaced with the evaluated value
   * of the appropriate expression. Expressions not referenced in
   * `log_message_format` are not logged.
   * Example: `Message received, id = $0, count = $1` with
   * `expressions` = `[ message.id, message.count ]`.
   * </pre>
   *
   * <code>string log_message_format = 14;</code>
   *
   * @return The bytes for logMessageFormat.
   */
  com.google.protobuf.ByteString getLogMessageFormatBytes();

  /**
   *
   *
   * <pre>
   * Indicates the severity of the log. Only relevant when action is `LOG`.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
   *
   * @return The enum numeric value on the wire for logLevel.
   */
  int getLogLevelValue();
  /**
   *
   *
   * <pre>
   * Indicates the severity of the log. Only relevant when action is `LOG`.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
   *
   * @return The logLevel.
   */
  com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel getLogLevel();

  /**
   *
   *
   * <pre>
   * When true, indicates that this is a final result and the
   * breakpoint state will not change from here on.
   * </pre>
   *
   * <code>bool is_final_state = 5;</code>
   *
   * @return The isFinalState.
   */
  boolean getIsFinalState();

  /**
   *
   *
   * <pre>
   * Time this breakpoint was created by the server in seconds resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Time this breakpoint was created by the server in seconds resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Time this breakpoint was created by the server in seconds resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Time this breakpoint was finalized as seen by the server in seconds
   * resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp final_time = 12;</code>
   *
   * @return Whether the finalTime field is set.
   */
  boolean hasFinalTime();
  /**
   *
   *
   * <pre>
   * Time this breakpoint was finalized as seen by the server in seconds
   * resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp final_time = 12;</code>
   *
   * @return The finalTime.
   */
  com.google.protobuf.Timestamp getFinalTime();
  /**
   *
   *
   * <pre>
   * Time this breakpoint was finalized as seen by the server in seconds
   * resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp final_time = 12;</code>
   */
  com.google.protobuf.TimestampOrBuilder getFinalTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * E-mail address of the user that created this breakpoint
   * </pre>
   *
   * <code>string user_email = 16;</code>
   *
   * @return The userEmail.
   */
  java.lang.String getUserEmail();
  /**
   *
   *
   * <pre>
   * E-mail address of the user that created this breakpoint
   * </pre>
   *
   * <code>string user_email = 16;</code>
   *
   * @return The bytes for userEmail.
   */
  com.google.protobuf.ByteString getUserEmailBytes();

  /**
   *
   *
   * <pre>
   * Breakpoint status.
   * The status includes an error flag and a human readable message.
   * This field is usually unset. The message can be either
   * informational or an error message. Regardless, clients should always
   * display the text message back to the user.
   * Error status indicates complete failure of the breakpoint.
   * Example (non-final state): `Still loading symbols...`
   * Examples (final state):
   * *   `Invalid line number` referring to location
   * *   `Field f not found in class C` referring to condition
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();
  /**
   *
   *
   * <pre>
   * Breakpoint status.
   * The status includes an error flag and a human readable message.
   * This field is usually unset. The message can be either
   * informational or an error message. Regardless, clients should always
   * display the text message back to the user.
   * Error status indicates complete failure of the breakpoint.
   * Example (non-final state): `Still loading symbols...`
   * Examples (final state):
   * *   `Invalid line number` referring to location
   * *   `Field f not found in class C` referring to condition
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
   *
   * @return The status.
   */
  com.google.devtools.clouddebugger.v2.StatusMessage getStatus();
  /**
   *
   *
   * <pre>
   * Breakpoint status.
   * The status includes an error flag and a human readable message.
   * This field is usually unset. The message can be either
   * informational or an error message. Regardless, clients should always
   * display the text message back to the user.
   * Error status indicates complete failure of the breakpoint.
   * Example (non-final state): `Still loading symbols...`
   * Examples (final state):
   * *   `Invalid line number` referring to location
   * *   `Field f not found in class C` referring to condition
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
   */
  com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  java.util.List<com.google.devtools.clouddebugger.v2.StackFrame> getStackFramesList();
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  com.google.devtools.clouddebugger.v2.StackFrame getStackFrames(int index);
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  int getStackFramesCount();
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  java.util.List<? extends com.google.devtools.clouddebugger.v2.StackFrameOrBuilder>
      getStackFramesOrBuilderList();
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  com.google.devtools.clouddebugger.v2.StackFrameOrBuilder getStackFramesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  java.util.List<com.google.devtools.clouddebugger.v2.Variable> getEvaluatedExpressionsList();
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  com.google.devtools.clouddebugger.v2.Variable getEvaluatedExpressions(int index);
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  int getEvaluatedExpressionsCount();
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getEvaluatedExpressionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  com.google.devtools.clouddebugger.v2.VariableOrBuilder getEvaluatedExpressionsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  java.util.List<com.google.devtools.clouddebugger.v2.Variable> getVariableTableList();
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  com.google.devtools.clouddebugger.v2.Variable getVariableTable(int index);
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  int getVariableTableCount();
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getVariableTableOrBuilderList();
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  com.google.devtools.clouddebugger.v2.VariableOrBuilder getVariableTableOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */

  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);
}
