/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/clouddebugger/v2/data.proto

package com.google.devtools.clouddebugger.v2;

/**
 *
 *
 * <pre>
 * Represents the breakpoint specification, status and results.
 * </pre>
 *
 * Protobuf type {@code google.devtools.clouddebugger.v2.Breakpoint}
 */
public final class Breakpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.clouddebugger.v2.Breakpoint)
    BreakpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Breakpoint.newBuilder() to construct.
  private Breakpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Breakpoint() {
    id_ = "";
    action_ = 0;
    condition_ = "";
    expressions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    logMessageFormat_ = "";
    logLevel_ = 0;
    userEmail_ = "";
    stackFrames_ = java.util.Collections.emptyList();
    evaluatedExpressions_ = java.util.Collections.emptyList();
    variableTable_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Breakpoint();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_Breakpoint_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 17:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.clouddebugger.v2.DataProto
        .internal_static_google_devtools_clouddebugger_v2_Breakpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.clouddebugger.v2.Breakpoint.class,
            com.google.devtools.clouddebugger.v2.Breakpoint.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Actions that can be taken when a breakpoint hits.
   * Agents should reject breakpoints with unsupported or unknown action values.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.clouddebugger.v2.Breakpoint.Action}
   */
  public enum Action implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Capture stack frame and variables and update the breakpoint.
     * The data is only captured once. After that the breakpoint is set
     * in a final state.
     * </pre>
     *
     * <code>CAPTURE = 0;</code>
     */
    CAPTURE(0),
    /**
     *
     *
     * <pre>
     * Log each breakpoint hit. The breakpoint remains active until
     * deleted or expired.
     * </pre>
     *
     * <code>LOG = 1;</code>
     */
    LOG(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Capture stack frame and variables and update the breakpoint.
     * The data is only captured once. After that the breakpoint is set
     * in a final state.
     * </pre>
     *
     * <code>CAPTURE = 0;</code>
     */
    public static final int CAPTURE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Log each breakpoint hit. The breakpoint remains active until
     * deleted or expired.
     * </pre>
     *
     * <code>LOG = 1;</code>
     */
    public static final int LOG_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0:
          return CAPTURE;
        case 1:
          return LOG;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Action>() {
          public Action findValueByNumber(int number) {
            return Action.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.Breakpoint.getDescriptor().getEnumTypes().get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.clouddebugger.v2.Breakpoint.Action)
  }

  /**
   *
   *
   * <pre>
   * Log severity levels.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.clouddebugger.v2.Breakpoint.LogLevel}
   */
  public enum LogLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Information log message.
     * </pre>
     *
     * <code>INFO = 0;</code>
     */
    INFO(0),
    /**
     *
     *
     * <pre>
     * Warning log message.
     * </pre>
     *
     * <code>WARNING = 1;</code>
     */
    WARNING(1),
    /**
     *
     *
     * <pre>
     * Error log message.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    ERROR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Information log message.
     * </pre>
     *
     * <code>INFO = 0;</code>
     */
    public static final int INFO_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Warning log message.
     * </pre>
     *
     * <code>WARNING = 1;</code>
     */
    public static final int WARNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Error log message.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    public static final int ERROR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LogLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LogLevel forNumber(int value) {
      switch (value) {
        case 0:
          return INFO;
        case 1:
          return WARNING;
        case 2:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LogLevel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LogLevel> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LogLevel>() {
          public LogLevel findValueByNumber(int number) {
            return LogLevel.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.Breakpoint.getDescriptor().getEnumTypes().get(1);
    }

    private static final LogLevel[] VALUES = values();

    public static LogLevel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LogLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.clouddebugger.v2.Breakpoint.LogLevel)
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Breakpoint identifier, unique in the scope of the debuggee.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Breakpoint identifier, unique in the scope of the debuggee.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTION_FIELD_NUMBER = 13;
  private int action_;
  /**
   *
   *
   * <pre>
   * Action that the agent should perform when the code at the
   * breakpoint location is hit.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
   *
   * @return The enum numeric value on the wire for action.
   */
  @java.lang.Override
  public int getActionValue() {
    return action_;
  }
  /**
   *
   *
   * <pre>
   * Action that the agent should perform when the code at the
   * breakpoint location is hit.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Breakpoint.Action getAction() {
    @SuppressWarnings("deprecation")
    com.google.devtools.clouddebugger.v2.Breakpoint.Action result =
        com.google.devtools.clouddebugger.v2.Breakpoint.Action.valueOf(action_);
    return result == null
        ? com.google.devtools.clouddebugger.v2.Breakpoint.Action.UNRECOGNIZED
        : result;
  }

  public static final int LOCATION_FIELD_NUMBER = 2;
  private com.google.devtools.clouddebugger.v2.SourceLocation location_;
  /**
   *
   *
   * <pre>
   * Breakpoint source location.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return location_ != null;
  }
  /**
   *
   *
   * <pre>
   * Breakpoint source location.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.SourceLocation getLocation() {
    return location_ == null
        ? com.google.devtools.clouddebugger.v2.SourceLocation.getDefaultInstance()
        : location_;
  }
  /**
   *
   *
   * <pre>
   * Breakpoint source location.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder getLocationOrBuilder() {
    return getLocation();
  }

  public static final int CONDITION_FIELD_NUMBER = 3;
  private volatile java.lang.Object condition_;
  /**
   *
   *
   * <pre>
   * Condition that triggers the breakpoint.
   * The condition is a compound boolean expression composed using expressions
   * in a programming language at the source location.
   * </pre>
   *
   * <code>string condition = 3;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public java.lang.String getCondition() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      condition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Condition that triggers the breakpoint.
   * The condition is a compound boolean expression composed using expressions
   * in a programming language at the source location.
   * </pre>
   *
   * <code>string condition = 3;</code>
   *
   * @return The bytes for condition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConditionBytes() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      condition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPRESSIONS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList expressions_;
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @return A list containing the expressions.
   */
  public com.google.protobuf.ProtocolStringList getExpressionsList() {
    return expressions_;
  }
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @return The count of expressions.
   */
  public int getExpressionsCount() {
    return expressions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The expressions at the given index.
   */
  public java.lang.String getExpressions(int index) {
    return expressions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of read-only expressions to evaluate at the breakpoint location.
   * The expressions are composed using expressions in the programming language
   * at the source location. If the breakpoint action is `LOG`, the evaluated
   * expressions are included in log statements.
   * </pre>
   *
   * <code>repeated string expressions = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the expressions at the given index.
   */
  public com.google.protobuf.ByteString getExpressionsBytes(int index) {
    return expressions_.getByteString(index);
  }

  public static final int LOG_MESSAGE_FORMAT_FIELD_NUMBER = 14;
  private volatile java.lang.Object logMessageFormat_;
  /**
   *
   *
   * <pre>
   * Only relevant when action is `LOG`. Defines the message to log when
   * the breakpoint hits. The message may include parameter placeholders `$0`,
   * `$1`, etc. These placeholders are replaced with the evaluated value
   * of the appropriate expression. Expressions not referenced in
   * `log_message_format` are not logged.
   * Example: `Message received, id = $0, count = $1` with
   * `expressions` = `[ message.id, message.count ]`.
   * </pre>
   *
   * <code>string log_message_format = 14;</code>
   *
   * @return The logMessageFormat.
   */
  @java.lang.Override
  public java.lang.String getLogMessageFormat() {
    java.lang.Object ref = logMessageFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logMessageFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Only relevant when action is `LOG`. Defines the message to log when
   * the breakpoint hits. The message may include parameter placeholders `$0`,
   * `$1`, etc. These placeholders are replaced with the evaluated value
   * of the appropriate expression. Expressions not referenced in
   * `log_message_format` are not logged.
   * Example: `Message received, id = $0, count = $1` with
   * `expressions` = `[ message.id, message.count ]`.
   * </pre>
   *
   * <code>string log_message_format = 14;</code>
   *
   * @return The bytes for logMessageFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogMessageFormatBytes() {
    java.lang.Object ref = logMessageFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logMessageFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_LEVEL_FIELD_NUMBER = 15;
  private int logLevel_;
  /**
   *
   *
   * <pre>
   * Indicates the severity of the log. Only relevant when action is `LOG`.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
   *
   * @return The enum numeric value on the wire for logLevel.
   */
  @java.lang.Override
  public int getLogLevelValue() {
    return logLevel_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the severity of the log. Only relevant when action is `LOG`.
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
   *
   * @return The logLevel.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel getLogLevel() {
    @SuppressWarnings("deprecation")
    com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel result =
        com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel.valueOf(logLevel_);
    return result == null
        ? com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel.UNRECOGNIZED
        : result;
  }

  public static final int IS_FINAL_STATE_FIELD_NUMBER = 5;
  private boolean isFinalState_;
  /**
   *
   *
   * <pre>
   * When true, indicates that this is a final result and the
   * breakpoint state will not change from here on.
   * </pre>
   *
   * <code>bool is_final_state = 5;</code>
   *
   * @return The isFinalState.
   */
  @java.lang.Override
  public boolean getIsFinalState() {
    return isFinalState_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Time this breakpoint was created by the server in seconds resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time this breakpoint was created by the server in seconds resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Time this breakpoint was created by the server in seconds resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int FINAL_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp finalTime_;
  /**
   *
   *
   * <pre>
   * Time this breakpoint was finalized as seen by the server in seconds
   * resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp final_time = 12;</code>
   *
   * @return Whether the finalTime field is set.
   */
  @java.lang.Override
  public boolean hasFinalTime() {
    return finalTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time this breakpoint was finalized as seen by the server in seconds
   * resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp final_time = 12;</code>
   *
   * @return The finalTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFinalTime() {
    return finalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finalTime_;
  }
  /**
   *
   *
   * <pre>
   * Time this breakpoint was finalized as seen by the server in seconds
   * resolution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp final_time = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFinalTimeOrBuilder() {
    return getFinalTime();
  }

  public static final int USER_EMAIL_FIELD_NUMBER = 16;
  private volatile java.lang.Object userEmail_;
  /**
   *
   *
   * <pre>
   * E-mail address of the user that created this breakpoint
   * </pre>
   *
   * <code>string user_email = 16;</code>
   *
   * @return The userEmail.
   */
  @java.lang.Override
  public java.lang.String getUserEmail() {
    java.lang.Object ref = userEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * E-mail address of the user that created this breakpoint
   * </pre>
   *
   * <code>string user_email = 16;</code>
   *
   * @return The bytes for userEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserEmailBytes() {
    java.lang.Object ref = userEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 10;
  private com.google.devtools.clouddebugger.v2.StatusMessage status_;
  /**
   *
   *
   * <pre>
   * Breakpoint status.
   * The status includes an error flag and a human readable message.
   * This field is usually unset. The message can be either
   * informational or an error message. Regardless, clients should always
   * display the text message back to the user.
   * Error status indicates complete failure of the breakpoint.
   * Example (non-final state): `Still loading symbols...`
   * Examples (final state):
   * *   `Invalid line number` referring to location
   * *   `Field f not found in class C` referring to condition
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Breakpoint status.
   * The status includes an error flag and a human readable message.
   * This field is usually unset. The message can be either
   * informational or an error message. Regardless, clients should always
   * display the text message back to the user.
   * Error status indicates complete failure of the breakpoint.
   * Example (non-final state): `Still loading symbols...`
   * Examples (final state):
   * *   `Invalid line number` referring to location
   * *   `Field f not found in class C` referring to condition
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StatusMessage getStatus() {
    return status_ == null
        ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Breakpoint status.
   * The status includes an error flag and a human readable message.
   * This field is usually unset. The message can be either
   * informational or an error message. Regardless, clients should always
   * display the text message back to the user.
   * Error status indicates complete failure of the breakpoint.
   * Example (non-final state): `Still loading symbols...`
   * Examples (final state):
   * *   `Invalid line number` referring to location
   * *   `Field f not found in class C` referring to condition
   * </pre>
   *
   * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  public static final int STACK_FRAMES_FIELD_NUMBER = 7;
  private java.util.List<com.google.devtools.clouddebugger.v2.StackFrame> stackFrames_;
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.clouddebugger.v2.StackFrame> getStackFramesList() {
    return stackFrames_;
  }
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.clouddebugger.v2.StackFrameOrBuilder>
      getStackFramesOrBuilderList() {
    return stackFrames_;
  }
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  @java.lang.Override
  public int getStackFramesCount() {
    return stackFrames_.size();
  }
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StackFrame getStackFrames(int index) {
    return stackFrames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The stack at breakpoint time, where stack_frames[0] represents the most
   * recently entered function.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.StackFrameOrBuilder getStackFramesOrBuilder(
      int index) {
    return stackFrames_.get(index);
  }

  public static final int EVALUATED_EXPRESSIONS_FIELD_NUMBER = 8;
  private java.util.List<com.google.devtools.clouddebugger.v2.Variable> evaluatedExpressions_;
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.clouddebugger.v2.Variable>
      getEvaluatedExpressionsList() {
    return evaluatedExpressions_;
  }
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getEvaluatedExpressionsOrBuilderList() {
    return evaluatedExpressions_;
  }
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  @java.lang.Override
  public int getEvaluatedExpressionsCount() {
    return evaluatedExpressions_.size();
  }
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Variable getEvaluatedExpressions(int index) {
    return evaluatedExpressions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Values of evaluated expressions at breakpoint time.
   * The evaluated expressions appear in exactly the same order they
   * are listed in the `expressions` field.
   * The `name` field holds the original expression text, the `value` or
   * `members` field holds the result of the evaluated expression.
   * If the expression cannot be evaluated, the `status` inside the `Variable`
   * will indicate an error and contain the error text.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.VariableOrBuilder getEvaluatedExpressionsOrBuilder(
      int index) {
    return evaluatedExpressions_.get(index);
  }

  public static final int VARIABLE_TABLE_FIELD_NUMBER = 9;
  private java.util.List<com.google.devtools.clouddebugger.v2.Variable> variableTable_;
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getVariableTableList() {
    return variableTable_;
  }
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
      getVariableTableOrBuilderList() {
    return variableTable_;
  }
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  @java.lang.Override
  public int getVariableTableCount() {
    return variableTable_.size();
  }
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Variable getVariableTable(int index) {
    return variableTable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The `variable_table` exists to aid with computation, memory and network
   * traffic optimization.  It enables storing a variable once and reference
   * it from multiple variables, including variables stored in the
   * `variable_table` itself.
   * For example, the same `this` object, which may appear at many levels of
   * the stack, can have all of its data stored once in this table.  The
   * stack frame variables then would hold only a reference to it.
   * The variable `var_table_index` field is an index into this repeated field.
   * The stored objects are nameless and get their name from the referencing
   * variable. The effective variable is a merge of the referencing variable
   * and the referenced variable.
   * </pre>
   *
   * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
   */
  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.VariableOrBuilder getVariableTableOrBuilder(
      int index) {
    return variableTable_.get(index);
  }

  public static final int LABELS_FIELD_NUMBER = 17;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.devtools.clouddebugger.v2.DataProto
                .internal_static_google_devtools_clouddebugger_v2_Breakpoint_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A set of custom breakpoint properties, populated by the agent, to be
   * displayed to the user.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (location_ != null) {
      output.writeMessage(2, getLocation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, condition_);
    }
    for (int i = 0; i < expressions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, expressions_.getRaw(i));
    }
    if (isFinalState_ != false) {
      output.writeBool(5, isFinalState_);
    }
    for (int i = 0; i < stackFrames_.size(); i++) {
      output.writeMessage(7, stackFrames_.get(i));
    }
    for (int i = 0; i < evaluatedExpressions_.size(); i++) {
      output.writeMessage(8, evaluatedExpressions_.get(i));
    }
    for (int i = 0; i < variableTable_.size(); i++) {
      output.writeMessage(9, variableTable_.get(i));
    }
    if (status_ != null) {
      output.writeMessage(10, getStatus());
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (finalTime_ != null) {
      output.writeMessage(12, getFinalTime());
    }
    if (action_ != com.google.devtools.clouddebugger.v2.Breakpoint.Action.CAPTURE.getNumber()) {
      output.writeEnum(13, action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logMessageFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, logMessageFormat_);
    }
    if (logLevel_ != com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel.INFO.getNumber()) {
      output.writeEnum(15, logLevel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, userEmail_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 17);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (location_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLocation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, condition_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < expressions_.size(); i++) {
        dataSize += computeStringSizeNoTag(expressions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExpressionsList().size();
    }
    if (isFinalState_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, isFinalState_);
    }
    for (int i = 0; i < stackFrames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, stackFrames_.get(i));
    }
    for (int i = 0; i < evaluatedExpressions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, evaluatedExpressions_.get(i));
    }
    for (int i = 0; i < variableTable_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, variableTable_.get(i));
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getStatus());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (finalTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getFinalTime());
    }
    if (action_ != com.google.devtools.clouddebugger.v2.Breakpoint.Action.CAPTURE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logMessageFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, logMessageFormat_);
    }
    if (logLevel_ != com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel.INFO.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, logLevel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, userEmail_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.clouddebugger.v2.Breakpoint)) {
      return super.equals(obj);
    }
    com.google.devtools.clouddebugger.v2.Breakpoint other =
        (com.google.devtools.clouddebugger.v2.Breakpoint) obj;

    if (!getId().equals(other.getId())) return false;
    if (action_ != other.action_) return false;
    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (!getCondition().equals(other.getCondition())) return false;
    if (!getExpressionsList().equals(other.getExpressionsList())) return false;
    if (!getLogMessageFormat().equals(other.getLogMessageFormat())) return false;
    if (logLevel_ != other.logLevel_) return false;
    if (getIsFinalState() != other.getIsFinalState()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasFinalTime() != other.hasFinalTime()) return false;
    if (hasFinalTime()) {
      if (!getFinalTime().equals(other.getFinalTime())) return false;
    }
    if (!getUserEmail().equals(other.getUserEmail())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStackFramesList().equals(other.getStackFramesList())) return false;
    if (!getEvaluatedExpressionsList().equals(other.getEvaluatedExpressionsList())) return false;
    if (!getVariableTableList().equals(other.getVariableTableList())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    hash = (37 * hash) + CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getCondition().hashCode();
    if (getExpressionsCount() > 0) {
      hash = (37 * hash) + EXPRESSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExpressionsList().hashCode();
    }
    hash = (37 * hash) + LOG_MESSAGE_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getLogMessageFormat().hashCode();
    hash = (37 * hash) + LOG_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + logLevel_;
    hash = (37 * hash) + IS_FINAL_STATE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsFinalState());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasFinalTime()) {
      hash = (37 * hash) + FINAL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getFinalTime().hashCode();
    }
    hash = (37 * hash) + USER_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getUserEmail().hashCode();
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStackFramesCount() > 0) {
      hash = (37 * hash) + STACK_FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getStackFramesList().hashCode();
    }
    if (getEvaluatedExpressionsCount() > 0) {
      hash = (37 * hash) + EVALUATED_EXPRESSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluatedExpressionsList().hashCode();
    }
    if (getVariableTableCount() > 0) {
      hash = (37 * hash) + VARIABLE_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getVariableTableList().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.clouddebugger.v2.Breakpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the breakpoint specification, status and results.
   * </pre>
   *
   * Protobuf type {@code google.devtools.clouddebugger.v2.Breakpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.clouddebugger.v2.Breakpoint)
      com.google.devtools.clouddebugger.v2.BreakpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Breakpoint_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 17:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 17:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Breakpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.clouddebugger.v2.Breakpoint.class,
              com.google.devtools.clouddebugger.v2.Breakpoint.Builder.class);
    }

    // Construct using com.google.devtools.clouddebugger.v2.Breakpoint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      action_ = 0;

      if (locationBuilder_ == null) {
        location_ = null;
      } else {
        location_ = null;
        locationBuilder_ = null;
      }
      condition_ = "";

      expressions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      logMessageFormat_ = "";

      logLevel_ = 0;

      isFinalState_ = false;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (finalTimeBuilder_ == null) {
        finalTime_ = null;
      } else {
        finalTime_ = null;
        finalTimeBuilder_ = null;
      }
      userEmail_ = "";

      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      if (stackFramesBuilder_ == null) {
        stackFrames_ = java.util.Collections.emptyList();
      } else {
        stackFrames_ = null;
        stackFramesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (evaluatedExpressionsBuilder_ == null) {
        evaluatedExpressions_ = java.util.Collections.emptyList();
      } else {
        evaluatedExpressions_ = null;
        evaluatedExpressionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (variableTableBuilder_ == null) {
        variableTable_ = java.util.Collections.emptyList();
      } else {
        variableTable_ = null;
        variableTableBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.clouddebugger.v2.DataProto
          .internal_static_google_devtools_clouddebugger_v2_Breakpoint_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Breakpoint getDefaultInstanceForType() {
      return com.google.devtools.clouddebugger.v2.Breakpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Breakpoint build() {
      com.google.devtools.clouddebugger.v2.Breakpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Breakpoint buildPartial() {
      com.google.devtools.clouddebugger.v2.Breakpoint result =
          new com.google.devtools.clouddebugger.v2.Breakpoint(this);
      int from_bitField0_ = bitField0_;
      result.id_ = id_;
      result.action_ = action_;
      if (locationBuilder_ == null) {
        result.location_ = location_;
      } else {
        result.location_ = locationBuilder_.build();
      }
      result.condition_ = condition_;
      if (((bitField0_ & 0x00000001) != 0)) {
        expressions_ = expressions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.expressions_ = expressions_;
      result.logMessageFormat_ = logMessageFormat_;
      result.logLevel_ = logLevel_;
      result.isFinalState_ = isFinalState_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (finalTimeBuilder_ == null) {
        result.finalTime_ = finalTime_;
      } else {
        result.finalTime_ = finalTimeBuilder_.build();
      }
      result.userEmail_ = userEmail_;
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      if (stackFramesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          stackFrames_ = java.util.Collections.unmodifiableList(stackFrames_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.stackFrames_ = stackFrames_;
      } else {
        result.stackFrames_ = stackFramesBuilder_.build();
      }
      if (evaluatedExpressionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          evaluatedExpressions_ = java.util.Collections.unmodifiableList(evaluatedExpressions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.evaluatedExpressions_ = evaluatedExpressions_;
      } else {
        result.evaluatedExpressions_ = evaluatedExpressionsBuilder_.build();
      }
      if (variableTableBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          variableTable_ = java.util.Collections.unmodifiableList(variableTable_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.variableTable_ = variableTable_;
      } else {
        result.variableTable_ = variableTableBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.clouddebugger.v2.Breakpoint) {
        return mergeFrom((com.google.devtools.clouddebugger.v2.Breakpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.clouddebugger.v2.Breakpoint other) {
      if (other == com.google.devtools.clouddebugger.v2.Breakpoint.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (!other.getCondition().isEmpty()) {
        condition_ = other.condition_;
        onChanged();
      }
      if (!other.expressions_.isEmpty()) {
        if (expressions_.isEmpty()) {
          expressions_ = other.expressions_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureExpressionsIsMutable();
          expressions_.addAll(other.expressions_);
        }
        onChanged();
      }
      if (!other.getLogMessageFormat().isEmpty()) {
        logMessageFormat_ = other.logMessageFormat_;
        onChanged();
      }
      if (other.logLevel_ != 0) {
        setLogLevelValue(other.getLogLevelValue());
      }
      if (other.getIsFinalState() != false) {
        setIsFinalState(other.getIsFinalState());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasFinalTime()) {
        mergeFinalTime(other.getFinalTime());
      }
      if (!other.getUserEmail().isEmpty()) {
        userEmail_ = other.userEmail_;
        onChanged();
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (stackFramesBuilder_ == null) {
        if (!other.stackFrames_.isEmpty()) {
          if (stackFrames_.isEmpty()) {
            stackFrames_ = other.stackFrames_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStackFramesIsMutable();
            stackFrames_.addAll(other.stackFrames_);
          }
          onChanged();
        }
      } else {
        if (!other.stackFrames_.isEmpty()) {
          if (stackFramesBuilder_.isEmpty()) {
            stackFramesBuilder_.dispose();
            stackFramesBuilder_ = null;
            stackFrames_ = other.stackFrames_;
            bitField0_ = (bitField0_ & ~0x00000002);
            stackFramesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStackFramesFieldBuilder()
                    : null;
          } else {
            stackFramesBuilder_.addAllMessages(other.stackFrames_);
          }
        }
      }
      if (evaluatedExpressionsBuilder_ == null) {
        if (!other.evaluatedExpressions_.isEmpty()) {
          if (evaluatedExpressions_.isEmpty()) {
            evaluatedExpressions_ = other.evaluatedExpressions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEvaluatedExpressionsIsMutable();
            evaluatedExpressions_.addAll(other.evaluatedExpressions_);
          }
          onChanged();
        }
      } else {
        if (!other.evaluatedExpressions_.isEmpty()) {
          if (evaluatedExpressionsBuilder_.isEmpty()) {
            evaluatedExpressionsBuilder_.dispose();
            evaluatedExpressionsBuilder_ = null;
            evaluatedExpressions_ = other.evaluatedExpressions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            evaluatedExpressionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEvaluatedExpressionsFieldBuilder()
                    : null;
          } else {
            evaluatedExpressionsBuilder_.addAllMessages(other.evaluatedExpressions_);
          }
        }
      }
      if (variableTableBuilder_ == null) {
        if (!other.variableTable_.isEmpty()) {
          if (variableTable_.isEmpty()) {
            variableTable_ = other.variableTable_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureVariableTableIsMutable();
            variableTable_.addAll(other.variableTable_);
          }
          onChanged();
        }
      } else {
        if (!other.variableTable_.isEmpty()) {
          if (variableTableBuilder_.isEmpty()) {
            variableTableBuilder_.dispose();
            variableTableBuilder_ = null;
            variableTable_ = other.variableTable_;
            bitField0_ = (bitField0_ & ~0x00000008);
            variableTableBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVariableTableFieldBuilder()
                    : null;
          } else {
            variableTableBuilder_.addAllMessages(other.variableTable_);
          }
        }
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                condition_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExpressionsIsMutable();
                expressions_.add(s);
                break;
              } // case 34
            case 40:
              {
                isFinalState_ = input.readBool();

                break;
              } // case 40
            case 58:
              {
                com.google.devtools.clouddebugger.v2.StackFrame m =
                    input.readMessage(
                        com.google.devtools.clouddebugger.v2.StackFrame.parser(),
                        extensionRegistry);
                if (stackFramesBuilder_ == null) {
                  ensureStackFramesIsMutable();
                  stackFrames_.add(m);
                } else {
                  stackFramesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                com.google.devtools.clouddebugger.v2.Variable m =
                    input.readMessage(
                        com.google.devtools.clouddebugger.v2.Variable.parser(), extensionRegistry);
                if (evaluatedExpressionsBuilder_ == null) {
                  ensureEvaluatedExpressionsIsMutable();
                  evaluatedExpressions_.add(m);
                } else {
                  evaluatedExpressionsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.devtools.clouddebugger.v2.Variable m =
                    input.readMessage(
                        com.google.devtools.clouddebugger.v2.Variable.parser(), extensionRegistry);
                if (variableTableBuilder_ == null) {
                  ensureVariableTableIsMutable();
                  variableTable_.add(m);
                } else {
                  variableTableBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 98:
              {
                input.readMessage(getFinalTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 104:
              {
                action_ = input.readEnum();

                break;
              } // case 104
            case 114:
              {
                logMessageFormat_ = input.readStringRequireUtf8();

                break;
              } // case 114
            case 120:
              {
                logLevel_ = input.readEnum();

                break;
              } // case 120
            case 130:
              {
                userEmail_ = input.readStringRequireUtf8();

                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Breakpoint identifier, unique in the scope of the debuggee.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Breakpoint identifier, unique in the scope of the debuggee.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Breakpoint identifier, unique in the scope of the debuggee.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint identifier, unique in the scope of the debuggee.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint identifier, unique in the scope of the debuggee.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private int action_ = 0;
    /**
     *
     *
     * <pre>
     * Action that the agent should perform when the code at the
     * breakpoint location is hit.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
     *
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override
    public int getActionValue() {
      return action_;
    }
    /**
     *
     *
     * <pre>
     * Action that the agent should perform when the code at the
     * breakpoint location is hit.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
     *
     * @param value The enum numeric value on the wire for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionValue(int value) {

      action_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that the agent should perform when the code at the
     * breakpoint location is hit.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Breakpoint.Action getAction() {
      @SuppressWarnings("deprecation")
      com.google.devtools.clouddebugger.v2.Breakpoint.Action result =
          com.google.devtools.clouddebugger.v2.Breakpoint.Action.valueOf(action_);
      return result == null
          ? com.google.devtools.clouddebugger.v2.Breakpoint.Action.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Action that the agent should perform when the code at the
     * breakpoint location is hit.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(com.google.devtools.clouddebugger.v2.Breakpoint.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }

      action_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that the agent should perform when the code at the
     * breakpoint location is hit.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.Action action = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {

      action_ = 0;
      onChanged();
      return this;
    }

    private com.google.devtools.clouddebugger.v2.SourceLocation location_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.SourceLocation,
            com.google.devtools.clouddebugger.v2.SourceLocation.Builder,
            com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder>
        locationBuilder_;
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return locationBuilder_ != null || location_ != null;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     *
     * @return The location.
     */
    public com.google.devtools.clouddebugger.v2.SourceLocation getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null
            ? com.google.devtools.clouddebugger.v2.SourceLocation.getDefaultInstance()
            : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder setLocation(com.google.devtools.clouddebugger.v2.SourceLocation value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        locationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder setLocation(
        com.google.devtools.clouddebugger.v2.SourceLocation.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder mergeLocation(com.google.devtools.clouddebugger.v2.SourceLocation value) {
      if (locationBuilder_ == null) {
        if (location_ != null) {
          location_ =
              com.google.devtools.clouddebugger.v2.SourceLocation.newBuilder(location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        locationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public Builder clearLocation() {
      if (locationBuilder_ == null) {
        location_ = null;
        onChanged();
      } else {
        location_ = null;
        locationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public com.google.devtools.clouddebugger.v2.SourceLocation.Builder getLocationBuilder() {

      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    public com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null
            ? com.google.devtools.clouddebugger.v2.SourceLocation.getDefaultInstance()
            : location_;
      }
    }
    /**
     *
     *
     * <pre>
     * Breakpoint source location.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.SourceLocation location = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.SourceLocation,
            com.google.devtools.clouddebugger.v2.SourceLocation.Builder,
            com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder>
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.SourceLocation,
                com.google.devtools.clouddebugger.v2.SourceLocation.Builder,
                com.google.devtools.clouddebugger.v2.SourceLocationOrBuilder>(
                getLocation(), getParentForChildren(), isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * Condition that triggers the breakpoint.
     * The condition is a compound boolean expression composed using expressions
     * in a programming language at the source location.
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @return The condition.
     */
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Condition that triggers the breakpoint.
     * The condition is a compound boolean expression composed using expressions
     * in a programming language at the source location.
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @return The bytes for condition.
     */
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Condition that triggers the breakpoint.
     * The condition is a compound boolean expression composed using expressions
     * in a programming language at the source location.
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @param value The condition to set.
     * @return This builder for chaining.
     */
    public Builder setCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      condition_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition that triggers the breakpoint.
     * The condition is a compound boolean expression composed using expressions
     * in a programming language at the source location.
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCondition() {

      condition_ = getDefaultInstance().getCondition();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition that triggers the breakpoint.
     * The condition is a compound boolean expression composed using expressions
     * in a programming language at the source location.
     * </pre>
     *
     * <code>string condition = 3;</code>
     *
     * @param value The bytes for condition to set.
     * @return This builder for chaining.
     */
    public Builder setConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      condition_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList expressions_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureExpressionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        expressions_ = new com.google.protobuf.LazyStringArrayList(expressions_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @return A list containing the expressions.
     */
    public com.google.protobuf.ProtocolStringList getExpressionsList() {
      return expressions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @return The count of expressions.
     */
    public int getExpressionsCount() {
      return expressions_.size();
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The expressions at the given index.
     */
    public java.lang.String getExpressions(int index) {
      return expressions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the expressions at the given index.
     */
    public com.google.protobuf.ByteString getExpressionsBytes(int index) {
      return expressions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The expressions to set.
     * @return This builder for chaining.
     */
    public Builder setExpressions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExpressionsIsMutable();
      expressions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @param value The expressions to add.
     * @return This builder for chaining.
     */
    public Builder addExpressions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExpressionsIsMutable();
      expressions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @param values The expressions to add.
     * @return This builder for chaining.
     */
    public Builder addAllExpressions(java.lang.Iterable<java.lang.String> values) {
      ensureExpressionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, expressions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpressions() {
      expressions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of read-only expressions to evaluate at the breakpoint location.
     * The expressions are composed using expressions in the programming language
     * at the source location. If the breakpoint action is `LOG`, the evaluated
     * expressions are included in log statements.
     * </pre>
     *
     * <code>repeated string expressions = 4;</code>
     *
     * @param value The bytes of the expressions to add.
     * @return This builder for chaining.
     */
    public Builder addExpressionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExpressionsIsMutable();
      expressions_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object logMessageFormat_ = "";
    /**
     *
     *
     * <pre>
     * Only relevant when action is `LOG`. Defines the message to log when
     * the breakpoint hits. The message may include parameter placeholders `$0`,
     * `$1`, etc. These placeholders are replaced with the evaluated value
     * of the appropriate expression. Expressions not referenced in
     * `log_message_format` are not logged.
     * Example: `Message received, id = $0, count = $1` with
     * `expressions` = `[ message.id, message.count ]`.
     * </pre>
     *
     * <code>string log_message_format = 14;</code>
     *
     * @return The logMessageFormat.
     */
    public java.lang.String getLogMessageFormat() {
      java.lang.Object ref = logMessageFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logMessageFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Only relevant when action is `LOG`. Defines the message to log when
     * the breakpoint hits. The message may include parameter placeholders `$0`,
     * `$1`, etc. These placeholders are replaced with the evaluated value
     * of the appropriate expression. Expressions not referenced in
     * `log_message_format` are not logged.
     * Example: `Message received, id = $0, count = $1` with
     * `expressions` = `[ message.id, message.count ]`.
     * </pre>
     *
     * <code>string log_message_format = 14;</code>
     *
     * @return The bytes for logMessageFormat.
     */
    public com.google.protobuf.ByteString getLogMessageFormatBytes() {
      java.lang.Object ref = logMessageFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logMessageFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Only relevant when action is `LOG`. Defines the message to log when
     * the breakpoint hits. The message may include parameter placeholders `$0`,
     * `$1`, etc. These placeholders are replaced with the evaluated value
     * of the appropriate expression. Expressions not referenced in
     * `log_message_format` are not logged.
     * Example: `Message received, id = $0, count = $1` with
     * `expressions` = `[ message.id, message.count ]`.
     * </pre>
     *
     * <code>string log_message_format = 14;</code>
     *
     * @param value The logMessageFormat to set.
     * @return This builder for chaining.
     */
    public Builder setLogMessageFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      logMessageFormat_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only relevant when action is `LOG`. Defines the message to log when
     * the breakpoint hits. The message may include parameter placeholders `$0`,
     * `$1`, etc. These placeholders are replaced with the evaluated value
     * of the appropriate expression. Expressions not referenced in
     * `log_message_format` are not logged.
     * Example: `Message received, id = $0, count = $1` with
     * `expressions` = `[ message.id, message.count ]`.
     * </pre>
     *
     * <code>string log_message_format = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogMessageFormat() {

      logMessageFormat_ = getDefaultInstance().getLogMessageFormat();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only relevant when action is `LOG`. Defines the message to log when
     * the breakpoint hits. The message may include parameter placeholders `$0`,
     * `$1`, etc. These placeholders are replaced with the evaluated value
     * of the appropriate expression. Expressions not referenced in
     * `log_message_format` are not logged.
     * Example: `Message received, id = $0, count = $1` with
     * `expressions` = `[ message.id, message.count ]`.
     * </pre>
     *
     * <code>string log_message_format = 14;</code>
     *
     * @param value The bytes for logMessageFormat to set.
     * @return This builder for chaining.
     */
    public Builder setLogMessageFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      logMessageFormat_ = value;
      onChanged();
      return this;
    }

    private int logLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the severity of the log. Only relevant when action is `LOG`.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
     *
     * @return The enum numeric value on the wire for logLevel.
     */
    @java.lang.Override
    public int getLogLevelValue() {
      return logLevel_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the log. Only relevant when action is `LOG`.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
     *
     * @param value The enum numeric value on the wire for logLevel to set.
     * @return This builder for chaining.
     */
    public Builder setLogLevelValue(int value) {

      logLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the log. Only relevant when action is `LOG`.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
     *
     * @return The logLevel.
     */
    @java.lang.Override
    public com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel getLogLevel() {
      @SuppressWarnings("deprecation")
      com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel result =
          com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel.valueOf(logLevel_);
      return result == null
          ? com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the log. Only relevant when action is `LOG`.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
     *
     * @param value The logLevel to set.
     * @return This builder for chaining.
     */
    public Builder setLogLevel(com.google.devtools.clouddebugger.v2.Breakpoint.LogLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      logLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the log. Only relevant when action is `LOG`.
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.Breakpoint.LogLevel log_level = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogLevel() {

      logLevel_ = 0;
      onChanged();
      return this;
    }

    private boolean isFinalState_;
    /**
     *
     *
     * <pre>
     * When true, indicates that this is a final result and the
     * breakpoint state will not change from here on.
     * </pre>
     *
     * <code>bool is_final_state = 5;</code>
     *
     * @return The isFinalState.
     */
    @java.lang.Override
    public boolean getIsFinalState() {
      return isFinalState_;
    }
    /**
     *
     *
     * <pre>
     * When true, indicates that this is a final result and the
     * breakpoint state will not change from here on.
     * </pre>
     *
     * <code>bool is_final_state = 5;</code>
     *
     * @param value The isFinalState to set.
     * @return This builder for chaining.
     */
    public Builder setIsFinalState(boolean value) {

      isFinalState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When true, indicates that this is a final result and the
     * breakpoint state will not change from here on.
     * </pre>
     *
     * <code>bool is_final_state = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsFinalState() {

      isFinalState_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was created by the server in seconds resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp finalTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        finalTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     *
     * @return Whether the finalTime field is set.
     */
    public boolean hasFinalTime() {
      return finalTimeBuilder_ != null || finalTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     *
     * @return The finalTime.
     */
    public com.google.protobuf.Timestamp getFinalTime() {
      if (finalTimeBuilder_ == null) {
        return finalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finalTime_;
      } else {
        return finalTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    public Builder setFinalTime(com.google.protobuf.Timestamp value) {
      if (finalTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finalTime_ = value;
        onChanged();
      } else {
        finalTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    public Builder setFinalTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (finalTimeBuilder_ == null) {
        finalTime_ = builderForValue.build();
        onChanged();
      } else {
        finalTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    public Builder mergeFinalTime(com.google.protobuf.Timestamp value) {
      if (finalTimeBuilder_ == null) {
        if (finalTime_ != null) {
          finalTime_ =
              com.google.protobuf.Timestamp.newBuilder(finalTime_).mergeFrom(value).buildPartial();
        } else {
          finalTime_ = value;
        }
        onChanged();
      } else {
        finalTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    public Builder clearFinalTime() {
      if (finalTimeBuilder_ == null) {
        finalTime_ = null;
        onChanged();
      } else {
        finalTime_ = null;
        finalTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    public com.google.protobuf.Timestamp.Builder getFinalTimeBuilder() {

      onChanged();
      return getFinalTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getFinalTimeOrBuilder() {
      if (finalTimeBuilder_ != null) {
        return finalTimeBuilder_.getMessageOrBuilder();
      } else {
        return finalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finalTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time this breakpoint was finalized as seen by the server in seconds
     * resolution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp final_time = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFinalTimeFieldBuilder() {
      if (finalTimeBuilder_ == null) {
        finalTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getFinalTime(), getParentForChildren(), isClean());
        finalTime_ = null;
      }
      return finalTimeBuilder_;
    }

    private java.lang.Object userEmail_ = "";
    /**
     *
     *
     * <pre>
     * E-mail address of the user that created this breakpoint
     * </pre>
     *
     * <code>string user_email = 16;</code>
     *
     * @return The userEmail.
     */
    public java.lang.String getUserEmail() {
      java.lang.Object ref = userEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * E-mail address of the user that created this breakpoint
     * </pre>
     *
     * <code>string user_email = 16;</code>
     *
     * @return The bytes for userEmail.
     */
    public com.google.protobuf.ByteString getUserEmailBytes() {
      java.lang.Object ref = userEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * E-mail address of the user that created this breakpoint
     * </pre>
     *
     * <code>string user_email = 16;</code>
     *
     * @param value The userEmail to set.
     * @return This builder for chaining.
     */
    public Builder setUserEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      userEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * E-mail address of the user that created this breakpoint
     * </pre>
     *
     * <code>string user_email = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserEmail() {

      userEmail_ = getDefaultInstance().getUserEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * E-mail address of the user that created this breakpoint
     * </pre>
     *
     * <code>string user_email = 16;</code>
     *
     * @param value The bytes for userEmail to set.
     * @return This builder for chaining.
     */
    public Builder setUserEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      userEmail_ = value;
      onChanged();
      return this;
    }

    private com.google.devtools.clouddebugger.v2.StatusMessage status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StatusMessage,
            com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
            com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     *
     * @return The status.
     */
    public com.google.devtools.clouddebugger.v2.StatusMessage getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    public Builder setStatus(com.google.devtools.clouddebugger.v2.StatusMessage value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    public Builder setStatus(
        com.google.devtools.clouddebugger.v2.StatusMessage.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    public Builder mergeStatus(com.google.devtools.clouddebugger.v2.StatusMessage value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ =
              com.google.devtools.clouddebugger.v2.StatusMessage.newBuilder(status_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    public com.google.devtools.clouddebugger.v2.StatusMessage.Builder getStatusBuilder() {

      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    public com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.devtools.clouddebugger.v2.StatusMessage.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Breakpoint status.
     * The status includes an error flag and a human readable message.
     * This field is usually unset. The message can be either
     * informational or an error message. Regardless, clients should always
     * display the text message back to the user.
     * Error status indicates complete failure of the breakpoint.
     * Example (non-final state): `Still loading symbols...`
     * Examples (final state):
     * *   `Invalid line number` referring to location
     * *   `Field f not found in class C` referring to condition
     * </pre>
     *
     * <code>.google.devtools.clouddebugger.v2.StatusMessage status = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StatusMessage,
            com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
            com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.StatusMessage,
                com.google.devtools.clouddebugger.v2.StatusMessage.Builder,
                com.google.devtools.clouddebugger.v2.StatusMessageOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.devtools.clouddebugger.v2.StackFrame> stackFrames_ =
        java.util.Collections.emptyList();

    private void ensureStackFramesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        stackFrames_ =
            new java.util.ArrayList<com.google.devtools.clouddebugger.v2.StackFrame>(stackFrames_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StackFrame,
            com.google.devtools.clouddebugger.v2.StackFrame.Builder,
            com.google.devtools.clouddebugger.v2.StackFrameOrBuilder>
        stackFramesBuilder_;

    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.StackFrame> getStackFramesList() {
      if (stackFramesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stackFrames_);
      } else {
        return stackFramesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public int getStackFramesCount() {
      if (stackFramesBuilder_ == null) {
        return stackFrames_.size();
      } else {
        return stackFramesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public com.google.devtools.clouddebugger.v2.StackFrame getStackFrames(int index) {
      if (stackFramesBuilder_ == null) {
        return stackFrames_.get(index);
      } else {
        return stackFramesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder setStackFrames(
        int index, com.google.devtools.clouddebugger.v2.StackFrame value) {
      if (stackFramesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStackFramesIsMutable();
        stackFrames_.set(index, value);
        onChanged();
      } else {
        stackFramesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder setStackFrames(
        int index, com.google.devtools.clouddebugger.v2.StackFrame.Builder builderForValue) {
      if (stackFramesBuilder_ == null) {
        ensureStackFramesIsMutable();
        stackFrames_.set(index, builderForValue.build());
        onChanged();
      } else {
        stackFramesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder addStackFrames(com.google.devtools.clouddebugger.v2.StackFrame value) {
      if (stackFramesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStackFramesIsMutable();
        stackFrames_.add(value);
        onChanged();
      } else {
        stackFramesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder addStackFrames(
        int index, com.google.devtools.clouddebugger.v2.StackFrame value) {
      if (stackFramesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStackFramesIsMutable();
        stackFrames_.add(index, value);
        onChanged();
      } else {
        stackFramesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder addStackFrames(
        com.google.devtools.clouddebugger.v2.StackFrame.Builder builderForValue) {
      if (stackFramesBuilder_ == null) {
        ensureStackFramesIsMutable();
        stackFrames_.add(builderForValue.build());
        onChanged();
      } else {
        stackFramesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder addStackFrames(
        int index, com.google.devtools.clouddebugger.v2.StackFrame.Builder builderForValue) {
      if (stackFramesBuilder_ == null) {
        ensureStackFramesIsMutable();
        stackFrames_.add(index, builderForValue.build());
        onChanged();
      } else {
        stackFramesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder addAllStackFrames(
        java.lang.Iterable<? extends com.google.devtools.clouddebugger.v2.StackFrame> values) {
      if (stackFramesBuilder_ == null) {
        ensureStackFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stackFrames_);
        onChanged();
      } else {
        stackFramesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder clearStackFrames() {
      if (stackFramesBuilder_ == null) {
        stackFrames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        stackFramesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public Builder removeStackFrames(int index) {
      if (stackFramesBuilder_ == null) {
        ensureStackFramesIsMutable();
        stackFrames_.remove(index);
        onChanged();
      } else {
        stackFramesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public com.google.devtools.clouddebugger.v2.StackFrame.Builder getStackFramesBuilder(
        int index) {
      return getStackFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public com.google.devtools.clouddebugger.v2.StackFrameOrBuilder getStackFramesOrBuilder(
        int index) {
      if (stackFramesBuilder_ == null) {
        return stackFrames_.get(index);
      } else {
        return stackFramesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public java.util.List<? extends com.google.devtools.clouddebugger.v2.StackFrameOrBuilder>
        getStackFramesOrBuilderList() {
      if (stackFramesBuilder_ != null) {
        return stackFramesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stackFrames_);
      }
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public com.google.devtools.clouddebugger.v2.StackFrame.Builder addStackFramesBuilder() {
      return getStackFramesFieldBuilder()
          .addBuilder(com.google.devtools.clouddebugger.v2.StackFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public com.google.devtools.clouddebugger.v2.StackFrame.Builder addStackFramesBuilder(
        int index) {
      return getStackFramesFieldBuilder()
          .addBuilder(index, com.google.devtools.clouddebugger.v2.StackFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The stack at breakpoint time, where stack_frames[0] represents the most
     * recently entered function.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.StackFrame stack_frames = 7;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.StackFrame.Builder>
        getStackFramesBuilderList() {
      return getStackFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.StackFrame,
            com.google.devtools.clouddebugger.v2.StackFrame.Builder,
            com.google.devtools.clouddebugger.v2.StackFrameOrBuilder>
        getStackFramesFieldBuilder() {
      if (stackFramesBuilder_ == null) {
        stackFramesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.StackFrame,
                com.google.devtools.clouddebugger.v2.StackFrame.Builder,
                com.google.devtools.clouddebugger.v2.StackFrameOrBuilder>(
                stackFrames_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        stackFrames_ = null;
      }
      return stackFramesBuilder_;
    }

    private java.util.List<com.google.devtools.clouddebugger.v2.Variable> evaluatedExpressions_ =
        java.util.Collections.emptyList();

    private void ensureEvaluatedExpressionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        evaluatedExpressions_ =
            new java.util.ArrayList<com.google.devtools.clouddebugger.v2.Variable>(
                evaluatedExpressions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        evaluatedExpressionsBuilder_;

    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable>
        getEvaluatedExpressionsList() {
      if (evaluatedExpressionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(evaluatedExpressions_);
      } else {
        return evaluatedExpressionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public int getEvaluatedExpressionsCount() {
      if (evaluatedExpressionsBuilder_ == null) {
        return evaluatedExpressions_.size();
      } else {
        return evaluatedExpressionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable getEvaluatedExpressions(int index) {
      if (evaluatedExpressionsBuilder_ == null) {
        return evaluatedExpressions_.get(index);
      } else {
        return evaluatedExpressionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder setEvaluatedExpressions(
        int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (evaluatedExpressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.set(index, value);
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder setEvaluatedExpressions(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (evaluatedExpressionsBuilder_ == null) {
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.set(index, builderForValue.build());
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder addEvaluatedExpressions(com.google.devtools.clouddebugger.v2.Variable value) {
      if (evaluatedExpressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.add(value);
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder addEvaluatedExpressions(
        int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (evaluatedExpressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.add(index, value);
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder addEvaluatedExpressions(
        com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (evaluatedExpressionsBuilder_ == null) {
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.add(builderForValue.build());
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder addEvaluatedExpressions(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (evaluatedExpressionsBuilder_ == null) {
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.add(index, builderForValue.build());
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder addAllEvaluatedExpressions(
        java.lang.Iterable<? extends com.google.devtools.clouddebugger.v2.Variable> values) {
      if (evaluatedExpressionsBuilder_ == null) {
        ensureEvaluatedExpressionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, evaluatedExpressions_);
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder clearEvaluatedExpressions() {
      if (evaluatedExpressionsBuilder_ == null) {
        evaluatedExpressions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public Builder removeEvaluatedExpressions(int index) {
      if (evaluatedExpressionsBuilder_ == null) {
        ensureEvaluatedExpressionsIsMutable();
        evaluatedExpressions_.remove(index);
        onChanged();
      } else {
        evaluatedExpressionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder getEvaluatedExpressionsBuilder(
        int index) {
      return getEvaluatedExpressionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.VariableOrBuilder getEvaluatedExpressionsOrBuilder(
        int index) {
      if (evaluatedExpressionsBuilder_ == null) {
        return evaluatedExpressions_.get(index);
      } else {
        return evaluatedExpressionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getEvaluatedExpressionsOrBuilderList() {
      if (evaluatedExpressionsBuilder_ != null) {
        return evaluatedExpressionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(evaluatedExpressions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addEvaluatedExpressionsBuilder() {
      return getEvaluatedExpressionsFieldBuilder()
          .addBuilder(com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addEvaluatedExpressionsBuilder(
        int index) {
      return getEvaluatedExpressionsFieldBuilder()
          .addBuilder(index, com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Values of evaluated expressions at breakpoint time.
     * The evaluated expressions appear in exactly the same order they
     * are listed in the `expressions` field.
     * The `name` field holds the original expression text, the `value` or
     * `members` field holds the result of the evaluated expression.
     * If the expression cannot be evaluated, the `status` inside the `Variable`
     * will indicate an error and contain the error text.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable evaluated_expressions = 8;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable.Builder>
        getEvaluatedExpressionsBuilderList() {
      return getEvaluatedExpressionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getEvaluatedExpressionsFieldBuilder() {
      if (evaluatedExpressionsBuilder_ == null) {
        evaluatedExpressionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.Variable,
                com.google.devtools.clouddebugger.v2.Variable.Builder,
                com.google.devtools.clouddebugger.v2.VariableOrBuilder>(
                evaluatedExpressions_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        evaluatedExpressions_ = null;
      }
      return evaluatedExpressionsBuilder_;
    }

    private java.util.List<com.google.devtools.clouddebugger.v2.Variable> variableTable_ =
        java.util.Collections.emptyList();

    private void ensureVariableTableIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        variableTable_ =
            new java.util.ArrayList<com.google.devtools.clouddebugger.v2.Variable>(variableTable_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        variableTableBuilder_;

    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable> getVariableTableList() {
      if (variableTableBuilder_ == null) {
        return java.util.Collections.unmodifiableList(variableTable_);
      } else {
        return variableTableBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public int getVariableTableCount() {
      if (variableTableBuilder_ == null) {
        return variableTable_.size();
      } else {
        return variableTableBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable getVariableTable(int index) {
      if (variableTableBuilder_ == null) {
        return variableTable_.get(index);
      } else {
        return variableTableBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder setVariableTable(
        int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (variableTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariableTableIsMutable();
        variableTable_.set(index, value);
        onChanged();
      } else {
        variableTableBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder setVariableTable(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (variableTableBuilder_ == null) {
        ensureVariableTableIsMutable();
        variableTable_.set(index, builderForValue.build());
        onChanged();
      } else {
        variableTableBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder addVariableTable(com.google.devtools.clouddebugger.v2.Variable value) {
      if (variableTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariableTableIsMutable();
        variableTable_.add(value);
        onChanged();
      } else {
        variableTableBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder addVariableTable(
        int index, com.google.devtools.clouddebugger.v2.Variable value) {
      if (variableTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariableTableIsMutable();
        variableTable_.add(index, value);
        onChanged();
      } else {
        variableTableBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder addVariableTable(
        com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (variableTableBuilder_ == null) {
        ensureVariableTableIsMutable();
        variableTable_.add(builderForValue.build());
        onChanged();
      } else {
        variableTableBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder addVariableTable(
        int index, com.google.devtools.clouddebugger.v2.Variable.Builder builderForValue) {
      if (variableTableBuilder_ == null) {
        ensureVariableTableIsMutable();
        variableTable_.add(index, builderForValue.build());
        onChanged();
      } else {
        variableTableBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder addAllVariableTable(
        java.lang.Iterable<? extends com.google.devtools.clouddebugger.v2.Variable> values) {
      if (variableTableBuilder_ == null) {
        ensureVariableTableIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, variableTable_);
        onChanged();
      } else {
        variableTableBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder clearVariableTable() {
      if (variableTableBuilder_ == null) {
        variableTable_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        variableTableBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public Builder removeVariableTable(int index) {
      if (variableTableBuilder_ == null) {
        ensureVariableTableIsMutable();
        variableTable_.remove(index);
        onChanged();
      } else {
        variableTableBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder getVariableTableBuilder(
        int index) {
      return getVariableTableFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public com.google.devtools.clouddebugger.v2.VariableOrBuilder getVariableTableOrBuilder(
        int index) {
      if (variableTableBuilder_ == null) {
        return variableTable_.get(index);
      } else {
        return variableTableBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public java.util.List<? extends com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getVariableTableOrBuilderList() {
      if (variableTableBuilder_ != null) {
        return variableTableBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(variableTable_);
      }
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addVariableTableBuilder() {
      return getVariableTableFieldBuilder()
          .addBuilder(com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public com.google.devtools.clouddebugger.v2.Variable.Builder addVariableTableBuilder(
        int index) {
      return getVariableTableFieldBuilder()
          .addBuilder(index, com.google.devtools.clouddebugger.v2.Variable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The `variable_table` exists to aid with computation, memory and network
     * traffic optimization.  It enables storing a variable once and reference
     * it from multiple variables, including variables stored in the
     * `variable_table` itself.
     * For example, the same `this` object, which may appear at many levels of
     * the stack, can have all of its data stored once in this table.  The
     * stack frame variables then would hold only a reference to it.
     * The variable `var_table_index` field is an index into this repeated field.
     * The stored objects are nameless and get their name from the referencing
     * variable. The effective variable is a merge of the referencing variable
     * and the referenced variable.
     * </pre>
     *
     * <code>repeated .google.devtools.clouddebugger.v2.Variable variable_table = 9;</code>
     */
    public java.util.List<com.google.devtools.clouddebugger.v2.Variable.Builder>
        getVariableTableBuilderList() {
      return getVariableTableFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.devtools.clouddebugger.v2.Variable,
            com.google.devtools.clouddebugger.v2.Variable.Builder,
            com.google.devtools.clouddebugger.v2.VariableOrBuilder>
        getVariableTableFieldBuilder() {
      if (variableTableBuilder_ == null) {
        variableTableBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.devtools.clouddebugger.v2.Variable,
                com.google.devtools.clouddebugger.v2.Variable.Builder,
                com.google.devtools.clouddebugger.v2.VariableOrBuilder>(
                variableTable_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        variableTable_ = null;
      }
      return variableTableBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of custom breakpoint properties, populated by the agent, to be
     * displayed to the user.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.clouddebugger.v2.Breakpoint)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.clouddebugger.v2.Breakpoint)
  private static final com.google.devtools.clouddebugger.v2.Breakpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.clouddebugger.v2.Breakpoint();
  }

  public static com.google.devtools.clouddebugger.v2.Breakpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Breakpoint> PARSER =
      new com.google.protobuf.AbstractParser<Breakpoint>() {
        @java.lang.Override
        public Breakpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Breakpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Breakpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.clouddebugger.v2.Breakpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
