/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/translation_config.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * The potential components of a full name mapping that will be mapped
 * during translation in the source data warehouse.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.NameMappingKey}
 */
public final class NameMappingKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.NameMappingKey)
    NameMappingKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NameMappingKey.newBuilder() to construct.
  private NameMappingKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NameMappingKey() {
    type_ = 0;
    database_ = "";
    schema_ = "";
    relation_ = "";
    attribute_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NameMappingKey();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
        .internal_static_google_cloud_bigquery_migration_v2_NameMappingKey_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
        .internal_static_google_cloud_bigquery_migration_v2_NameMappingKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.NameMappingKey.class,
            com.google.cloud.bigquery.migration.v2.NameMappingKey.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the object that is being mapped.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.migration.v2.NameMappingKey.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified name mapping type.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The object being mapped is a database.
     * </pre>
     *
     * <code>DATABASE = 1;</code>
     */
    DATABASE(1),
    /**
     *
     *
     * <pre>
     * The object being mapped is a schema.
     * </pre>
     *
     * <code>SCHEMA = 2;</code>
     */
    SCHEMA(2),
    /**
     *
     *
     * <pre>
     * The object being mapped is a relation.
     * </pre>
     *
     * <code>RELATION = 3;</code>
     */
    RELATION(3),
    /**
     *
     *
     * <pre>
     * The object being mapped is an attribute.
     * </pre>
     *
     * <code>ATTRIBUTE = 4;</code>
     */
    ATTRIBUTE(4),
    /**
     *
     *
     * <pre>
     * The object being mapped is a relation alias.
     * </pre>
     *
     * <code>RELATION_ALIAS = 5;</code>
     */
    RELATION_ALIAS(5),
    /**
     *
     *
     * <pre>
     * The object being mapped is a an attribute alias.
     * </pre>
     *
     * <code>ATTRIBUTE_ALIAS = 6;</code>
     */
    ATTRIBUTE_ALIAS(6),
    /**
     *
     *
     * <pre>
     * The object being mapped is a function.
     * </pre>
     *
     * <code>FUNCTION = 7;</code>
     */
    FUNCTION(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified name mapping type.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The object being mapped is a database.
     * </pre>
     *
     * <code>DATABASE = 1;</code>
     */
    public static final int DATABASE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The object being mapped is a schema.
     * </pre>
     *
     * <code>SCHEMA = 2;</code>
     */
    public static final int SCHEMA_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The object being mapped is a relation.
     * </pre>
     *
     * <code>RELATION = 3;</code>
     */
    public static final int RELATION_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The object being mapped is an attribute.
     * </pre>
     *
     * <code>ATTRIBUTE = 4;</code>
     */
    public static final int ATTRIBUTE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The object being mapped is a relation alias.
     * </pre>
     *
     * <code>RELATION_ALIAS = 5;</code>
     */
    public static final int RELATION_ALIAS_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The object being mapped is a an attribute alias.
     * </pre>
     *
     * <code>ATTRIBUTE_ALIAS = 6;</code>
     */
    public static final int ATTRIBUTE_ALIAS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The object being mapped is a function.
     * </pre>
     *
     * <code>FUNCTION = 7;</code>
     */
    public static final int FUNCTION_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return DATABASE;
        case 2:
          return SCHEMA;
        case 3:
          return RELATION;
        case 4:
          return ATTRIBUTE;
        case 5:
          return RELATION_ALIAS;
        case 6:
          return ATTRIBUTE_ALIAS;
        case 7:
          return FUNCTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.NameMappingKey.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2.NameMappingKey.Type)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_;
  /**
   *
   *
   * <pre>
   * The type of object that is being mapped.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of object that is being mapped.
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.NameMappingKey.Type getType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.migration.v2.NameMappingKey.Type result =
        com.google.cloud.bigquery.migration.v2.NameMappingKey.Type.valueOf(type_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2.NameMappingKey.Type.UNRECOGNIZED
        : result;
  }

  public static final int DATABASE_FIELD_NUMBER = 2;
  private volatile java.lang.Object database_;
  /**
   *
   *
   * <pre>
   * The database name (BigQuery project ID equivalent in the source data
   * warehouse).
   * </pre>
   *
   * <code>string database = 2;</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The database name (BigQuery project ID equivalent in the source data
   * warehouse).
   * </pre>
   *
   * <code>string database = 2;</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_FIELD_NUMBER = 3;
  private volatile java.lang.Object schema_;
  /**
   *
   *
   * <pre>
   * The schema name (BigQuery dataset equivalent in the source data warehouse).
   * </pre>
   *
   * <code>string schema = 3;</code>
   *
   * @return The schema.
   */
  @java.lang.Override
  public java.lang.String getSchema() {
    java.lang.Object ref = schema_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schema_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The schema name (BigQuery dataset equivalent in the source data warehouse).
   * </pre>
   *
   * <code>string schema = 3;</code>
   *
   * @return The bytes for schema.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaBytes() {
    java.lang.Object ref = schema_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schema_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELATION_FIELD_NUMBER = 4;
  private volatile java.lang.Object relation_;
  /**
   *
   *
   * <pre>
   * The relation name (BigQuery table or view equivalent in the source data
   * warehouse).
   * </pre>
   *
   * <code>string relation = 4;</code>
   *
   * @return The relation.
   */
  @java.lang.Override
  public java.lang.String getRelation() {
    java.lang.Object ref = relation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relation name (BigQuery table or view equivalent in the source data
   * warehouse).
   * </pre>
   *
   * <code>string relation = 4;</code>
   *
   * @return The bytes for relation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelationBytes() {
    java.lang.Object ref = relation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTRIBUTE_FIELD_NUMBER = 5;
  private volatile java.lang.Object attribute_;
  /**
   *
   *
   * <pre>
   * The attribute name (BigQuery column equivalent in the source data
   * warehouse).
   * </pre>
   *
   * <code>string attribute = 5;</code>
   *
   * @return The attribute.
   */
  @java.lang.Override
  public java.lang.String getAttribute() {
    java.lang.Object ref = attribute_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attribute_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The attribute name (BigQuery column equivalent in the source data
   * warehouse).
   * </pre>
   *
   * <code>string attribute = 5;</code>
   *
   * @return The bytes for attribute.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributeBytes() {
    java.lang.Object ref = attribute_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attribute_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.cloud.bigquery.migration.v2.NameMappingKey.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, database_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, schema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, relation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attribute_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, attribute_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.cloud.bigquery.migration.v2.NameMappingKey.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, database_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, schema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, relation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attribute_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, attribute_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.NameMappingKey)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.NameMappingKey other =
        (com.google.cloud.bigquery.migration.v2.NameMappingKey) obj;

    if (type_ != other.type_) return false;
    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getSchema().equals(other.getSchema())) return false;
    if (!getRelation().equals(other.getRelation())) return false;
    if (!getAttribute().equals(other.getAttribute())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + getSchema().hashCode();
    hash = (37 * hash) + RELATION_FIELD_NUMBER;
    hash = (53 * hash) + getRelation().hashCode();
    hash = (37 * hash) + ATTRIBUTE_FIELD_NUMBER;
    hash = (53 * hash) + getAttribute().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2.NameMappingKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The potential components of a full name mapping that will be mapped
   * during translation in the source data warehouse.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.NameMappingKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.NameMappingKey)
      com.google.cloud.bigquery.migration.v2.NameMappingKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_NameMappingKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_NameMappingKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.NameMappingKey.class,
              com.google.cloud.bigquery.migration.v2.NameMappingKey.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.NameMappingKey.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      type_ = 0;

      database_ = "";

      schema_ = "";

      relation_ = "";

      attribute_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_NameMappingKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.NameMappingKey getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.NameMappingKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.NameMappingKey build() {
      com.google.cloud.bigquery.migration.v2.NameMappingKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.NameMappingKey buildPartial() {
      com.google.cloud.bigquery.migration.v2.NameMappingKey result =
          new com.google.cloud.bigquery.migration.v2.NameMappingKey(this);
      result.type_ = type_;
      result.database_ = database_;
      result.schema_ = schema_;
      result.relation_ = relation_;
      result.attribute_ = attribute_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.NameMappingKey) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.NameMappingKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2.NameMappingKey other) {
      if (other == com.google.cloud.bigquery.migration.v2.NameMappingKey.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        onChanged();
      }
      if (!other.getSchema().isEmpty()) {
        schema_ = other.schema_;
        onChanged();
      }
      if (!other.getRelation().isEmpty()) {
        relation_ = other.relation_;
        onChanged();
      }
      if (!other.getAttribute().isEmpty()) {
        attribute_ = other.attribute_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                database_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                schema_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                relation_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                attribute_ = input.readStringRequireUtf8();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of object that is being mapped.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of object that is being mapped.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of object that is being mapped.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.NameMappingKey.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.migration.v2.NameMappingKey.Type result =
          com.google.cloud.bigquery.migration.v2.NameMappingKey.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2.NameMappingKey.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of object that is being mapped.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.bigquery.migration.v2.NameMappingKey.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of object that is being mapped.
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NameMappingKey.Type type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * The database name (BigQuery project ID equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The database name (BigQuery project ID equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The database name (BigQuery project ID equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      database_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database name (BigQuery project ID equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {

      database_ = getDefaultInstance().getDatabase();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database name (BigQuery project ID equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      database_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object schema_ = "";
    /**
     *
     *
     * <pre>
     * The schema name (BigQuery dataset equivalent in the source data warehouse).
     * </pre>
     *
     * <code>string schema = 3;</code>
     *
     * @return The schema.
     */
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema name (BigQuery dataset equivalent in the source data warehouse).
     * </pre>
     *
     * <code>string schema = 3;</code>
     *
     * @return The bytes for schema.
     */
    public com.google.protobuf.ByteString getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema name (BigQuery dataset equivalent in the source data warehouse).
     * </pre>
     *
     * <code>string schema = 3;</code>
     *
     * @param value The schema to set.
     * @return This builder for chaining.
     */
    public Builder setSchema(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      schema_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema name (BigQuery dataset equivalent in the source data warehouse).
     * </pre>
     *
     * <code>string schema = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchema() {

      schema_ = getDefaultInstance().getSchema();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema name (BigQuery dataset equivalent in the source data warehouse).
     * </pre>
     *
     * <code>string schema = 3;</code>
     *
     * @param value The bytes for schema to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      schema_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object relation_ = "";
    /**
     *
     *
     * <pre>
     * The relation name (BigQuery table or view equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string relation = 4;</code>
     *
     * @return The relation.
     */
    public java.lang.String getRelation() {
      java.lang.Object ref = relation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relation name (BigQuery table or view equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string relation = 4;</code>
     *
     * @return The bytes for relation.
     */
    public com.google.protobuf.ByteString getRelationBytes() {
      java.lang.Object ref = relation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relation name (BigQuery table or view equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string relation = 4;</code>
     *
     * @param value The relation to set.
     * @return This builder for chaining.
     */
    public Builder setRelation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      relation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relation name (BigQuery table or view equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string relation = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelation() {

      relation_ = getDefaultInstance().getRelation();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relation name (BigQuery table or view equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string relation = 4;</code>
     *
     * @param value The bytes for relation to set.
     * @return This builder for chaining.
     */
    public Builder setRelationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      relation_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object attribute_ = "";
    /**
     *
     *
     * <pre>
     * The attribute name (BigQuery column equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string attribute = 5;</code>
     *
     * @return The attribute.
     */
    public java.lang.String getAttribute() {
      java.lang.Object ref = attribute_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attribute_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The attribute name (BigQuery column equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string attribute = 5;</code>
     *
     * @return The bytes for attribute.
     */
    public com.google.protobuf.ByteString getAttributeBytes() {
      java.lang.Object ref = attribute_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attribute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The attribute name (BigQuery column equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string attribute = 5;</code>
     *
     * @param value The attribute to set.
     * @return This builder for chaining.
     */
    public Builder setAttribute(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      attribute_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The attribute name (BigQuery column equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string attribute = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttribute() {

      attribute_ = getDefaultInstance().getAttribute();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The attribute name (BigQuery column equivalent in the source data
     * warehouse).
     * </pre>
     *
     * <code>string attribute = 5;</code>
     *
     * @param value The bytes for attribute to set.
     * @return This builder for chaining.
     */
    public Builder setAttributeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      attribute_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.NameMappingKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.NameMappingKey)
  private static final com.google.cloud.bigquery.migration.v2.NameMappingKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.NameMappingKey();
  }

  public static com.google.cloud.bigquery.migration.v2.NameMappingKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NameMappingKey> PARSER =
      new com.google.protobuf.AbstractParser<NameMappingKey>() {
        @java.lang.Override
        public NameMappingKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NameMappingKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NameMappingKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.NameMappingKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
