/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/migration_entities.proto

package com.google.cloud.bigquery.migration.v2;

public interface MigrationWorkflowOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.migration.v2.MigrationWorkflow)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration workflow.
   * The ID is server-generated.
   * Example: `projects/123/locations/us/workflows/345`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration workflow.
   * The ID is server-generated.
   * Example: `projects/123/locations/us/workflows/345`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The display name of the workflow. This can be set to give a workflow
   * a descriptive name. There is no guarantee or enforcement of uniqueness.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * The display name of the workflow. This can be set to give a workflow
   * a descriptive name. There is no guarantee or enforcement of uniqueness.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  int getTasksCount();
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  boolean containsTasks(java.lang.String key);
  /** Use {@link #getTasksMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask> getTasks();
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
      getTasksMap();
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */

  /* nullable */
  com.google.cloud.bigquery.migration.v2.MigrationTask getTasksOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.bigquery.migration.v2.MigrationTask defaultValue);
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  com.google.cloud.bigquery.migration.v2.MigrationTask getTasksOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. That status of the workflow.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. That status of the workflow.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State getState();

  /**
   *
   *
   * <pre>
   * Time when the workflow was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Time when the workflow was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Time when the workflow was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Time when the workflow was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  boolean hasLastUpdateTime();
  /**
   *
   *
   * <pre>
   * Time when the workflow was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
   *
   * @return The lastUpdateTime.
   */
  com.google.protobuf.Timestamp getLastUpdateTime();
  /**
   *
   *
   * <pre>
   * Time when the workflow was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
   */
  com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder();
}
