/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/migration_entities.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * A migration workflow which specifies what needs to be done for an EDW
 * migration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.MigrationWorkflow}
 */
public final class MigrationWorkflow extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.MigrationWorkflow)
    MigrationWorkflowOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrationWorkflow.newBuilder() to construct.
  private MigrationWorkflow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationWorkflow() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationWorkflow();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2_MigrationWorkflow_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetTasks();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2_MigrationWorkflow_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.MigrationWorkflow.class,
            com.google.cloud.bigquery.migration.v2.MigrationWorkflow.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible migration workflow states.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.migration.v2.MigrationWorkflow.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Workflow state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Workflow is in draft status, i.e. tasks are not yet eligible for
     * execution.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    DRAFT(1),
    /**
     *
     *
     * <pre>
     * Workflow is running (i.e. tasks are eligible for execution).
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * Workflow is paused. Tasks currently in progress may continue, but no
     * further tasks will be scheduled.
     * </pre>
     *
     * <code>PAUSED = 3;</code>
     */
    PAUSED(3),
    /**
     *
     *
     * <pre>
     * Workflow is complete. There should not be any task in a non-terminal
     * state, but if they are (e.g. forced termination), they will not be
     * scheduled.
     * </pre>
     *
     * <code>COMPLETED = 4;</code>
     */
    COMPLETED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Workflow state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Workflow is in draft status, i.e. tasks are not yet eligible for
     * execution.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    public static final int DRAFT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Workflow is running (i.e. tasks are eligible for execution).
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Workflow is paused. Tasks currently in progress may continue, but no
     * further tasks will be scheduled.
     * </pre>
     *
     * <code>PAUSED = 3;</code>
     */
    public static final int PAUSED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Workflow is complete. There should not be any task in a non-terminal
     * state, but if they are (e.g. forced termination), they will not be
     * scheduled.
     * </pre>
     *
     * <code>COMPLETED = 4;</code>
     */
    public static final int COMPLETED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return DRAFT;
        case 2:
          return RUNNING;
        case 3:
          return PAUSED;
        case 4:
          return COMPLETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationWorkflow.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2.MigrationWorkflow.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration workflow.
   * The ID is server-generated.
   * Example: `projects/123/locations/us/workflows/345`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The unique identifier for the migration workflow.
   * The ID is server-generated.
   * Example: `projects/123/locations/us/workflows/345`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the workflow. This can be set to give a workflow
   * a descriptive name. There is no guarantee or enforcement of uniqueness.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the workflow. This can be set to give a workflow
   * a descriptive name. There is no guarantee or enforcement of uniqueness.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TASKS_FIELD_NUMBER = 2;

  private static final class TasksDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
                    newDefaultInstance(
                        com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
                            .internal_static_google_cloud_bigquery_migration_v2_MigrationWorkflow_TasksEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.bigquery.migration.v2.MigrationTask.getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
      tasks_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
      internalGetTasks() {
    if (tasks_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TasksDefaultEntryHolder.defaultEntry);
    }
    return tasks_;
  }

  public int getTasksCount() {
    return internalGetTasks().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  @java.lang.Override
  public boolean containsTasks(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTasks().getMap().containsKey(key);
  }
  /** Use {@link #getTasksMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
      getTasks() {
    return getTasksMap();
  }
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
      getTasksMap() {
    return internalGetTasks().getMap();
  }
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationTask getTasksOrDefault(
      java.lang.String key, com.google.cloud.bigquery.migration.v2.MigrationTask defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask> map =
        internalGetTasks().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The tasks in a workflow in a named map. The name (i.e. key) has no
   * meaning and is merely a convenient way to address a specific task
   * in a workflow.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationTask getTasksOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask> map =
        internalGetTasks().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. That status of the workflow.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. That status of the workflow.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State result =
        com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State.valueOf(state_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Time when the workflow was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the workflow was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the workflow was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp lastUpdateTime_;
  /**
   *
   *
   * <pre>
   * Time when the workflow was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return lastUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the workflow was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the workflow was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return getLastUpdateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTasks(), TasksDefaultEntryHolder.defaultEntry, 2);
    if (state_
        != com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      output.writeMessage(5, getLastUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        entry : internalGetTasks().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
          tasks__ =
              TasksDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, tasks__);
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getLastUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.MigrationWorkflow)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.MigrationWorkflow other =
        (com.google.cloud.bigquery.migration.v2.MigrationWorkflow) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetTasks().equals(other.internalGetTasks())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetTasks().getMap().isEmpty()) {
      hash = (37 * hash) + TASKS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTasks().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2.MigrationWorkflow prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A migration workflow which specifies what needs to be done for an EDW
   * migration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.MigrationWorkflow}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.MigrationWorkflow)
      com.google.cloud.bigquery.migration.v2.MigrationWorkflowOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationWorkflow_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetTasks();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableTasks();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationWorkflow_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.MigrationWorkflow.class,
              com.google.cloud.bigquery.migration.v2.MigrationWorkflow.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.MigrationWorkflow.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      internalGetMutableTasks().clear();
      state_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = null;
      } else {
        lastUpdateTime_ = null;
        lastUpdateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationWorkflow_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationWorkflow getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationWorkflow.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationWorkflow build() {
      com.google.cloud.bigquery.migration.v2.MigrationWorkflow result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationWorkflow buildPartial() {
      com.google.cloud.bigquery.migration.v2.MigrationWorkflow result =
          new com.google.cloud.bigquery.migration.v2.MigrationWorkflow(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.tasks_ = internalGetTasks();
      result.tasks_.makeImmutable();
      result.state_ = state_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (lastUpdateTimeBuilder_ == null) {
        result.lastUpdateTime_ = lastUpdateTime_;
      } else {
        result.lastUpdateTime_ = lastUpdateTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.MigrationWorkflow) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.MigrationWorkflow) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2.MigrationWorkflow other) {
      if (other == com.google.cloud.bigquery.migration.v2.MigrationWorkflow.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      internalGetMutableTasks().mergeFrom(other.internalGetTasks());
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
                    tasks__ =
                        input.readMessage(
                            TasksDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableTasks().getMutableMap().put(tasks__.getKey(), tasks__.getValue());
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration workflow.
     * The ID is server-generated.
     * Example: `projects/123/locations/us/workflows/345`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration workflow.
     * The ID is server-generated.
     * Example: `projects/123/locations/us/workflows/345`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration workflow.
     * The ID is server-generated.
     * Example: `projects/123/locations/us/workflows/345`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration workflow.
     * The ID is server-generated.
     * Example: `projects/123/locations/us/workflows/345`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The unique identifier for the migration workflow.
     * The ID is server-generated.
     * Example: `projects/123/locations/us/workflows/345`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the workflow. This can be set to give a workflow
     * a descriptive name. There is no guarantee or enforcement of uniqueness.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the workflow. This can be set to give a workflow
     * a descriptive name. There is no guarantee or enforcement of uniqueness.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the workflow. This can be set to give a workflow
     * a descriptive name. There is no guarantee or enforcement of uniqueness.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the workflow. This can be set to give a workflow
     * a descriptive name. There is no guarantee or enforcement of uniqueness.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the workflow. This can be set to give a workflow
     * a descriptive name. There is no guarantee or enforcement of uniqueness.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        tasks_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        internalGetTasks() {
      if (tasks_ == null) {
        return com.google.protobuf.MapField.emptyMapField(TasksDefaultEntryHolder.defaultEntry);
      }
      return tasks_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        internalGetMutableTasks() {
      onChanged();
      ;
      if (tasks_ == null) {
        tasks_ = com.google.protobuf.MapField.newMapField(TasksDefaultEntryHolder.defaultEntry);
      }
      if (!tasks_.isMutable()) {
        tasks_ = tasks_.copy();
      }
      return tasks_;
    }

    public int getTasksCount() {
      return internalGetTasks().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    @java.lang.Override
    public boolean containsTasks(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTasks().getMap().containsKey(key);
    }
    /** Use {@link #getTasksMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        getTasks() {
      return getTasksMap();
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        getTasksMap() {
      return internalGetTasks().getMap();
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationTask getTasksOrDefault(
        java.lang.String key, com.google.cloud.bigquery.migration.v2.MigrationTask defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask> map =
          internalGetTasks().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationTask getTasksOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask> map =
          internalGetTasks().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTasks() {
      internalGetMutableTasks().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    public Builder removeTasks(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTasks().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
        getMutableTasks() {
      return internalGetMutableTasks().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    public Builder putTasks(
        java.lang.String key, com.google.cloud.bigquery.migration.v2.MigrationTask value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableTasks().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tasks in a workflow in a named map. The name (i.e. key) has no
     * meaning and is merely a convenient way to address a specific task
     * in a workflow.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.bigquery.migration.v2.MigrationTask&gt; tasks = 2;</code>
     */
    public Builder putAllTasks(
        java.util.Map<java.lang.String, com.google.cloud.bigquery.migration.v2.MigrationTask>
            values) {
      internalGetMutableTasks().getMutableMap().putAll(values);
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. That status of the workflow.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. That status of the workflow.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. That status of the workflow.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State result =
          com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State.valueOf(state_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. That status of the workflow.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.migration.v2.MigrationWorkflow.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. That status of the workflow.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationWorkflow.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return lastUpdateTimeBuilder_ != null || lastUpdateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
        onChanged();
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
        onChanged();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (lastUpdateTime_ != null) {
          lastUpdateTime_ =
              com.google.protobuf.Timestamp.newBuilder(lastUpdateTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          lastUpdateTime_ = value;
        }
        onChanged();
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    public Builder clearLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = null;
        onChanged();
      } else {
        lastUpdateTime_ = null;
        lastUpdateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {

      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the workflow was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.MigrationWorkflow)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.MigrationWorkflow)
  private static final com.google.cloud.bigquery.migration.v2.MigrationWorkflow DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.MigrationWorkflow();
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationWorkflow getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationWorkflow> PARSER =
      new com.google.protobuf.AbstractParser<MigrationWorkflow>() {
        @java.lang.Override
        public MigrationWorkflow parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationWorkflow> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationWorkflow> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationWorkflow getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
