/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/migration_entities.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * A subtask for a migration which carries details about the configuration of
 * the subtask. The content of the details should not matter to the end user,
 * but is a contract between the subtask creator and subtask worker.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.MigrationSubtask}
 */
public final class MigrationSubtask extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.MigrationSubtask)
    MigrationSubtaskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrationSubtask.newBuilder() to construct.
  private MigrationSubtask(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationSubtask() {
    name_ = "";
    taskId_ = "";
    type_ = "";
    state_ = 0;
    resourceErrorDetails_ = java.util.Collections.emptyList();
    metrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationSubtask();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2_MigrationSubtask_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
        .internal_static_google_cloud_bigquery_migration_v2_MigrationSubtask_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.MigrationSubtask.class,
            com.google.cloud.bigquery.migration.v2.MigrationSubtask.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a migration subtask.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.migration.v2.MigrationSubtask.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The subtask is ready, i.e. it is ready for execution.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The subtask is running, i.e. it is assigned to a worker for execution.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The subtask finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The subtask finished unsuccessfully.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The subtask is paused, i.e., it will not be scheduled. If it was already
     * assigned,it might still finish but no new lease renewals will be granted.
     * </pre>
     *
     * <code>PAUSED = 5;</code>
     */
    PAUSED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The subtask is ready, i.e. it is ready for execution.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The subtask is running, i.e. it is assigned to a worker for execution.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The subtask finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The subtask finished unsuccessfully.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The subtask is paused, i.e., it will not be scheduled. If it was already
     * assigned,it might still finish but no new lease renewals will be granted.
     * </pre>
     *
     * <code>PAUSED = 5;</code>
     */
    public static final int PAUSED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return RUNNING;
        case 3:
          return SUCCEEDED;
        case 4:
          return FAILED;
        case 5:
          return PAUSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationSubtask.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.migration.v2.MigrationSubtask.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The resource name for the migration subtask. The ID
   * is server-generated.
   * Example: `projects/123/locations/us/workflows/345/subtasks/678`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The resource name for the migration subtask. The ID
   * is server-generated.
   * Example: `projects/123/locations/us/workflows/345/subtasks/678`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TASK_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object taskId_;
  /**
   *
   *
   * <pre>
   * The unique ID of the task to which this subtask belongs.
   * </pre>
   *
   * <code>string task_id = 2;</code>
   *
   * @return The taskId.
   */
  @java.lang.Override
  public java.lang.String getTaskId() {
    java.lang.Object ref = taskId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      taskId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique ID of the task to which this subtask belongs.
   * </pre>
   *
   * <code>string task_id = 2;</code>
   *
   * @return The bytes for taskId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTaskIdBytes() {
    java.lang.Object ref = taskId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      taskId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private volatile java.lang.Object type_;
  /**
   *
   *
   * <pre>
   * The type of the Subtask. The migration service does not check whether this
   * is a known type. It is up to the task creator (i.e. orchestrator or worker)
   * to ensure it only creates subtasks for which there are compatible workers
   * polling for Subtasks.
   * </pre>
   *
   * <code>string type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the Subtask. The migration service does not check whether this
   * is a known type. It is up to the task creator (i.e. orchestrator or worker)
   * to ensure it only creates subtasks for which there are compatible workers
   * polling for Subtasks.
   * </pre>
   *
   * <code>string type = 3;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the subtask.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the subtask.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationSubtask.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.migration.v2.MigrationSubtask.State result =
        com.google.cloud.bigquery.migration.v2.MigrationSubtask.State.valueOf(state_);
    return result == null
        ? com.google.cloud.bigquery.migration.v2.MigrationSubtask.State.UNRECOGNIZED
        : result;
  }

  public static final int PROCESSING_ERROR_FIELD_NUMBER = 6;
  private com.google.rpc.ErrorInfo processingError_;
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in
   * FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the processingError field is set.
   */
  @java.lang.Override
  public boolean hasProcessingError() {
    return processingError_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in
   * FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The processingError.
   */
  @java.lang.Override
  public com.google.rpc.ErrorInfo getProcessingError() {
    return processingError_ == null
        ? com.google.rpc.ErrorInfo.getDefaultInstance()
        : processingError_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An explanation that may be populated when the task is in
   * FAILED state.
   * </pre>
   *
   * <code>.google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.ErrorInfoOrBuilder getProcessingErrorOrBuilder() {
    return getProcessingError();
  }

  public static final int RESOURCE_ERROR_DETAILS_FIELD_NUMBER = 12;
  private java.util.List<com.google.cloud.bigquery.migration.v2.ResourceErrorDetail>
      resourceErrorDetails_;
  /**
   *
   *
   * <pre>
   * Output only. Provides details to errors and issues encountered while
   * processing the subtask. Presence of error details does not mean that the
   * subtask failed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2.ResourceErrorDetail>
      getResourceErrorDetailsList() {
    return resourceErrorDetails_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provides details to errors and issues encountered while
   * processing the subtask. Presence of error details does not mean that the
   * subtask failed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder>
      getResourceErrorDetailsOrBuilderList() {
    return resourceErrorDetails_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provides details to errors and issues encountered while
   * processing the subtask. Presence of error details does not mean that the
   * subtask failed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getResourceErrorDetailsCount() {
    return resourceErrorDetails_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Provides details to errors and issues encountered while
   * processing the subtask. Presence of error details does not mean that the
   * subtask failed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail getResourceErrorDetails(
      int index) {
    return resourceErrorDetails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Provides details to errors and issues encountered while
   * processing the subtask. Presence of error details does not mean that the
   * subtask failed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder
      getResourceErrorDetailsOrBuilder(int index) {
    return resourceErrorDetails_.get(index);
  }

  public static final int RESOURCE_ERROR_COUNT_FIELD_NUMBER = 13;
  private int resourceErrorCount_;
  /**
   *
   *
   * <pre>
   * The number or resources with errors. Note: This is not the total
   * number of errors as each resource can have more than one error.
   * This is used to indicate truncation by having a `resource_error_count`
   * that is higher than the size of `resource_error_details`.
   * </pre>
   *
   * <code>int32 resource_error_count = 13;</code>
   *
   * @return The resourceErrorCount.
   */
  @java.lang.Override
  public int getResourceErrorCount() {
    return resourceErrorCount_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Time when the subtask was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the subtask was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the subtask was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp lastUpdateTime_;
  /**
   *
   *
   * <pre>
   * Time when the subtask was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return lastUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the subtask was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the subtask was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return getLastUpdateTime();
  }

  public static final int METRICS_FIELD_NUMBER = 11;
  private java.util.List<com.google.cloud.bigquery.migration.v2.TimeSeries> metrics_;
  /**
   *
   *
   * <pre>
   * The metrics for the subtask.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.migration.v2.TimeSeries> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metrics for the subtask.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metrics for the subtask.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * The metrics for the subtask.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TimeSeries getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The metrics for the subtask.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(taskId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, taskId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2.MigrationSubtask.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, state_);
    }
    if (processingError_ != null) {
      output.writeMessage(6, getProcessingError());
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      output.writeMessage(8, getLastUpdateTime());
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(11, metrics_.get(i));
    }
    for (int i = 0; i < resourceErrorDetails_.size(); i++) {
      output.writeMessage(12, resourceErrorDetails_.get(i));
    }
    if (resourceErrorCount_ != 0) {
      output.writeInt32(13, resourceErrorCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(taskId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, taskId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
    }
    if (state_
        != com.google.cloud.bigquery.migration.v2.MigrationSubtask.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (processingError_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getProcessingError());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (lastUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLastUpdateTime());
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, metrics_.get(i));
    }
    for (int i = 0; i < resourceErrorDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, resourceErrorDetails_.get(i));
    }
    if (resourceErrorCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, resourceErrorCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.MigrationSubtask)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.MigrationSubtask other =
        (com.google.cloud.bigquery.migration.v2.MigrationSubtask) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTaskId().equals(other.getTaskId())) return false;
    if (!getType().equals(other.getType())) return false;
    if (state_ != other.state_) return false;
    if (hasProcessingError() != other.hasProcessingError()) return false;
    if (hasProcessingError()) {
      if (!getProcessingError().equals(other.getProcessingError())) return false;
    }
    if (!getResourceErrorDetailsList().equals(other.getResourceErrorDetailsList())) return false;
    if (getResourceErrorCount() != other.getResourceErrorCount()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TASK_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTaskId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasProcessingError()) {
      hash = (37 * hash) + PROCESSING_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getProcessingError().hashCode();
    }
    if (getResourceErrorDetailsCount() > 0) {
      hash = (37 * hash) + RESOURCE_ERROR_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceErrorDetailsList().hashCode();
    }
    hash = (37 * hash) + RESOURCE_ERROR_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getResourceErrorCount();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.migration.v2.MigrationSubtask prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A subtask for a migration which carries details about the configuration of
   * the subtask. The content of the details should not matter to the end user,
   * but is a contract between the subtask creator and subtask worker.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.MigrationSubtask}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.MigrationSubtask)
      com.google.cloud.bigquery.migration.v2.MigrationSubtaskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationSubtask_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationSubtask_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.MigrationSubtask.class,
              com.google.cloud.bigquery.migration.v2.MigrationSubtask.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.MigrationSubtask.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      taskId_ = "";

      type_ = "";

      state_ = 0;

      if (processingErrorBuilder_ == null) {
        processingError_ = null;
      } else {
        processingError_ = null;
        processingErrorBuilder_ = null;
      }
      if (resourceErrorDetailsBuilder_ == null) {
        resourceErrorDetails_ = java.util.Collections.emptyList();
      } else {
        resourceErrorDetails_ = null;
        resourceErrorDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      resourceErrorCount_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = null;
      } else {
        lastUpdateTime_ = null;
        lastUpdateTimeBuilder_ = null;
      }
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationEntitiesProto
          .internal_static_google_cloud_bigquery_migration_v2_MigrationSubtask_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationSubtask getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.MigrationSubtask.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationSubtask build() {
      com.google.cloud.bigquery.migration.v2.MigrationSubtask result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationSubtask buildPartial() {
      com.google.cloud.bigquery.migration.v2.MigrationSubtask result =
          new com.google.cloud.bigquery.migration.v2.MigrationSubtask(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.taskId_ = taskId_;
      result.type_ = type_;
      result.state_ = state_;
      if (processingErrorBuilder_ == null) {
        result.processingError_ = processingError_;
      } else {
        result.processingError_ = processingErrorBuilder_.build();
      }
      if (resourceErrorDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          resourceErrorDetails_ = java.util.Collections.unmodifiableList(resourceErrorDetails_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.resourceErrorDetails_ = resourceErrorDetails_;
      } else {
        result.resourceErrorDetails_ = resourceErrorDetailsBuilder_.build();
      }
      result.resourceErrorCount_ = resourceErrorCount_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (lastUpdateTimeBuilder_ == null) {
        result.lastUpdateTime_ = lastUpdateTime_;
      } else {
        result.lastUpdateTime_ = lastUpdateTimeBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.MigrationSubtask) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.MigrationSubtask) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2.MigrationSubtask other) {
      if (other == com.google.cloud.bigquery.migration.v2.MigrationSubtask.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getTaskId().isEmpty()) {
        taskId_ = other.taskId_;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasProcessingError()) {
        mergeProcessingError(other.getProcessingError());
      }
      if (resourceErrorDetailsBuilder_ == null) {
        if (!other.resourceErrorDetails_.isEmpty()) {
          if (resourceErrorDetails_.isEmpty()) {
            resourceErrorDetails_ = other.resourceErrorDetails_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResourceErrorDetailsIsMutable();
            resourceErrorDetails_.addAll(other.resourceErrorDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.resourceErrorDetails_.isEmpty()) {
          if (resourceErrorDetailsBuilder_.isEmpty()) {
            resourceErrorDetailsBuilder_.dispose();
            resourceErrorDetailsBuilder_ = null;
            resourceErrorDetails_ = other.resourceErrorDetails_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resourceErrorDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourceErrorDetailsFieldBuilder()
                    : null;
          } else {
            resourceErrorDetailsBuilder_.addAllMessages(other.resourceErrorDetails_);
          }
        }
      }
      if (other.getResourceErrorCount() != 0) {
        setResourceErrorCount(other.getResourceErrorCount());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                taskId_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                type_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 40:
              {
                state_ = input.readEnum();

                break;
              } // case 40
            case 50:
              {
                input.readMessage(getProcessingErrorFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 90:
              {
                com.google.cloud.bigquery.migration.v2.TimeSeries m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2.TimeSeries.parser(),
                        extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.bigquery.migration.v2.ResourceErrorDetail m =
                    input.readMessage(
                        com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.parser(),
                        extensionRegistry);
                if (resourceErrorDetailsBuilder_ == null) {
                  ensureResourceErrorDetailsIsMutable();
                  resourceErrorDetails_.add(m);
                } else {
                  resourceErrorDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 104:
              {
                resourceErrorCount_ = input.readInt32();

                break;
              } // case 104
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name for the migration subtask. The ID
     * is server-generated.
     * Example: `projects/123/locations/us/workflows/345/subtasks/678`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object taskId_ = "";
    /**
     *
     *
     * <pre>
     * The unique ID of the task to which this subtask belongs.
     * </pre>
     *
     * <code>string task_id = 2;</code>
     *
     * @return The taskId.
     */
    public java.lang.String getTaskId() {
      java.lang.Object ref = taskId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        taskId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique ID of the task to which this subtask belongs.
     * </pre>
     *
     * <code>string task_id = 2;</code>
     *
     * @return The bytes for taskId.
     */
    public com.google.protobuf.ByteString getTaskIdBytes() {
      java.lang.Object ref = taskId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        taskId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique ID of the task to which this subtask belongs.
     * </pre>
     *
     * <code>string task_id = 2;</code>
     *
     * @param value The taskId to set.
     * @return This builder for chaining.
     */
    public Builder setTaskId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      taskId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique ID of the task to which this subtask belongs.
     * </pre>
     *
     * <code>string task_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskId() {

      taskId_ = getDefaultInstance().getTaskId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique ID of the task to which this subtask belongs.
     * </pre>
     *
     * <code>string task_id = 2;</code>
     *
     * @param value The bytes for taskId to set.
     * @return This builder for chaining.
     */
    public Builder setTaskIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      taskId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = getDefaultInstance().getType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the Subtask. The migration service does not check whether this
     * is a known type. It is up to the task creator (i.e. orchestrator or worker)
     * to ensure it only creates subtasks for which there are compatible workers
     * polling for Subtasks.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      type_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the subtask.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the subtask.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the subtask.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MigrationSubtask.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.migration.v2.MigrationSubtask.State result =
          com.google.cloud.bigquery.migration.v2.MigrationSubtask.State.valueOf(state_);
      return result == null
          ? com.google.cloud.bigquery.migration.v2.MigrationSubtask.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the subtask.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.migration.v2.MigrationSubtask.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the subtask.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.migration.v2.MigrationSubtask.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.ErrorInfo processingError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ErrorInfo,
            com.google.rpc.ErrorInfo.Builder,
            com.google.rpc.ErrorInfoOrBuilder>
        processingErrorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the processingError field is set.
     */
    public boolean hasProcessingError() {
      return processingErrorBuilder_ != null || processingError_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The processingError.
     */
    public com.google.rpc.ErrorInfo getProcessingError() {
      if (processingErrorBuilder_ == null) {
        return processingError_ == null
            ? com.google.rpc.ErrorInfo.getDefaultInstance()
            : processingError_;
      } else {
        return processingErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessingError(com.google.rpc.ErrorInfo value) {
      if (processingErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processingError_ = value;
        onChanged();
      } else {
        processingErrorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessingError(com.google.rpc.ErrorInfo.Builder builderForValue) {
      if (processingErrorBuilder_ == null) {
        processingError_ = builderForValue.build();
        onChanged();
      } else {
        processingErrorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProcessingError(com.google.rpc.ErrorInfo value) {
      if (processingErrorBuilder_ == null) {
        if (processingError_ != null) {
          processingError_ =
              com.google.rpc.ErrorInfo.newBuilder(processingError_).mergeFrom(value).buildPartial();
        } else {
          processingError_ = value;
        }
        onChanged();
      } else {
        processingErrorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProcessingError() {
      if (processingErrorBuilder_ == null) {
        processingError_ = null;
        onChanged();
      } else {
        processingError_ = null;
        processingErrorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.ErrorInfo.Builder getProcessingErrorBuilder() {

      onChanged();
      return getProcessingErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.ErrorInfoOrBuilder getProcessingErrorOrBuilder() {
      if (processingErrorBuilder_ != null) {
        return processingErrorBuilder_.getMessageOrBuilder();
      } else {
        return processingError_ == null
            ? com.google.rpc.ErrorInfo.getDefaultInstance()
            : processingError_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An explanation that may be populated when the task is in
     * FAILED state.
     * </pre>
     *
     * <code>
     * .google.rpc.ErrorInfo processing_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.ErrorInfo,
            com.google.rpc.ErrorInfo.Builder,
            com.google.rpc.ErrorInfoOrBuilder>
        getProcessingErrorFieldBuilder() {
      if (processingErrorBuilder_ == null) {
        processingErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.ErrorInfo,
                com.google.rpc.ErrorInfo.Builder,
                com.google.rpc.ErrorInfoOrBuilder>(
                getProcessingError(), getParentForChildren(), isClean());
        processingError_ = null;
      }
      return processingErrorBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2.ResourceErrorDetail>
        resourceErrorDetails_ = java.util.Collections.emptyList();

    private void ensureResourceErrorDetailsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        resourceErrorDetails_ =
            new java.util.ArrayList<com.google.cloud.bigquery.migration.v2.ResourceErrorDetail>(
                resourceErrorDetails_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetail,
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder,
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder>
        resourceErrorDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2.ResourceErrorDetail>
        getResourceErrorDetailsList() {
      if (resourceErrorDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resourceErrorDetails_);
      } else {
        return resourceErrorDetailsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getResourceErrorDetailsCount() {
      if (resourceErrorDetailsBuilder_ == null) {
        return resourceErrorDetails_.size();
      } else {
        return resourceErrorDetailsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail getResourceErrorDetails(
        int index) {
      if (resourceErrorDetailsBuilder_ == null) {
        return resourceErrorDetails_.get(index);
      } else {
        return resourceErrorDetailsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourceErrorDetails(
        int index, com.google.cloud.bigquery.migration.v2.ResourceErrorDetail value) {
      if (resourceErrorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.set(index, value);
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourceErrorDetails(
        int index,
        com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder builderForValue) {
      if (resourceErrorDetailsBuilder_ == null) {
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addResourceErrorDetails(
        com.google.cloud.bigquery.migration.v2.ResourceErrorDetail value) {
      if (resourceErrorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.add(value);
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addResourceErrorDetails(
        int index, com.google.cloud.bigquery.migration.v2.ResourceErrorDetail value) {
      if (resourceErrorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.add(index, value);
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addResourceErrorDetails(
        com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder builderForValue) {
      if (resourceErrorDetailsBuilder_ == null) {
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.add(builderForValue.build());
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addResourceErrorDetails(
        int index,
        com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder builderForValue) {
      if (resourceErrorDetailsBuilder_ == null) {
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllResourceErrorDetails(
        java.lang.Iterable<? extends com.google.cloud.bigquery.migration.v2.ResourceErrorDetail>
            values) {
      if (resourceErrorDetailsBuilder_ == null) {
        ensureResourceErrorDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceErrorDetails_);
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResourceErrorDetails() {
      if (resourceErrorDetailsBuilder_ == null) {
        resourceErrorDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeResourceErrorDetails(int index) {
      if (resourceErrorDetailsBuilder_ == null) {
        ensureResourceErrorDetailsIsMutable();
        resourceErrorDetails_.remove(index);
        onChanged();
      } else {
        resourceErrorDetailsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder
        getResourceErrorDetailsBuilder(int index) {
      return getResourceErrorDetailsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder
        getResourceErrorDetailsOrBuilder(int index) {
      if (resourceErrorDetailsBuilder_ == null) {
        return resourceErrorDetails_.get(index);
      } else {
        return resourceErrorDetailsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder>
        getResourceErrorDetailsOrBuilderList() {
      if (resourceErrorDetailsBuilder_ != null) {
        return resourceErrorDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resourceErrorDetails_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder
        addResourceErrorDetailsBuilder() {
      return getResourceErrorDetailsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder
        addResourceErrorDetailsBuilder(int index) {
      return getResourceErrorDetailsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides details to errors and issues encountered while
     * processing the subtask. Presence of error details does not mean that the
     * subtask failed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.migration.v2.ResourceErrorDetail resource_error_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder>
        getResourceErrorDetailsBuilderList() {
      return getResourceErrorDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetail,
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder,
            com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder>
        getResourceErrorDetailsFieldBuilder() {
      if (resourceErrorDetailsBuilder_ == null) {
        resourceErrorDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.ResourceErrorDetail,
                com.google.cloud.bigquery.migration.v2.ResourceErrorDetail.Builder,
                com.google.cloud.bigquery.migration.v2.ResourceErrorDetailOrBuilder>(
                resourceErrorDetails_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        resourceErrorDetails_ = null;
      }
      return resourceErrorDetailsBuilder_;
    }

    private int resourceErrorCount_;
    /**
     *
     *
     * <pre>
     * The number or resources with errors. Note: This is not the total
     * number of errors as each resource can have more than one error.
     * This is used to indicate truncation by having a `resource_error_count`
     * that is higher than the size of `resource_error_details`.
     * </pre>
     *
     * <code>int32 resource_error_count = 13;</code>
     *
     * @return The resourceErrorCount.
     */
    @java.lang.Override
    public int getResourceErrorCount() {
      return resourceErrorCount_;
    }
    /**
     *
     *
     * <pre>
     * The number or resources with errors. Note: This is not the total
     * number of errors as each resource can have more than one error.
     * This is used to indicate truncation by having a `resource_error_count`
     * that is higher than the size of `resource_error_details`.
     * </pre>
     *
     * <code>int32 resource_error_count = 13;</code>
     *
     * @param value The resourceErrorCount to set.
     * @return This builder for chaining.
     */
    public Builder setResourceErrorCount(int value) {

      resourceErrorCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number or resources with errors. Note: This is not the total
     * number of errors as each resource can have more than one error.
     * This is used to indicate truncation by having a `resource_error_count`
     * that is higher than the size of `resource_error_details`.
     * </pre>
     *
     * <code>int32 resource_error_count = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceErrorCount() {

      resourceErrorCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return lastUpdateTimeBuilder_ != null || lastUpdateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
        onChanged();
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
        onChanged();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (lastUpdateTime_ != null) {
          lastUpdateTime_ =
              com.google.protobuf.Timestamp.newBuilder(lastUpdateTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          lastUpdateTime_ = value;
        }
        onChanged();
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    public Builder clearLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = null;
        onChanged();
      } else {
        lastUpdateTime_ = null;
        lastUpdateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {

      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the subtask was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.migration.v2.TimeSeries> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.cloud.bigquery.migration.v2.TimeSeries>(metrics_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.TimeSeries,
            com.google.cloud.bigquery.migration.v2.TimeSeries.Builder,
            com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2.TimeSeries> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2.TimeSeries getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder setMetrics(int index, com.google.cloud.bigquery.migration.v2.TimeSeries value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.bigquery.migration.v2.TimeSeries.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder addMetrics(com.google.cloud.bigquery.migration.v2.TimeSeries value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder addMetrics(int index, com.google.cloud.bigquery.migration.v2.TimeSeries value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder addMetrics(
        com.google.cloud.bigquery.migration.v2.TimeSeries.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.bigquery.migration.v2.TimeSeries.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.bigquery.migration.v2.TimeSeries> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2.TimeSeries.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder getMetricsOrBuilder(
        int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2.TimeSeries.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.migration.v2.TimeSeries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2.TimeSeries.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.migration.v2.TimeSeries.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metrics for the subtask.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.migration.v2.TimeSeries metrics = 11;</code>
     */
    public java.util.List<com.google.cloud.bigquery.migration.v2.TimeSeries.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.TimeSeries,
            com.google.cloud.bigquery.migration.v2.TimeSeries.Builder,
            com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.TimeSeries,
                com.google.cloud.bigquery.migration.v2.TimeSeries.Builder,
                com.google.cloud.bigquery.migration.v2.TimeSeriesOrBuilder>(
                metrics_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.MigrationSubtask)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.MigrationSubtask)
  private static final com.google.cloud.bigquery.migration.v2.MigrationSubtask DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.MigrationSubtask();
  }

  public static com.google.cloud.bigquery.migration.v2.MigrationSubtask getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationSubtask> PARSER =
      new com.google.protobuf.AbstractParser<MigrationSubtask>() {
        @java.lang.Override
        public MigrationSubtask parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationSubtask> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationSubtask> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MigrationSubtask getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
