/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/migration/v2/translation_config.proto

package com.google.cloud.bigquery.migration.v2;

/**
 *
 *
 * <pre>
 * The possible dialect options for translation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.migration.v2.Dialect}
 */
public final class Dialect extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.migration.v2.Dialect)
    DialectOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Dialect.newBuilder() to construct.
  private Dialect(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Dialect() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Dialect();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
        .internal_static_google_cloud_bigquery_migration_v2_Dialect_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
        .internal_static_google_cloud_bigquery_migration_v2_Dialect_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.migration.v2.Dialect.class,
            com.google.cloud.bigquery.migration.v2.Dialect.Builder.class);
  }

  private int dialectValueCase_ = 0;
  private java.lang.Object dialectValue_;

  public enum DialectValueCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGQUERY_DIALECT(1),
    HIVEQL_DIALECT(2),
    REDSHIFT_DIALECT(3),
    TERADATA_DIALECT(4),
    ORACLE_DIALECT(5),
    SPARKSQL_DIALECT(6),
    SNOWFLAKE_DIALECT(7),
    NETEZZA_DIALECT(8),
    AZURE_SYNAPSE_DIALECT(9),
    VERTICA_DIALECT(10),
    SQL_SERVER_DIALECT(11),
    POSTGRESQL_DIALECT(12),
    PRESTO_DIALECT(13),
    MYSQL_DIALECT(14),
    DIALECTVALUE_NOT_SET(0);
    private final int value;

    private DialectValueCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DialectValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static DialectValueCase forNumber(int value) {
      switch (value) {
        case 1:
          return BIGQUERY_DIALECT;
        case 2:
          return HIVEQL_DIALECT;
        case 3:
          return REDSHIFT_DIALECT;
        case 4:
          return TERADATA_DIALECT;
        case 5:
          return ORACLE_DIALECT;
        case 6:
          return SPARKSQL_DIALECT;
        case 7:
          return SNOWFLAKE_DIALECT;
        case 8:
          return NETEZZA_DIALECT;
        case 9:
          return AZURE_SYNAPSE_DIALECT;
        case 10:
          return VERTICA_DIALECT;
        case 11:
          return SQL_SERVER_DIALECT;
        case 12:
          return POSTGRESQL_DIALECT;
        case 13:
          return PRESTO_DIALECT;
        case 14:
          return MYSQL_DIALECT;
        case 0:
          return DIALECTVALUE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DialectValueCase getDialectValueCase() {
    return DialectValueCase.forNumber(dialectValueCase_);
  }

  public static final int BIGQUERY_DIALECT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The BigQuery dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
   *
   * @return Whether the bigqueryDialect field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDialect() {
    return dialectValueCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The BigQuery dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
   *
   * @return The bigqueryDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.BigQueryDialect getBigqueryDialect() {
    if (dialectValueCase_ == 1) {
      return (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The BigQuery dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.BigQueryDialectOrBuilder
      getBigqueryDialectOrBuilder() {
    if (dialectValueCase_ == 1) {
      return (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance();
  }

  public static final int HIVEQL_DIALECT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The HiveQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
   *
   * @return Whether the hiveqlDialect field is set.
   */
  @java.lang.Override
  public boolean hasHiveqlDialect() {
    return dialectValueCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The HiveQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
   *
   * @return The hiveqlDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.HiveQLDialect getHiveqlDialect() {
    if (dialectValueCase_ == 2) {
      return (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The HiveQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.HiveQLDialectOrBuilder getHiveqlDialectOrBuilder() {
    if (dialectValueCase_ == 2) {
      return (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance();
  }

  public static final int REDSHIFT_DIALECT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The Redshift dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
   *
   * @return Whether the redshiftDialect field is set.
   */
  @java.lang.Override
  public boolean hasRedshiftDialect() {
    return dialectValueCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The Redshift dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
   *
   * @return The redshiftDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.RedshiftDialect getRedshiftDialect() {
    if (dialectValueCase_ == 3) {
      return (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Redshift dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.RedshiftDialectOrBuilder
      getRedshiftDialectOrBuilder() {
    if (dialectValueCase_ == 3) {
      return (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance();
  }

  public static final int TERADATA_DIALECT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The Teradata dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
   *
   * @return Whether the teradataDialect field is set.
   */
  @java.lang.Override
  public boolean hasTeradataDialect() {
    return dialectValueCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The Teradata dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
   *
   * @return The teradataDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TeradataDialect getTeradataDialect() {
    if (dialectValueCase_ == 4) {
      return (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Teradata dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.TeradataDialectOrBuilder
      getTeradataDialectOrBuilder() {
    if (dialectValueCase_ == 4) {
      return (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance();
  }

  public static final int ORACLE_DIALECT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The Oracle dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
   *
   * @return Whether the oracleDialect field is set.
   */
  @java.lang.Override
  public boolean hasOracleDialect() {
    return dialectValueCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The Oracle dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
   *
   * @return The oracleDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.OracleDialect getOracleDialect() {
    if (dialectValueCase_ == 5) {
      return (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Oracle dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.OracleDialectOrBuilder getOracleDialectOrBuilder() {
    if (dialectValueCase_ == 5) {
      return (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance();
  }

  public static final int SPARKSQL_DIALECT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The SparkSQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
   *
   * @return Whether the sparksqlDialect field is set.
   */
  @java.lang.Override
  public boolean hasSparksqlDialect() {
    return dialectValueCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The SparkSQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
   *
   * @return The sparksqlDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SparkSQLDialect getSparksqlDialect() {
    if (dialectValueCase_ == 6) {
      return (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The SparkSQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SparkSQLDialectOrBuilder
      getSparksqlDialectOrBuilder() {
    if (dialectValueCase_ == 6) {
      return (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance();
  }

  public static final int SNOWFLAKE_DIALECT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The Snowflake dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
   *
   * @return Whether the snowflakeDialect field is set.
   */
  @java.lang.Override
  public boolean hasSnowflakeDialect() {
    return dialectValueCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The Snowflake dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
   *
   * @return The snowflakeDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SnowflakeDialect getSnowflakeDialect() {
    if (dialectValueCase_ == 7) {
      return (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Snowflake dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SnowflakeDialectOrBuilder
      getSnowflakeDialectOrBuilder() {
    if (dialectValueCase_ == 7) {
      return (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance();
  }

  public static final int NETEZZA_DIALECT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The Netezza dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
   *
   * @return Whether the netezzaDialect field is set.
   */
  @java.lang.Override
  public boolean hasNetezzaDialect() {
    return dialectValueCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The Netezza dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
   *
   * @return The netezzaDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.NetezzaDialect getNetezzaDialect() {
    if (dialectValueCase_ == 8) {
      return (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Netezza dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.NetezzaDialectOrBuilder
      getNetezzaDialectOrBuilder() {
    if (dialectValueCase_ == 8) {
      return (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance();
  }

  public static final int AZURE_SYNAPSE_DIALECT_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * The Azure Synapse dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;</code>
   *
   * @return Whether the azureSynapseDialect field is set.
   */
  @java.lang.Override
  public boolean hasAzureSynapseDialect() {
    return dialectValueCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * The Azure Synapse dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;</code>
   *
   * @return The azureSynapseDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.AzureSynapseDialect getAzureSynapseDialect() {
    if (dialectValueCase_ == 9) {
      return (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Azure Synapse dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.AzureSynapseDialectOrBuilder
      getAzureSynapseDialectOrBuilder() {
    if (dialectValueCase_ == 9) {
      return (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.getDefaultInstance();
  }

  public static final int VERTICA_DIALECT_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * The Vertica dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
   *
   * @return Whether the verticaDialect field is set.
   */
  @java.lang.Override
  public boolean hasVerticaDialect() {
    return dialectValueCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * The Vertica dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
   *
   * @return The verticaDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.VerticaDialect getVerticaDialect() {
    if (dialectValueCase_ == 10) {
      return (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Vertica dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.VerticaDialectOrBuilder
      getVerticaDialectOrBuilder() {
    if (dialectValueCase_ == 10) {
      return (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance();
  }

  public static final int SQL_SERVER_DIALECT_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * The SQL Server dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
   *
   * @return Whether the sqlServerDialect field is set.
   */
  @java.lang.Override
  public boolean hasSqlServerDialect() {
    return dialectValueCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * The SQL Server dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
   *
   * @return The sqlServerDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SQLServerDialect getSqlServerDialect() {
    if (dialectValueCase_ == 11) {
      return (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The SQL Server dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.SQLServerDialectOrBuilder
      getSqlServerDialectOrBuilder() {
    if (dialectValueCase_ == 11) {
      return (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance();
  }

  public static final int POSTGRESQL_DIALECT_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * The Postgresql dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
   *
   * @return Whether the postgresqlDialect field is set.
   */
  @java.lang.Override
  public boolean hasPostgresqlDialect() {
    return dialectValueCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * The Postgresql dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
   *
   * @return The postgresqlDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.PostgresqlDialect getPostgresqlDialect() {
    if (dialectValueCase_ == 12) {
      return (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Postgresql dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.PostgresqlDialectOrBuilder
      getPostgresqlDialectOrBuilder() {
    if (dialectValueCase_ == 12) {
      return (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance();
  }

  public static final int PRESTO_DIALECT_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * The Presto dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
   *
   * @return Whether the prestoDialect field is set.
   */
  @java.lang.Override
  public boolean hasPrestoDialect() {
    return dialectValueCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * The Presto dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
   *
   * @return The prestoDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.PrestoDialect getPrestoDialect() {
    if (dialectValueCase_ == 13) {
      return (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Presto dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.PrestoDialectOrBuilder getPrestoDialectOrBuilder() {
    if (dialectValueCase_ == 13) {
      return (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance();
  }

  public static final int MYSQL_DIALECT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * The MySQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
   *
   * @return Whether the mysqlDialect field is set.
   */
  @java.lang.Override
  public boolean hasMysqlDialect() {
    return dialectValueCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * The MySQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
   *
   * @return The mysqlDialect.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MySQLDialect getMysqlDialect() {
    if (dialectValueCase_ == 14) {
      return (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The MySQL dialect
   * </pre>
   *
   * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.MySQLDialectOrBuilder getMysqlDialectOrBuilder() {
    if (dialectValueCase_ == 14) {
      return (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_;
    }
    return com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dialectValueCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_);
    }
    if (dialectValueCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_);
    }
    if (dialectValueCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_);
    }
    if (dialectValueCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_);
    }
    if (dialectValueCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_);
    }
    if (dialectValueCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_);
    }
    if (dialectValueCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_);
    }
    if (dialectValueCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_);
    }
    if (dialectValueCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_);
    }
    if (dialectValueCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_);
    }
    if (dialectValueCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_);
    }
    if (dialectValueCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_);
    }
    if (dialectValueCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_);
    }
    if (dialectValueCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dialectValueCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_);
    }
    if (dialectValueCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_);
    }
    if (dialectValueCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_);
    }
    if (dialectValueCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_);
    }
    if (dialectValueCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_);
    }
    if (dialectValueCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_);
    }
    if (dialectValueCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_);
    }
    if (dialectValueCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_);
    }
    if (dialectValueCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_);
    }
    if (dialectValueCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_);
    }
    if (dialectValueCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_);
    }
    if (dialectValueCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_);
    }
    if (dialectValueCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_);
    }
    if (dialectValueCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.migration.v2.Dialect)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.migration.v2.Dialect other =
        (com.google.cloud.bigquery.migration.v2.Dialect) obj;

    if (!getDialectValueCase().equals(other.getDialectValueCase())) return false;
    switch (dialectValueCase_) {
      case 1:
        if (!getBigqueryDialect().equals(other.getBigqueryDialect())) return false;
        break;
      case 2:
        if (!getHiveqlDialect().equals(other.getHiveqlDialect())) return false;
        break;
      case 3:
        if (!getRedshiftDialect().equals(other.getRedshiftDialect())) return false;
        break;
      case 4:
        if (!getTeradataDialect().equals(other.getTeradataDialect())) return false;
        break;
      case 5:
        if (!getOracleDialect().equals(other.getOracleDialect())) return false;
        break;
      case 6:
        if (!getSparksqlDialect().equals(other.getSparksqlDialect())) return false;
        break;
      case 7:
        if (!getSnowflakeDialect().equals(other.getSnowflakeDialect())) return false;
        break;
      case 8:
        if (!getNetezzaDialect().equals(other.getNetezzaDialect())) return false;
        break;
      case 9:
        if (!getAzureSynapseDialect().equals(other.getAzureSynapseDialect())) return false;
        break;
      case 10:
        if (!getVerticaDialect().equals(other.getVerticaDialect())) return false;
        break;
      case 11:
        if (!getSqlServerDialect().equals(other.getSqlServerDialect())) return false;
        break;
      case 12:
        if (!getPostgresqlDialect().equals(other.getPostgresqlDialect())) return false;
        break;
      case 13:
        if (!getPrestoDialect().equals(other.getPrestoDialect())) return false;
        break;
      case 14:
        if (!getMysqlDialect().equals(other.getMysqlDialect())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (dialectValueCase_) {
      case 1:
        hash = (37 * hash) + BIGQUERY_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDialect().hashCode();
        break;
      case 2:
        hash = (37 * hash) + HIVEQL_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getHiveqlDialect().hashCode();
        break;
      case 3:
        hash = (37 * hash) + REDSHIFT_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getRedshiftDialect().hashCode();
        break;
      case 4:
        hash = (37 * hash) + TERADATA_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getTeradataDialect().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ORACLE_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getOracleDialect().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SPARKSQL_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getSparksqlDialect().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SNOWFLAKE_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getSnowflakeDialect().hashCode();
        break;
      case 8:
        hash = (37 * hash) + NETEZZA_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getNetezzaDialect().hashCode();
        break;
      case 9:
        hash = (37 * hash) + AZURE_SYNAPSE_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getAzureSynapseDialect().hashCode();
        break;
      case 10:
        hash = (37 * hash) + VERTICA_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getVerticaDialect().hashCode();
        break;
      case 11:
        hash = (37 * hash) + SQL_SERVER_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getSqlServerDialect().hashCode();
        break;
      case 12:
        hash = (37 * hash) + POSTGRESQL_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getPostgresqlDialect().hashCode();
        break;
      case 13:
        hash = (37 * hash) + PRESTO_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getPrestoDialect().hashCode();
        break;
      case 14:
        hash = (37 * hash) + MYSQL_DIALECT_FIELD_NUMBER;
        hash = (53 * hash) + getMysqlDialect().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.migration.v2.Dialect prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The possible dialect options for translation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.migration.v2.Dialect}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.migration.v2.Dialect)
      com.google.cloud.bigquery.migration.v2.DialectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_Dialect_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_Dialect_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.migration.v2.Dialect.class,
              com.google.cloud.bigquery.migration.v2.Dialect.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.migration.v2.Dialect.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (bigqueryDialectBuilder_ != null) {
        bigqueryDialectBuilder_.clear();
      }
      if (hiveqlDialectBuilder_ != null) {
        hiveqlDialectBuilder_.clear();
      }
      if (redshiftDialectBuilder_ != null) {
        redshiftDialectBuilder_.clear();
      }
      if (teradataDialectBuilder_ != null) {
        teradataDialectBuilder_.clear();
      }
      if (oracleDialectBuilder_ != null) {
        oracleDialectBuilder_.clear();
      }
      if (sparksqlDialectBuilder_ != null) {
        sparksqlDialectBuilder_.clear();
      }
      if (snowflakeDialectBuilder_ != null) {
        snowflakeDialectBuilder_.clear();
      }
      if (netezzaDialectBuilder_ != null) {
        netezzaDialectBuilder_.clear();
      }
      if (azureSynapseDialectBuilder_ != null) {
        azureSynapseDialectBuilder_.clear();
      }
      if (verticaDialectBuilder_ != null) {
        verticaDialectBuilder_.clear();
      }
      if (sqlServerDialectBuilder_ != null) {
        sqlServerDialectBuilder_.clear();
      }
      if (postgresqlDialectBuilder_ != null) {
        postgresqlDialectBuilder_.clear();
      }
      if (prestoDialectBuilder_ != null) {
        prestoDialectBuilder_.clear();
      }
      if (mysqlDialectBuilder_ != null) {
        mysqlDialectBuilder_.clear();
      }
      dialectValueCase_ = 0;
      dialectValue_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.migration.v2.TranslationConfigProto
          .internal_static_google_cloud_bigquery_migration_v2_Dialect_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.Dialect getDefaultInstanceForType() {
      return com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.Dialect build() {
      com.google.cloud.bigquery.migration.v2.Dialect result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.Dialect buildPartial() {
      com.google.cloud.bigquery.migration.v2.Dialect result =
          new com.google.cloud.bigquery.migration.v2.Dialect(this);
      if (dialectValueCase_ == 1) {
        if (bigqueryDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = bigqueryDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 2) {
        if (hiveqlDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = hiveqlDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 3) {
        if (redshiftDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = redshiftDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 4) {
        if (teradataDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = teradataDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 5) {
        if (oracleDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = oracleDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 6) {
        if (sparksqlDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = sparksqlDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 7) {
        if (snowflakeDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = snowflakeDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 8) {
        if (netezzaDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = netezzaDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 9) {
        if (azureSynapseDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = azureSynapseDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 10) {
        if (verticaDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = verticaDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 11) {
        if (sqlServerDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = sqlServerDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 12) {
        if (postgresqlDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = postgresqlDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 13) {
        if (prestoDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = prestoDialectBuilder_.build();
        }
      }
      if (dialectValueCase_ == 14) {
        if (mysqlDialectBuilder_ == null) {
          result.dialectValue_ = dialectValue_;
        } else {
          result.dialectValue_ = mysqlDialectBuilder_.build();
        }
      }
      result.dialectValueCase_ = dialectValueCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.migration.v2.Dialect) {
        return mergeFrom((com.google.cloud.bigquery.migration.v2.Dialect) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.migration.v2.Dialect other) {
      if (other == com.google.cloud.bigquery.migration.v2.Dialect.getDefaultInstance()) return this;
      switch (other.getDialectValueCase()) {
        case BIGQUERY_DIALECT:
          {
            mergeBigqueryDialect(other.getBigqueryDialect());
            break;
          }
        case HIVEQL_DIALECT:
          {
            mergeHiveqlDialect(other.getHiveqlDialect());
            break;
          }
        case REDSHIFT_DIALECT:
          {
            mergeRedshiftDialect(other.getRedshiftDialect());
            break;
          }
        case TERADATA_DIALECT:
          {
            mergeTeradataDialect(other.getTeradataDialect());
            break;
          }
        case ORACLE_DIALECT:
          {
            mergeOracleDialect(other.getOracleDialect());
            break;
          }
        case SPARKSQL_DIALECT:
          {
            mergeSparksqlDialect(other.getSparksqlDialect());
            break;
          }
        case SNOWFLAKE_DIALECT:
          {
            mergeSnowflakeDialect(other.getSnowflakeDialect());
            break;
          }
        case NETEZZA_DIALECT:
          {
            mergeNetezzaDialect(other.getNetezzaDialect());
            break;
          }
        case AZURE_SYNAPSE_DIALECT:
          {
            mergeAzureSynapseDialect(other.getAzureSynapseDialect());
            break;
          }
        case VERTICA_DIALECT:
          {
            mergeVerticaDialect(other.getVerticaDialect());
            break;
          }
        case SQL_SERVER_DIALECT:
          {
            mergeSqlServerDialect(other.getSqlServerDialect());
            break;
          }
        case POSTGRESQL_DIALECT:
          {
            mergePostgresqlDialect(other.getPostgresqlDialect());
            break;
          }
        case PRESTO_DIALECT:
          {
            mergePrestoDialect(other.getPrestoDialect());
            break;
          }
        case MYSQL_DIALECT:
          {
            mergeMysqlDialect(other.getMysqlDialect());
            break;
          }
        case DIALECTVALUE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getBigqueryDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getHiveqlDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRedshiftDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTeradataDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getOracleDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSparksqlDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getSnowflakeDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getNetezzaDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getAzureSynapseDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getVerticaDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getSqlServerDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getPostgresqlDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getPrestoDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getMysqlDialectFieldBuilder().getBuilder(), extensionRegistry);
                dialectValueCase_ = 14;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dialectValueCase_ = 0;
    private java.lang.Object dialectValue_;

    public DialectValueCase getDialectValueCase() {
      return DialectValueCase.forNumber(dialectValueCase_);
    }

    public Builder clearDialectValue() {
      dialectValueCase_ = 0;
      dialectValue_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.BigQueryDialect,
            com.google.cloud.bigquery.migration.v2.BigQueryDialect.Builder,
            com.google.cloud.bigquery.migration.v2.BigQueryDialectOrBuilder>
        bigqueryDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     *
     * @return Whether the bigqueryDialect field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDialect() {
      return dialectValueCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     *
     * @return The bigqueryDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.BigQueryDialect getBigqueryDialect() {
      if (bigqueryDialectBuilder_ == null) {
        if (dialectValueCase_ == 1) {
          return (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 1) {
          return bigqueryDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    public Builder setBigqueryDialect(
        com.google.cloud.bigquery.migration.v2.BigQueryDialect value) {
      if (bigqueryDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        bigqueryDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    public Builder setBigqueryDialect(
        com.google.cloud.bigquery.migration.v2.BigQueryDialect.Builder builderForValue) {
      if (bigqueryDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    public Builder mergeBigqueryDialect(
        com.google.cloud.bigquery.migration.v2.BigQueryDialect value) {
      if (bigqueryDialectBuilder_ == null) {
        if (dialectValueCase_ == 1
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.BigQueryDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 1) {
          bigqueryDialectBuilder_.mergeFrom(value);
        } else {
          bigqueryDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    public Builder clearBigqueryDialect() {
      if (bigqueryDialectBuilder_ == null) {
        if (dialectValueCase_ == 1) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 1) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        bigqueryDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    public com.google.cloud.bigquery.migration.v2.BigQueryDialect.Builder
        getBigqueryDialectBuilder() {
      return getBigqueryDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.BigQueryDialectOrBuilder
        getBigqueryDialectOrBuilder() {
      if ((dialectValueCase_ == 1) && (bigqueryDialectBuilder_ != null)) {
        return bigqueryDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 1) {
          return (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.BigQueryDialect bigquery_dialect = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.BigQueryDialect,
            com.google.cloud.bigquery.migration.v2.BigQueryDialect.Builder,
            com.google.cloud.bigquery.migration.v2.BigQueryDialectOrBuilder>
        getBigqueryDialectFieldBuilder() {
      if (bigqueryDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 1)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.BigQueryDialect.getDefaultInstance();
        }
        bigqueryDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.BigQueryDialect,
                com.google.cloud.bigquery.migration.v2.BigQueryDialect.Builder,
                com.google.cloud.bigquery.migration.v2.BigQueryDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.BigQueryDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 1;
      onChanged();
      ;
      return bigqueryDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.HiveQLDialect,
            com.google.cloud.bigquery.migration.v2.HiveQLDialect.Builder,
            com.google.cloud.bigquery.migration.v2.HiveQLDialectOrBuilder>
        hiveqlDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     *
     * @return Whether the hiveqlDialect field is set.
     */
    @java.lang.Override
    public boolean hasHiveqlDialect() {
      return dialectValueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     *
     * @return The hiveqlDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.HiveQLDialect getHiveqlDialect() {
      if (hiveqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 2) {
          return (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 2) {
          return hiveqlDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    public Builder setHiveqlDialect(com.google.cloud.bigquery.migration.v2.HiveQLDialect value) {
      if (hiveqlDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        hiveqlDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    public Builder setHiveqlDialect(
        com.google.cloud.bigquery.migration.v2.HiveQLDialect.Builder builderForValue) {
      if (hiveqlDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        hiveqlDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    public Builder mergeHiveqlDialect(com.google.cloud.bigquery.migration.v2.HiveQLDialect value) {
      if (hiveqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 2
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.HiveQLDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 2) {
          hiveqlDialectBuilder_.mergeFrom(value);
        } else {
          hiveqlDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    public Builder clearHiveqlDialect() {
      if (hiveqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 2) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 2) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        hiveqlDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    public com.google.cloud.bigquery.migration.v2.HiveQLDialect.Builder getHiveqlDialectBuilder() {
      return getHiveqlDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.HiveQLDialectOrBuilder
        getHiveqlDialectOrBuilder() {
      if ((dialectValueCase_ == 2) && (hiveqlDialectBuilder_ != null)) {
        return hiveqlDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 2) {
          return (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The HiveQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.HiveQLDialect hiveql_dialect = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.HiveQLDialect,
            com.google.cloud.bigquery.migration.v2.HiveQLDialect.Builder,
            com.google.cloud.bigquery.migration.v2.HiveQLDialectOrBuilder>
        getHiveqlDialectFieldBuilder() {
      if (hiveqlDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 2)) {
          dialectValue_ = com.google.cloud.bigquery.migration.v2.HiveQLDialect.getDefaultInstance();
        }
        hiveqlDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.HiveQLDialect,
                com.google.cloud.bigquery.migration.v2.HiveQLDialect.Builder,
                com.google.cloud.bigquery.migration.v2.HiveQLDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.HiveQLDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 2;
      onChanged();
      ;
      return hiveqlDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.RedshiftDialect,
            com.google.cloud.bigquery.migration.v2.RedshiftDialect.Builder,
            com.google.cloud.bigquery.migration.v2.RedshiftDialectOrBuilder>
        redshiftDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     *
     * @return Whether the redshiftDialect field is set.
     */
    @java.lang.Override
    public boolean hasRedshiftDialect() {
      return dialectValueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     *
     * @return The redshiftDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.RedshiftDialect getRedshiftDialect() {
      if (redshiftDialectBuilder_ == null) {
        if (dialectValueCase_ == 3) {
          return (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 3) {
          return redshiftDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    public Builder setRedshiftDialect(
        com.google.cloud.bigquery.migration.v2.RedshiftDialect value) {
      if (redshiftDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        redshiftDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    public Builder setRedshiftDialect(
        com.google.cloud.bigquery.migration.v2.RedshiftDialect.Builder builderForValue) {
      if (redshiftDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        redshiftDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    public Builder mergeRedshiftDialect(
        com.google.cloud.bigquery.migration.v2.RedshiftDialect value) {
      if (redshiftDialectBuilder_ == null) {
        if (dialectValueCase_ == 3
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.RedshiftDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 3) {
          redshiftDialectBuilder_.mergeFrom(value);
        } else {
          redshiftDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    public Builder clearRedshiftDialect() {
      if (redshiftDialectBuilder_ == null) {
        if (dialectValueCase_ == 3) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 3) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        redshiftDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    public com.google.cloud.bigquery.migration.v2.RedshiftDialect.Builder
        getRedshiftDialectBuilder() {
      return getRedshiftDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.RedshiftDialectOrBuilder
        getRedshiftDialectOrBuilder() {
      if ((dialectValueCase_ == 3) && (redshiftDialectBuilder_ != null)) {
        return redshiftDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 3) {
          return (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Redshift dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.RedshiftDialect redshift_dialect = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.RedshiftDialect,
            com.google.cloud.bigquery.migration.v2.RedshiftDialect.Builder,
            com.google.cloud.bigquery.migration.v2.RedshiftDialectOrBuilder>
        getRedshiftDialectFieldBuilder() {
      if (redshiftDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 3)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.RedshiftDialect.getDefaultInstance();
        }
        redshiftDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.RedshiftDialect,
                com.google.cloud.bigquery.migration.v2.RedshiftDialect.Builder,
                com.google.cloud.bigquery.migration.v2.RedshiftDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.RedshiftDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 3;
      onChanged();
      ;
      return redshiftDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.TeradataDialect,
            com.google.cloud.bigquery.migration.v2.TeradataDialect.Builder,
            com.google.cloud.bigquery.migration.v2.TeradataDialectOrBuilder>
        teradataDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     *
     * @return Whether the teradataDialect field is set.
     */
    @java.lang.Override
    public boolean hasTeradataDialect() {
      return dialectValueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     *
     * @return The teradataDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TeradataDialect getTeradataDialect() {
      if (teradataDialectBuilder_ == null) {
        if (dialectValueCase_ == 4) {
          return (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 4) {
          return teradataDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    public Builder setTeradataDialect(
        com.google.cloud.bigquery.migration.v2.TeradataDialect value) {
      if (teradataDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        teradataDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    public Builder setTeradataDialect(
        com.google.cloud.bigquery.migration.v2.TeradataDialect.Builder builderForValue) {
      if (teradataDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        teradataDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    public Builder mergeTeradataDialect(
        com.google.cloud.bigquery.migration.v2.TeradataDialect value) {
      if (teradataDialectBuilder_ == null) {
        if (dialectValueCase_ == 4
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.TeradataDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 4) {
          teradataDialectBuilder_.mergeFrom(value);
        } else {
          teradataDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    public Builder clearTeradataDialect() {
      if (teradataDialectBuilder_ == null) {
        if (dialectValueCase_ == 4) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 4) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        teradataDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    public com.google.cloud.bigquery.migration.v2.TeradataDialect.Builder
        getTeradataDialectBuilder() {
      return getTeradataDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.TeradataDialectOrBuilder
        getTeradataDialectOrBuilder() {
      if ((dialectValueCase_ == 4) && (teradataDialectBuilder_ != null)) {
        return teradataDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 4) {
          return (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Teradata dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.TeradataDialect teradata_dialect = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.TeradataDialect,
            com.google.cloud.bigquery.migration.v2.TeradataDialect.Builder,
            com.google.cloud.bigquery.migration.v2.TeradataDialectOrBuilder>
        getTeradataDialectFieldBuilder() {
      if (teradataDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 4)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.TeradataDialect.getDefaultInstance();
        }
        teradataDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.TeradataDialect,
                com.google.cloud.bigquery.migration.v2.TeradataDialect.Builder,
                com.google.cloud.bigquery.migration.v2.TeradataDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.TeradataDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 4;
      onChanged();
      ;
      return teradataDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.OracleDialect,
            com.google.cloud.bigquery.migration.v2.OracleDialect.Builder,
            com.google.cloud.bigquery.migration.v2.OracleDialectOrBuilder>
        oracleDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     *
     * @return Whether the oracleDialect field is set.
     */
    @java.lang.Override
    public boolean hasOracleDialect() {
      return dialectValueCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     *
     * @return The oracleDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.OracleDialect getOracleDialect() {
      if (oracleDialectBuilder_ == null) {
        if (dialectValueCase_ == 5) {
          return (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 5) {
          return oracleDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    public Builder setOracleDialect(com.google.cloud.bigquery.migration.v2.OracleDialect value) {
      if (oracleDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        oracleDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    public Builder setOracleDialect(
        com.google.cloud.bigquery.migration.v2.OracleDialect.Builder builderForValue) {
      if (oracleDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        oracleDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    public Builder mergeOracleDialect(com.google.cloud.bigquery.migration.v2.OracleDialect value) {
      if (oracleDialectBuilder_ == null) {
        if (dialectValueCase_ == 5
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.OracleDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 5) {
          oracleDialectBuilder_.mergeFrom(value);
        } else {
          oracleDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    public Builder clearOracleDialect() {
      if (oracleDialectBuilder_ == null) {
        if (dialectValueCase_ == 5) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 5) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        oracleDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    public com.google.cloud.bigquery.migration.v2.OracleDialect.Builder getOracleDialectBuilder() {
      return getOracleDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.OracleDialectOrBuilder
        getOracleDialectOrBuilder() {
      if ((dialectValueCase_ == 5) && (oracleDialectBuilder_ != null)) {
        return oracleDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 5) {
          return (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Oracle dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.OracleDialect oracle_dialect = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.OracleDialect,
            com.google.cloud.bigquery.migration.v2.OracleDialect.Builder,
            com.google.cloud.bigquery.migration.v2.OracleDialectOrBuilder>
        getOracleDialectFieldBuilder() {
      if (oracleDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 5)) {
          dialectValue_ = com.google.cloud.bigquery.migration.v2.OracleDialect.getDefaultInstance();
        }
        oracleDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.OracleDialect,
                com.google.cloud.bigquery.migration.v2.OracleDialect.Builder,
                com.google.cloud.bigquery.migration.v2.OracleDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.OracleDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 5;
      onChanged();
      ;
      return oracleDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SparkSQLDialect,
            com.google.cloud.bigquery.migration.v2.SparkSQLDialect.Builder,
            com.google.cloud.bigquery.migration.v2.SparkSQLDialectOrBuilder>
        sparksqlDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     *
     * @return Whether the sparksqlDialect field is set.
     */
    @java.lang.Override
    public boolean hasSparksqlDialect() {
      return dialectValueCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     *
     * @return The sparksqlDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.SparkSQLDialect getSparksqlDialect() {
      if (sparksqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 6) {
          return (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 6) {
          return sparksqlDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    public Builder setSparksqlDialect(
        com.google.cloud.bigquery.migration.v2.SparkSQLDialect value) {
      if (sparksqlDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        sparksqlDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    public Builder setSparksqlDialect(
        com.google.cloud.bigquery.migration.v2.SparkSQLDialect.Builder builderForValue) {
      if (sparksqlDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        sparksqlDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    public Builder mergeSparksqlDialect(
        com.google.cloud.bigquery.migration.v2.SparkSQLDialect value) {
      if (sparksqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 6
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.SparkSQLDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 6) {
          sparksqlDialectBuilder_.mergeFrom(value);
        } else {
          sparksqlDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    public Builder clearSparksqlDialect() {
      if (sparksqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 6) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 6) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        sparksqlDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    public com.google.cloud.bigquery.migration.v2.SparkSQLDialect.Builder
        getSparksqlDialectBuilder() {
      return getSparksqlDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.SparkSQLDialectOrBuilder
        getSparksqlDialectOrBuilder() {
      if ((dialectValueCase_ == 6) && (sparksqlDialectBuilder_ != null)) {
        return sparksqlDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 6) {
          return (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The SparkSQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SparkSQLDialect sparksql_dialect = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SparkSQLDialect,
            com.google.cloud.bigquery.migration.v2.SparkSQLDialect.Builder,
            com.google.cloud.bigquery.migration.v2.SparkSQLDialectOrBuilder>
        getSparksqlDialectFieldBuilder() {
      if (sparksqlDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 6)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.SparkSQLDialect.getDefaultInstance();
        }
        sparksqlDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.SparkSQLDialect,
                com.google.cloud.bigquery.migration.v2.SparkSQLDialect.Builder,
                com.google.cloud.bigquery.migration.v2.SparkSQLDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.SparkSQLDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 6;
      onChanged();
      ;
      return sparksqlDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SnowflakeDialect,
            com.google.cloud.bigquery.migration.v2.SnowflakeDialect.Builder,
            com.google.cloud.bigquery.migration.v2.SnowflakeDialectOrBuilder>
        snowflakeDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     *
     * @return Whether the snowflakeDialect field is set.
     */
    @java.lang.Override
    public boolean hasSnowflakeDialect() {
      return dialectValueCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     *
     * @return The snowflakeDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.SnowflakeDialect getSnowflakeDialect() {
      if (snowflakeDialectBuilder_ == null) {
        if (dialectValueCase_ == 7) {
          return (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 7) {
          return snowflakeDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    public Builder setSnowflakeDialect(
        com.google.cloud.bigquery.migration.v2.SnowflakeDialect value) {
      if (snowflakeDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        snowflakeDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    public Builder setSnowflakeDialect(
        com.google.cloud.bigquery.migration.v2.SnowflakeDialect.Builder builderForValue) {
      if (snowflakeDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        snowflakeDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    public Builder mergeSnowflakeDialect(
        com.google.cloud.bigquery.migration.v2.SnowflakeDialect value) {
      if (snowflakeDialectBuilder_ == null) {
        if (dialectValueCase_ == 7
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.SnowflakeDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 7) {
          snowflakeDialectBuilder_.mergeFrom(value);
        } else {
          snowflakeDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    public Builder clearSnowflakeDialect() {
      if (snowflakeDialectBuilder_ == null) {
        if (dialectValueCase_ == 7) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 7) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        snowflakeDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    public com.google.cloud.bigquery.migration.v2.SnowflakeDialect.Builder
        getSnowflakeDialectBuilder() {
      return getSnowflakeDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.SnowflakeDialectOrBuilder
        getSnowflakeDialectOrBuilder() {
      if ((dialectValueCase_ == 7) && (snowflakeDialectBuilder_ != null)) {
        return snowflakeDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 7) {
          return (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Snowflake dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SnowflakeDialect snowflake_dialect = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SnowflakeDialect,
            com.google.cloud.bigquery.migration.v2.SnowflakeDialect.Builder,
            com.google.cloud.bigquery.migration.v2.SnowflakeDialectOrBuilder>
        getSnowflakeDialectFieldBuilder() {
      if (snowflakeDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 7)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.SnowflakeDialect.getDefaultInstance();
        }
        snowflakeDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.SnowflakeDialect,
                com.google.cloud.bigquery.migration.v2.SnowflakeDialect.Builder,
                com.google.cloud.bigquery.migration.v2.SnowflakeDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.SnowflakeDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 7;
      onChanged();
      ;
      return snowflakeDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.NetezzaDialect,
            com.google.cloud.bigquery.migration.v2.NetezzaDialect.Builder,
            com.google.cloud.bigquery.migration.v2.NetezzaDialectOrBuilder>
        netezzaDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     *
     * @return Whether the netezzaDialect field is set.
     */
    @java.lang.Override
    public boolean hasNetezzaDialect() {
      return dialectValueCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     *
     * @return The netezzaDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.NetezzaDialect getNetezzaDialect() {
      if (netezzaDialectBuilder_ == null) {
        if (dialectValueCase_ == 8) {
          return (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 8) {
          return netezzaDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    public Builder setNetezzaDialect(com.google.cloud.bigquery.migration.v2.NetezzaDialect value) {
      if (netezzaDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        netezzaDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    public Builder setNetezzaDialect(
        com.google.cloud.bigquery.migration.v2.NetezzaDialect.Builder builderForValue) {
      if (netezzaDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        netezzaDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    public Builder mergeNetezzaDialect(
        com.google.cloud.bigquery.migration.v2.NetezzaDialect value) {
      if (netezzaDialectBuilder_ == null) {
        if (dialectValueCase_ == 8
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.NetezzaDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 8) {
          netezzaDialectBuilder_.mergeFrom(value);
        } else {
          netezzaDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    public Builder clearNetezzaDialect() {
      if (netezzaDialectBuilder_ == null) {
        if (dialectValueCase_ == 8) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 8) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        netezzaDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    public com.google.cloud.bigquery.migration.v2.NetezzaDialect.Builder
        getNetezzaDialectBuilder() {
      return getNetezzaDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.NetezzaDialectOrBuilder
        getNetezzaDialectOrBuilder() {
      if ((dialectValueCase_ == 8) && (netezzaDialectBuilder_ != null)) {
        return netezzaDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 8) {
          return (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Netezza dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.NetezzaDialect netezza_dialect = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.NetezzaDialect,
            com.google.cloud.bigquery.migration.v2.NetezzaDialect.Builder,
            com.google.cloud.bigquery.migration.v2.NetezzaDialectOrBuilder>
        getNetezzaDialectFieldBuilder() {
      if (netezzaDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 8)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.NetezzaDialect.getDefaultInstance();
        }
        netezzaDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.NetezzaDialect,
                com.google.cloud.bigquery.migration.v2.NetezzaDialect.Builder,
                com.google.cloud.bigquery.migration.v2.NetezzaDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.NetezzaDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 8;
      onChanged();
      ;
      return netezzaDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.AzureSynapseDialect,
            com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.Builder,
            com.google.cloud.bigquery.migration.v2.AzureSynapseDialectOrBuilder>
        azureSynapseDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     *
     * @return Whether the azureSynapseDialect field is set.
     */
    @java.lang.Override
    public boolean hasAzureSynapseDialect() {
      return dialectValueCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     *
     * @return The azureSynapseDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.AzureSynapseDialect getAzureSynapseDialect() {
      if (azureSynapseDialectBuilder_ == null) {
        if (dialectValueCase_ == 9) {
          return (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 9) {
          return azureSynapseDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    public Builder setAzureSynapseDialect(
        com.google.cloud.bigquery.migration.v2.AzureSynapseDialect value) {
      if (azureSynapseDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        azureSynapseDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    public Builder setAzureSynapseDialect(
        com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.Builder builderForValue) {
      if (azureSynapseDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        azureSynapseDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    public Builder mergeAzureSynapseDialect(
        com.google.cloud.bigquery.migration.v2.AzureSynapseDialect value) {
      if (azureSynapseDialectBuilder_ == null) {
        if (dialectValueCase_ == 9
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.AzureSynapseDialect
                    .getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 9) {
          azureSynapseDialectBuilder_.mergeFrom(value);
        } else {
          azureSynapseDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    public Builder clearAzureSynapseDialect() {
      if (azureSynapseDialectBuilder_ == null) {
        if (dialectValueCase_ == 9) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 9) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        azureSynapseDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    public com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.Builder
        getAzureSynapseDialectBuilder() {
      return getAzureSynapseDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.AzureSynapseDialectOrBuilder
        getAzureSynapseDialectOrBuilder() {
      if ((dialectValueCase_ == 9) && (azureSynapseDialectBuilder_ != null)) {
        return azureSynapseDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 9) {
          return (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Azure Synapse dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.AzureSynapseDialect azure_synapse_dialect = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.AzureSynapseDialect,
            com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.Builder,
            com.google.cloud.bigquery.migration.v2.AzureSynapseDialectOrBuilder>
        getAzureSynapseDialectFieldBuilder() {
      if (azureSynapseDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 9)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.getDefaultInstance();
        }
        azureSynapseDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.AzureSynapseDialect,
                com.google.cloud.bigquery.migration.v2.AzureSynapseDialect.Builder,
                com.google.cloud.bigquery.migration.v2.AzureSynapseDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.AzureSynapseDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 9;
      onChanged();
      ;
      return azureSynapseDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.VerticaDialect,
            com.google.cloud.bigquery.migration.v2.VerticaDialect.Builder,
            com.google.cloud.bigquery.migration.v2.VerticaDialectOrBuilder>
        verticaDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     *
     * @return Whether the verticaDialect field is set.
     */
    @java.lang.Override
    public boolean hasVerticaDialect() {
      return dialectValueCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     *
     * @return The verticaDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.VerticaDialect getVerticaDialect() {
      if (verticaDialectBuilder_ == null) {
        if (dialectValueCase_ == 10) {
          return (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 10) {
          return verticaDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    public Builder setVerticaDialect(com.google.cloud.bigquery.migration.v2.VerticaDialect value) {
      if (verticaDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        verticaDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    public Builder setVerticaDialect(
        com.google.cloud.bigquery.migration.v2.VerticaDialect.Builder builderForValue) {
      if (verticaDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        verticaDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    public Builder mergeVerticaDialect(
        com.google.cloud.bigquery.migration.v2.VerticaDialect value) {
      if (verticaDialectBuilder_ == null) {
        if (dialectValueCase_ == 10
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.VerticaDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 10) {
          verticaDialectBuilder_.mergeFrom(value);
        } else {
          verticaDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    public Builder clearVerticaDialect() {
      if (verticaDialectBuilder_ == null) {
        if (dialectValueCase_ == 10) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 10) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        verticaDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    public com.google.cloud.bigquery.migration.v2.VerticaDialect.Builder
        getVerticaDialectBuilder() {
      return getVerticaDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.VerticaDialectOrBuilder
        getVerticaDialectOrBuilder() {
      if ((dialectValueCase_ == 10) && (verticaDialectBuilder_ != null)) {
        return verticaDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 10) {
          return (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Vertica dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.VerticaDialect vertica_dialect = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.VerticaDialect,
            com.google.cloud.bigquery.migration.v2.VerticaDialect.Builder,
            com.google.cloud.bigquery.migration.v2.VerticaDialectOrBuilder>
        getVerticaDialectFieldBuilder() {
      if (verticaDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 10)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.VerticaDialect.getDefaultInstance();
        }
        verticaDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.VerticaDialect,
                com.google.cloud.bigquery.migration.v2.VerticaDialect.Builder,
                com.google.cloud.bigquery.migration.v2.VerticaDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.VerticaDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 10;
      onChanged();
      ;
      return verticaDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SQLServerDialect,
            com.google.cloud.bigquery.migration.v2.SQLServerDialect.Builder,
            com.google.cloud.bigquery.migration.v2.SQLServerDialectOrBuilder>
        sqlServerDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     *
     * @return Whether the sqlServerDialect field is set.
     */
    @java.lang.Override
    public boolean hasSqlServerDialect() {
      return dialectValueCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     *
     * @return The sqlServerDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.SQLServerDialect getSqlServerDialect() {
      if (sqlServerDialectBuilder_ == null) {
        if (dialectValueCase_ == 11) {
          return (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 11) {
          return sqlServerDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    public Builder setSqlServerDialect(
        com.google.cloud.bigquery.migration.v2.SQLServerDialect value) {
      if (sqlServerDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        sqlServerDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    public Builder setSqlServerDialect(
        com.google.cloud.bigquery.migration.v2.SQLServerDialect.Builder builderForValue) {
      if (sqlServerDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        sqlServerDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    public Builder mergeSqlServerDialect(
        com.google.cloud.bigquery.migration.v2.SQLServerDialect value) {
      if (sqlServerDialectBuilder_ == null) {
        if (dialectValueCase_ == 11
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.SQLServerDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 11) {
          sqlServerDialectBuilder_.mergeFrom(value);
        } else {
          sqlServerDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    public Builder clearSqlServerDialect() {
      if (sqlServerDialectBuilder_ == null) {
        if (dialectValueCase_ == 11) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 11) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        sqlServerDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    public com.google.cloud.bigquery.migration.v2.SQLServerDialect.Builder
        getSqlServerDialectBuilder() {
      return getSqlServerDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.SQLServerDialectOrBuilder
        getSqlServerDialectOrBuilder() {
      if ((dialectValueCase_ == 11) && (sqlServerDialectBuilder_ != null)) {
        return sqlServerDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 11) {
          return (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The SQL Server dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.SQLServerDialect sql_server_dialect = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.SQLServerDialect,
            com.google.cloud.bigquery.migration.v2.SQLServerDialect.Builder,
            com.google.cloud.bigquery.migration.v2.SQLServerDialectOrBuilder>
        getSqlServerDialectFieldBuilder() {
      if (sqlServerDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 11)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.SQLServerDialect.getDefaultInstance();
        }
        sqlServerDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.SQLServerDialect,
                com.google.cloud.bigquery.migration.v2.SQLServerDialect.Builder,
                com.google.cloud.bigquery.migration.v2.SQLServerDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.SQLServerDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 11;
      onChanged();
      ;
      return sqlServerDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.PostgresqlDialect,
            com.google.cloud.bigquery.migration.v2.PostgresqlDialect.Builder,
            com.google.cloud.bigquery.migration.v2.PostgresqlDialectOrBuilder>
        postgresqlDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     *
     * @return Whether the postgresqlDialect field is set.
     */
    @java.lang.Override
    public boolean hasPostgresqlDialect() {
      return dialectValueCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     *
     * @return The postgresqlDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.PostgresqlDialect getPostgresqlDialect() {
      if (postgresqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 12) {
          return (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 12) {
          return postgresqlDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    public Builder setPostgresqlDialect(
        com.google.cloud.bigquery.migration.v2.PostgresqlDialect value) {
      if (postgresqlDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        postgresqlDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    public Builder setPostgresqlDialect(
        com.google.cloud.bigquery.migration.v2.PostgresqlDialect.Builder builderForValue) {
      if (postgresqlDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        postgresqlDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    public Builder mergePostgresqlDialect(
        com.google.cloud.bigquery.migration.v2.PostgresqlDialect value) {
      if (postgresqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 12
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.PostgresqlDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 12) {
          postgresqlDialectBuilder_.mergeFrom(value);
        } else {
          postgresqlDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    public Builder clearPostgresqlDialect() {
      if (postgresqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 12) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 12) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        postgresqlDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    public com.google.cloud.bigquery.migration.v2.PostgresqlDialect.Builder
        getPostgresqlDialectBuilder() {
      return getPostgresqlDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.PostgresqlDialectOrBuilder
        getPostgresqlDialectOrBuilder() {
      if ((dialectValueCase_ == 12) && (postgresqlDialectBuilder_ != null)) {
        return postgresqlDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 12) {
          return (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Postgresql dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PostgresqlDialect postgresql_dialect = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.PostgresqlDialect,
            com.google.cloud.bigquery.migration.v2.PostgresqlDialect.Builder,
            com.google.cloud.bigquery.migration.v2.PostgresqlDialectOrBuilder>
        getPostgresqlDialectFieldBuilder() {
      if (postgresqlDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 12)) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.PostgresqlDialect.getDefaultInstance();
        }
        postgresqlDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.PostgresqlDialect,
                com.google.cloud.bigquery.migration.v2.PostgresqlDialect.Builder,
                com.google.cloud.bigquery.migration.v2.PostgresqlDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.PostgresqlDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 12;
      onChanged();
      ;
      return postgresqlDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.PrestoDialect,
            com.google.cloud.bigquery.migration.v2.PrestoDialect.Builder,
            com.google.cloud.bigquery.migration.v2.PrestoDialectOrBuilder>
        prestoDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     *
     * @return Whether the prestoDialect field is set.
     */
    @java.lang.Override
    public boolean hasPrestoDialect() {
      return dialectValueCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     *
     * @return The prestoDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.PrestoDialect getPrestoDialect() {
      if (prestoDialectBuilder_ == null) {
        if (dialectValueCase_ == 13) {
          return (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 13) {
          return prestoDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    public Builder setPrestoDialect(com.google.cloud.bigquery.migration.v2.PrestoDialect value) {
      if (prestoDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        prestoDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    public Builder setPrestoDialect(
        com.google.cloud.bigquery.migration.v2.PrestoDialect.Builder builderForValue) {
      if (prestoDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        prestoDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    public Builder mergePrestoDialect(com.google.cloud.bigquery.migration.v2.PrestoDialect value) {
      if (prestoDialectBuilder_ == null) {
        if (dialectValueCase_ == 13
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.PrestoDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 13) {
          prestoDialectBuilder_.mergeFrom(value);
        } else {
          prestoDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    public Builder clearPrestoDialect() {
      if (prestoDialectBuilder_ == null) {
        if (dialectValueCase_ == 13) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 13) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        prestoDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    public com.google.cloud.bigquery.migration.v2.PrestoDialect.Builder getPrestoDialectBuilder() {
      return getPrestoDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.PrestoDialectOrBuilder
        getPrestoDialectOrBuilder() {
      if ((dialectValueCase_ == 13) && (prestoDialectBuilder_ != null)) {
        return prestoDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 13) {
          return (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Presto dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.PrestoDialect presto_dialect = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.PrestoDialect,
            com.google.cloud.bigquery.migration.v2.PrestoDialect.Builder,
            com.google.cloud.bigquery.migration.v2.PrestoDialectOrBuilder>
        getPrestoDialectFieldBuilder() {
      if (prestoDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 13)) {
          dialectValue_ = com.google.cloud.bigquery.migration.v2.PrestoDialect.getDefaultInstance();
        }
        prestoDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.PrestoDialect,
                com.google.cloud.bigquery.migration.v2.PrestoDialect.Builder,
                com.google.cloud.bigquery.migration.v2.PrestoDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.PrestoDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 13;
      onChanged();
      ;
      return prestoDialectBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.MySQLDialect,
            com.google.cloud.bigquery.migration.v2.MySQLDialect.Builder,
            com.google.cloud.bigquery.migration.v2.MySQLDialectOrBuilder>
        mysqlDialectBuilder_;
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     *
     * @return Whether the mysqlDialect field is set.
     */
    @java.lang.Override
    public boolean hasMysqlDialect() {
      return dialectValueCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     *
     * @return The mysqlDialect.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MySQLDialect getMysqlDialect() {
      if (mysqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 14) {
          return (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance();
      } else {
        if (dialectValueCase_ == 14) {
          return mysqlDialectBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    public Builder setMysqlDialect(com.google.cloud.bigquery.migration.v2.MySQLDialect value) {
      if (mysqlDialectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialectValue_ = value;
        onChanged();
      } else {
        mysqlDialectBuilder_.setMessage(value);
      }
      dialectValueCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    public Builder setMysqlDialect(
        com.google.cloud.bigquery.migration.v2.MySQLDialect.Builder builderForValue) {
      if (mysqlDialectBuilder_ == null) {
        dialectValue_ = builderForValue.build();
        onChanged();
      } else {
        mysqlDialectBuilder_.setMessage(builderForValue.build());
      }
      dialectValueCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    public Builder mergeMysqlDialect(com.google.cloud.bigquery.migration.v2.MySQLDialect value) {
      if (mysqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 14
            && dialectValue_
                != com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance()) {
          dialectValue_ =
              com.google.cloud.bigquery.migration.v2.MySQLDialect.newBuilder(
                      (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dialectValue_ = value;
        }
        onChanged();
      } else {
        if (dialectValueCase_ == 14) {
          mysqlDialectBuilder_.mergeFrom(value);
        } else {
          mysqlDialectBuilder_.setMessage(value);
        }
      }
      dialectValueCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    public Builder clearMysqlDialect() {
      if (mysqlDialectBuilder_ == null) {
        if (dialectValueCase_ == 14) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
          onChanged();
        }
      } else {
        if (dialectValueCase_ == 14) {
          dialectValueCase_ = 0;
          dialectValue_ = null;
        }
        mysqlDialectBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    public com.google.cloud.bigquery.migration.v2.MySQLDialect.Builder getMysqlDialectBuilder() {
      return getMysqlDialectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.migration.v2.MySQLDialectOrBuilder getMysqlDialectOrBuilder() {
      if ((dialectValueCase_ == 14) && (mysqlDialectBuilder_ != null)) {
        return mysqlDialectBuilder_.getMessageOrBuilder();
      } else {
        if (dialectValueCase_ == 14) {
          return (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_;
        }
        return com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The MySQL dialect
     * </pre>
     *
     * <code>.google.cloud.bigquery.migration.v2.MySQLDialect mysql_dialect = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.migration.v2.MySQLDialect,
            com.google.cloud.bigquery.migration.v2.MySQLDialect.Builder,
            com.google.cloud.bigquery.migration.v2.MySQLDialectOrBuilder>
        getMysqlDialectFieldBuilder() {
      if (mysqlDialectBuilder_ == null) {
        if (!(dialectValueCase_ == 14)) {
          dialectValue_ = com.google.cloud.bigquery.migration.v2.MySQLDialect.getDefaultInstance();
        }
        mysqlDialectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.migration.v2.MySQLDialect,
                com.google.cloud.bigquery.migration.v2.MySQLDialect.Builder,
                com.google.cloud.bigquery.migration.v2.MySQLDialectOrBuilder>(
                (com.google.cloud.bigquery.migration.v2.MySQLDialect) dialectValue_,
                getParentForChildren(),
                isClean());
        dialectValue_ = null;
      }
      dialectValueCase_ = 14;
      onChanged();
      ;
      return mysqlDialectBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.migration.v2.Dialect)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.migration.v2.Dialect)
  private static final com.google.cloud.bigquery.migration.v2.Dialect DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.migration.v2.Dialect();
  }

  public static com.google.cloud.bigquery.migration.v2.Dialect getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Dialect> PARSER =
      new com.google.protobuf.AbstractParser<Dialect>() {
        @java.lang.Override
        public Dialect parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Dialect> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Dialect> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.migration.v2.Dialect getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
