/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * A segment is a subset of your Analytics data. For example, of your entire set
 * of users, one segment might be users from a particular country or city.
 * Another segment might be users who purchase a particular line of products or
 * who visit a specific part of your site or trigger certain events in your app.
 * To learn more, see [GA4 Segment
 * Builder](https://support.google.com/analytics/answer/9304353).
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.Segment}
 */
public final class Segment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.Segment)
    SegmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Segment.newBuilder() to construct.
  private Segment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Segment() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Segment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_Segment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_Segment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.Segment.class,
            com.google.analytics.data.v1alpha.Segment.Builder.class);
  }

  private int oneSegmentScopeCase_ = 0;
  private java.lang.Object oneSegmentScope_;

  public enum OneSegmentScopeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_SEGMENT(2),
    SESSION_SEGMENT(3),
    EVENT_SEGMENT(4),
    ONESEGMENTSCOPE_NOT_SET(0);
    private final int value;

    private OneSegmentScopeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OneSegmentScopeCase valueOf(int value) {
      return forNumber(value);
    }

    public static OneSegmentScopeCase forNumber(int value) {
      switch (value) {
        case 2:
          return USER_SEGMENT;
        case 3:
          return SESSION_SEGMENT;
        case 4:
          return EVENT_SEGMENT;
        case 0:
          return ONESEGMENTSCOPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OneSegmentScopeCase getOneSegmentScopeCase() {
    return OneSegmentScopeCase.forNumber(oneSegmentScopeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name for this segment. If unspecified, segments are named "Segment".
   * This name defines string value returned by the `segment` dimension. The
   * `segment` dimension prefixes segment names by the 1-based index number of
   * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name for this segment. If unspecified, segments are named "Segment".
   * This name defines string value returned by the `segment` dimension. The
   * `segment` dimension prefixes segment names by the 1-based index number of
   * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_SEGMENT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * User segments are subsets of users who engaged with your site or app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
   *
   * @return Whether the userSegment field is set.
   */
  @java.lang.Override
  public boolean hasUserSegment() {
    return oneSegmentScopeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * User segments are subsets of users who engaged with your site or app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
   *
   * @return The userSegment.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserSegment getUserSegment() {
    if (oneSegmentScopeCase_ == 2) {
      return (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_;
    }
    return com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * User segments are subsets of users who engaged with your site or app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.UserSegmentOrBuilder getUserSegmentOrBuilder() {
    if (oneSegmentScopeCase_ == 2) {
      return (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_;
    }
    return com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance();
  }

  public static final int SESSION_SEGMENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Session segments are subsets of the sessions that occurred on your site
   * or app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
   *
   * @return Whether the sessionSegment field is set.
   */
  @java.lang.Override
  public boolean hasSessionSegment() {
    return oneSegmentScopeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Session segments are subsets of the sessions that occurred on your site
   * or app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
   *
   * @return The sessionSegment.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SessionSegment getSessionSegment() {
    if (oneSegmentScopeCase_ == 3) {
      return (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_;
    }
    return com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Session segments are subsets of the sessions that occurred on your site
   * or app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SessionSegmentOrBuilder getSessionSegmentOrBuilder() {
    if (oneSegmentScopeCase_ == 3) {
      return (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_;
    }
    return com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance();
  }

  public static final int EVENT_SEGMENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Event segments are subsets of events that were triggered on your site or
   * app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
   *
   * @return Whether the eventSegment field is set.
   */
  @java.lang.Override
  public boolean hasEventSegment() {
    return oneSegmentScopeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Event segments are subsets of events that were triggered on your site or
   * app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
   *
   * @return The eventSegment.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.EventSegment getEventSegment() {
    if (oneSegmentScopeCase_ == 4) {
      return (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_;
    }
    return com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Event segments are subsets of events that were triggered on your site or
   * app.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.EventSegmentOrBuilder getEventSegmentOrBuilder() {
    if (oneSegmentScopeCase_ == 4) {
      return (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_;
    }
    return com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (oneSegmentScopeCase_ == 2) {
      output.writeMessage(2, (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_);
    }
    if (oneSegmentScopeCase_ == 3) {
      output.writeMessage(3, (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_);
    }
    if (oneSegmentScopeCase_ == 4) {
      output.writeMessage(4, (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (oneSegmentScopeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_);
    }
    if (oneSegmentScopeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_);
    }
    if (oneSegmentScopeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.Segment)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.Segment other =
        (com.google.analytics.data.v1alpha.Segment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getOneSegmentScopeCase().equals(other.getOneSegmentScopeCase())) return false;
    switch (oneSegmentScopeCase_) {
      case 2:
        if (!getUserSegment().equals(other.getUserSegment())) return false;
        break;
      case 3:
        if (!getSessionSegment().equals(other.getSessionSegment())) return false;
        break;
      case 4:
        if (!getEventSegment().equals(other.getEventSegment())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    switch (oneSegmentScopeCase_) {
      case 2:
        hash = (37 * hash) + USER_SEGMENT_FIELD_NUMBER;
        hash = (53 * hash) + getUserSegment().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SESSION_SEGMENT_FIELD_NUMBER;
        hash = (53 * hash) + getSessionSegment().hashCode();
        break;
      case 4:
        hash = (37 * hash) + EVENT_SEGMENT_FIELD_NUMBER;
        hash = (53 * hash) + getEventSegment().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Segment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.Segment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.Segment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.Segment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A segment is a subset of your Analytics data. For example, of your entire set
   * of users, one segment might be users from a particular country or city.
   * Another segment might be users who purchase a particular line of products or
   * who visit a specific part of your site or trigger certain events in your app.
   * To learn more, see [GA4 Segment
   * Builder](https://support.google.com/analytics/answer/9304353).
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.Segment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.Segment)
      com.google.analytics.data.v1alpha.SegmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_Segment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_Segment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.Segment.class,
              com.google.analytics.data.v1alpha.Segment.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.Segment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (userSegmentBuilder_ != null) {
        userSegmentBuilder_.clear();
      }
      if (sessionSegmentBuilder_ != null) {
        sessionSegmentBuilder_.clear();
      }
      if (eventSegmentBuilder_ != null) {
        eventSegmentBuilder_.clear();
      }
      oneSegmentScopeCase_ = 0;
      oneSegmentScope_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_Segment_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.Segment getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.Segment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.Segment build() {
      com.google.analytics.data.v1alpha.Segment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.Segment buildPartial() {
      com.google.analytics.data.v1alpha.Segment result =
          new com.google.analytics.data.v1alpha.Segment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.Segment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    private void buildPartialOneofs(com.google.analytics.data.v1alpha.Segment result) {
      result.oneSegmentScopeCase_ = oneSegmentScopeCase_;
      result.oneSegmentScope_ = this.oneSegmentScope_;
      if (oneSegmentScopeCase_ == 2 && userSegmentBuilder_ != null) {
        result.oneSegmentScope_ = userSegmentBuilder_.build();
      }
      if (oneSegmentScopeCase_ == 3 && sessionSegmentBuilder_ != null) {
        result.oneSegmentScope_ = sessionSegmentBuilder_.build();
      }
      if (oneSegmentScopeCase_ == 4 && eventSegmentBuilder_ != null) {
        result.oneSegmentScope_ = eventSegmentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.Segment) {
        return mergeFrom((com.google.analytics.data.v1alpha.Segment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.Segment other) {
      if (other == com.google.analytics.data.v1alpha.Segment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getOneSegmentScopeCase()) {
        case USER_SEGMENT:
          {
            mergeUserSegment(other.getUserSegment());
            break;
          }
        case SESSION_SEGMENT:
          {
            mergeSessionSegment(other.getSessionSegment());
            break;
          }
        case EVENT_SEGMENT:
          {
            mergeEventSegment(other.getEventSegment());
            break;
          }
        case ONESEGMENTSCOPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUserSegmentFieldBuilder().getBuilder(), extensionRegistry);
                oneSegmentScopeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSessionSegmentFieldBuilder().getBuilder(), extensionRegistry);
                oneSegmentScopeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEventSegmentFieldBuilder().getBuilder(), extensionRegistry);
                oneSegmentScopeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int oneSegmentScopeCase_ = 0;
    private java.lang.Object oneSegmentScope_;

    public OneSegmentScopeCase getOneSegmentScopeCase() {
      return OneSegmentScopeCase.forNumber(oneSegmentScopeCase_);
    }

    public Builder clearOneSegmentScope() {
      oneSegmentScopeCase_ = 0;
      oneSegmentScope_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name for this segment. If unspecified, segments are named "Segment".
     * This name defines string value returned by the `segment` dimension. The
     * `segment` dimension prefixes segment names by the 1-based index number of
     * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name for this segment. If unspecified, segments are named "Segment".
     * This name defines string value returned by the `segment` dimension. The
     * `segment` dimension prefixes segment names by the 1-based index number of
     * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name for this segment. If unspecified, segments are named "Segment".
     * This name defines string value returned by the `segment` dimension. The
     * `segment` dimension prefixes segment names by the 1-based index number of
     * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name for this segment. If unspecified, segments are named "Segment".
     * This name defines string value returned by the `segment` dimension. The
     * `segment` dimension prefixes segment names by the 1-based index number of
     * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name for this segment. If unspecified, segments are named "Segment".
     * This name defines string value returned by the `segment` dimension. The
     * `segment` dimension prefixes segment names by the 1-based index number of
     * the segment in the request (i.e. "1. Segment", "2. Segment", etc.).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.UserSegment,
            com.google.analytics.data.v1alpha.UserSegment.Builder,
            com.google.analytics.data.v1alpha.UserSegmentOrBuilder>
        userSegmentBuilder_;
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     *
     * @return Whether the userSegment field is set.
     */
    @java.lang.Override
    public boolean hasUserSegment() {
      return oneSegmentScopeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     *
     * @return The userSegment.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSegment getUserSegment() {
      if (userSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 2) {
          return (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_;
        }
        return com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance();
      } else {
        if (oneSegmentScopeCase_ == 2) {
          return userSegmentBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    public Builder setUserSegment(com.google.analytics.data.v1alpha.UserSegment value) {
      if (userSegmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneSegmentScope_ = value;
        onChanged();
      } else {
        userSegmentBuilder_.setMessage(value);
      }
      oneSegmentScopeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    public Builder setUserSegment(
        com.google.analytics.data.v1alpha.UserSegment.Builder builderForValue) {
      if (userSegmentBuilder_ == null) {
        oneSegmentScope_ = builderForValue.build();
        onChanged();
      } else {
        userSegmentBuilder_.setMessage(builderForValue.build());
      }
      oneSegmentScopeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    public Builder mergeUserSegment(com.google.analytics.data.v1alpha.UserSegment value) {
      if (userSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 2
            && oneSegmentScope_
                != com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance()) {
          oneSegmentScope_ =
              com.google.analytics.data.v1alpha.UserSegment.newBuilder(
                      (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneSegmentScope_ = value;
        }
        onChanged();
      } else {
        if (oneSegmentScopeCase_ == 2) {
          userSegmentBuilder_.mergeFrom(value);
        } else {
          userSegmentBuilder_.setMessage(value);
        }
      }
      oneSegmentScopeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    public Builder clearUserSegment() {
      if (userSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 2) {
          oneSegmentScopeCase_ = 0;
          oneSegmentScope_ = null;
          onChanged();
        }
      } else {
        if (oneSegmentScopeCase_ == 2) {
          oneSegmentScopeCase_ = 0;
          oneSegmentScope_ = null;
        }
        userSegmentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    public com.google.analytics.data.v1alpha.UserSegment.Builder getUserSegmentBuilder() {
      return getUserSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.UserSegmentOrBuilder getUserSegmentOrBuilder() {
      if ((oneSegmentScopeCase_ == 2) && (userSegmentBuilder_ != null)) {
        return userSegmentBuilder_.getMessageOrBuilder();
      } else {
        if (oneSegmentScopeCase_ == 2) {
          return (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_;
        }
        return com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * User segments are subsets of users who engaged with your site or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.UserSegment user_segment = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.UserSegment,
            com.google.analytics.data.v1alpha.UserSegment.Builder,
            com.google.analytics.data.v1alpha.UserSegmentOrBuilder>
        getUserSegmentFieldBuilder() {
      if (userSegmentBuilder_ == null) {
        if (!(oneSegmentScopeCase_ == 2)) {
          oneSegmentScope_ = com.google.analytics.data.v1alpha.UserSegment.getDefaultInstance();
        }
        userSegmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.UserSegment,
                com.google.analytics.data.v1alpha.UserSegment.Builder,
                com.google.analytics.data.v1alpha.UserSegmentOrBuilder>(
                (com.google.analytics.data.v1alpha.UserSegment) oneSegmentScope_,
                getParentForChildren(),
                isClean());
        oneSegmentScope_ = null;
      }
      oneSegmentScopeCase_ = 2;
      onChanged();
      return userSegmentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.SessionSegment,
            com.google.analytics.data.v1alpha.SessionSegment.Builder,
            com.google.analytics.data.v1alpha.SessionSegmentOrBuilder>
        sessionSegmentBuilder_;
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     *
     * @return Whether the sessionSegment field is set.
     */
    @java.lang.Override
    public boolean hasSessionSegment() {
      return oneSegmentScopeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     *
     * @return The sessionSegment.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.SessionSegment getSessionSegment() {
      if (sessionSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 3) {
          return (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_;
        }
        return com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance();
      } else {
        if (oneSegmentScopeCase_ == 3) {
          return sessionSegmentBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    public Builder setSessionSegment(com.google.analytics.data.v1alpha.SessionSegment value) {
      if (sessionSegmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneSegmentScope_ = value;
        onChanged();
      } else {
        sessionSegmentBuilder_.setMessage(value);
      }
      oneSegmentScopeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    public Builder setSessionSegment(
        com.google.analytics.data.v1alpha.SessionSegment.Builder builderForValue) {
      if (sessionSegmentBuilder_ == null) {
        oneSegmentScope_ = builderForValue.build();
        onChanged();
      } else {
        sessionSegmentBuilder_.setMessage(builderForValue.build());
      }
      oneSegmentScopeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    public Builder mergeSessionSegment(com.google.analytics.data.v1alpha.SessionSegment value) {
      if (sessionSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 3
            && oneSegmentScope_
                != com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance()) {
          oneSegmentScope_ =
              com.google.analytics.data.v1alpha.SessionSegment.newBuilder(
                      (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneSegmentScope_ = value;
        }
        onChanged();
      } else {
        if (oneSegmentScopeCase_ == 3) {
          sessionSegmentBuilder_.mergeFrom(value);
        } else {
          sessionSegmentBuilder_.setMessage(value);
        }
      }
      oneSegmentScopeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    public Builder clearSessionSegment() {
      if (sessionSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 3) {
          oneSegmentScopeCase_ = 0;
          oneSegmentScope_ = null;
          onChanged();
        }
      } else {
        if (oneSegmentScopeCase_ == 3) {
          oneSegmentScopeCase_ = 0;
          oneSegmentScope_ = null;
        }
        sessionSegmentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    public com.google.analytics.data.v1alpha.SessionSegment.Builder getSessionSegmentBuilder() {
      return getSessionSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.SessionSegmentOrBuilder getSessionSegmentOrBuilder() {
      if ((oneSegmentScopeCase_ == 3) && (sessionSegmentBuilder_ != null)) {
        return sessionSegmentBuilder_.getMessageOrBuilder();
      } else {
        if (oneSegmentScopeCase_ == 3) {
          return (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_;
        }
        return com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Session segments are subsets of the sessions that occurred on your site
     * or app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.SessionSegment session_segment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.SessionSegment,
            com.google.analytics.data.v1alpha.SessionSegment.Builder,
            com.google.analytics.data.v1alpha.SessionSegmentOrBuilder>
        getSessionSegmentFieldBuilder() {
      if (sessionSegmentBuilder_ == null) {
        if (!(oneSegmentScopeCase_ == 3)) {
          oneSegmentScope_ = com.google.analytics.data.v1alpha.SessionSegment.getDefaultInstance();
        }
        sessionSegmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.SessionSegment,
                com.google.analytics.data.v1alpha.SessionSegment.Builder,
                com.google.analytics.data.v1alpha.SessionSegmentOrBuilder>(
                (com.google.analytics.data.v1alpha.SessionSegment) oneSegmentScope_,
                getParentForChildren(),
                isClean());
        oneSegmentScope_ = null;
      }
      oneSegmentScopeCase_ = 3;
      onChanged();
      return sessionSegmentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.EventSegment,
            com.google.analytics.data.v1alpha.EventSegment.Builder,
            com.google.analytics.data.v1alpha.EventSegmentOrBuilder>
        eventSegmentBuilder_;
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     *
     * @return Whether the eventSegment field is set.
     */
    @java.lang.Override
    public boolean hasEventSegment() {
      return oneSegmentScopeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     *
     * @return The eventSegment.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.EventSegment getEventSegment() {
      if (eventSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 4) {
          return (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_;
        }
        return com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance();
      } else {
        if (oneSegmentScopeCase_ == 4) {
          return eventSegmentBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    public Builder setEventSegment(com.google.analytics.data.v1alpha.EventSegment value) {
      if (eventSegmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneSegmentScope_ = value;
        onChanged();
      } else {
        eventSegmentBuilder_.setMessage(value);
      }
      oneSegmentScopeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    public Builder setEventSegment(
        com.google.analytics.data.v1alpha.EventSegment.Builder builderForValue) {
      if (eventSegmentBuilder_ == null) {
        oneSegmentScope_ = builderForValue.build();
        onChanged();
      } else {
        eventSegmentBuilder_.setMessage(builderForValue.build());
      }
      oneSegmentScopeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    public Builder mergeEventSegment(com.google.analytics.data.v1alpha.EventSegment value) {
      if (eventSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 4
            && oneSegmentScope_
                != com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance()) {
          oneSegmentScope_ =
              com.google.analytics.data.v1alpha.EventSegment.newBuilder(
                      (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneSegmentScope_ = value;
        }
        onChanged();
      } else {
        if (oneSegmentScopeCase_ == 4) {
          eventSegmentBuilder_.mergeFrom(value);
        } else {
          eventSegmentBuilder_.setMessage(value);
        }
      }
      oneSegmentScopeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    public Builder clearEventSegment() {
      if (eventSegmentBuilder_ == null) {
        if (oneSegmentScopeCase_ == 4) {
          oneSegmentScopeCase_ = 0;
          oneSegmentScope_ = null;
          onChanged();
        }
      } else {
        if (oneSegmentScopeCase_ == 4) {
          oneSegmentScopeCase_ = 0;
          oneSegmentScope_ = null;
        }
        eventSegmentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    public com.google.analytics.data.v1alpha.EventSegment.Builder getEventSegmentBuilder() {
      return getEventSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.EventSegmentOrBuilder getEventSegmentOrBuilder() {
      if ((oneSegmentScopeCase_ == 4) && (eventSegmentBuilder_ != null)) {
        return eventSegmentBuilder_.getMessageOrBuilder();
      } else {
        if (oneSegmentScopeCase_ == 4) {
          return (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_;
        }
        return com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Event segments are subsets of events that were triggered on your site or
     * app.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.EventSegment event_segment = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.EventSegment,
            com.google.analytics.data.v1alpha.EventSegment.Builder,
            com.google.analytics.data.v1alpha.EventSegmentOrBuilder>
        getEventSegmentFieldBuilder() {
      if (eventSegmentBuilder_ == null) {
        if (!(oneSegmentScopeCase_ == 4)) {
          oneSegmentScope_ = com.google.analytics.data.v1alpha.EventSegment.getDefaultInstance();
        }
        eventSegmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.EventSegment,
                com.google.analytics.data.v1alpha.EventSegment.Builder,
                com.google.analytics.data.v1alpha.EventSegmentOrBuilder>(
                (com.google.analytics.data.v1alpha.EventSegment) oneSegmentScope_,
                getParentForChildren(),
                isClean());
        oneSegmentScope_ = null;
      }
      oneSegmentScopeCase_ = 4;
      onChanged();
      return eventSegmentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.Segment)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.Segment)
  private static final com.google.analytics.data.v1alpha.Segment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.Segment();
  }

  public static com.google.analytics.data.v1alpha.Segment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Segment> PARSER =
      new com.google.protobuf.AbstractParser<Segment>() {
        @java.lang.Override
        public Segment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Segment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Segment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.Segment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
