/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * The request for a funnel report.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.RunFunnelReportRequest}
 */
public final class RunFunnelReportRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.RunFunnelReportRequest)
    RunFunnelReportRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunFunnelReportRequest.newBuilder() to construct.
  private RunFunnelReportRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunFunnelReportRequest() {
    property_ = "";
    dateRanges_ = java.util.Collections.emptyList();
    funnelVisualizationType_ = 0;
    segments_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunFunnelReportRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_RunFunnelReportRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_RunFunnelReportRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.RunFunnelReportRequest.class,
            com.google.analytics.data.v1alpha.RunFunnelReportRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Controls the dimensions present in the funnel visualization sub report
   * response.
   * </pre>
   *
   * Protobuf enum {@code
   * google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType}
   */
  public enum FunnelVisualizationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type.
     * </pre>
     *
     * <code>FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED = 0;</code>
     */
    FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A standard (stepped) funnel. The funnel visualization sub report in the
     * response will not contain date.
     * </pre>
     *
     * <code>STANDARD_FUNNEL = 1;</code>
     */
    STANDARD_FUNNEL(1),
    /**
     *
     *
     * <pre>
     * A trended (line chart) funnel. The funnel visualization sub report in the
     * response will contain the date dimension.
     * </pre>
     *
     * <code>TRENDED_FUNNEL = 2;</code>
     */
    TRENDED_FUNNEL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type.
     * </pre>
     *
     * <code>FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A standard (stepped) funnel. The funnel visualization sub report in the
     * response will not contain date.
     * </pre>
     *
     * <code>STANDARD_FUNNEL = 1;</code>
     */
    public static final int STANDARD_FUNNEL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A trended (line chart) funnel. The funnel visualization sub report in the
     * response will contain the date dimension.
     * </pre>
     *
     * <code>TRENDED_FUNNEL = 2;</code>
     */
    public static final int TRENDED_FUNNEL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FunnelVisualizationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FunnelVisualizationType forNumber(int value) {
      switch (value) {
        case 0:
          return FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED;
        case 1:
          return STANDARD_FUNNEL;
        case 2:
          return TRENDED_FUNNEL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FunnelVisualizationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FunnelVisualizationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FunnelVisualizationType>() {
              public FunnelVisualizationType findValueByNumber(int number) {
                return FunnelVisualizationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.RunFunnelReportRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FunnelVisualizationType[] VALUES = values();

    public static FunnelVisualizationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FunnelVisualizationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType)
  }

  public static final int PROPERTY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object property_ = "";
  /**
   *
   *
   * <pre>
   * A Google Analytics GA4 property identifier whose events are tracked.
   * Specified in the URL path and not the body. To learn more, see [where to
   * find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   * Within a batch request, this property should either be unspecified or
   * consistent with the batch-level property.
   * Example: properties/1234
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public java.lang.String getProperty() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      property_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Google Analytics GA4 property identifier whose events are tracked.
   * Specified in the URL path and not the body. To learn more, see [where to
   * find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   * Within a batch request, this property should either be unspecified or
   * consistent with the batch-level property.
   * Example: properties/1234
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The bytes for property.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPropertyBytes() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      property_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATE_RANGES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1alpha.DateRange> dateRanges_;
  /**
   *
   *
   * <pre>
   * Date ranges of data to read. If multiple date ranges are requested, each
   * response row will contain a zero based date range index. If two date
   * ranges overlap, the event data for the overlapping days is included in the
   * response rows for both date ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.DateRange> getDateRangesList() {
    return dateRanges_;
  }
  /**
   *
   *
   * <pre>
   * Date ranges of data to read. If multiple date ranges are requested, each
   * response row will contain a zero based date range index. If two date
   * ranges overlap, the event data for the overlapping days is included in the
   * response rows for both date ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.DateRangeOrBuilder>
      getDateRangesOrBuilderList() {
    return dateRanges_;
  }
  /**
   *
   *
   * <pre>
   * Date ranges of data to read. If multiple date ranges are requested, each
   * response row will contain a zero based date range index. If two date
   * ranges overlap, the event data for the overlapping days is included in the
   * response rows for both date ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
   */
  @java.lang.Override
  public int getDateRangesCount() {
    return dateRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Date ranges of data to read. If multiple date ranges are requested, each
   * response row will contain a zero based date range index. If two date
   * ranges overlap, the event data for the overlapping days is included in the
   * response rows for both date ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.DateRange getDateRanges(int index) {
    return dateRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Date ranges of data to read. If multiple date ranges are requested, each
   * response row will contain a zero based date range index. If two date
   * ranges overlap, the event data for the overlapping days is included in the
   * response rows for both date ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.DateRangeOrBuilder getDateRangesOrBuilder(int index) {
    return dateRanges_.get(index);
  }

  public static final int FUNNEL_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1alpha.Funnel funnel_;
  /**
   *
   *
   * <pre>
   * The configuration of this request's funnel. This funnel configuration is
   * required.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
   *
   * @return Whether the funnel field is set.
   */
  @java.lang.Override
  public boolean hasFunnel() {
    return funnel_ != null;
  }
  /**
   *
   *
   * <pre>
   * The configuration of this request's funnel. This funnel configuration is
   * required.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
   *
   * @return The funnel.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.Funnel getFunnel() {
    return funnel_ == null
        ? com.google.analytics.data.v1alpha.Funnel.getDefaultInstance()
        : funnel_;
  }
  /**
   *
   *
   * <pre>
   * The configuration of this request's funnel. This funnel configuration is
   * required.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelOrBuilder getFunnelOrBuilder() {
    return funnel_ == null
        ? com.google.analytics.data.v1alpha.Funnel.getDefaultInstance()
        : funnel_;
  }

  public static final int FUNNEL_BREAKDOWN_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1alpha.FunnelBreakdown funnelBreakdown_;
  /**
   *
   *
   * <pre>
   * If specified, this breakdown adds a dimension to the funnel table sub
   * report response. This breakdown dimension expands each funnel step to the
   * unique values of the breakdown dimension. For example, a breakdown by the
   * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
   * `desktop`, and the total.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
   *
   * @return Whether the funnelBreakdown field is set.
   */
  @java.lang.Override
  public boolean hasFunnelBreakdown() {
    return funnelBreakdown_ != null;
  }
  /**
   *
   *
   * <pre>
   * If specified, this breakdown adds a dimension to the funnel table sub
   * report response. This breakdown dimension expands each funnel step to the
   * unique values of the breakdown dimension. For example, a breakdown by the
   * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
   * `desktop`, and the total.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
   *
   * @return The funnelBreakdown.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelBreakdown getFunnelBreakdown() {
    return funnelBreakdown_ == null
        ? com.google.analytics.data.v1alpha.FunnelBreakdown.getDefaultInstance()
        : funnelBreakdown_;
  }
  /**
   *
   *
   * <pre>
   * If specified, this breakdown adds a dimension to the funnel table sub
   * report response. This breakdown dimension expands each funnel step to the
   * unique values of the breakdown dimension. For example, a breakdown by the
   * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
   * `desktop`, and the total.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelBreakdownOrBuilder getFunnelBreakdownOrBuilder() {
    return funnelBreakdown_ == null
        ? com.google.analytics.data.v1alpha.FunnelBreakdown.getDefaultInstance()
        : funnelBreakdown_;
  }

  public static final int FUNNEL_NEXT_ACTION_FIELD_NUMBER = 5;
  private com.google.analytics.data.v1alpha.FunnelNextAction funnelNextAction_;
  /**
   *
   *
   * <pre>
   * If specified, next action adds a dimension to the funnel visualization sub
   * report response. This next action dimension expands each funnel step to the
   * unique values of the next action. For example a next action of the
   * `eventName` dimension will create rows for several events (i.e.
   * `session_start` &amp; `click`) and the total.
   * Next action only supports `eventName` and most Page / Screen dimensions
   * like `pageTitle` and `pagePath`.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
   *
   * @return Whether the funnelNextAction field is set.
   */
  @java.lang.Override
  public boolean hasFunnelNextAction() {
    return funnelNextAction_ != null;
  }
  /**
   *
   *
   * <pre>
   * If specified, next action adds a dimension to the funnel visualization sub
   * report response. This next action dimension expands each funnel step to the
   * unique values of the next action. For example a next action of the
   * `eventName` dimension will create rows for several events (i.e.
   * `session_start` &amp; `click`) and the total.
   * Next action only supports `eventName` and most Page / Screen dimensions
   * like `pageTitle` and `pagePath`.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
   *
   * @return The funnelNextAction.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelNextAction getFunnelNextAction() {
    return funnelNextAction_ == null
        ? com.google.analytics.data.v1alpha.FunnelNextAction.getDefaultInstance()
        : funnelNextAction_;
  }
  /**
   *
   *
   * <pre>
   * If specified, next action adds a dimension to the funnel visualization sub
   * report response. This next action dimension expands each funnel step to the
   * unique values of the next action. For example a next action of the
   * `eventName` dimension will create rows for several events (i.e.
   * `session_start` &amp; `click`) and the total.
   * Next action only supports `eventName` and most Page / Screen dimensions
   * like `pageTitle` and `pagePath`.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelNextActionOrBuilder
      getFunnelNextActionOrBuilder() {
    return funnelNextAction_ == null
        ? com.google.analytics.data.v1alpha.FunnelNextAction.getDefaultInstance()
        : funnelNextAction_;
  }

  public static final int FUNNEL_VISUALIZATION_TYPE_FIELD_NUMBER = 6;
  private int funnelVisualizationType_ = 0;
  /**
   *
   *
   * <pre>
   * The funnel visualization type controls the dimensions present in the funnel
   * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
   * used.
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for funnelVisualizationType.
   */
  @java.lang.Override
  public int getFunnelVisualizationTypeValue() {
    return funnelVisualizationType_;
  }
  /**
   *
   *
   * <pre>
   * The funnel visualization type controls the dimensions present in the funnel
   * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
   * used.
   * </pre>
   *
   * <code>
   * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
   * </code>
   *
   * @return The funnelVisualizationType.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
      getFunnelVisualizationType() {
    com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType result =
        com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType.forNumber(
            funnelVisualizationType_);
    return result == null
        ? com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
            .UNRECOGNIZED
        : result;
  }

  public static final int SEGMENTS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1alpha.Segment> segments_;
  /**
   *
   *
   * <pre>
   * The configurations of segments. Segments are subsets of a property's data.
   * In a funnel report with segments, the funnel is evaluated in each segment.
   * Each segment specified in this request
   * produces a separate row in the response; in the response, each segment
   * identified by its name.
   * The segments parameter is optional. Requests are limited to 4 segments.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.Segment> getSegmentsList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * The configurations of segments. Segments are subsets of a property's data.
   * In a funnel report with segments, the funnel is evaluated in each segment.
   * Each segment specified in this request
   * produces a separate row in the response; in the response, each segment
   * identified by its name.
   * The segments parameter is optional. Requests are limited to 4 segments.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.SegmentOrBuilder>
      getSegmentsOrBuilderList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * The configurations of segments. Segments are subsets of a property's data.
   * In a funnel report with segments, the funnel is evaluated in each segment.
   * Each segment specified in this request
   * produces a separate row in the response; in the response, each segment
   * identified by its name.
   * The segments parameter is optional. Requests are limited to 4 segments.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
   */
  @java.lang.Override
  public int getSegmentsCount() {
    return segments_.size();
  }
  /**
   *
   *
   * <pre>
   * The configurations of segments. Segments are subsets of a property's data.
   * In a funnel report with segments, the funnel is evaluated in each segment.
   * Each segment specified in this request
   * produces a separate row in the response; in the response, each segment
   * identified by its name.
   * The segments parameter is optional. Requests are limited to 4 segments.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.Segment getSegments(int index) {
    return segments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The configurations of segments. Segments are subsets of a property's data.
   * In a funnel report with segments, the funnel is evaluated in each segment.
   * Each segment specified in this request
   * produces a separate row in the response; in the response, each segment
   * identified by its name.
   * The segments parameter is optional. Requests are limited to 4 segments.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.SegmentOrBuilder getSegmentsOrBuilder(int index) {
    return segments_.get(index);
  }

  public static final int LIMIT_FIELD_NUMBER = 9;
  private long limit_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of rows to return. If unspecified, 10,000 rows are returned. The
   * API returns a maximum of 100,000 rows per request, no matter how many you
   * ask for. `limit` must be positive.
   * The API can also return fewer rows than the requested `limit`, if there
   * aren't as many dimension values as the `limit`.
   * </pre>
   *
   * <code>int64 limit = 9;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public long getLimit() {
    return limit_;
  }

  public static final int DIMENSION_FILTER_FIELD_NUMBER = 10;
  private com.google.analytics.data.v1alpha.FilterExpression dimensionFilter_;
  /**
   *
   *
   * <pre>
   * Dimension filters allow you to ask for only specific dimension values in
   * the report. To learn more, see [Creating a Report: Dimension
   * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
   * for examples. Metrics cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
   *
   * @return Whether the dimensionFilter field is set.
   */
  @java.lang.Override
  public boolean hasDimensionFilter() {
    return dimensionFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * Dimension filters allow you to ask for only specific dimension values in
   * the report. To learn more, see [Creating a Report: Dimension
   * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
   * for examples. Metrics cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
   *
   * @return The dimensionFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FilterExpression getDimensionFilter() {
    return dimensionFilter_ == null
        ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
        : dimensionFilter_;
  }
  /**
   *
   *
   * <pre>
   * Dimension filters allow you to ask for only specific dimension values in
   * the report. To learn more, see [Creating a Report: Dimension
   * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
   * for examples. Metrics cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FilterExpressionOrBuilder getDimensionFilterOrBuilder() {
    return dimensionFilter_ == null
        ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
        : dimensionFilter_;
  }

  public static final int RETURN_PROPERTY_QUOTA_FIELD_NUMBER = 12;
  private boolean returnPropertyQuota_ = false;
  /**
   *
   *
   * <pre>
   * Toggles whether to return the current state of this Analytics Property's
   * quota. Quota is returned in [PropertyQuota](#PropertyQuota).
   * </pre>
   *
   * <code>bool return_property_quota = 12;</code>
   *
   * @return The returnPropertyQuota.
   */
  @java.lang.Override
  public boolean getReturnPropertyQuota() {
    return returnPropertyQuota_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, property_);
    }
    for (int i = 0; i < dateRanges_.size(); i++) {
      output.writeMessage(2, dateRanges_.get(i));
    }
    if (funnel_ != null) {
      output.writeMessage(3, getFunnel());
    }
    if (funnelBreakdown_ != null) {
      output.writeMessage(4, getFunnelBreakdown());
    }
    if (funnelNextAction_ != null) {
      output.writeMessage(5, getFunnelNextAction());
    }
    if (funnelVisualizationType_
        != com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
            .FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, funnelVisualizationType_);
    }
    for (int i = 0; i < segments_.size(); i++) {
      output.writeMessage(7, segments_.get(i));
    }
    if (limit_ != 0L) {
      output.writeInt64(9, limit_);
    }
    if (dimensionFilter_ != null) {
      output.writeMessage(10, getDimensionFilter());
    }
    if (returnPropertyQuota_ != false) {
      output.writeBool(12, returnPropertyQuota_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, property_);
    }
    for (int i = 0; i < dateRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dateRanges_.get(i));
    }
    if (funnel_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFunnel());
    }
    if (funnelBreakdown_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFunnelBreakdown());
    }
    if (funnelNextAction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFunnelNextAction());
    }
    if (funnelVisualizationType_
        != com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
            .FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, funnelVisualizationType_);
    }
    for (int i = 0; i < segments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, segments_.get(i));
    }
    if (limit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, limit_);
    }
    if (dimensionFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDimensionFilter());
    }
    if (returnPropertyQuota_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, returnPropertyQuota_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.RunFunnelReportRequest)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.RunFunnelReportRequest other =
        (com.google.analytics.data.v1alpha.RunFunnelReportRequest) obj;

    if (!getProperty().equals(other.getProperty())) return false;
    if (!getDateRangesList().equals(other.getDateRangesList())) return false;
    if (hasFunnel() != other.hasFunnel()) return false;
    if (hasFunnel()) {
      if (!getFunnel().equals(other.getFunnel())) return false;
    }
    if (hasFunnelBreakdown() != other.hasFunnelBreakdown()) return false;
    if (hasFunnelBreakdown()) {
      if (!getFunnelBreakdown().equals(other.getFunnelBreakdown())) return false;
    }
    if (hasFunnelNextAction() != other.hasFunnelNextAction()) return false;
    if (hasFunnelNextAction()) {
      if (!getFunnelNextAction().equals(other.getFunnelNextAction())) return false;
    }
    if (funnelVisualizationType_ != other.funnelVisualizationType_) return false;
    if (!getSegmentsList().equals(other.getSegmentsList())) return false;
    if (getLimit() != other.getLimit()) return false;
    if (hasDimensionFilter() != other.hasDimensionFilter()) return false;
    if (hasDimensionFilter()) {
      if (!getDimensionFilter().equals(other.getDimensionFilter())) return false;
    }
    if (getReturnPropertyQuota() != other.getReturnPropertyQuota()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
    hash = (53 * hash) + getProperty().hashCode();
    if (getDateRangesCount() > 0) {
      hash = (37 * hash) + DATE_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDateRangesList().hashCode();
    }
    if (hasFunnel()) {
      hash = (37 * hash) + FUNNEL_FIELD_NUMBER;
      hash = (53 * hash) + getFunnel().hashCode();
    }
    if (hasFunnelBreakdown()) {
      hash = (37 * hash) + FUNNEL_BREAKDOWN_FIELD_NUMBER;
      hash = (53 * hash) + getFunnelBreakdown().hashCode();
    }
    if (hasFunnelNextAction()) {
      hash = (37 * hash) + FUNNEL_NEXT_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getFunnelNextAction().hashCode();
    }
    hash = (37 * hash) + FUNNEL_VISUALIZATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + funnelVisualizationType_;
    if (getSegmentsCount() > 0) {
      hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentsList().hashCode();
    }
    hash = (37 * hash) + LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLimit());
    if (hasDimensionFilter()) {
      hash = (37 * hash) + DIMENSION_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionFilter().hashCode();
    }
    hash = (37 * hash) + RETURN_PROPERTY_QUOTA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnPropertyQuota());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1alpha.RunFunnelReportRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for a funnel report.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.RunFunnelReportRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.RunFunnelReportRequest)
      com.google.analytics.data.v1alpha.RunFunnelReportRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RunFunnelReportRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RunFunnelReportRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.RunFunnelReportRequest.class,
              com.google.analytics.data.v1alpha.RunFunnelReportRequest.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.RunFunnelReportRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = "";
      if (dateRangesBuilder_ == null) {
        dateRanges_ = java.util.Collections.emptyList();
      } else {
        dateRanges_ = null;
        dateRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      funnel_ = null;
      if (funnelBuilder_ != null) {
        funnelBuilder_.dispose();
        funnelBuilder_ = null;
      }
      funnelBreakdown_ = null;
      if (funnelBreakdownBuilder_ != null) {
        funnelBreakdownBuilder_.dispose();
        funnelBreakdownBuilder_ = null;
      }
      funnelNextAction_ = null;
      if (funnelNextActionBuilder_ != null) {
        funnelNextActionBuilder_.dispose();
        funnelNextActionBuilder_ = null;
      }
      funnelVisualizationType_ = 0;
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
      } else {
        segments_ = null;
        segmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      limit_ = 0L;
      dimensionFilter_ = null;
      if (dimensionFilterBuilder_ != null) {
        dimensionFilterBuilder_.dispose();
        dimensionFilterBuilder_ = null;
      }
      returnPropertyQuota_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RunFunnelReportRequest_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportRequest getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.RunFunnelReportRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportRequest build() {
      com.google.analytics.data.v1alpha.RunFunnelReportRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportRequest buildPartial() {
      com.google.analytics.data.v1alpha.RunFunnelReportRequest result =
          new com.google.analytics.data.v1alpha.RunFunnelReportRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.analytics.data.v1alpha.RunFunnelReportRequest result) {
      if (dateRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dateRanges_ = java.util.Collections.unmodifiableList(dateRanges_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dateRanges_ = dateRanges_;
      } else {
        result.dateRanges_ = dateRangesBuilder_.build();
      }
      if (segmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          segments_ = java.util.Collections.unmodifiableList(segments_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.segments_ = segments_;
      } else {
        result.segments_ = segmentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.RunFunnelReportRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = property_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.funnel_ = funnelBuilder_ == null ? funnel_ : funnelBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.funnelBreakdown_ =
            funnelBreakdownBuilder_ == null ? funnelBreakdown_ : funnelBreakdownBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.funnelNextAction_ =
            funnelNextActionBuilder_ == null ? funnelNextAction_ : funnelNextActionBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.funnelVisualizationType_ = funnelVisualizationType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.limit_ = limit_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.dimensionFilter_ =
            dimensionFilterBuilder_ == null ? dimensionFilter_ : dimensionFilterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.returnPropertyQuota_ = returnPropertyQuota_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.RunFunnelReportRequest) {
        return mergeFrom((com.google.analytics.data.v1alpha.RunFunnelReportRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.RunFunnelReportRequest other) {
      if (other == com.google.analytics.data.v1alpha.RunFunnelReportRequest.getDefaultInstance())
        return this;
      if (!other.getProperty().isEmpty()) {
        property_ = other.property_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dateRangesBuilder_ == null) {
        if (!other.dateRanges_.isEmpty()) {
          if (dateRanges_.isEmpty()) {
            dateRanges_ = other.dateRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDateRangesIsMutable();
            dateRanges_.addAll(other.dateRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.dateRanges_.isEmpty()) {
          if (dateRangesBuilder_.isEmpty()) {
            dateRangesBuilder_.dispose();
            dateRangesBuilder_ = null;
            dateRanges_ = other.dateRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dateRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDateRangesFieldBuilder()
                    : null;
          } else {
            dateRangesBuilder_.addAllMessages(other.dateRanges_);
          }
        }
      }
      if (other.hasFunnel()) {
        mergeFunnel(other.getFunnel());
      }
      if (other.hasFunnelBreakdown()) {
        mergeFunnelBreakdown(other.getFunnelBreakdown());
      }
      if (other.hasFunnelNextAction()) {
        mergeFunnelNextAction(other.getFunnelNextAction());
      }
      if (other.funnelVisualizationType_ != 0) {
        setFunnelVisualizationTypeValue(other.getFunnelVisualizationTypeValue());
      }
      if (segmentsBuilder_ == null) {
        if (!other.segments_.isEmpty()) {
          if (segments_.isEmpty()) {
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSegmentsIsMutable();
            segments_.addAll(other.segments_);
          }
          onChanged();
        }
      } else {
        if (!other.segments_.isEmpty()) {
          if (segmentsBuilder_.isEmpty()) {
            segmentsBuilder_.dispose();
            segmentsBuilder_ = null;
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000040);
            segmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentsFieldBuilder()
                    : null;
          } else {
            segmentsBuilder_.addAllMessages(other.segments_);
          }
        }
      }
      if (other.getLimit() != 0L) {
        setLimit(other.getLimit());
      }
      if (other.hasDimensionFilter()) {
        mergeDimensionFilter(other.getDimensionFilter());
      }
      if (other.getReturnPropertyQuota() != false) {
        setReturnPropertyQuota(other.getReturnPropertyQuota());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                property_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.analytics.data.v1alpha.DateRange m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.DateRange.parser(), extensionRegistry);
                if (dateRangesBuilder_ == null) {
                  ensureDateRangesIsMutable();
                  dateRanges_.add(m);
                } else {
                  dateRangesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getFunnelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getFunnelBreakdownFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getFunnelNextActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                funnelVisualizationType_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.analytics.data.v1alpha.Segment m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.Segment.parser(), extensionRegistry);
                if (segmentsBuilder_ == null) {
                  ensureSegmentsIsMutable();
                  segments_.add(m);
                } else {
                  segmentsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 72:
              {
                limit_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getDimensionFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 96:
              {
                returnPropertyQuota_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object property_ = "";
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * Within a batch request, this property should either be unspecified or
     * consistent with the batch-level property.
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The property.
     */
    public java.lang.String getProperty() {
      java.lang.Object ref = property_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        property_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * Within a batch request, this property should either be unspecified or
     * consistent with the batch-level property.
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The bytes for property.
     */
    public com.google.protobuf.ByteString getPropertyBytes() {
      java.lang.Object ref = property_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        property_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * Within a batch request, this property should either be unspecified or
     * consistent with the batch-level property.
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The property to set.
     * @return This builder for chaining.
     */
    public Builder setProperty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * Within a batch request, this property should either be unspecified or
     * consistent with the batch-level property.
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProperty() {
      property_ = getDefaultInstance().getProperty();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * Within a batch request, this property should either be unspecified or
     * consistent with the batch-level property.
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The bytes for property to set.
     * @return This builder for chaining.
     */
    public Builder setPropertyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1alpha.DateRange> dateRanges_ =
        java.util.Collections.emptyList();

    private void ensureDateRangesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dateRanges_ =
            new java.util.ArrayList<com.google.analytics.data.v1alpha.DateRange>(dateRanges_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.DateRange,
            com.google.analytics.data.v1alpha.DateRange.Builder,
            com.google.analytics.data.v1alpha.DateRangeOrBuilder>
        dateRangesBuilder_;

    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.DateRange> getDateRangesList() {
      if (dateRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dateRanges_);
      } else {
        return dateRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public int getDateRangesCount() {
      if (dateRangesBuilder_ == null) {
        return dateRanges_.size();
      } else {
        return dateRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public com.google.analytics.data.v1alpha.DateRange getDateRanges(int index) {
      if (dateRangesBuilder_ == null) {
        return dateRanges_.get(index);
      } else {
        return dateRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder setDateRanges(int index, com.google.analytics.data.v1alpha.DateRange value) {
      if (dateRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDateRangesIsMutable();
        dateRanges_.set(index, value);
        onChanged();
      } else {
        dateRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder setDateRanges(
        int index, com.google.analytics.data.v1alpha.DateRange.Builder builderForValue) {
      if (dateRangesBuilder_ == null) {
        ensureDateRangesIsMutable();
        dateRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        dateRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder addDateRanges(com.google.analytics.data.v1alpha.DateRange value) {
      if (dateRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDateRangesIsMutable();
        dateRanges_.add(value);
        onChanged();
      } else {
        dateRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder addDateRanges(int index, com.google.analytics.data.v1alpha.DateRange value) {
      if (dateRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDateRangesIsMutable();
        dateRanges_.add(index, value);
        onChanged();
      } else {
        dateRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder addDateRanges(
        com.google.analytics.data.v1alpha.DateRange.Builder builderForValue) {
      if (dateRangesBuilder_ == null) {
        ensureDateRangesIsMutable();
        dateRanges_.add(builderForValue.build());
        onChanged();
      } else {
        dateRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder addDateRanges(
        int index, com.google.analytics.data.v1alpha.DateRange.Builder builderForValue) {
      if (dateRangesBuilder_ == null) {
        ensureDateRangesIsMutable();
        dateRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        dateRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder addAllDateRanges(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.DateRange> values) {
      if (dateRangesBuilder_ == null) {
        ensureDateRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dateRanges_);
        onChanged();
      } else {
        dateRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder clearDateRanges() {
      if (dateRangesBuilder_ == null) {
        dateRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dateRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public Builder removeDateRanges(int index) {
      if (dateRangesBuilder_ == null) {
        ensureDateRangesIsMutable();
        dateRanges_.remove(index);
        onChanged();
      } else {
        dateRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public com.google.analytics.data.v1alpha.DateRange.Builder getDateRangesBuilder(int index) {
      return getDateRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public com.google.analytics.data.v1alpha.DateRangeOrBuilder getDateRangesOrBuilder(int index) {
      if (dateRangesBuilder_ == null) {
        return dateRanges_.get(index);
      } else {
        return dateRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.DateRangeOrBuilder>
        getDateRangesOrBuilderList() {
      if (dateRangesBuilder_ != null) {
        return dateRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dateRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public com.google.analytics.data.v1alpha.DateRange.Builder addDateRangesBuilder() {
      return getDateRangesFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.DateRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public com.google.analytics.data.v1alpha.DateRange.Builder addDateRangesBuilder(int index) {
      return getDateRangesFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1alpha.DateRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Date ranges of data to read. If multiple date ranges are requested, each
     * response row will contain a zero based date range index. If two date
     * ranges overlap, the event data for the overlapping days is included in the
     * response rows for both date ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.DateRange date_ranges = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.DateRange.Builder>
        getDateRangesBuilderList() {
      return getDateRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.DateRange,
            com.google.analytics.data.v1alpha.DateRange.Builder,
            com.google.analytics.data.v1alpha.DateRangeOrBuilder>
        getDateRangesFieldBuilder() {
      if (dateRangesBuilder_ == null) {
        dateRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.DateRange,
                com.google.analytics.data.v1alpha.DateRange.Builder,
                com.google.analytics.data.v1alpha.DateRangeOrBuilder>(
                dateRanges_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        dateRanges_ = null;
      }
      return dateRangesBuilder_;
    }

    private com.google.analytics.data.v1alpha.Funnel funnel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.Funnel,
            com.google.analytics.data.v1alpha.Funnel.Builder,
            com.google.analytics.data.v1alpha.FunnelOrBuilder>
        funnelBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     *
     * @return Whether the funnel field is set.
     */
    public boolean hasFunnel() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     *
     * @return The funnel.
     */
    public com.google.analytics.data.v1alpha.Funnel getFunnel() {
      if (funnelBuilder_ == null) {
        return funnel_ == null
            ? com.google.analytics.data.v1alpha.Funnel.getDefaultInstance()
            : funnel_;
      } else {
        return funnelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    public Builder setFunnel(com.google.analytics.data.v1alpha.Funnel value) {
      if (funnelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        funnel_ = value;
      } else {
        funnelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    public Builder setFunnel(com.google.analytics.data.v1alpha.Funnel.Builder builderForValue) {
      if (funnelBuilder_ == null) {
        funnel_ = builderForValue.build();
      } else {
        funnelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    public Builder mergeFunnel(com.google.analytics.data.v1alpha.Funnel value) {
      if (funnelBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && funnel_ != null
            && funnel_ != com.google.analytics.data.v1alpha.Funnel.getDefaultInstance()) {
          getFunnelBuilder().mergeFrom(value);
        } else {
          funnel_ = value;
        }
      } else {
        funnelBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    public Builder clearFunnel() {
      bitField0_ = (bitField0_ & ~0x00000004);
      funnel_ = null;
      if (funnelBuilder_ != null) {
        funnelBuilder_.dispose();
        funnelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    public com.google.analytics.data.v1alpha.Funnel.Builder getFunnelBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFunnelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelOrBuilder getFunnelOrBuilder() {
      if (funnelBuilder_ != null) {
        return funnelBuilder_.getMessageOrBuilder();
      } else {
        return funnel_ == null
            ? com.google.analytics.data.v1alpha.Funnel.getDefaultInstance()
            : funnel_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration of this request's funnel. This funnel configuration is
     * required.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.Funnel funnel = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.Funnel,
            com.google.analytics.data.v1alpha.Funnel.Builder,
            com.google.analytics.data.v1alpha.FunnelOrBuilder>
        getFunnelFieldBuilder() {
      if (funnelBuilder_ == null) {
        funnelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.Funnel,
                com.google.analytics.data.v1alpha.Funnel.Builder,
                com.google.analytics.data.v1alpha.FunnelOrBuilder>(
                getFunnel(), getParentForChildren(), isClean());
        funnel_ = null;
      }
      return funnelBuilder_;
    }

    private com.google.analytics.data.v1alpha.FunnelBreakdown funnelBreakdown_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelBreakdown,
            com.google.analytics.data.v1alpha.FunnelBreakdown.Builder,
            com.google.analytics.data.v1alpha.FunnelBreakdownOrBuilder>
        funnelBreakdownBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     *
     * @return Whether the funnelBreakdown field is set.
     */
    public boolean hasFunnelBreakdown() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     *
     * @return The funnelBreakdown.
     */
    public com.google.analytics.data.v1alpha.FunnelBreakdown getFunnelBreakdown() {
      if (funnelBreakdownBuilder_ == null) {
        return funnelBreakdown_ == null
            ? com.google.analytics.data.v1alpha.FunnelBreakdown.getDefaultInstance()
            : funnelBreakdown_;
      } else {
        return funnelBreakdownBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    public Builder setFunnelBreakdown(com.google.analytics.data.v1alpha.FunnelBreakdown value) {
      if (funnelBreakdownBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        funnelBreakdown_ = value;
      } else {
        funnelBreakdownBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    public Builder setFunnelBreakdown(
        com.google.analytics.data.v1alpha.FunnelBreakdown.Builder builderForValue) {
      if (funnelBreakdownBuilder_ == null) {
        funnelBreakdown_ = builderForValue.build();
      } else {
        funnelBreakdownBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    public Builder mergeFunnelBreakdown(com.google.analytics.data.v1alpha.FunnelBreakdown value) {
      if (funnelBreakdownBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && funnelBreakdown_ != null
            && funnelBreakdown_
                != com.google.analytics.data.v1alpha.FunnelBreakdown.getDefaultInstance()) {
          getFunnelBreakdownBuilder().mergeFrom(value);
        } else {
          funnelBreakdown_ = value;
        }
      } else {
        funnelBreakdownBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    public Builder clearFunnelBreakdown() {
      bitField0_ = (bitField0_ & ~0x00000008);
      funnelBreakdown_ = null;
      if (funnelBreakdownBuilder_ != null) {
        funnelBreakdownBuilder_.dispose();
        funnelBreakdownBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelBreakdown.Builder getFunnelBreakdownBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFunnelBreakdownFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelBreakdownOrBuilder
        getFunnelBreakdownOrBuilder() {
      if (funnelBreakdownBuilder_ != null) {
        return funnelBreakdownBuilder_.getMessageOrBuilder();
      } else {
        return funnelBreakdown_ == null
            ? com.google.analytics.data.v1alpha.FunnelBreakdown.getDefaultInstance()
            : funnelBreakdown_;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, this breakdown adds a dimension to the funnel table sub
     * report response. This breakdown dimension expands each funnel step to the
     * unique values of the breakdown dimension. For example, a breakdown by the
     * `deviceCategory` dimension will create rows for `mobile`, `tablet`,
     * `desktop`, and the total.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelBreakdown funnel_breakdown = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelBreakdown,
            com.google.analytics.data.v1alpha.FunnelBreakdown.Builder,
            com.google.analytics.data.v1alpha.FunnelBreakdownOrBuilder>
        getFunnelBreakdownFieldBuilder() {
      if (funnelBreakdownBuilder_ == null) {
        funnelBreakdownBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FunnelBreakdown,
                com.google.analytics.data.v1alpha.FunnelBreakdown.Builder,
                com.google.analytics.data.v1alpha.FunnelBreakdownOrBuilder>(
                getFunnelBreakdown(), getParentForChildren(), isClean());
        funnelBreakdown_ = null;
      }
      return funnelBreakdownBuilder_;
    }

    private com.google.analytics.data.v1alpha.FunnelNextAction funnelNextAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelNextAction,
            com.google.analytics.data.v1alpha.FunnelNextAction.Builder,
            com.google.analytics.data.v1alpha.FunnelNextActionOrBuilder>
        funnelNextActionBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     *
     * @return Whether the funnelNextAction field is set.
     */
    public boolean hasFunnelNextAction() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     *
     * @return The funnelNextAction.
     */
    public com.google.analytics.data.v1alpha.FunnelNextAction getFunnelNextAction() {
      if (funnelNextActionBuilder_ == null) {
        return funnelNextAction_ == null
            ? com.google.analytics.data.v1alpha.FunnelNextAction.getDefaultInstance()
            : funnelNextAction_;
      } else {
        return funnelNextActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    public Builder setFunnelNextAction(com.google.analytics.data.v1alpha.FunnelNextAction value) {
      if (funnelNextActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        funnelNextAction_ = value;
      } else {
        funnelNextActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    public Builder setFunnelNextAction(
        com.google.analytics.data.v1alpha.FunnelNextAction.Builder builderForValue) {
      if (funnelNextActionBuilder_ == null) {
        funnelNextAction_ = builderForValue.build();
      } else {
        funnelNextActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    public Builder mergeFunnelNextAction(com.google.analytics.data.v1alpha.FunnelNextAction value) {
      if (funnelNextActionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && funnelNextAction_ != null
            && funnelNextAction_
                != com.google.analytics.data.v1alpha.FunnelNextAction.getDefaultInstance()) {
          getFunnelNextActionBuilder().mergeFrom(value);
        } else {
          funnelNextAction_ = value;
        }
      } else {
        funnelNextActionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    public Builder clearFunnelNextAction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      funnelNextAction_ = null;
      if (funnelNextActionBuilder_ != null) {
        funnelNextActionBuilder_.dispose();
        funnelNextActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelNextAction.Builder getFunnelNextActionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getFunnelNextActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelNextActionOrBuilder
        getFunnelNextActionOrBuilder() {
      if (funnelNextActionBuilder_ != null) {
        return funnelNextActionBuilder_.getMessageOrBuilder();
      } else {
        return funnelNextAction_ == null
            ? com.google.analytics.data.v1alpha.FunnelNextAction.getDefaultInstance()
            : funnelNextAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, next action adds a dimension to the funnel visualization sub
     * report response. This next action dimension expands each funnel step to the
     * unique values of the next action. For example a next action of the
     * `eventName` dimension will create rows for several events (i.e.
     * `session_start` &amp; `click`) and the total.
     * Next action only supports `eventName` and most Page / Screen dimensions
     * like `pageTitle` and `pagePath`.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelNextAction funnel_next_action = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelNextAction,
            com.google.analytics.data.v1alpha.FunnelNextAction.Builder,
            com.google.analytics.data.v1alpha.FunnelNextActionOrBuilder>
        getFunnelNextActionFieldBuilder() {
      if (funnelNextActionBuilder_ == null) {
        funnelNextActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FunnelNextAction,
                com.google.analytics.data.v1alpha.FunnelNextAction.Builder,
                com.google.analytics.data.v1alpha.FunnelNextActionOrBuilder>(
                getFunnelNextAction(), getParentForChildren(), isClean());
        funnelNextAction_ = null;
      }
      return funnelNextActionBuilder_;
    }

    private int funnelVisualizationType_ = 0;
    /**
     *
     *
     * <pre>
     * The funnel visualization type controls the dimensions present in the funnel
     * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
     * used.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for funnelVisualizationType.
     */
    @java.lang.Override
    public int getFunnelVisualizationTypeValue() {
      return funnelVisualizationType_;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization type controls the dimensions present in the funnel
     * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
     * used.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for funnelVisualizationType to set.
     * @return This builder for chaining.
     */
    public Builder setFunnelVisualizationTypeValue(int value) {
      funnelVisualizationType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization type controls the dimensions present in the funnel
     * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
     * used.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
     * </code>
     *
     * @return The funnelVisualizationType.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
        getFunnelVisualizationType() {
      com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType result =
          com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
              .forNumber(funnelVisualizationType_);
      return result == null
          ? com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization type controls the dimensions present in the funnel
     * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
     * used.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
     * </code>
     *
     * @param value The funnelVisualizationType to set.
     * @return This builder for chaining.
     */
    public Builder setFunnelVisualizationType(
        com.google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      funnelVisualizationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The funnel visualization type controls the dimensions present in the funnel
     * visualization sub report response. If not specified, `STANDARD_FUNNEL` is
     * used.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType funnel_visualization_type = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFunnelVisualizationType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      funnelVisualizationType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1alpha.Segment> segments_ =
        java.util.Collections.emptyList();

    private void ensureSegmentsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        segments_ = new java.util.ArrayList<com.google.analytics.data.v1alpha.Segment>(segments_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.Segment,
            com.google.analytics.data.v1alpha.Segment.Builder,
            com.google.analytics.data.v1alpha.SegmentOrBuilder>
        segmentsBuilder_;

    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.Segment> getSegmentsList() {
      if (segmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segments_);
      } else {
        return segmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public int getSegmentsCount() {
      if (segmentsBuilder_ == null) {
        return segments_.size();
      } else {
        return segmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public com.google.analytics.data.v1alpha.Segment getSegments(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder setSegments(int index, com.google.analytics.data.v1alpha.Segment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.set(index, value);
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder setSegments(
        int index, com.google.analytics.data.v1alpha.Segment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder addSegments(com.google.analytics.data.v1alpha.Segment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder addSegments(int index, com.google.analytics.data.v1alpha.Segment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(index, value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder addSegments(com.google.analytics.data.v1alpha.Segment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder addSegments(
        int index, com.google.analytics.data.v1alpha.Segment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder addAllSegments(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.Segment> values) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
        onChanged();
      } else {
        segmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder clearSegments() {
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        segmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public Builder removeSegments(int index) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.remove(index);
        onChanged();
      } else {
        segmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public com.google.analytics.data.v1alpha.Segment.Builder getSegmentsBuilder(int index) {
      return getSegmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public com.google.analytics.data.v1alpha.SegmentOrBuilder getSegmentsOrBuilder(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.SegmentOrBuilder>
        getSegmentsOrBuilderList() {
      if (segmentsBuilder_ != null) {
        return segmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segments_);
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public com.google.analytics.data.v1alpha.Segment.Builder addSegmentsBuilder() {
      return getSegmentsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.Segment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public com.google.analytics.data.v1alpha.Segment.Builder addSegmentsBuilder(int index) {
      return getSegmentsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1alpha.Segment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configurations of segments. Segments are subsets of a property's data.
     * In a funnel report with segments, the funnel is evaluated in each segment.
     * Each segment specified in this request
     * produces a separate row in the response; in the response, each segment
     * identified by its name.
     * The segments parameter is optional. Requests are limited to 4 segments.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1alpha.Segment segments = 7;</code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.Segment.Builder>
        getSegmentsBuilderList() {
      return getSegmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.Segment,
            com.google.analytics.data.v1alpha.Segment.Builder,
            com.google.analytics.data.v1alpha.SegmentOrBuilder>
        getSegmentsFieldBuilder() {
      if (segmentsBuilder_ == null) {
        segmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.Segment,
                com.google.analytics.data.v1alpha.Segment.Builder,
                com.google.analytics.data.v1alpha.SegmentOrBuilder>(
                segments_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        segments_ = null;
      }
      return segmentsBuilder_;
    }

    private long limit_;
    /**
     *
     *
     * <pre>
     * The number of rows to return. If unspecified, 10,000 rows are returned. The
     * API returns a maximum of 100,000 rows per request, no matter how many you
     * ask for. `limit` must be positive.
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`.
     * </pre>
     *
     * <code>int64 limit = 9;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public long getLimit() {
      return limit_;
    }
    /**
     *
     *
     * <pre>
     * The number of rows to return. If unspecified, 10,000 rows are returned. The
     * API returns a maximum of 100,000 rows per request, no matter how many you
     * ask for. `limit` must be positive.
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`.
     * </pre>
     *
     * <code>int64 limit = 9;</code>
     *
     * @param value The limit to set.
     * @return This builder for chaining.
     */
    public Builder setLimit(long value) {

      limit_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of rows to return. If unspecified, 10,000 rows are returned. The
     * API returns a maximum of 100,000 rows per request, no matter how many you
     * ask for. `limit` must be positive.
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`.
     * </pre>
     *
     * <code>int64 limit = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000080);
      limit_ = 0L;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.FilterExpression dimensionFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FilterExpression,
            com.google.analytics.data.v1alpha.FilterExpression.Builder,
            com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>
        dimensionFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     *
     * @return Whether the dimensionFilter field is set.
     */
    public boolean hasDimensionFilter() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     *
     * @return The dimensionFilter.
     */
    public com.google.analytics.data.v1alpha.FilterExpression getDimensionFilter() {
      if (dimensionFilterBuilder_ == null) {
        return dimensionFilter_ == null
            ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
            : dimensionFilter_;
      } else {
        return dimensionFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    public Builder setDimensionFilter(com.google.analytics.data.v1alpha.FilterExpression value) {
      if (dimensionFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionFilter_ = value;
      } else {
        dimensionFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    public Builder setDimensionFilter(
        com.google.analytics.data.v1alpha.FilterExpression.Builder builderForValue) {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilter_ = builderForValue.build();
      } else {
        dimensionFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    public Builder mergeDimensionFilter(com.google.analytics.data.v1alpha.FilterExpression value) {
      if (dimensionFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && dimensionFilter_ != null
            && dimensionFilter_
                != com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()) {
          getDimensionFilterBuilder().mergeFrom(value);
        } else {
          dimensionFilter_ = value;
        }
      } else {
        dimensionFilterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    public Builder clearDimensionFilter() {
      bitField0_ = (bitField0_ & ~0x00000100);
      dimensionFilter_ = null;
      if (dimensionFilterBuilder_ != null) {
        dimensionFilterBuilder_.dispose();
        dimensionFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    public com.google.analytics.data.v1alpha.FilterExpression.Builder getDimensionFilterBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDimensionFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    public com.google.analytics.data.v1alpha.FilterExpressionOrBuilder
        getDimensionFilterOrBuilder() {
      if (dimensionFilterBuilder_ != null) {
        return dimensionFilterBuilder_.getMessageOrBuilder();
      } else {
        return dimensionFilter_ == null
            ? com.google.analytics.data.v1alpha.FilterExpression.getDefaultInstance()
            : dimensionFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Dimension filters allow you to ask for only specific dimension values in
     * the report. To learn more, see [Creating a Report: Dimension
     * Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
     * for examples. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FilterExpression dimension_filter = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FilterExpression,
            com.google.analytics.data.v1alpha.FilterExpression.Builder,
            com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>
        getDimensionFilterFieldBuilder() {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FilterExpression,
                com.google.analytics.data.v1alpha.FilterExpression.Builder,
                com.google.analytics.data.v1alpha.FilterExpressionOrBuilder>(
                getDimensionFilter(), getParentForChildren(), isClean());
        dimensionFilter_ = null;
      }
      return dimensionFilterBuilder_;
    }

    private boolean returnPropertyQuota_;
    /**
     *
     *
     * <pre>
     * Toggles whether to return the current state of this Analytics Property's
     * quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     * </pre>
     *
     * <code>bool return_property_quota = 12;</code>
     *
     * @return The returnPropertyQuota.
     */
    @java.lang.Override
    public boolean getReturnPropertyQuota() {
      return returnPropertyQuota_;
    }
    /**
     *
     *
     * <pre>
     * Toggles whether to return the current state of this Analytics Property's
     * quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     * </pre>
     *
     * <code>bool return_property_quota = 12;</code>
     *
     * @param value The returnPropertyQuota to set.
     * @return This builder for chaining.
     */
    public Builder setReturnPropertyQuota(boolean value) {

      returnPropertyQuota_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Toggles whether to return the current state of this Analytics Property's
     * quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     * </pre>
     *
     * <code>bool return_property_quota = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnPropertyQuota() {
      bitField0_ = (bitField0_ & ~0x00000200);
      returnPropertyQuota_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.RunFunnelReportRequest)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.RunFunnelReportRequest)
  private static final com.google.analytics.data.v1alpha.RunFunnelReportRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.RunFunnelReportRequest();
  }

  public static com.google.analytics.data.v1alpha.RunFunnelReportRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunFunnelReportRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunFunnelReportRequest>() {
        @java.lang.Override
        public RunFunnelReportRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunFunnelReportRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunFunnelReportRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.RunFunnelReportRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
