/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.utils;

import com.google.ads.googleads.lib.reflect.ReflectionFieldAccessor;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;

public class FieldMasks {
    public static <T extends GeneratedMessageV3> FieldMask compare(T original, T modified) {
        Preconditions.checkNotNull(original, (Object)"original is null");
        Preconditions.checkNotNull(modified, (Object)"modified is null");
        if (!original.getDescriptorForType().getFullName().equals(modified.getDescriptorForType().getFullName())) {
            throw new IllegalArgumentException(String.format("Parameters of types %s and %s must be of the same type.", original.getDescriptorForType().getFullName(), modified.getDescriptorForType().getFullName()));
        }
        FieldMask.Builder mask = FieldMask.newBuilder();
        FieldMasks.compare(mask, "", original, modified);
        return mask.build();
    }

    public static <T extends GeneratedMessageV3> FieldMask allSetFieldsOf(T message) {
        Preconditions.checkNotNull(message, (Object)"message is null");
        return FieldMasks.compare((GeneratedMessageV3)message.getDefaultInstanceForType(), message);
    }

    private static void compare(FieldMask.Builder mask, String currentField, Message original, Message modified) {
        Descriptors.Descriptor descriptor = original.getDescriptorForType();
        block4: for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            String fieldName = FieldMasks.getFieldName(currentField, field);
            Object fieldValueOriginal = original.getField(field);
            Object fieldValueModified = modified.getField(field);
            if (field.isRepeated()) {
                if (Objects.equals(fieldValueOriginal, fieldValueModified)) continue;
                mask.addPaths(fieldName);
                continue;
            }
            boolean hasValueChanged = original.hasField(field) != modified.hasField(field) || !Objects.equals(fieldValueOriginal, fieldValueModified);
            switch (field.getJavaType()) {
                case MESSAGE: {
                    if (!hasValueChanged) continue block4;
                    if (FieldMasks.shouldAddTopLevelMessageToPath(original, modified, field)) {
                        mask.addPaths(fieldName);
                        continue block4;
                    }
                    FieldMasks.compare(mask, fieldName, (Message)fieldValueOriginal, (Message)fieldValueModified);
                    continue block4;
                }
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: 
                case BYTE_STRING: 
                case ENUM: {
                    if (!hasValueChanged) continue block4;
                    mask.addPaths(fieldName);
                    continue block4;
                }
            }
            String string = String.valueOf(field.getJavaType());
            throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(fieldName).length()).append("Unexpected java type ").append(string).append(" encountered for field ").append(fieldName).toString());
        }
    }

    private static boolean shouldAddTopLevelMessageToPath(Message original, Message modified, Descriptors.FieldDescriptor field) {
        return FieldMasks.isWrapperType(field.getMessageType()) || FieldMasks.isClearingMessage(original, modified, field) || FieldMasks.isSettingEmptyOneOf(original, modified, field);
    }

    private static boolean isClearingMessage(Message original, Message modified, Descriptors.FieldDescriptor field) {
        Message originalValueMessage = (Message)original.getField(field);
        return !modified.hasField(field) && original.hasField(field) && originalValueMessage.getAllFields().isEmpty();
    }

    private static boolean isSettingEmptyOneOf(Message original, Message modified, Descriptors.FieldDescriptor field) {
        Message fieldValueModifiedMsg = (Message)modified.getField(field);
        return !original.hasField(field) && modified.hasField(field) && field.getContainingOneof() != null && fieldValueModifiedMsg.getDescriptorForType().getFields().isEmpty();
    }

    public static <T> List<T> getFieldValue(String fieldMaskPath, Message entity) {
        return new ReflectionFieldAccessor(fieldMaskPath).getValues(entity);
    }

    private static String getFieldName(String currentField, Descriptors.FieldDescriptor field) {
        if (currentField.isEmpty()) {
            return field.getName();
        }
        String string = field.getName();
        return new StringBuilder(1 + String.valueOf(currentField).length() + String.valueOf(string).length()).append(currentField).append(".").append(string).toString();
    }

    private static boolean isWrapperType(Descriptors.Descriptor descriptor) {
        return descriptor.getFile().getPackage().equals("google.protobuf") && descriptor.getFile().getFullName().equals("google/protobuf/wrappers.proto");
    }
}

