/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.lib.catalog.Primer;
import com.google.auth.Credentials;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrimer
extends Primer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPrimer.class);
    private static final int MAX_NUM_THREADS = 5;
    private static final String GRPC_RESOURCE_PATH = "/googleadsapi-primer/grpc_class_names";
    private static final String PROTOBUF_RESOURCE_PATH = "/googleadsapi-primer/protobuf_class_names";
    private final ExecutorService executorService;
    private final AtomicBoolean isGrpcPrimed = new AtomicBoolean(false);
    private final AtomicBoolean isProtobufPrimed = new AtomicBoolean(false);
    private final Consumer<String> classLoaderStrategy;
    private final String grpcResourcePath;
    private final String protobufResourcePath;

    DefaultPrimer() {
        this(name -> {
            try {
                Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }, GRPC_RESOURCE_PATH, PROTOBUF_RESOURCE_PATH, DefaultPrimer.createDefaultExecutor());
    }

    @VisibleForTesting
    DefaultPrimer(Consumer<String> classloaderStrategy, String grpcResourcePath, String protobufResourcePath, ExecutorService executorService) {
        this.classLoaderStrategy = classloaderStrategy;
        this.grpcResourcePath = grpcResourcePath;
        this.protobufResourcePath = protobufResourcePath;
        this.executorService = executorService;
    }

    @Override
    public void primeGrpcAsync() {
        boolean needsPrime = this.isGrpcPrimed.compareAndSet(false, true);
        if (needsPrime) {
            this.primeClassNamesResourceAsync(this.grpcResourcePath);
        }
    }

    @Override
    public void primeProtobufAsync() {
        boolean needsPrime = this.isProtobufPrimed.compareAndSet(false, true);
        if (needsPrime) {
            this.primeClassNamesResourceAsync(this.protobufResourcePath);
        }
    }

    @Override
    public void primeAllVersionsAsync() {
        this.runAndPreserveStacktrace(() -> GoogleAdsAllVersions.class.getMethods());
    }

    @Override
    public void primeCredentialsAsync(Credentials credentials) {
        this.runAndPreserveStacktrace(() -> {
            try {
                credentials.getRequestMetadata();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void runAndPreserveStacktrace(Runnable runnable) {
        this.executorService.submit(new StackTracePreservingRunnable(runnable));
    }

    private void primeClassNamesResourceAsync(String resourcePath) {
        this.runAndPreserveStacktrace(() -> this.primeClassNamesResource(resourcePath));
    }

    private static ExecutorService createDefaultExecutor() {
        return Executors.newFixedThreadPool(5, r -> {
            Thread t = new Thread(r);
            long l = t.getId();
            t.setName(new StringBuilder(40).append("GAAPI primer thread ").append(l).toString());
            t.setDaemon(true);
            return t;
        });
    }

    private void primeClassNamesResource(String resourcePath) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(DefaultPrimer.class.getResourceAsStream(resourcePath)));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0) continue;
                this.classLoaderStrategy.accept(line);
            }
        }
        catch (IOException e) {
            logger.debug("Failed to prime", (Throwable)e);
        }
    }

    private static class StackTracePreservingRunnable
    implements Runnable {
        private final StackTraceElement[] originalStackTrace = Thread.currentThread().getStackTrace();
        private final Runnable innerRunnable;

        public StackTracePreservingRunnable(Runnable innerRunnable) {
            this.innerRunnable = innerRunnable;
        }

        @Override
        public void run() {
            try {
                this.innerRunnable.run();
            }
            catch (Exception cause) {
                CrossThreadException exception = new CrossThreadException(this.originalStackTrace, cause);
                throw exception;
            }
        }

        private static class CrossThreadException
        extends RuntimeException {
            public CrossThreadException(StackTraceElement[] originalStackTrace, Exception cause) {
                super(cause);
                this.setStackTrace(originalStackTrace);
            }
        }
    }
}

