/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.services;

import com.google.ads.googleads.v11.enums.MonthOfYearEnum;
import com.google.ads.googleads.v11.services.InvoiceServiceSettings;
import com.google.ads.googleads.v11.services.ListInvoicesRequest;
import com.google.ads.googleads.v11.services.ListInvoicesResponse;
import com.google.ads.googleads.v11.services.stub.InvoiceServiceStub;
import com.google.ads.googleads.v11.services.stub.InvoiceServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class InvoiceServiceClient
implements BackgroundResource {
    private final InvoiceServiceSettings settings;
    private final InvoiceServiceStub stub;

    public static final InvoiceServiceClient create() throws IOException {
        return InvoiceServiceClient.create(InvoiceServiceSettings.newBuilder().build());
    }

    public static final InvoiceServiceClient create(InvoiceServiceSettings settings) throws IOException {
        return new InvoiceServiceClient(settings);
    }

    public static final InvoiceServiceClient create(InvoiceServiceStub stub) {
        return new InvoiceServiceClient(stub);
    }

    protected InvoiceServiceClient(InvoiceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InvoiceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected InvoiceServiceClient(InvoiceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InvoiceServiceSettings getSettings() {
        return this.settings;
    }

    public InvoiceServiceStub getStub() {
        return this.stub;
    }

    public final ListInvoicesResponse listInvoices(String customerId, String billingSetup, String issueYear, MonthOfYearEnum.MonthOfYear issueMonth) {
        ListInvoicesRequest request = ListInvoicesRequest.newBuilder().setCustomerId(customerId).setBillingSetup(billingSetup).setIssueYear(issueYear).setIssueMonth(issueMonth).build();
        return this.listInvoices(request);
    }

    public final ListInvoicesResponse listInvoices(ListInvoicesRequest request) {
        return (ListInvoicesResponse)this.listInvoicesCallable().call((Object)request);
    }

    public final UnaryCallable<ListInvoicesRequest, ListInvoicesResponse> listInvoicesCallable() {
        return this.stub.listInvoicesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

