/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.services;

import com.google.ads.googleads.v11.services.CustomizerAttributeOperation;
import com.google.ads.googleads.v11.services.CustomizerAttributeServiceSettings;
import com.google.ads.googleads.v11.services.MutateCustomizerAttributesRequest;
import com.google.ads.googleads.v11.services.MutateCustomizerAttributesResponse;
import com.google.ads.googleads.v11.services.stub.CustomizerAttributeServiceStub;
import com.google.ads.googleads.v11.services.stub.CustomizerAttributeServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomizerAttributeServiceClient
implements BackgroundResource {
    private final CustomizerAttributeServiceSettings settings;
    private final CustomizerAttributeServiceStub stub;

    public static final CustomizerAttributeServiceClient create() throws IOException {
        return CustomizerAttributeServiceClient.create(CustomizerAttributeServiceSettings.newBuilder().build());
    }

    public static final CustomizerAttributeServiceClient create(CustomizerAttributeServiceSettings settings) throws IOException {
        return new CustomizerAttributeServiceClient(settings);
    }

    public static final CustomizerAttributeServiceClient create(CustomizerAttributeServiceStub stub) {
        return new CustomizerAttributeServiceClient(stub);
    }

    protected CustomizerAttributeServiceClient(CustomizerAttributeServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomizerAttributeServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomizerAttributeServiceClient(CustomizerAttributeServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomizerAttributeServiceSettings getSettings() {
        return this.settings;
    }

    public CustomizerAttributeServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomizerAttributesResponse mutateCustomizerAttributes(String customerId, List<CustomizerAttributeOperation> operations) {
        MutateCustomizerAttributesRequest request = MutateCustomizerAttributesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomizerAttributes(request);
    }

    public final MutateCustomizerAttributesResponse mutateCustomizerAttributes(MutateCustomizerAttributesRequest request) {
        return (MutateCustomizerAttributesResponse)this.mutateCustomizerAttributesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomizerAttributesRequest, MutateCustomizerAttributesResponse> mutateCustomizerAttributesCallable() {
        return this.stub.mutateCustomizerAttributesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

