/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GeographicViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_COUNTRY_CRITERION_ID_LOCATION_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/geographicViews/{country_criterion_id}~{location_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String countryCriterionId;
    private final String locationType;

    @Deprecated
    protected GeographicViewName() {
        this.customerId = null;
        this.countryCriterionId = null;
        this.locationType = null;
    }

    private GeographicViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.countryCriterionId = (String)Preconditions.checkNotNull((Object)builder.getCountryCriterionId());
        this.locationType = (String)Preconditions.checkNotNull((Object)builder.getLocationType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCountryCriterionId() {
        return this.countryCriterionId;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GeographicViewName of(String customerId, String countryCriterionId, String locationType) {
        return GeographicViewName.newBuilder().setCustomerId(customerId).setCountryCriterionId(countryCriterionId).setLocationType(locationType).build();
    }

    public static String format(String customerId, String countryCriterionId, String locationType) {
        return GeographicViewName.newBuilder().setCustomerId(customerId).setCountryCriterionId(countryCriterionId).setLocationType(locationType).build().toString();
    }

    public static GeographicViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_COUNTRY_CRITERION_ID_LOCATION_TYPE.validatedMatch(formattedString, "GeographicViewName.parse: formattedString not in valid format");
        return GeographicViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("country_criterion_id"), (String)matchMap.get("location_type"));
    }

    public static List<GeographicViewName> parseList(List<String> formattedStrings) {
        ArrayList<GeographicViewName> list = new ArrayList<GeographicViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GeographicViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GeographicViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GeographicViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_COUNTRY_CRITERION_ID_LOCATION_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GeographicViewName geographicViewName = this;
            synchronized (geographicViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.countryCriterionId != null) {
                        fieldMapBuilder.put((Object)"country_criterion_id", (Object)this.countryCriterionId);
                    }
                    if (this.locationType != null) {
                        fieldMapBuilder.put((Object)"location_type", (Object)this.locationType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_COUNTRY_CRITERION_ID_LOCATION_TYPE.instantiate(new String[]{"customer_id", this.customerId, "country_criterion_id", this.countryCriterionId, "location_type", this.locationType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GeographicViewName that = (GeographicViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.countryCriterionId, that.countryCriterionId) && Objects.equals(this.locationType, that.locationType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.countryCriterionId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.locationType);
    }

    public static class Builder {
        private String customerId;
        private String countryCriterionId;
        private String locationType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCountryCriterionId() {
            return this.countryCriterionId;
        }

        public String getLocationType() {
            return this.locationType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCountryCriterionId(String countryCriterionId) {
            this.countryCriterionId = countryCriterionId;
            return this;
        }

        public Builder setLocationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        private Builder(GeographicViewName geographicViewName) {
            this.customerId = geographicViewName.customerId;
            this.countryCriterionId = geographicViewName.countryCriterionId;
            this.locationType = geographicViewName.locationType;
        }

        public GeographicViewName build() {
            return new GeographicViewName(this);
        }
    }
}

