/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v11.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomConversionGoalName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_GOAL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customConversionGoals/{goal_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String goalId;

    @Deprecated
    protected CustomConversionGoalName() {
        this.customerId = null;
        this.goalId = null;
    }

    private CustomConversionGoalName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.goalId = (String)Preconditions.checkNotNull((Object)builder.getGoalId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getGoalId() {
        return this.goalId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomConversionGoalName of(String customerId, String goalId) {
        return CustomConversionGoalName.newBuilder().setCustomerId(customerId).setGoalId(goalId).build();
    }

    public static String format(String customerId, String goalId) {
        return CustomConversionGoalName.newBuilder().setCustomerId(customerId).setGoalId(goalId).build().toString();
    }

    public static CustomConversionGoalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_GOAL_ID.validatedMatch(formattedString, "CustomConversionGoalName.parse: formattedString not in valid format");
        return CustomConversionGoalName.of((String)matchMap.get("customer_id"), (String)matchMap.get("goal_id"));
    }

    public static List<CustomConversionGoalName> parseList(List<String> formattedStrings) {
        ArrayList<CustomConversionGoalName> list = new ArrayList<CustomConversionGoalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomConversionGoalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomConversionGoalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomConversionGoalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_GOAL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomConversionGoalName customConversionGoalName = this;
            synchronized (customConversionGoalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.goalId != null) {
                        fieldMapBuilder.put((Object)"goal_id", (Object)this.goalId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_GOAL_ID.instantiate(new String[]{"customer_id", this.customerId, "goal_id", this.goalId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomConversionGoalName that = (CustomConversionGoalName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.goalId, that.goalId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.goalId);
    }

    public static class Builder {
        private String customerId;
        private String goalId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getGoalId() {
            return this.goalId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setGoalId(String goalId) {
            this.goalId = goalId;
            return this;
        }

        private Builder(CustomConversionGoalName customConversionGoalName) {
            this.customerId = customConversionGoalName.customerId;
            this.goalId = customConversionGoalName.goalId;
        }

        public CustomConversionGoalName build() {
            return new CustomConversionGoalName(this);
        }
    }
}

