/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.google.ads.googleads.codegen.AbstractGoogleAdsClientCodeGenerator;
import com.google.ads.googleads.codegen.GeneratedCatalogCodeGenerator;
import com.google.ads.googleads.codegen.Generator;
import com.google.ads.googleads.codegen.GoogleAdsAllVersionsCodeGenerator;
import com.google.ads.googleads.codegen.VersionFactoryCodeGenerator;
import com.google.ads.googleads.lib.stubs.annotations.VersionDescriptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class RunCodeGenerators {
    private final File targetDirectory;
    private final ImmutableMap<VersionDescriptor, Class<?>> descriptors;

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new RuntimeException("Specify 1 argument, the directory for the generated code");
        }
        RunCodeGenerators entryPoint = new RunCodeGenerators(new File(args[0]));
        entryPoint.runAll();
    }

    private static Set<Class<?>> loadAnnotatedClasses() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)"com.google.ads.googleads", (ClassLoader[])new ClassLoader[0])).addScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()}));
        return reflections.getTypesAnnotatedWith(VersionDescriptor.class);
    }

    private static Map<VersionDescriptor, Class<?>> extractVersionDescriptors(Set<Class<?>> versionDescriptorTypes) {
        return versionDescriptorTypes.stream().collect(Collectors.toMap(c -> c.getAnnotation(VersionDescriptor.class), c -> c));
    }

    public RunCodeGenerators(File targetDirectory) {
        this(targetDirectory, RunCodeGenerators.loadAnnotatedClasses());
    }

    public RunCodeGenerators(File targetDirectory, Set<Class<?>> annotatedClasses) {
        this(targetDirectory, RunCodeGenerators.extractVersionDescriptors(annotatedClasses));
    }

    public RunCodeGenerators(File targetDirectory, Map<VersionDescriptor, Class<?>> versionDescriptors) {
        this.targetDirectory = targetDirectory;
        this.descriptors = ImmutableMap.copyOf(versionDescriptors);
    }

    public void runAll() {
        if (!this.targetDirectory.exists()) {
            this.targetDirectory.mkdirs();
        } else if (!this.targetDirectory.isDirectory()) {
            String string = String.valueOf(this.targetDirectory);
            throw new RuntimeException(new StringBuilder(48 + String.valueOf(string).length()).append("Target directory exists and is not a directory: ").append(string).toString());
        }
        for (Generator generator : this.loadGenerators(this.targetDirectory)) {
            generator.generate();
        }
    }

    private List<Generator> loadGenerators(File targetDirectory) {
        Set<Integer> versions = this.getApiMajorVersions();
        int latestVersion = this.getLatestVersion();
        return ImmutableList.of((Object)new VersionFactoryCodeGenerator(versions, targetDirectory), (Object)new GeneratedCatalogCodeGenerator(versions, latestVersion, this.descriptors, targetDirectory), (Object)new GoogleAdsAllVersionsCodeGenerator(versions, latestVersion, targetDirectory), (Object)new AbstractGoogleAdsClientCodeGenerator(versions, latestVersion, targetDirectory));
    }

    private Set<Integer> getApiMajorVersions() {
        return this.descriptors.keySet().stream().map(d -> Integer.valueOf(d.versionName().substring(1))).collect(Collectors.toSet());
    }

    private int getLatestVersion() {
        int latestVersion = 0;
        for (int version : this.getApiMajorVersions()) {
            if (version == 999) continue;
            latestVersion = Math.max(latestVersion, version);
        }
        return latestVersion;
    }
}

