/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.google.ads.googleads.codegen.Generator;
import com.google.ads.googleads.codegen.Utils;
import com.google.ads.googleads.lib.stubs.annotations.ServiceClientDescriptor;
import com.google.ads.googleads.lib.stubs.annotations.VersionDescriptor;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.Modifier;

public class GeneratedCatalogCodeGenerator
implements Generator {
    private static final ClassName VERSION_CLASS_NAME = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"Version", (String[])new String[0]);
    private static final ClassName IMMUTABLE_SET_CLASS_NAME = ClassName.get(ImmutableSet.class);
    private final Set<Integer> versions;
    private final int latestVersion;
    private final File targetDirectory;
    private final ImmutableMap<VersionDescriptor, Class<?>> allVersionDescriptors;

    public GeneratedCatalogCodeGenerator(Set<Integer> versions, int latestVersion, ImmutableMap<VersionDescriptor, Class<?>> allVersionDescriptors, File targetDirectory) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.allVersionDescriptors = allVersionDescriptors;
        this.targetDirectory = targetDirectory;
    }

    @Override
    public JavaFile generate() {
        String generatedCatalogSimpleName = "GeneratedCatalog";
        ClassName generatedCatalogClassName = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)generatedCatalogSimpleName, (String[])new String[0]);
        FieldSpec instance = FieldSpec.builder((TypeName)generatedCatalogClassName, (String)"instance", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
        CodeBlock instanceInitializer = CodeBlock.builder().beginControlFlow("try", new Object[0]).addStatement("instance = new $T($T.getVersions())", new Object[]{generatedCatalogClassName, ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"VersionFactory", (String[])new String[0])}).nextControlFlow("catch ($T e)", new Object[]{IllegalAccessException.class}).addStatement("throw new RuntimeException(e)", new Object[0]).nextControlFlow("catch ($T e)", new Object[]{InstantiationException.class}).addStatement("throw new RuntimeException(e)", new Object[0]).endControlFlow().build();
        FieldSpec supportedVersions = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableSortedSet.class), (TypeName[])new TypeName[]{VERSION_CLASS_NAME}), (String)"supportedVersions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)IMMUTABLE_SET_CLASS_NAME, (TypeName[])new TypeName[]{VERSION_CLASS_NAME}), "versions", new Modifier[0]).addStatement("supportedVersions = $T.copyOf(versions)", new Object[]{ImmutableSortedSet.class}).addJavadoc("Creates a new constant catalog from a known collection of versions.", new Object[0]).build();
        MethodSpec getDefault = MethodSpec.methodBuilder((String)"getDefault").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)generatedCatalogClassName).addStatement("return instance", new Object[0]).build();
        MethodSpec getSupportedVersions = MethodSpec.methodBuilder((String)"getSupportedVersions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SortedSet.class), (TypeName[])new TypeName[]{VERSION_CLASS_NAME})).addStatement("return supportedVersions", new Object[0]).build();
        MethodSpec getLatestVersion = MethodSpec.methodBuilder((String)"getLatestVersion").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)VERSION_CLASS_NAME).addStatement("return getSupportedVersions().first()", new Object[0]).build();
        MethodSpec createAllVersionsClient = GeneratedCatalogCodeGenerator.createAllVersionsClient(this.versions, this.latestVersion);
        TypeSpec.Builder generatedCatalogBuilder = TypeSpec.classBuilder((String)generatedCatalogSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(instance).addStaticBlock(instanceInitializer).addField(supportedVersions).addMethod(constructor).addMethod(getDefault).addMethod(getSupportedVersions).addMethod(getLatestVersion).addMethod(createAllVersionsClient);
        if (generatedCatalogSimpleName.equals("GeneratedCatalog")) {
            generatedCatalogBuilder.addSuperinterface((TypeName)ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"ApiCatalog", (String[])new String[0]));
        }
        for (Integer version : this.versions) {
            generatedCatalogBuilder.addType(this.createClient(version));
        }
        JavaFile javaFile = Utils.createJavaFile("com.google.ads.googleads.lib.catalog", generatedCatalogBuilder.build());
        Utils.writeGeneratedClassToFile(javaFile, this.targetDirectory);
        return javaFile;
    }

    private TypeSpec createClient(int version) {
        FieldSpec provider = FieldSpec.builder(TransportChannelProvider.class, (String)"provider", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        FieldSpec credentials = FieldSpec.builder(Credentials.class, (String)"credentials", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransportChannelProvider.class, "provider", new Modifier[0]).addParameter(Credentials.class, "credentials", new Modifier[0]).addStatement("this.provider = provider", new Object[0]).addStatement("this.credentials = credentials", new Object[0]).build();
        TypeSpec.Builder clientBuilder = TypeSpec.classBuilder((String)new StringBuilder(18).append("V").append(version).append("Client").toString()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addSuperinterface((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).addField(provider).addField(credentials).addMethod(constructor);
        ClassName versionClassName = Utils.createServiceClientClassName(version, "GoogleAdsVersion");
        VersionDescriptor descriptor = this.getDescriptorForVersion(version);
        Class descriptorClass = (Class)this.allVersionDescriptors.get((Object)descriptor);
        for (Method method : descriptorClass.getMethods()) {
            if (!method.isAnnotationPresent(ServiceClientDescriptor.class)) continue;
            clientBuilder.addMethod(GeneratedCatalogCodeGenerator.createServiceClient(version, method.getReturnType().getSimpleName()));
        }
        return clientBuilder.build();
    }

    private VersionDescriptor getDescriptorForVersion(int version) {
        for (VersionDescriptor descriptor : this.allVersionDescriptors.keySet()) {
            if (Integer.valueOf(descriptor.versionName().substring(1)) != version) continue;
            return descriptor;
        }
        throw new RuntimeException(new StringBuilder(43).append("Failed to lookup descriptor for ").append(version).toString());
    }

    private static MethodSpec createServiceClient(int version, String serviceClient) {
        String string = String.valueOf(serviceClient);
        MethodSpec.Builder serviceBuilder = MethodSpec.methodBuilder((String)(string.length() != 0 ? "create".concat(string) : new String("create"))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)Utils.createServiceClientClassName(version, serviceClient));
        String noClientName = serviceClient.substring(0, serviceClient.length() - "client".length());
        serviceBuilder.addCode("try {\n  $T settings =\n    $T.newBuilder()\n      .setCredentialsProvider($T.create(credentials))\n      .setTransportChannelProvider(provider)\n      .build();\n  return $T.create(settings);\n} catch ($T e) {\n  throw new RuntimeException(e);\n}\n", new Object[]{Utils.createServiceClientClassName(version, String.valueOf(noClientName).concat("Settings")), Utils.createServiceClientClassName(version, String.valueOf(noClientName).concat("Settings")), FixedCredentialsProvider.class, Utils.createServiceClientClassName(version, serviceClient), IOException.class});
        return serviceBuilder.build();
    }

    private static MethodSpec createAllVersionsClient(Set<Integer> versions, int latestVersion) {
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        ClassName googleAdsAllVersionsClassName = ClassName.get((String)"com.google.ads.googleads.lib", (String)googleAdsAllVersionsSimpleName, (String[])new String[0]);
        TypeSpec.Builder allVersionsClientBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)googleAdsAllVersionsClassName);
        for (Integer version : versions) {
            allVersionsClientBuilder.addMethod(GeneratedCatalogCodeGenerator.getVersion(version));
        }
        allVersionsClientBuilder.addMethod(MethodSpec.methodBuilder((String)"getLatestVersion").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)new StringBuilder(46).append("com.google.ads.googleads.v").append(latestVersion).append(".services").toString(), (String)"GoogleAdsVersion", (String[])new String[0])).addStatement("return getVersion$L()", new Object[]{latestVersion}).build());
        TypeSpec allVersionsClient = allVersionsClientBuilder.build();
        return MethodSpec.methodBuilder((String)"createAllVersionsClient").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $L", new Object[]{allVersionsClient}).returns((TypeName)googleAdsAllVersionsClassName).addParameter(TransportChannelProvider.class, "provider", new Modifier[0]).addParameter(Credentials.class, "credentials", new Modifier[0]).build();
    }

    private static MethodSpec getVersion(int version) {
        return MethodSpec.methodBuilder((String)new StringBuilder(21).append("getVersion").append(version).toString()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).addStatement(new StringBuilder(52).append("return new V").append(version).append("Client(provider, credentials)").toString(), new Object[0]).build();
    }
}

