/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.apache.commons.lang.SerializationException;

public class JaxBDeserializer<T> {
    private final Class<T> clazz;
    private final JAXBContext jaxbContext;

    public JaxBDeserializer(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            throw new SerializationException(String.format("Could not construct deserializer for class: %s.", clazz), (Throwable)e);
        }
    }

    public T deserialize(Source source) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = unmarshaller.unmarshal(source, this.clazz);
            return (T)jaxbElement.getValue();
        }
        catch (JAXBException e) {
            throw new SerializationException(String.format("Could not deserialize %s object from source %s.", this.clazz, source), (Throwable)e);
        }
    }
}

