/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.client.http.HttpResponse;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BatchJobUploadResponse {
    private final InputStream responseContent;
    private final BatchJobUploadStatus uploadStatus;
    private final int httpStatus;
    private final String httpResponseMessage;

    public BatchJobUploadResponse(InputStream responseContent, int httpStatus, String httpResponseMessage, long totalContentLength, @Nullable URI resumableSessionURI) {
        this.responseContent = (InputStream)Preconditions.checkNotNull((Object)responseContent, (Object)"Null response content");
        this.httpStatus = httpStatus;
        this.httpResponseMessage = httpResponseMessage;
        this.uploadStatus = new BatchJobUploadStatus(totalContentLength, resumableSessionURI);
    }

    public BatchJobUploadResponse(HttpResponse httpResponse, long totalContentLength, @Nullable URI resumableSessionURI) throws IOException {
        this(((HttpResponse)Preconditions.checkNotNull((Object)httpResponse, (Object)"Null HTTP response")).getContent(), httpResponse.getStatusCode(), httpResponse.getStatusMessage(), totalContentLength, resumableSessionURI);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getHttpResponseMessage() {
        return this.httpResponseMessage;
    }

    public InputStream getResponseContent() {
        return this.responseContent;
    }

    public BatchJobUploadStatus getBatchJobUploadStatus() {
        return this.uploadStatus;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("httpStatus", this.httpStatus).append("httpResponseMessage", (Object)this.httpResponseMessage).append("uploadStatus", (Object)this.uploadStatus).append("hasContent", this.responseContent != null).toString();
    }
}

