package com.google.adk.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GroundingMetadata;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LlmResponse extends LlmResponse {

  private final Optional<Content> content;

  private final Optional<GroundingMetadata> groundingMetadata;

  private final Optional<Boolean> partial;

  private final Optional<Boolean> turnComplete;

  private final Optional<FinishReason> errorCode;

  private final Optional<String> errorMessage;

  private final Optional<Boolean> interrupted;

  private AutoValue_LlmResponse(
      Optional<Content> content,
      Optional<GroundingMetadata> groundingMetadata,
      Optional<Boolean> partial,
      Optional<Boolean> turnComplete,
      Optional<FinishReason> errorCode,
      Optional<String> errorMessage,
      Optional<Boolean> interrupted) {
    this.content = content;
    this.groundingMetadata = groundingMetadata;
    this.partial = partial;
    this.turnComplete = turnComplete;
    this.errorCode = errorCode;
    this.errorMessage = errorMessage;
    this.interrupted = interrupted;
  }

  @JsonProperty("content")
  @Override
  public Optional<Content> content() {
    return content;
  }

  @JsonProperty("groundingMetadata")
  @Override
  public Optional<GroundingMetadata> groundingMetadata() {
    return groundingMetadata;
  }

  @JsonProperty("partial")
  @Override
  public Optional<Boolean> partial() {
    return partial;
  }

  @JsonProperty("turnComplete")
  @Override
  public Optional<Boolean> turnComplete() {
    return turnComplete;
  }

  @JsonProperty("errorCode")
  @Override
  public Optional<FinishReason> errorCode() {
    return errorCode;
  }

  @JsonProperty("errorMessage")
  @Override
  public Optional<String> errorMessage() {
    return errorMessage;
  }

  @JsonProperty("interrupted")
  @Override
  public Optional<Boolean> interrupted() {
    return interrupted;
  }

  @Override
  public String toString() {
    return "LlmResponse{"
        + "content=" + content + ", "
        + "groundingMetadata=" + groundingMetadata + ", "
        + "partial=" + partial + ", "
        + "turnComplete=" + turnComplete + ", "
        + "errorCode=" + errorCode + ", "
        + "errorMessage=" + errorMessage + ", "
        + "interrupted=" + interrupted
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LlmResponse) {
      LlmResponse that = (LlmResponse) o;
      return this.content.equals(that.content())
          && this.groundingMetadata.equals(that.groundingMetadata())
          && this.partial.equals(that.partial())
          && this.turnComplete.equals(that.turnComplete())
          && this.errorCode.equals(that.errorCode())
          && this.errorMessage.equals(that.errorMessage())
          && this.interrupted.equals(that.interrupted());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= content.hashCode();
    h$ *= 1000003;
    h$ ^= groundingMetadata.hashCode();
    h$ *= 1000003;
    h$ ^= partial.hashCode();
    h$ *= 1000003;
    h$ ^= turnComplete.hashCode();
    h$ *= 1000003;
    h$ ^= errorCode.hashCode();
    h$ *= 1000003;
    h$ ^= errorMessage.hashCode();
    h$ *= 1000003;
    h$ ^= interrupted.hashCode();
    return h$;
  }

  @Override
  public LlmResponse.Builder toBuilder() {
    return new AutoValue_LlmResponse.Builder(this);
  }

  static final class Builder extends LlmResponse.Builder {
    private Optional<Content> content = Optional.empty();
    private Optional<GroundingMetadata> groundingMetadata = Optional.empty();
    private Optional<Boolean> partial = Optional.empty();
    private Optional<Boolean> turnComplete = Optional.empty();
    private Optional<FinishReason> errorCode = Optional.empty();
    private Optional<String> errorMessage = Optional.empty();
    private Optional<Boolean> interrupted = Optional.empty();
    Builder() {
    }
    Builder(LlmResponse source) {
      this.content = source.content();
      this.groundingMetadata = source.groundingMetadata();
      this.partial = source.partial();
      this.turnComplete = source.turnComplete();
      this.errorCode = source.errorCode();
      this.errorMessage = source.errorMessage();
      this.interrupted = source.interrupted();
    }
    @Override
    public LlmResponse.Builder content(Content content) {
      this.content = Optional.of(content);
      return this;
    }
    @Override
    public LlmResponse.Builder groundingMetadata(@Nullable GroundingMetadata groundingMetadata) {
      this.groundingMetadata = Optional.ofNullable(groundingMetadata);
      return this;
    }
    @Override
    public LlmResponse.Builder groundingMetadata(Optional<GroundingMetadata> groundingMetadata) {
      if (groundingMetadata == null) {
        throw new NullPointerException("Null groundingMetadata");
      }
      this.groundingMetadata = groundingMetadata;
      return this;
    }
    @Override
    public LlmResponse.Builder partial(@Nullable Boolean partial) {
      this.partial = Optional.ofNullable(partial);
      return this;
    }
    @Override
    public LlmResponse.Builder partial(Optional<Boolean> partial) {
      if (partial == null) {
        throw new NullPointerException("Null partial");
      }
      this.partial = partial;
      return this;
    }
    @Override
    public LlmResponse.Builder turnComplete(@Nullable Boolean turnComplete) {
      this.turnComplete = Optional.ofNullable(turnComplete);
      return this;
    }
    @Override
    public LlmResponse.Builder turnComplete(Optional<Boolean> turnComplete) {
      if (turnComplete == null) {
        throw new NullPointerException("Null turnComplete");
      }
      this.turnComplete = turnComplete;
      return this;
    }
    @Override
    public LlmResponse.Builder errorCode(@Nullable FinishReason errorCode) {
      this.errorCode = Optional.ofNullable(errorCode);
      return this;
    }
    @Override
    public LlmResponse.Builder errorCode(Optional<FinishReason> errorCode) {
      if (errorCode == null) {
        throw new NullPointerException("Null errorCode");
      }
      this.errorCode = errorCode;
      return this;
    }
    @Override
    public LlmResponse.Builder errorMessage(@Nullable String errorMessage) {
      this.errorMessage = Optional.ofNullable(errorMessage);
      return this;
    }
    @Override
    public LlmResponse.Builder errorMessage(Optional<String> errorMessage) {
      if (errorMessage == null) {
        throw new NullPointerException("Null errorMessage");
      }
      this.errorMessage = errorMessage;
      return this;
    }
    @Override
    public LlmResponse.Builder interrupted(@Nullable Boolean interrupted) {
      this.interrupted = Optional.ofNullable(interrupted);
      return this;
    }
    @Override
    public LlmResponse.Builder interrupted(Optional<Boolean> interrupted) {
      if (interrupted == null) {
        throw new NullPointerException("Null interrupted");
      }
      this.interrupted = interrupted;
      return this;
    }
    @Override
    LlmResponse autoBuild() {
      return new AutoValue_LlmResponse(
          this.content,
          this.groundingMetadata,
          this.partial,
          this.turnComplete,
          this.errorCode,
          this.errorMessage,
          this.interrupted);
    }
  }

}
