package com.google.adk.memory;

import com.google.genai.types.Content;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MemoryEntry extends MemoryEntry {

  private final Content content;

  @Nullable
  private final String author;

  @Nullable
  private final String timestamp;

  private AutoValue_MemoryEntry(
      Content content,
      @Nullable String author,
      @Nullable String timestamp) {
    this.content = content;
    this.author = author;
    this.timestamp = timestamp;
  }

  @Override
  public Content content() {
    return content;
  }

  @Nullable
  @Override
  public String author() {
    return author;
  }

  @Nullable
  @Override
  public String timestamp() {
    return timestamp;
  }

  @Override
  public String toString() {
    return "MemoryEntry{"
        + "content=" + content + ", "
        + "author=" + author + ", "
        + "timestamp=" + timestamp
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MemoryEntry) {
      MemoryEntry that = (MemoryEntry) o;
      return this.content.equals(that.content())
          && (this.author == null ? that.author() == null : this.author.equals(that.author()))
          && (this.timestamp == null ? that.timestamp() == null : this.timestamp.equals(that.timestamp()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= content.hashCode();
    h$ *= 1000003;
    h$ ^= (author == null) ? 0 : author.hashCode();
    h$ *= 1000003;
    h$ ^= (timestamp == null) ? 0 : timestamp.hashCode();
    return h$;
  }

  @Override
  public MemoryEntry.Builder toBuilder() {
    return new AutoValue_MemoryEntry.Builder(this);
  }

  static final class Builder extends MemoryEntry.Builder {
    private Content content;
    private String author;
    private String timestamp;
    Builder() {
    }
    Builder(MemoryEntry source) {
      this.content = source.content();
      this.author = source.author();
      this.timestamp = source.timestamp();
    }
    @Override
    public MemoryEntry.Builder setContent(Content content) {
      if (content == null) {
        throw new NullPointerException("Null content");
      }
      this.content = content;
      return this;
    }
    @Override
    public MemoryEntry.Builder setAuthor(@Nullable String author) {
      this.author = author;
      return this;
    }
    @Override
    public MemoryEntry.Builder setTimestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
      return this;
    }
    @Override
    public MemoryEntry build() {
      if (this.content == null) {
        String missing = " content";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MemoryEntry(
          this.content,
          this.author,
          this.timestamp);
    }
  }

}
