/*
 * Decompiled with CFR 0.152.
 */
package org.zxhtom.tmp;

import com.aspose.cells.License;
import com.aspose.cells.Workbook;
import com.aspose.words.Document;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zxhtom.base.LicenseFactory;

public class Office2pdf {
    private static Logger logger = LogManager.getLogger(Office2pdf.class);

    public static void doc2pdf(String wordPath, String pdfPath) {
        if (!LicenseFactory.getInstance().isPassLicense(com.aspose.words.License.class)) {
            return;
        }
        try {
            long old = System.currentTimeMillis();
            File file = new File(pdfPath);
            FileOutputStream os = new FileOutputStream(file);
            Document doc = new Document(wordPath);
            doc.save((OutputStream)os, 40);
            long now = System.currentTimeMillis();
            os.close();
            System.out.println("\u5171\u8017\u65f6\uff1a" + (double)(now - old) / 1000.0 + "\u79d2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void excel2pdf(String excelPath, String pdfPath) {
        if (!LicenseFactory.getInstance().isPassLicense(License.class)) {
            return;
        }
        try {
            long old = System.currentTimeMillis();
            Workbook wb = new Workbook(excelPath);
            FileOutputStream fileOS = new FileOutputStream(new File(pdfPath));
            wb.save((OutputStream)fileOS, 13);
            fileOS.close();
            long now = System.currentTimeMillis();
            System.out.println("\u5171\u8017\u65f6\uff1a" + (double)(now - old) / 1000.0 + "\u79d2");
        }
        catch (Exception e) {
            logger.error("\u62a5\u9519\uff1a" + e);
        }
    }

    public static void main(String[] args) {
        String source = "E://zxh//test//tew.xls";
        String target = "E://zxh//test//tew.pdf";
        Office2pdf.excel2pdf(source, target);
    }
}

