/*
 * Decompiled with CFR 0.152.
 */
package org.zxhtom.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zxhtom.Exception.CommonException;
import org.zxhtom.utils.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathAdapter {
    private Logger logger = LogManager.getLogger(PathAdapter.class);
    private String sourceClassPath = "";
    private String key = "";
    private String license = "";
    private static Map<String, Object> paramMap = new HashMap<String, Object>();
    private static Map<String, Object> targetMap = new HashMap<String, Object>();
    private static String formatTemplete = "org.zxhtom.base.saveformat.%1$s.SaveFormat";
    private static String keyTemplete = "com.aspose.%1$s.License";
    private static String pathRegex = "^.*\\.(doc|xls|ppt|pdf|html|txt)x?$";

    private void setKey(String source) throws CommonException {
        String regex = "^.*\\..*\\.(.*)\\..*";
        Matcher matcher = Pattern.compile(regex).matcher(this.sourceClassPath);
        if (!matcher.find()) {
            throw new CommonException("not find keys");
        }
        this.key = matcher.group(1);
        this.license = String.format(keyTemplete, this.key);
    }

    public String getLicensePath(String source) throws CommonException {
        return this.license;
    }

    public Class<?> getClassByPath(String source) throws ClassNotFoundException, CommonException {
        Matcher matcher = Pattern.compile(pathRegex).matcher(source);
        if (matcher.find()) {
            Object sourceObj = paramMap.get(matcher.group(1));
            if (null == sourceObj) {
                throw new CommonException(String.format("not register the type of %1$s Handler,please contact q:870775401 help", matcher.group(1)));
            }
            this.sourceClassPath = sourceObj.toString();
            this.setKey(source);
            return Class.forName(this.sourceClassPath);
        }
        this.logger.warn(String.format("source (%1$s) is not avalid ", source));
        return Object.class;
    }

    public int getFormatByPathTmp(String target) throws CommonException {
        if (StringUtils.isBlank((CharSequence)this.sourceClassPath)) {
            throw new CommonException("You must first call the getClassByPath method");
        }
        Matcher matcherTarget = Pattern.compile(pathRegex).matcher(target);
        if (matcherTarget.find()) {
            return (Integer)targetMap.get(matcherTarget.group(1) + "_" + this.key);
        }
        throw new CommonException("target unlawful");
    }

    public int getFormatByPath(String target) throws CommonException, ClassNotFoundException {
        if (StringUtils.isBlank((CharSequence)this.sourceClassPath)) {
            throw new CommonException("You must first call the getClassByPath method");
        }
        Matcher matcherTarget = Pattern.compile(pathRegex).matcher(target);
        if (matcherTarget.find()) {
            String format = String.format(formatTemplete, this.key);
            return (Integer)ReflectUtil.getField(Class.forName(format), (String)matcherTarget.group(1).toUpperCase());
        }
        throw new CommonException("target unlawful");
    }

    static {
        paramMap.put("doc", "com.aspose.words.Document");
        paramMap.put("xls", "com.aspose.cells.Workbook");
        paramMap.put("ppt", "com.aspose.slides.Presentation");
        paramMap.put("pdf", "com.aspose.pdf.Document");
    }
}

