/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.joda.time.Instant;
import java.nio.ByteBuffer;

public class StringTimestampCodec
extends TypeCodec<String> {
    public static final StringTimestampCodec instance = new StringTimestampCodec();

    private StringTimestampCodec() {
        super(DataType.timestamp(), String.class);
    }

    @Override
    public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(32) == 10 && value.indexOf(90) < 0) {
            StringBuilder builder = new StringBuilder(value).append('Z');
            builder.setCharAt(10, 'T');
            value = builder.toString();
        }
        return StringTimestampCodec.bigint().serializeNoBoxing(Instant.parse(value).getMillis(), protocolVersion);
    }

    @Override
    public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long millis = StringTimestampCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return new Instant(millis).toString();
    }

    @Override
    public String format(String value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(value);
    }

    @Override
    public String parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        return value;
    }
}

