/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.joda.time.LocalTime;
import java.nio.ByteBuffer;

public class StringTimeCodec
extends TypeCodec<String> {
    public static final StringTimeCodec instance = new StringTimeCodec();

    private StringTimeCodec() {
        super(DataType.time(), String.class);
    }

    @Override
    public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        return StringTimeCodec.bigint().serializeNoBoxing(LocalTime.parse(value).getMillisOfDay() * 1000000, protocolVersion);
    }

    @Override
    public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long nanosOfDay = StringTimeCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return LocalTime.fromMillisOfDay(nanosOfDay / 1000000L).toString();
    }

    @Override
    public String format(String value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(LocalTime.parse(value).toString());
    }

    @Override
    public String parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted(value)) {
            throw new InvalidTypeException("time values must be enclosed by single quotes");
        }
        return value.substring(1, value.length() - 1);
    }
}

