/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.CodecUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.joda.time.Days;
import com.github.cassandra.jdbc.internal.joda.time.LocalDate;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormat;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormatter;
import java.nio.ByteBuffer;

public class StringDateCodec
extends TypeCodec<String> {
    public static final StringDateCodec instance = new StringDateCodec();
    private static final LocalDate EPOCH = new LocalDate(1970, 1, 1);
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd").withZoneUTC();

    private StringDateCodec() {
        super(DataType.date(), String.class);
    }

    @Override
    public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        Days days = Days.daysBetween(EPOCH, LocalDate.parse(value));
        int unsigned = CodecUtils.fromSignedToUnsignedInt(days.getDays());
        return StringDateCodec.cint().serializeNoBoxing(unsigned, protocolVersion);
    }

    @Override
    public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int unsigned = StringDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion);
        int signed = CodecUtils.fromUnsignedToSignedInt(unsigned);
        return FORMATTER.print(EPOCH.plusDays(signed));
    }

    @Override
    public String format(String value) {
        return value == null ? "NULL" : ParseUtils.quote(value);
    }

    @Override
    public String parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        return value;
    }
}

