/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;

public class StringBlobCodec
extends TypeCodec<String> {
    public static final StringBlobCodec instance = new StringBlobCodec();

    private StringBlobCodec() {
        super(DataType.blob(), String.class);
    }

    @Override
    public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return value == null ? null : ByteBuffer.wrap(value.getBytes());
    }

    @Override
    public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        return new String(bytes.array());
    }

    @Override
    public String format(String value) {
        return value == null ? "NULL" : value;
    }

    @Override
    public String parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        return value;
    }
}

