/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.joda.time.Instant;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormat;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormatter;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormatterBuilder;
import com.github.cassandra.jdbc.internal.joda.time.format.ISODateTimeFormat;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public class JavaSqlTimestampCodec
extends TypeCodec<Timestamp> {
    public static final JavaSqlTimestampCodec instance = new JavaSqlTimestampCodec();
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateOptionalTimeParser().getParser()).appendOptional(new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toParser()).toFormatter().withZoneUTC();
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").withZoneUTC();

    private JavaSqlTimestampCodec() {
        super(DataType.timestamp(), Timestamp.class);
    }

    @Override
    public ByteBuffer serialize(Timestamp value, ProtocolVersion protocolVersion) {
        return value == null ? null : JavaSqlTimestampCodec.bigint().serializeNoBoxing(value.getTime(), protocolVersion);
    }

    @Override
    public Timestamp deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long millis = JavaSqlTimestampCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return new Timestamp(millis);
    }

    @Override
    public String format(Timestamp value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(FORMATTER.print(new Instant(value.getTime())));
    }

    @Override
    public Timestamp parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            try {
                return new Timestamp(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
            }
        }
        try {
            return new Timestamp(PARSER.parseMillis(value));
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
        }
    }
}

