/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.joda.time.LocalTime;
import java.nio.ByteBuffer;
import java.sql.Time;

public class JavaSqlTimeCodec
extends TypeCodec<Time> {
    public static final JavaSqlTimeCodec instance = new JavaSqlTimeCodec();

    private JavaSqlTimeCodec() {
        super(DataType.time(), Time.class);
    }

    @Override
    public ByteBuffer serialize(Time value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        return JavaSqlTimeCodec.bigint().serializeNoBoxing((long)new LocalTime(value.getTime()).getMillisOfDay() * 1000000L, protocolVersion);
    }

    @Override
    public Time deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long nanosOfDay = JavaSqlTimeCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return new Time(LocalTime.fromMillisOfDay(nanosOfDay / 1000000L).toDateTimeToday().getMillis());
    }

    @Override
    public String format(Time value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(new LocalTime(value.getTime()).toString());
    }

    @Override
    public Time parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted(value)) {
            throw new InvalidTypeException("time values must be enclosed by single quotes");
        }
        if (ParseUtils.isLongLiteral(value = value.substring(1, value.length() - 1))) {
            long nanosOfDay;
            try {
                nanosOfDay = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value), e);
            }
            return new Time(LocalTime.fromMillisOfDay(nanosOfDay / 1000000L).getMillisOfSecond());
        }
        try {
            return new Time(LocalTime.parse(value).toDateTimeToday().getMillis());
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value), e);
        }
    }
}

