/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.CodecUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.joda.time.Days;
import com.github.cassandra.jdbc.internal.joda.time.LocalDate;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormat;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormatter;
import java.nio.ByteBuffer;
import java.sql.Date;
import javax.xml.bind.DatatypeConverter;

public class JavaSqlDateCodec
extends TypeCodec<Date> {
    public static final JavaSqlDateCodec instance = new JavaSqlDateCodec();
    private static final LocalDate EPOCH = new LocalDate(1970, 1, 1);
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd").withZoneUTC();

    private JavaSqlDateCodec() {
        super(DataType.date(), Date.class);
    }

    @Override
    public ByteBuffer serialize(Date value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        Days days = Days.daysBetween(EPOCH, LocalDate.fromDateFields(value));
        int unsigned = CodecUtils.fromSignedToUnsignedInt(days.getDays());
        return JavaSqlDateCodec.cint().serializeNoBoxing(unsigned, protocolVersion);
    }

    @Override
    public Date deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int unsigned = JavaSqlDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion);
        int signed = CodecUtils.fromUnsignedToSignedInt(unsigned);
        return new Date(EPOCH.plusDays(signed).toDate().getTime());
    }

    @Override
    public String format(Date value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(FORMATTER.print(LocalDate.fromDateFields(value)));
    }

    @Override
    public Date parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            int days;
            long raw;
            try {
                raw = DatatypeConverter.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            try {
                days = CodecUtils.fromCqlDateToDaysSinceEpoch(raw);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            return new Date(EPOCH.plusDays(days).toDate().getTime());
        }
        try {
            return new Date(LocalDate.parse(value, FORMATTER).toDate().getTime());
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
        }
    }
}

