/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax.codecs;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BytesBlobCodec
extends TypeCodec<byte[]> {
    public static final BytesBlobCodec instance = new BytesBlobCodec();

    private BytesBlobCodec() {
        super(DataType.blob(), byte[].class);
    }

    @Override
    public ByteBuffer serialize(byte[] value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return value == null ? null : ByteBuffer.wrap(Arrays.copyOf(value, value.length));
    }

    @Override
    public byte[] deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        return bytes.duplicate().array();
    }

    @Override
    public String format(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        return Bytes.toHexString(value);
    }

    @Override
    public byte[] parse(String value) {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value).array();
    }
}

